/////////////////////////////////////////////////
//
//  filename: Stick.cpp
//  author:Chafumi Touji
//  date: 2021/07/04 ver1.00
//
/////////////////////////////////////////////////

#include "Cha3D/defcha3d.h"
#include "Stick.h"
#include "Coco.h"
#include "Piske.h"

CStick::CStick() : CCharacterBase() {

	Move = false;
	Attack = false;
	CollisionCheck = false;
}

CStick::CStick( CDispWindow *disp_window ) : CCharacterBase( disp_window) {

	Move = false;
	Attack = false;
	CollisionCheck = false;
	DispWindow = disp_window;
}

CStick::~CStick() {

}

void CStick::OnKeyDown(UINT nChar) {

	if (Attack == false) {
		if (nChar == 39 /*  */) {
			if (Move == false) {
				SetCurrentAnimation(L"WALK", 5, 1, true, false);
				SetRefrainSec(L"WALK", 20.0f);
			}
			Move = true;
		}
		if (nChar == 40 /*  */) {
			if (Move == false) {
				SetCurrentAnimation(L"WALK", 5, 1, true, false);
				SetRefrainSec(L"WALK", 20.0f);
			}
			Move = true;
		}
		if (nChar == 37 /*  */) {
			if (Move == false) {
				SetCurrentAnimation(L"WALK", 5, 1, true, false);
				SetRefrainSec(L"WALK", 20.0f);
			}
			Move = true;
		}
		if (nChar == 38 /*  */) {
			if (Move == false) {
				SetCurrentAnimation(L"WALK", 5, 1, true, false);
				SetRefrainSec(L"WALK", 20.0f);
			}
			Move = true;
		}
	}
	if (nChar == 32 /* enter */) {
		if (Attack == false) {
			Move = false;
			SetCurrentAnimation(L"ATTACK", 0, 2, false, false );
			SetFrameCount( 0 );
			SetRefrainSec(L"ATTACK", 0.0f);
			SetCollisionCheck(true);
			Attack = true;
		}
	}
}

void CStick::PreAction() {

	CCharacterBase* obj = GetChaObject(L"COCO1");
	if (obj != NULL) {
		XMFLOAT4 pos = obj->GetPosition();
		pos.z -= 0.1f;
		SetPosition(pos);
		SetRotation(obj->GetRotation());
	}
}

void CStick::Action() {

	CPiske* piske = (CPiske*)DispWindow->ObjectManager->GetCharacterData(L"PISKE");
	CCoco* coco = (CCoco *)DispWindow->ObjectManager->GetCharacterData(L"COCO1");

	if (Attack == true) {
		if (IsAnimationFinished(L"ATTACK") == true) {
			Attack = false;
			SetCurrentAnimation(L"STOP", 0, 1, true, false);
			SetRefrainSec(L"STOP", 0.0f);
		}
		else {
			if (CollisionXY == true && XYCollisionObject->CheckID(L"PISKE") == true) {
				if (piske->Hit == false) {

					piske->Hit = true;
					piske->HitSpeed = 0.5f;

					XMFLOAT4 coco_pos = coco->GetPosition();
					XMFLOAT4 piske_pos = piske->GetPosition();
					XMVECTOR vec = XMVectorSet(piske_pos.x - coco_pos.x, piske_pos.y - coco_pos.y, 0.0f, 1.0f);
					float x = XMVectorGetX(vec);
					float y = XMVectorGetY(vec);
					float rot_z = ToAngle(atan(y / x));
					if (x < 0)
						rot_z += 180.0f;
					rot_z -= 180.0f;

					if (rot_z < -180.0f)
						rot_z += 360.0f;
					if (rot_z > 180.0f)
						rot_z -= 360.0f;

					vec = XMVector3Normalize(vec);
					piske->HitVecX = XMVectorGetX(vec);
					piske->HitVecY = XMVectorGetY(vec);
					piske->SetRotation(XMFLOAT4(0, 0, rot_z, 0));
				}
			}
		}
	}
}

void CStick::OnKeyUp(UINT nChar) {

	if (Move == true) {
		SetCurrentAnimation(L"STOP", 5, 3, true, false);
		SetRefrainSec(L"STOP", 0.0f);
	}

	Move = false;
	Velocity = 0.0f;
}

void CStick::OnLButtonDown(UINT nFlag, CPoint point) {
}

void CStick::OnLButtonUp(UINT nFlag, CPoint point) {
}

void CStick::OnRButtonDown(UINT nFlag, CPoint point) {
}

void CStick::OnRButtonUp(UINT nFlag, CPoint point) {
}
