/////////////////////////////////////////////////
//
//  filename: Piske.cpp
//  author:Chafumi Touji
//  date: 2021/07/04 ver1.00
//
/////////////////////////////////////////////////

#include <time.h>
#include "Cha3D/defcha3d.h"
#include "ChaSound/ChaSound.h"
#include "Piske.h"

CPiske::CPiske() : CCharacterBase(){

	Move = false;
	CollisionCheck = true;
	Hit = false;
	HitSpeed = 0.0f;
	HitVecX = 0.0f;
	HitVecY = 0.0f;
	WalkingSpeed = 0.25f;
	AudioPlaying = false;
	Audio = NULL;
}

CPiske::CPiske(CDispWindow *disp_window) : CCharacterBase( disp_window ){

	srand((unsigned int)time(NULL));

	Move = false;
	CollisionCheck = true;
	DispWindow = disp_window;
	HitSpeed = 0.0f;
	HitVecX = 0.0f;
	HitVecY = 0.0f;
	RandomRotZ = rand() % 360 - 180;
	WalkingSpeed = 0.25f;
}

CPiske::~CPiske() {

}

void CPiske::OnKeyDown(UINT nChar) {


}

void CPiske::PreAction() {

}

void CPiske::Action() {

	static XMFLOAT4 prev_pos = XMFLOAT4(0, 0, 0, 0);
	if (Hit == true) {

		if (AudioPlaying == false) {
			AudioPlaying = true;
			Audio->SetLoop(3, false);
			Audio->Play(3);
		}

		if (wcscmp(CurrentAnimationID, L"DOWN") == 0) {
			if (IsAnimationFinished(L"DOWN") == true) {
				SetCurrentAnimation(L"DOWNDOWN", 0, 1.0f, false, false);
			}
		}
		else if (wcscmp(CurrentAnimationID, L"DOWNDOWN") == 0) {
			if (IsAnimationFinished(L"DOWNDOWN") == true) {
				SetSwapObject(0);
				SetCurrentAnimation(L"UP", 0, 1, false, true);
				ChaResourceObject->UpdateTransform();
			}
		}
		else if (wcscmp(CurrentAnimationID, L"UP") == 0) {
			if (IsAnimationFinished(L"UP") == true) {
				SetCurrentAnimation(L"WALK", 0, 5, true, false);
				Hit = false;
				AudioPlaying = false;
				Audio->Stop(3);
			}
		}
		else {
			SetSwapObject(1);
			SetCurrentAnimation(L"DOWN", 0, 3, false, true);
			ChaResourceObject->UpdateTransform();
		}

		HitSpeed /= 1.2f;
		if (HitSpeed < 0.05f)
			HitSpeed = 0.0f;

		XMFLOAT4 pos = GetPosition();
		pos.x += HitVecX * HitSpeed;
		pos.y += HitVecY * HitSpeed;
		SetPosition(pos);

		ChaResourceObject->UpdateTransform();
		ChaColliderObject->Transform();
		CheckCollision();
		if (CollisionXY == true && XYCollisionObject->CheckID(L"STICK") == false ) {
			HitSpeed = 0.0f;
			SetPosition(prev_pos);
		}
		else {
			prev_pos = pos;
		}
	}
	else{

		static bool set_prev_pos = false;

		static float gravity = 0.05f;
		if (CollisionZ == true)
			gravity = 0.05f;
		else {
			gravity *= 2.0f;
			AddPosition(XMFLOAT4(0, 0, -gravity, 0));
			CollisionPosZ.z -= gravity;
		}

		static int counter = 10;
		counter -= 1;
		if (counter < 0) {
			counter = 10;

			RandomRotZ = (float)((int)rand() % 360);
		}


		XMFLOAT4 rot = GetRotation();
		if (RandomRotZ > rot.z) {
			AddRotation(XMFLOAT4(0, 0, 20, 0));
		}
		else {
			AddRotation(XMFLOAT4(0, 0, -20, 0));
		}
		rot = GetRotation();

		XMFLOAT4 vec = XMFLOAT4(cos(ToRadian(rot.z)), sin(ToRadian(rot.z)), 0, 0);

		XMFLOAT4 pos = GetPosition();
		prev_pos = pos;
		pos.x += vec.x * WalkingSpeed;
		pos.y += vec.y * WalkingSpeed;
		SetPosition(pos);

		ChaResourceObject->UpdateTransform();
		ChaColliderObject->Transform();
		CheckCollision();
		if (CollisionXY == true && XYCollisionObject->CheckID(L"STICK") == false) {

			if (set_prev_pos == false) {
				RandomRotZ += 180.0f;
				rot.z += 180.0f;
			}
			set_prev_pos = true;

			if (RandomRotZ > 360.0f)
				RandomRotZ -= 360.0f;
			if (rot.z > 360.0f)
				rot.z -= 360.0f;

			SetRotation(rot);
			SetPosition(prev_pos);
		}
		else
			set_prev_pos = false;

		pos = GetPosition();
		if (CollisionXY == true && XYCollisionObject->CheckID(L"STICK") == false && XYCollisionObject->CheckID(L"COCO1") == false) {

			XMVECTOR vec = XMVectorSet(XYCollisionObject->CollisionNormalXY.x, XYCollisionObject->CollisionNormalXY.y, XYCollisionObject->CollisionNormalXY.z, 0.0f);
			vec = XMVector3Normalize(vec);
			float x = XMVectorGetX(vec);
			float y = XMVectorGetY(vec);
			SetPosition(XMFLOAT4(pos.x + x * 0.1f, pos.y + y * 0.1f, pos.z, 0.0f));
			prev_pos = GetPosition();
		}
		else
			set_prev_pos = false;

		pos = GetPosition();
		if (pos.z < CollisionPosZ.z - 0.6) {
			SetPosition(XMFLOAT4(pos.x, pos.y, CollisionPosZ.z - 0.6f, 0));
		}
	}
}

void CPiske::OnKeyUp(UINT nChar) {

	return;

	if (Move == true) {
		SetCurrentAnimation(L"STOP", 5, 3, true, false);
		SetRefrainSec(L"STOP", 0.0f);
	}

	Move = false;
	Velocity = 0.0f;
}

void CPiske::OnLButtonDown(UINT nFlag, CPoint point) {
}

void CPiske::OnLButtonUp(UINT nFlag, CPoint point) {
}

void CPiske::OnRButtonDown(UINT nFlag, CPoint point) {
}

void CPiske::OnRButtonUp(UINT nFlag, CPoint point) {
}
