/////////////////////////////////////////////////
//
//  filename: Config.cpp
//  author:Chafumi Touji 
//  date: 2020/03/13 ver1.00
//
/////////////////////////////////////////////////

#include "StdAfx.h"
#include "Config.h"

CConfig::CConfig(){

	wmemset(Path, 0, SIZE_CHAR_MAX);
	wcscpy_s(Path, SIZE_CHAR_MAX, DEFAULT_MODEL_NAME );
	BKColorA = 255;
	BKColorR = 140;
	BKColorG = 110;
	BKColorB = 110;
	TextColorA = 255;
	TextColorR = 200;
	TextColorG = 180;
	TextColorB = 180;
	BarColorA = 255;
	BarColorR = 100;
	BarColorG = 70;
	BarColorB = 70;
	ViewerBKColorA = 255;
	ViewerBKColorR = 220;
	ViewerBKColorG = 220;
	ViewerBKColorB = 220;
	MenuBKColorA = 255;
	MenuBKColorR = 110;
	MenuBKColorG = 80;
	MenuBKColorB = 80;
	MenuTextColorA = 255;
	MenuTextColorR = 220;
	MenuTextColorG = 200;
	MenuTextColorB = 200;
	LightPosX = 10.0f;
	LightPosY = 10.0f;
	LightPosZ = 10.0f;
	RotationX = 1.1f;
	RotationZ = -2.5f;

	wmemset(ExtModel, 0, SIZE_CHAR_MAX);
	wmemset(ExtAnim, 0, SIZE_CHAR_MAX);
	wmemset(ExtDae, 0, SIZE_CHAR_MAX);
	wmemset(ExtCdr, 0, SIZE_CHAR_MAX);
	wcscpy_s(ExtModel, SIZE_CHAR_MAX, EXT_MODEL);
	wcscpy_s(ExtAnim, SIZE_CHAR_MAX, EXT_ANIM);
	wcscpy_s(ExtDae, SIZE_CHAR_MAX, EXT_DAE);
	wcscpy_s(ExtCdr, SIZE_CHAR_MAX, EXT_CDR);
}

CConfig::~CConfig(){

}

bool CConfig::LoadConfigFile(const wchar_t *filename){

	FILE *file = NULL;

	_wfopen_s(&file, filename, L"r");
	if (file == NULL)
		return false;

	char *ctx;
	char line[SIZE_CHAR_MAX];
	char *param1;
	char *param2;
	while (fgets(line, SIZE_CHAR_MAX, file) != NULL){
		param1 = strtok_s(line, " =", &ctx);
		param2 = strtok_s(NULL, " =\n", &ctx);
		GetParamS(Path, "ModelPath", param1, param2);
		GetParamI(&BKColorA, "BKColorA", param1, param2);
		GetParamI(&BKColorR, "BKColorR", param1, param2);
		GetParamI(&BKColorG, "BKColorG", param1, param2);
		GetParamI(&BKColorB, "BKColorB", param1, param2);
		GetParamI(&TextColorA, "TextColorA", param1, param2);
		GetParamI(&TextColorR, "TextColorR", param1, param2);
		GetParamI(&TextColorG, "TextColorG", param1, param2);
		GetParamI(&TextColorB, "TextColorB", param1, param2);
		GetParamI(&BarColorA, "BarColorA", param1, param2);
		GetParamI(&BarColorR, "BarColorR", param1, param2);
		GetParamI(&BarColorG, "BarColorG", param1, param2);
		GetParamI(&BarColorB, "BarColorB", param1, param2);
		GetParamI(&ViewerBKColorA, "ViewerBKColorA", param1, param2);
		GetParamI(&ViewerBKColorR, "ViewerBKColorR", param1, param2);
		GetParamI(&ViewerBKColorG, "ViewerBKColorG", param1, param2);
		GetParamI(&ViewerBKColorB, "ViewerBKColorB", param1, param2);
		GetParamI(&MenuBKColorA, "MenuBKColorA", param1, param2);
		GetParamI(&MenuBKColorR, "MenuBKColorR", param1, param2);
		GetParamI(&MenuBKColorG, "MenuBKColorG", param1, param2);
		GetParamI(&MenuBKColorB, "MenuBKColorB", param1, param2);
		GetParamI(&MenuTextColorA, "MenuTextColorA", param1, param2);
		GetParamI(&MenuTextColorR, "MenuTextColorR", param1, param2);
		GetParamI(&MenuTextColorG, "MenuTextColorG", param1, param2);
		GetParamI(&MenuTextColorB, "MenuTextColorB", param1, param2);
		GetParamF(&LightPosX, "LightPosX", param1, param2);
		GetParamF(&LightPosY, "LightPosY", param1, param2);
		GetParamF(&LightPosZ, "LightPosZ", param1, param2);
		GetParamF(&RotationX, "RotationX", param1, param2);
		GetParamF(&RotationZ, "RotationZ", param1, param2);
		GetParamS(ExtModel, "ExtModel", param1, param2);
		GetParamS(ExtAnim, "ExtAnim", param1, param2);
		GetParamS(ExtDae, "ExtDae", param1, param2);
		GetParamS(ExtCdr, "ExtCdr", param1, param2);
	}

	fclose(file);

	return true;
}

bool CConfig::GetParamI( int *value, const char *name, char *param1, char *param2){

	if (strcmp(param1, name) == 0){
		*value = atoi(param2);
	}

	return true;
}

bool CConfig::GetParamF(float *value, const char *name, char *param1, char *param2){

	if (strcmp(param1, name) == 0){
		*value = (float) atof(param2);
	}

	return true;
}

bool CConfig::GetParamB(bool *value, const char *name, char *param1, char *param2){

	if (strcmp(param1, name) == 0){
		if (strcmp(param2, "true") == 0 || strcmp(param2, "1") == 0 || strcmp(param2, "TRUE") == 0)
			*value = true;
		else
			*value = false;
	}

	return true;
}

bool CConfig::GetParamS(wchar_t *str, const char *name, char *param1, char *param2){

	size_t size;
	if (strcmp(name, param1) == 0){
		mbstowcs_s(&size, str, SIZE_CHAR_MAX, param2, SIZE_CHAR_MAX);
	}

	return true;
}

bool CConfig::WriteParamI(FILE *file, const char *param1, int value){

	char paramline[SIZE_CHAR_MAX];
	memset(paramline, 0, SIZE_CHAR_MAX);

	char data[SIZE_CHAR_MAX];
	memset(data, 0, SIZE_CHAR_MAX);

	strcpy_s(paramline, SIZE_CHAR_MAX, param1);
	sprintf_s(data, "%d", value);
	strcat_s(paramline, SIZE_CHAR_MAX, data);
	strcat_s(paramline, SIZE_CHAR_MAX, "\n");
	fputs(paramline, file);

	return true;
}

bool CConfig::WriteParamF(FILE *file, const char *param1, float value){

	char paramline[SIZE_CHAR_MAX];
	memset(paramline, 0, SIZE_CHAR_MAX);

	char data[SIZE_CHAR_MAX];
	memset(data, 0, SIZE_CHAR_MAX);

	strcpy_s(paramline, SIZE_CHAR_MAX, param1);
	sprintf_s(data, "%.6f", value);
	strcat_s(paramline, SIZE_CHAR_MAX, data);
	strcat_s(paramline, SIZE_CHAR_MAX, "\n");
	fputs(paramline, file);

	return true;
}

bool CConfig::WriteParamB(FILE *file, const char *param1, bool value){

	char paramline[SIZE_CHAR_MAX];
	memset(paramline, 0, SIZE_CHAR_MAX);

	char data[SIZE_CHAR_MAX];
	memset(data, 0, SIZE_CHAR_MAX);

	strcpy_s(paramline, SIZE_CHAR_MAX, param1);
	if ( value == true )
		sprintf_s(data, "true");
	else
		sprintf_s(data, "false");
	strcat_s(paramline, SIZE_CHAR_MAX, data);
	strcat_s(paramline, SIZE_CHAR_MAX, "\n");
	fputs(paramline, file);

	return true;
}

bool CConfig::WriteParamS(FILE *file, const char *param1, wchar_t *str){

	char paramline[SIZE_CHAR_MAX];
	memset(paramline, 0, SIZE_CHAR_MAX);

	char data[SIZE_CHAR_MAX];
	memset(data, 0, SIZE_CHAR_MAX);
	size_t size;
	if (str != NULL)
		wcstombs_s(&size, data, SIZE_CHAR_MAX, str, SIZE_CHAR_MAX);

	strcpy_s(paramline, SIZE_CHAR_MAX, param1);
	strcat_s(paramline, SIZE_CHAR_MAX, data);
	strcat_s(paramline, SIZE_CHAR_MAX, "\n");
	fputs(paramline, file);

	return true;
}

bool CConfig::WriteConfigFile(const wchar_t *filename){

	FILE *file;
	
	_wfopen_s(&file, filename, L"w");
	if (file == NULL)
		return false;

	WriteParamS(file, "ModelPath = ", Path);
	WriteParamS(file, "ExtModel = ", ExtModel);
	WriteParamS(file, "ExtAnim = ", ExtAnim);
	WriteParamS(file, "ExtCdr = ", ExtCdr);
	WriteParamS(file, "ExtDae = ", ExtDae);
	WriteParamI(file, "BKColorA = ", BKColorA);
	WriteParamI(file, "BKColorR = ", BKColorR);
	WriteParamI(file, "BKColorG = ", BKColorG);
	WriteParamI(file, "BKColorB = ", BKColorB);
	WriteParamI(file, "TextColorA = ", TextColorA);
	WriteParamI(file, "TextColorR = ", TextColorR);
	WriteParamI(file, "TextColorG = ", TextColorG);
	WriteParamI(file, "TextColorB = ", TextColorB);
	WriteParamI(file, "BarColorA = ", BarColorA);
	WriteParamI(file, "BarColorR = ", BarColorR);
	WriteParamI(file, "BarColorG = ", BarColorG);
	WriteParamI(file, "BarColorB = ", BarColorB);
	WriteParamI(file, "ViewerBKColorA = ", ViewerBKColorA);
	WriteParamI(file, "ViewerBKColorR = ", ViewerBKColorR);
	WriteParamI(file, "ViewerBKColorG = ", ViewerBKColorG);
	WriteParamI(file, "ViewerBKColorB = ", ViewerBKColorB);
	WriteParamI(file, "MenuBKColorA = ", MenuBKColorA);
	WriteParamI(file, "MenuBKColorR = ", MenuBKColorR);
	WriteParamI(file, "MenuBKColorG = ", MenuBKColorG);
	WriteParamI(file, "MenuBKColorB = ", MenuBKColorB);
	WriteParamI(file, "MenuTextColorA = ", MenuTextColorA);
	WriteParamI(file, "MenuTextColorR = ", MenuTextColorR);
	WriteParamI(file, "MenuTextColorG = ", MenuTextColorG);
	WriteParamI(file, "MenuTextColorB = ", MenuTextColorB);
	WriteParamF(file, "LightPosX = ", LightPosX);
	WriteParamF(file, "LightPosY = ", LightPosY);
	WriteParamF(file, "LightPosZ = ", LightPosZ);
	WriteParamF(file, "RotationX = ", RotationX);
	WriteParamF(file, "RotationZ = ", RotationZ);

	fclose(file);

	return true;
}
