/////////////////////////////////////////////////
//
//  filename: CustomButton.jpp
//  author:Chafumi Touji
//  date: 2018/04/03 ver1.00
//		  2020/02/06 ver1.01
//
/////////////////////////////////////////////////

#include "StdAfx.h"
#include "Main.h"
#include "CustomButton.h"
#include "MainWindow.h"
#include "Config.h"

CCustomButton::CCustomButton(){

	Width = 0;
	Height = 0;
	PosX = PosY = 0;
	LButtonDown = false;
	ButtonImage = NULL;
	ButtonDownImage = NULL;
	FrameEdgeX = 0;
	FrameEdgeY = 0;
	BKColorA = 255;
	BKColorR = 0;
	BKColorG = 0;
	BKColorB = 0;
}

CCustomButton::~CCustomButton(){

}

bool CCustomButton::Action(){

	return true;
}

void CCustomButton::OnLButtonDown(UINT nFlag, CPoint point){

	::SetCapture( m_hWnd );
	LButtonDown = true;

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CCustomButton::OnLButtonUp(UINT nFlag, CPoint point){

	::ReleaseCapture();
	LButtonDown = false;

	Action();

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CCustomButton::OnPaint(){

	PAINTSTRUCT ps;
	HDC hdc = ::BeginPaint(m_hWnd, &ps);
	OnDraw(hdc);
	::EndPaint(m_hWnd, &ps);
}

bool CCustomButton::SetColor(int a, int r, int g, int b){

	BKColorA = a;
	BKColorR = r;
	BKColorG = g;
	BKColorB = b;

	return true;
}

bool CCustomButton::OnDraw(HDC hdc){

	Gdiplus::Graphics *gfc = new Gdiplus::Graphics(hdc);

	Gdiplus::SolidBrush *brush = new Gdiplus::SolidBrush(Gdiplus::Color(BKColorA, BKColorR, BKColorG, BKColorB));
	gfc->FillRectangle(brush, FrameEdgeX, FrameEdgeY, Width, Height);
	delete brush;

	if (LButtonDown == true)
		gfc->DrawImage(ButtonDownImage, FrameEdgeX, FrameEdgeY, Width, Height);
	else
		gfc->DrawImage(ButtonImage, FrameEdgeX, FrameEdgeY, Width, Height);

	delete gfc;

	return true;
}

bool CCustomButton::OnDraw(HDC hdc, int pos_x, int pos_y, int width, int height ){

	Gdiplus::Graphics *gfc = new Gdiplus::Graphics(hdc);

	Gdiplus::SolidBrush *brush = new Gdiplus::SolidBrush(Gdiplus::Color(BKColorA, BKColorR, BKColorG, BKColorB));
	gfc->FillRectangle(brush, pos_x, pos_y, width, height);
	delete brush;

	if (LButtonDown == true)
		gfc->DrawImage(ButtonDownImage, pos_x, pos_y, width, height);
	else
		gfc->DrawImage(ButtonImage, pos_x, pos_y, width, height);

	delete gfc;

	return true;
}

bool CCustomButton::CreateWnd(int x, int y, int w, int h, HWND ParentWnd){

	WNDCLASSEX wcx;
	memset(&wcx, 0, sizeof(WNDCLASSEX));
	wcx.style = CS_HREDRAW | CS_VREDRAW;
	wcx.cbSize = sizeof(WNDCLASSEX);
	wcx.hInstance = NULL;
	wcx.hIcon = NULL;
	wcx.lpszMenuName = NULL;
	wcx.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcx.lpfnWndProc = &CCustomButton::WindowProc;
	wcx.lpszClassName = L"CLASS_CUSTOMBUTTON";
	RegisterClassEx(&wcx);

	PosX = x;
	PosY = y;
	Width = w;
	Height = h;

	m_hWnd = CreateWindowEx(WS_EX_LEFT, L"CLASS_CUSTOMBUTTON", L"", WS_CHILD, PosX, PosY, Width, Height, ParentWnd, NULL, NULL, NULL);
	::SetWindowLongPtr(m_hWnd, GWLP_USERDATA, (UINT_PTR) this);

	::ShowWindow(m_hWnd, SW_SHOW);

	return true;
}

LRESULT CCustomButton::WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam){

	CCustomButton *button = (CCustomButton *) ::GetWindowLongPtr(hwnd, GWLP_USERDATA);
	if (button != NULL)
		button->CustomButtonWindowProc(hwnd, message, wParam, lParam);

	return DefWindowProc(hwnd, message, wParam, lParam);
}

LRESULT CCustomButton::CustomButtonWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam){

	int width = 0;
	int height = 0;
	int x = 0;
	int y = 0;

	switch (message){
	case WM_PAINT:
		OnPaint();
		break;
	case WM_LBUTTONDOWN:
		x = LOWORD(lParam);
		y = HIWORD(lParam);
		OnLButtonDown((UINT)wParam, CPoint(x, y));
		break;
	case WM_LBUTTONUP:
		x = LOWORD(lParam);
		y = HIWORD(lParam);
		OnLButtonUp((UINT)wParam, CPoint(x, y));
		break;
	default:
		break;
	}

	return 0;
}

bool CCustomButton::SetImage(const wchar_t* button_img_path, const wchar_t * button_down_img_path){

	ButtonImage = Gdiplus::Image::FromFile(button_img_path);
	ButtonDownImage = Gdiplus::Image::FromFile(button_down_img_path);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonClose::Action(){
	
	if (theApp->MainWindow->Config != NULL){
		::SetCurrentDirectory(theApp->MainWindow->InitDirectory);
		theApp->MainWindow->Config->WriteConfigFile(L"config.ini");
	}

	::SendMessage(theApp->MainWindow->m_hWnd, WM_DESTROY, 0, 0);
	PostQuitMessage(1);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonMinimize::Action(){

	CMainWindow *main_wnd = (CMainWindow *) theApp->MainWindow;
	::ShowWindow(main_wnd->m_hWnd, SW_MINIMIZE);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonMaximize::Action(){

	CMainWindow *main_wnd = (CMainWindow *)theApp->MainWindow;
	if (main_wnd->IsMaximized == true){
		::ShowWindow(main_wnd->m_hWnd, SW_RESTORE);
		main_wnd->IsMaximized = false;
	}
	else{
		::ShowWindow( main_wnd->m_hWnd, SW_MAXIMIZE);
		main_wnd->IsMaximized = true;
	}
	return true;
}

///////////////////////////////////////////////////////////////////////////////

