/////////////////////////////////////////////////
//
//  filename: CommonDevice.h
//  author:Chafumi Touji
//  date: 2021/06/30 ver1.00
//
/////////////////////////////////////////////////

#ifndef __COMMONDEVICE_H__
#define __COMMONDEVICE_H__

struct Vertex {

	float3 Pos;
	float3 Normal;
	float4 Color;
	float2 Tex;
	float2 Weight[WEIGHT_BONE_APPLY_NUM];
};

struct CScreenVertex {

	float3 Pos;
	float3 Normal;
	float2 Tex;
};

struct ConstantBuffer1 {

	XMFLOAT4X4	MatWorld;
	XMFLOAT4X4	MatView;
	XMFLOAT4X4	MatProj;
	XMFLOAT4X4	MatLight;
	XMFLOAT4X4	MatProjLight;
	XMFLOAT4	LightColor[16];
	XMFLOAT4	LightPos[16];
	XMFLOAT4	EyePos;
	XMFLOAT4	ShaderParam1;
};

class CCommonDevice {
public:

	ComPtr<ID3D12Debug> DebugLayer;
	ID3D12Device1* m_pDevice;
	ID3D12CommandQueue* m_pCmdQue;
	ID3D12CommandAllocator* m_pCmdAlloc;
	ID3D12GraphicsCommandList* m_pCmdList;
	IDXGIFactory4* m_pFactory;
	IDXGIAdapter1* m_pAdapter;
	IDXGISwapChain3* m_pSwapChain;
	ID3D12Fence1* m_pFence;
	HANDLE						FenceEvent;
	UINT64						FenceValue;
	D3D12_RECT					ScissorRect;
	UINT64						FrameIndex;

	D3D12_VERTEX_BUFFER_VIEW* VertexBufferView;

	int							RTVDescriptorSize;
	int							DepthDescriptorSize;
	int64_t			TmpSRVNum;
	int64_t			ToonSRVNum;
	int64_t			ToonDepthSRVNum;
	int64_t			ShadowMapSRVNum;

	ID3D12DescriptorHeap* m_pRTVHeap;
	ID3D12DescriptorHeap* m_pDepthHeap;
	ID3D12DescriptorHeap* m_pShadowMapHeap;
	ID3D12DescriptorHeap* m_pTmpHeap;
	ID3D12DescriptorHeap* m_pToonHeap;
	ID3D12DescriptorHeap* m_pToonDepthHeap;

	D3D12_CPU_DESCRIPTOR_HANDLE handleTmpRTV;
	D3D12_CPU_DESCRIPTOR_HANDLE handleTmpSRV;
	D3D12_CPU_DESCRIPTOR_HANDLE handleToonRTV;
	D3D12_CPU_DESCRIPTOR_HANDLE handleToonSRV;
	D3D12_CPU_DESCRIPTOR_HANDLE handleToonDepthRTV;
	D3D12_CPU_DESCRIPTOR_HANDLE handleToonDepthSRV;
	D3D12_CPU_DESCRIPTOR_HANDLE handleRTV;
	D3D12_CPU_DESCRIPTOR_HANDLE handleDSV;
	D3D12_CPU_DESCRIPTOR_HANDLE handleShadowMapRTV;
	D3D12_CPU_DESCRIPTOR_HANDLE handleShadowMapSRV;

	ID3D12Resource* m_pDepthStencilView;
	ID3D12Resource* m_pRenderTarget[2];
	ID3D12Resource* m_pTmpTexture;
	ID3D12Resource* m_pToonTexture;
	ID3D12Resource* m_pToonDepthTexture;
	ID3D12Resource* m_pShadowMapTexture;

	ID3D12Resource* m_pVertexBuffer;

	ID3D12DescriptorHeap* m_pHeap;
	CResManager* ResManager;

	ID3D12Resource* m_pConstantBuffer;
	ConstantBuffer1			constant_buffer;
	ConstantBuffer1* constant_buffer_begin;
	int64_t							constant_buffer_begin_num;

	ID3DBlob* Signature;
	ID3DBlob* Error;
	ID3D12RootSignature* RootSignature;
	ID3DBlob* m_pVS1Blob, * m_pVS2Blob, * m_pVS3Blob, * m_pVS4Blob, * m_pVS5Blob, * m_pVS6Blob;
	ID3DBlob* m_pPS1Blob, * m_pPS2Blob, * m_pPS3Blob, * m_pPS4Blob, * m_pPS5Blob, * m_pPS6Blob;

	ID3D12PipelineState* m_pPipeLineState1, * m_pPipeLineState2, * m_pPipeLineState3, * m_pPipeLineState4, *m_pPipeLineState5, *m_pPipeLineState6;

	IDXGISurface1* m_pSurface;

public:
	CCommonDevice();
	~CCommonDevice();
	bool CreateCommonDevice( HWND m_hWnd, int res_width, int res_height );
	bool ReleaseCommonDevice();
};

#endif