/////////////////////////////////////////////////
//
//  filename: DispWindow.h
//  author:Chafumi Touji
//  date: 2021/06/30 ver1.00
//
/////////////////////////////////////////////////

#ifndef __DISPWINDOW_H__
#define __DISPWINDOW_H__

class CObjectManager;

class CDispWindow {
public:

	CCommonDevice* Device;
	CObjectManager* ObjectManager;
	CCameraBase* Camera;

	wchar_t						Path[SIZE_CHAR_MAX];
	XMFLOAT4					BKColor;

	HWND			m_hWnd;
	UINT			TimerID;
	int				UpdateFrameCount;

	int				Width, Height;
	int				ResolutionWidth, ResolutionHeight;

	bool			Rock;
	bool			ReloadRock;

	bool			IsFullScreen;
	bool			BackFullScreen;
	bool			IsTransparent;
	int				TransparentR, TransparentG, TransparentB;

	bool			LButtonDown;
	bool			RButtonDown;
	CPoint			DownPoint;

public:
	CDispWindow();
	~CDispWindow();
	bool CreateWnd(HWND parent_wnd, int x, int y, int w, int h);
	bool Run();
	bool Draw(CObjectManager* manager);
	bool DrawShadowMap( CObjectManager *manager );
	bool Render( CObjectManager *manager );
	bool CheckCollision(CObjectManager* manager);
	bool DrawCollider(bool draw);

public:
	void OnPaint();
	void OnKeyDown(UINT nChar);
	void OnLButtonDown(UINT nFlag, CPoint point);
	void OnLButtonUp(UINT nFlag, CPoint point);
	void OnRButtonDown(UINT nFlag, CPoint point);
	void OnRButtonUp(UINT nFlag, CPoint point);
	void OnMouseMove(UINT nFlag, CPoint point);
	void OnMouseWheel(UINT key, int delta, CPoint point);
	void OnSize(UINT nType, int cx, int cy);
	void WaitForGPU();

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT DispWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	static void CALLBACK  TimeUpdateCallback(UINT timer_id, UINT msg, LPTIMECALLBACK user, DWORD_PTR data1, DWORD_PTR data2);
};

#endif
