/////////////////////////////////////////////////
//
//  filename: CharacterBase.cpp
//  author:Chafumi Touji
//  date: 2021/07/03 ver1.00
//
/////////////////////////////////////////////////

#ifndef __CHARACTERBASE_H__
#define __CHARACTERBASE_H__

class CCharacterBase {
public:

	CDispWindow* DispWindow;

	wchar_t		ID[SIZE_CHAR_MAX];
	wchar_t		CurrentAnimationID[SIZE_CHAR_MAX];
	int			DataType;

	CVector		*AnimationID;

	float		RotationX, RotationY, RotationZ;
	float		VecX, VecY, VecZ;
	float		Velocity;
	bool		CollisionCheck;
	bool		DrawObject;

	CChaDataObject* ChaDataObject;
	CChaResourceObject* ChaResourceObject;
	CChaColliderObject* ChaColliderObject;

	CListA* SwapChaDataObject;
	CListA* SwapChaResourceObject;
	CListA* SwapChaColliderObject;
	CVector* SwapID;

	bool CollisionZ;
	bool CollisionXY;
	float DistZ, DistXY;

	XMFLOAT4	CollisionPosZ, CollisionPosXY;
	XMFLOAT4	CollisionNormalZ, CollisionNormalXY;
	CCharacterBase* XYCollisionObject;
	CCharacterBase* ZCollisionObject;
	
public:

	CCharacterBase();
	CCharacterBase(CDispWindow *DispWindow);
	~CCharacterBase();
	bool Load(CCommonDevice *device, const wchar_t *filename, const wchar_t *id, int64_t swap_id  );
	bool Copy(CCommonDevice *device, CChaResourceObject *res_object, CChaColliderObject *collider_object, const wchar_t* ID);
	bool SetSwapObject(int64_t swap_id);
	XMFLOAT4 GetScaling();
	bool SetScaling(XMFLOAT4 scale);
	bool AddScaling(XMFLOAT4 scale);
	XMFLOAT4 GetRotation();
	bool SetRotation(XMFLOAT4 rot);
	bool AddRotation(XMFLOAT4 rot);
	XMFLOAT4 GetPosition();
	bool SetPosition(XMFLOAT4 point);
	bool AddPosition(XMFLOAT4 point);
	XMFLOAT4 GetVector();
	bool SetVector(XMFLOAT4 vec);
	bool AddVector(XMFLOAT4 vec);
	float GetVelocity();
	bool SetVelocity(float velocity);
	bool AddVelocity(float velocity);
	bool SetCollisionCheck(bool check);
	bool SetFrameCount(int count);
	bool SetCurrentAnimation(const wchar_t* anim_id, int change_frame, float speed, bool refrain, bool model_swapped  );
	bool SetRefrainSec(const wchar_t* anim_id, float sec);
	bool IsAnimationFinished(const wchar_t* anim_id);
	bool CheckCollision();
	bool CheckID(const wchar_t* id);
	bool ShowObject(bool show);
	CCharacterBase* GetChaObject(const wchar_t* id);
	virtual void PreAction();
	virtual void Action();
	virtual void OnKeyDown(UINT nChar);
	virtual void OnKeyUp(UINT nChar);
	virtual void OnLButtonDown(UINT nFlag, CPoint point);
	virtual void OnLButtonUp(UINT nFlag, CPoint point);
	virtual void OnRButtonDown(UINT nFlag, CPoint point);
	virtual void OnRButtonUp(UINT nFlag, CPoint point);
};

#endif