/////////////////////////////////////////////////
//
//  filename: CameraBase.cpp
//  author:Chafumi Touji
//  date: 2021/07/30 ver1.00
//
/////////////////////////////////////////////////

#ifndef __CAMERABASE_H__
#define __CAMERABASE_H__

class CCameraBase {
public:

	int				Width;
	int				Height;
	float			Aspect;
	float			ViewAngle;

	float			Zoom;
	float			CameraHeight;

	float			RotationX;
	float			RotationY;
	float			RotationZ;

	float			LightPosX, LightPosY, LightPosZ;

	float			EyeX;
	float			EyeY;
	float			EyeZ;

	float			AtX;
	float			AtY;
	float			AtZ;

	float			EyePosX;
	float			EyePosY;
	float			EyePosZ;

	XMMATRIX		matWorld;
	XMMATRIX		matView;
	XMMATRIX		matProj;

public:

	CCameraBase();
	CCameraBase( int width, int height );
	~CCameraBase();
	bool SetCamera( CCommonDevice *device );
	bool SetCameraforShadowMap(CCommonDevice* device);
	bool SetEyePos(float x, float y, float z);
	bool SetCameraAt(float x, float y, float z);
	bool SetCameraRot(float x, float y, float z);
	bool SetZoom(float zoom);
};

#endif