/////////////////////////////////////////////////
//
//  filename: ObjectManager.cpp
//  author:Chafumi Touji
//  date: 2021/07/03 ver1.00
//
/////////////////////////////////////////////////

#include "defcha3d.h"

CObjectManager::CObjectManager() {

	Device = NULL;
	DispWindow = NULL;
	CharacterList = new CListA();
	ObjectList = new CListA();
	DrawCollider = false;
}

CObjectManager::CObjectManager(CCommonDevice* device, CDispWindow *disp_window) {

	Device = device;
	DispWindow = disp_window;
	CharacterList = new CListA();
	ObjectList = new CListA();
}

CObjectManager::~CObjectManager() {

	delete CharacterList;
	delete ObjectList;
}

bool CObjectManager::AddCharacter(const wchar_t* filename, const wchar_t* id, CCharacterBase *obj, int64_t swap_id ) {

	bool load = obj->Load(Device, filename, id, swap_id );
	if (load == false) {
		delete obj;
		return false;
	}

	CharacterList->InsTail((void*)obj);

	return true;
}

bool CObjectManager::AddObject(const wchar_t* filename, const wchar_t* id, CCharacterBase *obj, int64_t swap_id  ) {

	bool load = obj->Load(Device, filename, id, swap_id);
	if (load == false) {
		delete obj;
		return false;
	}

	ObjectList->InsTail((void*)obj);

	return true;
}

bool CObjectManager::AddSwapCharacter(const wchar_t* filename, const wchar_t* id, int64_t swap_id ) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(obj->ID, id) == 0) {

			bool load = obj->Load(Device, filename, id, swap_id);
			if (load == false) {
				return false;
			}
			obj->SetSwapObject(0);

			break;
		}

	}

	return true;
}

bool CObjectManager::AddSwapObject(const wchar_t* filename, const wchar_t* id, int64_t swap_id) {

	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(obj->ID, id) == 0) {

			bool load = obj->Load(Device, filename, id, swap_id);
			if (load == false) {
				return false;
			}
			obj->SetSwapObject(0);

			break;
		}
	}

	return true;
}

bool CObjectManager::CopyCharacter(const wchar_t* origin_id, const wchar_t* id) {

	CCharacterBase* origin = GetCharacterData(origin_id);

	if (origin == NULL)
		return false;

	CCharacterBase* new_object = new CCharacterBase();
	new_object->Copy(Device, origin->ChaResourceObject, origin->ChaColliderObject, id);

	CharacterList->InsTail((void*)new_object);

	return true;
}

bool CObjectManager::CopyObject(const wchar_t* origin_id, const wchar_t* id) {

	CCharacterBase* origin = GetCharacterData(origin_id);

	if (origin == NULL)
		return false;

	CCharacterBase* new_object = new CCharacterBase();
	new_object->Copy(Device, origin->ChaResourceObject, origin->ChaColliderObject, id);

	ObjectList->InsTail((void*)new_object);

	return true;
}

bool CObjectManager::DeleteCharacter(const wchar_t* id) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(obj->ID, id) == 0) {
			CharacterList->Delete(i);
			break;
		}

	}

	return true;
}

bool CObjectManager::DeleteObject(const wchar_t* id) {

	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(obj->ID, id) == 0) {
			ObjectList->Delete(i);
			break;
		}

	}

	return true;
}

bool CObjectManager::AddAnimation(const wchar_t *filename, const wchar_t* anim_id, const wchar_t *id, int64_t swap_id  ) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			for (int j = 0; j <= obj->SwapID->PushPos - 1; j++) {
				int64_t* s_id = (int64_t*)obj->SwapID->GetData(j);
				if (*s_id == swap_id) {
					CChaDataObject* data_object = (CChaDataObject*)((CListDataA*)obj->SwapChaDataObject->GetAt(j+1))->Data;
					CVector* animation_id = *(CVector**)obj->AnimationID->GetData(j);
					wchar_t path[SIZE_CHAR_MAX];
					wmemset(path, 0, SIZE_CHAR_MAX);
					wcscpy_s(path, SIZE_CHAR_MAX, filename);
					data_object->LoadAnimation(path);
					animation_id->Push((void*)&anim_id);
				}
			}
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			for (int j = 0; j <= obj->SwapID->PushPos - 1; j++) {
				int64_t* s_id = (int64_t*)obj->SwapID->GetData(j);
				if (*s_id == swap_id) {
					CChaDataObject* data_object = (CChaDataObject*)((CListDataA*)obj->SwapChaDataObject->GetAt(j + 1))->Data;
					CVector* animation_id = *(CVector**)obj->AnimationID->GetData(j);
					wchar_t path[SIZE_CHAR_MAX];
					wmemset(path, 0, SIZE_CHAR_MAX);
					wcscpy_s(path, SIZE_CHAR_MAX, filename);
					data_object->LoadAnimation(path);
					animation_id->Push((void*)&anim_id);
				}
			}
		}
	}

	return true;
}

bool CObjectManager::CopyAnimation(const wchar_t* id) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			for (int j = 0; j <= obj->SwapID->PushPos - 1; j++) {
				CChaDataObject* data_object = (CChaDataObject*)((CListDataA*)obj->SwapChaDataObject->GetAt(j + 1))->Data;
				CChaResourceObject* res_object = (CChaResourceObject*)((CListDataA*)obj->SwapChaResourceObject->GetAt(j + 1))->Data;
				res_object->CopyAnimation(data_object);
			}
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			for (int j = 0; j <= obj->SwapID->PushPos - 1; j++) {
				CChaDataObject* data_object = (CChaDataObject*)((CListDataA*)obj->SwapChaDataObject->GetAt(j + 1))->Data;
				CChaResourceObject* res_object = (CChaResourceObject*)((CListDataA*)obj->SwapChaResourceObject->GetAt(j + 1))->Data;
				res_object->CopyAnimation(data_object);
			}
		}
	}

	return true;
}

CCharacterBase* CObjectManager::GetCharacterData(const wchar_t* id) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			return obj;
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			return obj;
		}
	}

	return NULL;
}

XMFLOAT4 CObjectManager::GetScaling(const wchar_t* id) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			return obj->GetScaling();
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			return obj->GetScaling();
		}
	}

	return XMFLOAT4( 0, 0, 0, 0 );
}

bool CObjectManager::SetScaling(const wchar_t* id, XMFLOAT4 scale) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->SetScaling(scale);

			return true;
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->SetScaling(scale);

			return true;
		}
	}

	return false;
}

bool CObjectManager::AddScaling(const wchar_t* id, XMFLOAT4 scale) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->AddScaling(scale);

			return true;
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->AddScaling(scale);

			return true;
		}
	}

	return false;
}

XMFLOAT4 CObjectManager::GetRotation(const wchar_t* id) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			return obj->GetRotation();
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			return obj->GetRotation();
		}
	}

	return XMFLOAT4(0, 0, 0, 0);
}

bool CObjectManager::SetRotation(const wchar_t* id, XMFLOAT4 rot) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->SetRotation(rot);

			return true;
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->SetRotation(rot);

			return true;
		}
	}

	return false;
}

bool CObjectManager::AddRotation(const wchar_t* id, XMFLOAT4 rot) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->AddRotation(rot);

			return true;
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->AddRotation(rot);

			return true;
		}
	}

	return false;
}

XMFLOAT4 CObjectManager::GetPosition(const wchar_t* id) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			return obj->GetPosition();
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			return obj->GetPosition();
		}
	}

	return XMFLOAT4(0, 0, 0, 0);
}

bool CObjectManager::SetPosition(const wchar_t* id, XMFLOAT4 point) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->SetPosition(point);

			return true;
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->SetPosition(point);

			return true;
		}
	}

	return false;
}

bool CObjectManager::AddPosition(const wchar_t* id, XMFLOAT4 point) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->AddPosition(point);

			return true;
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->AddPosition(point);

			return true;
		}
	}

	return false;
}

XMFLOAT4 CObjectManager::GetVector(const wchar_t* id) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			return obj->GetVector();
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			return obj->GetVector();
		}
	}

	return XMFLOAT4(0, 0, 0, 0);
}

bool CObjectManager::SetVector(const wchar_t* id, XMFLOAT4 vec) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->SetVector(vec);

			return true;
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->SetVector(vec);

			return true;
		}
	}

	return false;
}

bool CObjectManager::AddVector(const wchar_t* id, XMFLOAT4 vec) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->AddVector(vec);

			return true;
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->AddVector(vec);

			return true;
		}
	}

	return false;
}

float CObjectManager::GetVelocity(const wchar_t* id) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			return obj->GetVelocity();
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			return obj->GetVelocity();
		}
	}

	return 0.0f;
}

bool CObjectManager::SetVelocity(const wchar_t* id, float velocity) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->SetVelocity(velocity);

			return true;
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->SetVelocity(velocity);

			return true;
		}
	}

	return false;
}

bool CObjectManager::AddVelocity(const wchar_t* id, float velocity) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->AddVelocity(velocity);

			return true;
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			obj->AddVelocity(velocity);

			return true;
		}
	}

	return false;
}

bool CObjectManager::PreAction() {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		obj->PreAction();
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		obj->PreAction();
	}

	return true;
}

bool CObjectManager::Action() {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		obj->Action();
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		obj->Action();
	}

	return true;
}

bool CObjectManager::DrawCharacter() {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		if (obj->DrawObject == true) {
			obj->ChaResourceObject->Draw(Device->m_pCmdList, 1, 2, 5);
		}
	}

	return true;
}

bool CObjectManager::DrawObject() {

	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		if (obj->DrawObject == true) {
			obj->ChaResourceObject->Draw(Device->m_pCmdList, 1, 2, 5);
		}
	}

	return true;
}

bool CObjectManager::DrawCharacterCollider() {

	if (DrawCollider == true) {

		Device->m_pCmdList->IASetVertexBuffers(0, 1, Device->VertexBufferView);
		Device->m_pCmdList->IASetPrimitiveTopology(D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);

		for (int i = 1; i <= CharacterList->GetSize(); i++) {
			CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
			if (obj->DrawObject == true) {
				if (obj->ChaColliderObject != NULL) {
					obj->ChaColliderObject->Draw(Device->m_pCmdList, DispWindow->Camera->matWorld, DispWindow->Camera->matView, DispWindow->Camera->matProj, Device->m_pPipeLineState3, Device->m_pPipeLineState4, obj->CollisionXY, obj->CollisionZ);
				}
			}
		}

		return true;
	}

	return false;
}

bool CObjectManager::DrawObjectCollider() {

	if (DrawCollider == true) {

		Device->m_pCmdList->IASetPrimitiveTopology(D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
		Device->m_pCmdList->IASetVertexBuffers(0, 1, Device->VertexBufferView);

		for (int i = 1; i <= ObjectList->GetSize(); i++) {
			CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
			if (obj->DrawObject == true) {
				obj->ChaColliderObject->Draw(Device->m_pCmdList, DispWindow->Camera->matWorld, DispWindow->Camera->matView, DispWindow->Camera->matProj, Device->m_pPipeLineState3, Device->m_pPipeLineState4, obj->CollisionXY, obj->CollisionZ);
			}
		}
		return true;
	}

	return false;
}

bool CObjectManager::UpdateFrameCount(int count) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase *) ((CListDataA *)CharacterList->GetAt(i))->Data;
		obj->ChaResourceObject->FrameCount += count;
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA *) ObjectList->GetAt(i))->Data;
		obj->ChaResourceObject->FrameCount += count;
	}

	return true;
}

bool CObjectManager::UpdateTransform() {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		obj->ChaResourceObject->UpdateTransform();
		if (obj->ChaColliderObject != NULL) {
			obj->ChaColliderObject->Transform();
		}
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		obj->ChaResourceObject->UpdateTransform();
		if (obj->ChaColliderObject != NULL) {
			obj->ChaColliderObject->Transform();
		}
	}

	return true;
}

void CObjectManager::OnKeyDown(UINT nChar) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		obj->OnKeyDown(nChar);
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		obj->OnKeyDown(nChar);
	}
}

void CObjectManager::OnKeyUp(UINT nChar) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		obj->OnKeyUp(nChar);
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		obj->OnKeyUp(nChar);
	}
}

void CObjectManager::OnLButtonDown(UINT nFlag, CPoint point) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		obj->OnLButtonDown(nFlag, point);
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		obj->OnLButtonDown(nFlag, point);
	}
}
void CObjectManager::OnLButtonUp(UINT nFlag, CPoint point) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		obj->OnLButtonUp(nFlag, point);
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		obj->OnLButtonUp(nFlag, point);
	}
}

void CObjectManager::OnRButtonDown(UINT nFlag, CPoint point) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		obj->OnRButtonDown(nFlag, point);
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		obj->OnRButtonDown(nFlag, point);
	}
}

void CObjectManager::OnRButtonUp(UINT nFlag, CPoint point) {

	for (int i = 1; i <= CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)CharacterList->GetAt(i))->Data;
		obj->OnRButtonUp(nFlag, point);
	}
	for (int i = 1; i <= ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)ObjectList->GetAt(i))->Data;
		obj->OnRButtonUp(nFlag, point);
	}
}
