/////////////////////////////////////////////////
//
//  filename: DispWindow.cpp
//  author:Chafumi Touji
//  date: 2021/06/30 ver1.00
//
/////////////////////////////////////////////////

#include "defcha3d.h"

CDispWindow::CDispWindow() {

	Width = 0;
	Height = 0;
	IsFullScreen = false;
	BackFullScreen = false;
	IsTransparent = false;

	ResolutionWidth = FULLHD_WIDTH;
	ResolutionHeight = FULLHD_HEIGHT;

	UpdateFrameCount = 8;

	Rock = false;
	ReloadRock = false;
}

CDispWindow::~CDispWindow() {

	timeKillEvent(TimerID);
}

bool CDispWindow::CreateWnd(HWND ParentWnd, int x, int y, int w, int h) {

	WNDCLASSEX wcx;
	memset(&wcx, 0, sizeof(WNDCLASSEX));
	wcx.style = CS_HREDRAW | CS_VREDRAW;
	wcx.cbSize = sizeof(WNDCLASSEX);
	wcx.hInstance = NULL;
	wcx.hIcon = NULL;
	wcx.lpszMenuName = NULL;
	wcx.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcx.lpfnWndProc = &CDispWindow::WindowProc;
	wcx.lpszClassName = L"CLASS_DISPWINDOW";
	RegisterClassEx(&wcx);

	Width = w;
	Height = h;
	m_hWnd = CreateWindowEx(WS_EX_LEFT, L"CLASS_DISPWINDOW", _T("ModelViewer"), WS_CHILD, x, y, w, h, ParentWnd, NULL, NULL, NULL);
	::SetWindowLongPtr(m_hWnd, GWLP_USERDATA, (LONG_PTR)this);

	ResolutionWidth = FULLHD_WIDTH;
	ResolutionHeight = FULLHD_HEIGHT;

	Device = new CCommonDevice();
	Device->CreateCommonDevice(m_hWnd, ResolutionWidth, ResolutionHeight );

	ObjectManager = new CObjectManager(Device, this);

	Camera = new CCameraBase( ResolutionWidth, ResolutionHeight );
	Camera->LightPosX = -15.0f;
	Camera->LightPosY = 15.0f;
	Camera->LightPosZ = 15.0f;

	/////////////////////////////////////////////////////

	::ShowWindow(m_hWnd, SW_SHOW);

	//////////////////////////////////////////////////

	return true;
}

void CALLBACK  CDispWindow::TimeUpdateCallback(UINT timer_id, UINT msg, LPTIMECALLBACK user, DWORD_PTR data1, DWORD_PTR data2) {

	CDispWindow* disp_wnd = (CDispWindow*)user;
	disp_wnd->Render(disp_wnd->ObjectManager);
}

bool CDispWindow::Run() {

	if (TimerID == 0)
		TimerID = ::timeSetEvent(30, 5, (LPTIMECALLBACK)TimeUpdateCallback, (DWORD_PTR)this, TIME_PERIODIC);

	return true;
}

LRESULT CDispWindow::WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) {

	CDispWindow* disp_wnd = (CDispWindow*) ::GetWindowLongPtr(hwnd, GWLP_USERDATA);
	if (disp_wnd != NULL)
		disp_wnd->DispWindowProc(hwnd, message, wParam, lParam);

	return DefWindowProc(hwnd, message, wParam, lParam);
}

LRESULT CDispWindow::DispWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) {

	int width = 0;
	int height = 0;
	int x = 0;
	int y = 0;
	int delta = 0;
	int key = 0;

	switch (message) {
	case WM_PAINT:
		OnPaint();
		break;
	case WM_SIZE:
		width = GET_X_LPARAM(lParam);
		height = GET_Y_LPARAM(lParam);
		OnSize((UINT)wParam, width, height);
		break;
	case WM_LBUTTONDOWN:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		ObjectManager->OnLButtonDown((UINT)wParam, CPoint(x, y));
		OnLButtonDown((UINT)wParam, CPoint(x, y));
		break;
	case WM_LBUTTONUP:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		ObjectManager->OnLButtonUp((UINT)wParam, CPoint(x, y));
		OnLButtonUp((UINT)wParam, CPoint(x, y));
		break;
	case WM_RBUTTONDOWN:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		ObjectManager->OnRButtonDown((UINT)wParam, CPoint(x, y));
		OnRButtonDown((UINT)wParam, CPoint(x, y));
		break;
	case WM_RBUTTONUP:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		ObjectManager->OnRButtonUp((UINT)wParam, CPoint(x, y));
		OnRButtonUp((UINT)wParam, CPoint(x, y));
		break;
	case WM_MOUSEMOVE:
		::SetFocus(m_hWnd);
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		OnMouseMove((UINT)wParam, CPoint(x, y));
		break;
	case WM_MOUSEWHEEL:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		key = GET_KEYSTATE_WPARAM(wParam);
		delta = GET_WHEEL_DELTA_WPARAM(wParam);
		OnMouseWheel(key, delta, CPoint(x, y));
		break;
	case WM_KEYDOWN:
		ObjectManager->OnKeyDown((UINT) wParam);
		OnKeyDown((UINT)wParam);
		break;
	case WM_KEYUP:
		ObjectManager->OnKeyUp((UINT)wParam);
		OnKeyDown((UINT)wParam);
		break;
	default:
		break;
	}

	return 0;
}

void CDispWindow::OnKeyDown(UINT nChar) {

/*	if (nChar == 32 /* enter ) {

		if (IsTransparent == false) {
			BackFullScreen = theApp->MainWindow->IsMaximized;
			IsFullScreen = true;
		}
		else {
			IsFullScreen = BackFullScreen;
		}

		IsTransparent = !IsTransparent;

		if (IsFullScreen == true) {
			::ShowWindow(theApp->MainWindow->m_hWnd, SW_MAXIMIZE);
			theApp->MainWindow->OnSize(SIZE_MAXIMIZED, DisplayWidth, DisplayHeight);
		}
		else {
			::ShowWindow(theApp->MainWindow->m_hWnd, SW_RESTORE);
			theApp->MainWindow->OnSize(SIZE_RESTORED, Width, Height);
		}
		::InvalidateRect(m_hWnd, NULL, false);
		::UpdateWindow(m_hWnd);
	}
*/
}

void CDispWindow::OnSize(UINT nType, int cx, int cy) {

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

bool CDispWindow::CheckCollision(CObjectManager* manager) {

	for (int i = 1; i <= manager->CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)manager->CharacterList->GetAt(i))->Data;
		obj->CollisionZ = false;
		obj->CollisionXY = false;
	}
	for (int i = 1; i <= manager->ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)manager->ObjectList->GetAt(i))->Data;
		obj->CollisionZ = false;
		obj->CollisionXY = false;
	}

	for (int i = 1; i <= manager->CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)manager->CharacterList->GetAt(i))->Data;
		if( obj->CollisionCheck == true )
			obj->CheckCollision();
	}

	return true;
}

bool CDispWindow::DrawCollider(bool draw) {

	if( ObjectManager != NULL )
		ObjectManager->DrawCollider = draw;

	return true;
}

bool CDispWindow::Render(CObjectManager* obj_manager) {

	if (ReloadRock == true)
		return false;

	///////////////////////////////////////////////////////////////////////////

	// R}hAP[^ƃR}hXgZbg.
	Device->m_pCmdAlloc->Reset();
	Device->m_pCmdList->Reset(Device->m_pCmdAlloc, nullptr);

	// fBXNv^q[vݒ.
	Device->m_pCmdList->SetDescriptorHeaps(1, &Device->m_pHeap);

	// [gVOj`ݒ.
	Device->m_pCmdList->SetGraphicsRootSignature(Device->RootSignature);

	// fBXNv^q[ve[uݒ.
	Device->m_pCmdList->SetGraphicsRootConstantBufferView(0, Device->m_pConstantBuffer->GetGPUVirtualAddress());

	// r[|[g̐ݒ.
	D3D12_VIEWPORT vp;
	vp.Width = (float)ResolutionWidth;
	vp.Height = (float)ResolutionHeight;
	vp.TopLeftX = (float)0;
	vp.TopLeftY = (float)0;
	vp.MinDepth = 0.0f;
	vp.MaxDepth = 1.0f;
	Device->m_pCmdList->RSSetViewports(1, &vp);

	// VU[`̐ݒ.
	D3D12_RECT rect;
	rect.top = 0;
	rect.left = 0;
	rect.right = ResolutionWidth;
	rect.bottom = ResolutionHeight;
	Device->m_pCmdList->RSSetScissorRects(1, &rect);

	// _[^[Qbg̃nh擾.
	Device->handleRTV = Device->m_pTmpHeap->GetCPUDescriptorHandleForHeapStart();
	Device->handleDSV = Device->m_pDepthHeap->GetCPUDescriptorHandleForHeapStart();

	Device->m_pCmdList->SetDescriptorHeaps(1, &Device->m_pHeap);

	///////////////////////////////////////////////////////////////////

	obj_manager->PreAction();
	obj_manager->UpdateFrameCount(UpdateFrameCount);
	obj_manager->UpdateTransform();
	CheckCollision(obj_manager);
	obj_manager->Action();

	DrawShadowMap(ObjectManager);

	Device->m_pCmdList->SetGraphicsRootDescriptorTable(6, Device->ResManager->GetGPUHandle(Device->ShadowMapSRVNum));

	Draw(ObjectManager);

	Device->m_pCmdList->SetGraphicsRootDescriptorTable(5, Device->ResManager->GetGPUHandle(Device->TmpSRVNum));
	Device->m_pCmdList->SetGraphicsRootDescriptorTable(7, Device->ResManager->GetGPUHandle(Device->ToonSRVNum));
	Device->m_pCmdList->SetGraphicsRootDescriptorTable(8, Device->ResManager->GetGPUHandle(Device->ToonDepthSRVNum));
	Device->m_pCmdList->SetGraphicsRootDescriptorTable(9, Device->ResManager->GetGPUHandle(Device->ColliderSRVNum));

	///////////////////////////////////////////////////////////////////////////

	Device->handleRTV = Device->m_pRTVHeap->GetCPUDescriptorHandleForHeapStart();
	Device->handleDSV = Device->m_pDepthHeap->GetCPUDescriptorHandleForHeapStart();
	Device->handleRTV.ptr += (Device->FrameIndex * Device->RTVDescriptorSize);

	D3D12_RESOURCE_BARRIER barrier6;
	ZeroMemory(&barrier6, sizeof(barrier6));
	barrier6.Type = D3D12_RESOURCE_BARRIER_TYPE_TRANSITION;
	barrier6.Flags = D3D12_RESOURCE_BARRIER_FLAG_NONE;
	barrier6.Transition.pResource = Device->m_pRenderTarget[Device->FrameIndex];
	barrier6.Transition.StateBefore = D3D12_RESOURCE_STATE_PRESENT;
	barrier6.Transition.StateAfter = D3D12_RESOURCE_STATE_RENDER_TARGET;
	barrier6.Transition.Subresource = D3D12_RESOURCE_BARRIER_FLAG_NONE;
	Device->m_pCmdList->ResourceBarrier(1, &barrier6);

	Device->m_pCmdList->IASetPrimitiveTopology(D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
	Device->m_pCmdList->IASetVertexBuffers(0, 1, Device->VertexBufferView);

	// _[^[Qbg̐ݒ.
	Device->m_pCmdList->OMSetRenderTargets(1, &Device->handleRTV, FALSE, &Device->handleDSV);
	Device->m_pCmdList->SetPipelineState(Device->m_pPipeLineState2);

	// _[^[Qbgr[NA.
	float clearColor2[] = { 0.2f, 0.2f, 0.2f, 1.0f };
	Device->m_pCmdList->ClearRenderTargetView(Device->handleRTV, clearColor2, 0, NULL);
	Device->m_pCmdList->ClearDepthStencilView(Device->handleDSV, D3D12_CLEAR_FLAG_DEPTH, 1.0f, 0, 0, NULL);

	Device->m_pCmdList->IASetPrimitiveTopology(D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);
	Device->m_pCmdList->IASetVertexBuffers(0, 1, Device->VertexBufferView);

	Device->m_pCmdList->DrawInstanced(4, 1, 0, 0);

	// \[XoA̐ݒ.
	barrier6.Transition.StateBefore = D3D12_RESOURCE_STATE_RENDER_TARGET;
	barrier6.Transition.StateAfter = D3D12_RESOURCE_STATE_PRESENT;
	Device->m_pCmdList->ResourceBarrier(1, &barrier6);

	// R}h̋L^I.
	Device->m_pCmdList->Close();

	// R}hs.
	ID3D12CommandList* ppCmdLists[] = { Device->m_pCmdList };
	Device->m_pCmdQue->ExecuteCommandLists(_countof(ppCmdLists), ppCmdLists);

	// \.
	Device->m_pSwapChain->Present(1, 0);

	// R}h̊ҋ@.
	WaitForGPU();

	return true;
}

void CDispWindow::WaitForGPU() {

	// VOiԂɂāCtFXl𑝉.

	UINT64 fence = Device->FenceValue;
	HRESULT hr = Device->m_pCmdQue->Signal(Device->m_pFence, fence);

	Device->FenceValue++;

	// ҋ@.
	if (Device->m_pFence->GetCompletedValue() < fence) {
		hr = Device->m_pFence->SetEventOnCompletion(fence, Device->FenceEvent);
		WaitForSingleObject(Device->FenceEvent, INFINITE);
	}

	// t[obt@ԍXV.
	Device->FrameIndex = Device->m_pSwapChain->GetCurrentBackBufferIndex();
}

bool CDispWindow::Draw(CObjectManager* obj_manager) {

	Camera->SetCamera(Device);
	
	Device->m_pCmdList->ClearDepthStencilView(Device->handleDSV, D3D12_CLEAR_FLAG_DEPTH, 1.0f, 0, 0, NULL);

	float clearColor1[] = { 0.0f, 0.0f, 0.0f, 0.0f };
	Device->m_pCmdList->ClearRenderTargetView(Device->handleToonRTV, clearColor1, 0, NULL);
	Device->m_pCmdList->ClearRenderTargetView(Device->handleToonDepthRTV, clearColor1, 0, NULL);
	Device->m_pCmdList->ClearRenderTargetView(Device->handleColliderRTV, clearColor1, 0, NULL);

	float clearColor2[] = { 0.8f, 0.8f, 0.8f, 1.0f };
	Device->m_pCmdList->ClearRenderTargetView(Device->handleRTV, clearColor2, 0, NULL);

	/////////////////////////////////////////////////////////////////
	//wi̕`

	// _[^[Qbg̐ݒ.
	Device->m_pCmdList->OMSetRenderTargets(1, &Device->handleRTV, FALSE, &Device->handleDSV);
	Device->m_pCmdList->SetPipelineState(Device->m_pPipeLineState1);

	obj_manager->DrawObject();

	// _[^[Qbg̐ݒ.
	D3D12_CPU_DESCRIPTOR_HANDLE rtv[] = { Device->handleToonRTV, Device->handleToonDepthRTV };
	Device->m_pCmdList->OMSetRenderTargets(2, rtv, FALSE, &Device->handleDSV);
	Device->m_pCmdList->SetPipelineState(Device->m_pPipeLineState6);

	obj_manager->DrawCharacter();

	Device->m_pCmdList->ClearDepthStencilView(Device->handleDSV, D3D12_CLEAR_FLAG_DEPTH, 1.0f, 0, 0, NULL);

	if (obj_manager->DrawCollider == true) {

		Device->m_pCmdList->OMSetRenderTargets(1, &Device->handleColliderRTV, FALSE, &Device->handleDSV);
		obj_manager->DrawCharacterCollider();
		obj_manager->DrawObjectCollider();
	}

	return true;
}

bool CDispWindow::DrawShadowMap( CObjectManager *obj_manager ) {

	Device->m_pCmdList->SetPipelineState(Device->m_pPipeLineState5);

	Device->m_pCmdList->ClearRenderTargetView(Device->handleShadowMapRTV, Device->ClearValue3.Color, 0, NULL);
	Device->m_pCmdList->ClearDepthStencilView(Device->handleDSV, D3D12_CLEAR_FLAG_DEPTH, 1.0f, 0, 0, NULL);

	// _[^[Qbg̐ݒ.
	Device->m_pCmdList->OMSetRenderTargets(1, &Device->handleShadowMapRTV, FALSE, &Device->handleDSV);

	// r[|[g̐ݒ.
	D3D12_VIEWPORT vp;
	vp.Width = (float)ResolutionWidth * 2.0f;
	vp.Height = (float)ResolutionHeight * 2.0f;
	vp.TopLeftX = 0;
	vp.TopLeftY = 0;
	vp.MinDepth = 0.0f;
	vp.MaxDepth = 1.0f;
	Device->m_pCmdList->RSSetViewports(1, &vp);

	// VU[`̐ݒ.
	D3D12_RECT rect;
	rect.top = 0;
	rect.left = 0;
	rect.right = ResolutionWidth * 2.0f;
	rect.bottom = ResolutionHeight * 2.0f;
	Device->m_pCmdList->RSSetScissorRects(1, &rect);

	Camera->SetCameraforShadowMap(Device);

	obj_manager->DrawCharacter();
	obj_manager->DrawObject();

	// r[|[g̐ݒ.
	vp.Width = (float)ResolutionWidth;
	vp.Height = (float)ResolutionHeight;
	vp.TopLeftX = (float)0;
	vp.TopLeftY = (float)0;
	vp.MinDepth = 0.0f;
	vp.MaxDepth = 1.0f;
	Device->m_pCmdList->RSSetViewports(1, &vp);

	// VU[`̐ݒ.
	rect.top = 0;
	rect.left = 0;
	rect.right = ResolutionWidth;
	rect.bottom = ResolutionHeight;
	Device->m_pCmdList->RSSetScissorRects(1, &rect);

	return true;
}

void CDispWindow::OnPaint() {
}

void CDispWindow::OnLButtonDown(UINT nFlag, CPoint point) {

	LButtonDown = true;

	::ClientToScreen(m_hWnd, &point);

	DownPoint = point;
	LButtonDown = true;
	::SetCapture(m_hWnd);

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CDispWindow::OnRButtonDown(UINT nFlag, CPoint point) {

	RButtonDown = true;

	::ClientToScreen(m_hWnd, &point);

	DownPoint = point;
	RButtonDown = true;
	::SetCapture(m_hWnd);

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CDispWindow::OnLButtonUp(UINT nFlag, CPoint point) {

	LButtonDown = false;
	::ReleaseCapture();

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CDispWindow::OnRButtonUp(UINT nFlag, CPoint point) {

	::ReleaseCapture();
	RButtonDown = false;

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CDispWindow::OnMouseMove(UINT nFlag, CPoint point) {

	::ClientToScreen(m_hWnd, &point);

	DownPoint = point;

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CDispWindow::OnMouseWheel(UINT nFlag, int zDelta, CPoint point) {

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}
