/////////////////////////////////////////////////
//
//  filename: CharacterBase.cpp
//  author:Chafumi Touji
//  date: 2021/07/03 ver1.00
//
/////////////////////////////////////////////////

#include "defcha3d.h"

CCharacterBase::CCharacterBase() {

	wmemset(ID, 0, SIZE_CHAR_MAX);
	wmemset(CurrentAnimationID, 0, SIZE_CHAR_MAX);
	ChaDataObject = NULL;
	ChaResourceObject = NULL;
	ChaColliderObject = NULL;
	DispWindow = NULL;

	SwapChaDataObject = new CListA();
	SwapChaResourceObject = new CListA();
	SwapChaColliderObject = new CListA();
	SwapID = new CVector(sizeof(int64_t));

	AnimationID = new CVector(sizeof(int64_t));

	RotationX = RotationY = RotationZ = 0.0f;
	VecX = VecY = VecZ = 0.0f;
	Velocity = 0.0f;
	CollisionCheck = true;
	DrawObject = true;
	
	CollisionZ = false;
	CollisionXY = false;

	CollisionPosZ = XMFLOAT4(0, 0, 0, 0);
	CollisionPosXY = XMFLOAT4(0, 0, 0, 0);
	CollisionNormalXY = XMFLOAT4(0, 0, 0, 0);
	CollisionNormalZ = XMFLOAT4(0, 0, 0, 0);
	DistZ = 0.0f;
	DistXY = 0.0f;

	XYCollisionObject = NULL;
	ZCollisionObject = NULL;
}

CCharacterBase::CCharacterBase(CDispWindow *disp_window) {

	DispWindow = disp_window;

	wmemset(ID, 0, SIZE_CHAR_MAX);
	wmemset(CurrentAnimationID, 0, SIZE_CHAR_MAX);
	ChaDataObject = NULL;
	ChaResourceObject = NULL;
	ChaColliderObject = NULL;
	DrawObject = true;

	SwapChaDataObject = new CListA();
	SwapChaResourceObject = new CListA();
	SwapChaColliderObject = new CListA();
	SwapID = new CVector(sizeof(int64_t));

	AnimationID = new CVector(sizeof(int64_t));

	RotationX = RotationY = RotationZ = 0.0f;
	VecX = VecY = VecZ = 0.0f;
	Velocity = 0.0f;
	CollisionCheck = true;
}

CCharacterBase::~CCharacterBase() {

	for (int i = 1; i <= SwapChaDataObject->ListSize; i++) {
		CChaDataObject* obj = *(CChaDataObject**)((CListDataA*)SwapChaDataObject->GetAt(i))->Data;
		delete obj;
	}
	delete SwapChaDataObject;

	for (int i = 1; i <= SwapChaResourceObject->ListSize; i++) {
		CChaResourceObject *obj = *(CChaResourceObject **)((CListDataA*) SwapChaResourceObject->GetAt(i))->Data;
		delete obj;
	}
	delete SwapChaResourceObject;

	for (int i = 1; i <= SwapChaColliderObject->ListSize; i++) {
		CChaColliderObject* obj = *(CChaColliderObject**)((CListDataA*)SwapChaResourceObject->GetAt(i))->Data;
		delete obj;
	}
	delete SwapChaColliderObject;

	delete SwapID;
	delete AnimationID;
}

bool CCharacterBase::Load(CCommonDevice* device, const wchar_t* filename, const wchar_t *id, int64_t swap_id  ) {

	if (filename == NULL || wcslen(filename) <= 4)
		return false;

	wchar_t path[SIZE_CHAR_MAX];
	wmemset(path, 0, SIZE_CHAR_MAX);
	int num = wcslen(filename);
	for (int i = num; i > 0; i--) {
		if (filename[i] == L'/' || filename[i] == L'\\') {
			wcscpy_s(path, SIZE_CHAR_MAX, &filename[i + 1]);
			break;
		}
		num = i;
	}

	wchar_t current_path[SIZE_CHAR_MAX];
	wmemset(current_path, 0, SIZE_CHAR_MAX);
	::GetCurrentDirectory(SIZE_CHAR_MAX, current_path);

	wchar_t new_path[SIZE_CHAR_MAX];
	wmemset(new_path, 0, SIZE_CHAR_MAX);
	wmemcpy_s(new_path, SIZE_CHAR_MAX, filename, num);
	::SetCurrentDirectory(new_path);

	if (wcscmp(&filename[wcslen(filename) - 4], DAEMODEL_EXT_NAME) == 0) {
		ChaDataObject = new CChaDataObject();
		ChaDataObject->LoadDAE(path, DAEMODEL_EXT_NAME);
	}
	else if (wcscmp(&filename[wcslen(filename) - 4], CHAMODEL_EXT_NAME) == 0) {
		ChaDataObject = new CChaDataObject();
		ChaDataObject->LoadModel(path);
	}

	if (ChaDataObject == NULL) {
		::SetCurrentDirectory(current_path);
		return false;
	}

	DataType = DATA_TYPE_ORIGINAL;

	ChaResourceObject = new CChaResourceObject();
	ChaResourceObject->CreateResource(device->m_pDevice, ChaDataObject, device->ResManager, true);

	ChaColliderObject = new CChaColliderObject();
	if (ChaDataObject->ColliderFilePath != NULL) {
		ChaColliderObject->LoadCollider(ChaDataObject->ColliderFilePath);
		ChaColliderObject->CreateResource(device->m_pDevice, ChaResourceObject, device->ResManager);
	}

	wcscpy_s(ID, SIZE_CHAR_MAX, id);

	SwapChaDataObject->InsTail((void*)ChaDataObject);
	SwapChaResourceObject->InsTail((void*)ChaResourceObject);
	SwapChaColliderObject->InsTail((void*)ChaColliderObject);
	SwapID->Push((void*)&swap_id);

	CVector* anim_id = new CVector(SIZE_CHAR_MAX);
	AnimationID->Push((void*)&anim_id);

	::SetCurrentDirectory(current_path);

	return true;
}

bool CCharacterBase::SetSwapObject(int64_t swap_id ) {

	for (int i = 0; i <= SwapID->PushPos - 1; i++) {
		int64_t* id = (int64_t*)SwapID->GetData(i);
		if (*id == swap_id) {
			ChaDataObject = (CChaDataObject*)((CListDataA*)SwapChaDataObject->GetAt(i + 1))->Data;
			ChaResourceObject = (CChaResourceObject*)((CListDataA*)SwapChaResourceObject->GetAt(i + 1))->Data;
			ChaColliderObject = (CChaColliderObject*)((CListDataA*)SwapChaColliderObject->GetAt(i + 1))->Data;
			ChaResourceObject->UpdateTransform();

			return true;
		}
	}

	return false;
}

bool CCharacterBase::Copy(CCommonDevice* device, CChaResourceObject* res_object, CChaColliderObject* collider_object, const wchar_t* id) {

	if (res_object == NULL)
		return false;

	DataType = DATA_TYPE_COPY;
	wcscpy_s(ID, SIZE_CHAR_MAX, id);

	ChaResourceObject = new CChaResourceObject();

	wcscpy_s(ChaResourceObject->ModelID, SIZE_CHAR_MAX, res_object->ModelID);
	ChaResourceObject->DataType = DATA_TYPE_COPY;
	ChaResourceObject->CurrentAnimationNum = res_object->CurrentAnimationNum;
	ChaResourceObject->ResManager = res_object->ResManager;
	ChaResourceObject->IsAnimated = res_object->IsAnimated;
	ChaResourceObject->Refrain = res_object->Refrain;
	ChaResourceObject->AnimationFinished = res_object->AnimationFinished;
	ChaResourceObject->AnimationSpeed = res_object->AnimationSpeed;
	ChaResourceObject->Alpha = res_object->Alpha;
	ChaResourceObject->RefrainSec = res_object->RefrainSec;
	ChaResourceObject->TransformMatrix = res_object->TransformMatrix;
	ChaResourceObject->NormalTransformMatrix = res_object->NormalTransformMatrix;
	ChaResourceObject->Scale = res_object->Scale;
	ChaResourceObject->Rotation = res_object->Rotation;
	ChaResourceObject->Position = res_object->Position;
	ChaResourceObject->ToneLightPosition = res_object->ToneLightPosition;
	ChaResourceObject->FrameCount = res_object->FrameCount;
	ChaResourceObject->GeometryResource = res_object->GeometryResource;
	ChaResourceObject->TextureOrigin = res_object->TextureOrigin;
	ChaResourceObject->ShaderResourceOriginNum = res_object->ShaderResourceOriginNum;
	ChaResourceObject->ControlBone = res_object->ControlBone;
	ChaResourceObject->BoneArray = res_object->BoneArray;
	ChaResourceObject->AnimationList = res_object->AnimationList;

	//////////////////////////////////////////////////////////////////
	//RX^gobt@쐬

	// 萔obt@𐶐.
	// q[vvpeB̐ݒ.
	D3D12_HEAP_PROPERTIES prop;
	ZeroMemory(&prop, sizeof(prop));
	prop.Type = D3D12_HEAP_TYPE_UPLOAD;
	prop.CPUPageProperty = D3D12_CPU_PAGE_PROPERTY_UNKNOWN;
	prop.MemoryPoolPreference = D3D12_MEMORY_POOL_UNKNOWN;
	prop.CreationNodeMask = 1;
	prop.VisibleNodeMask = 1;

	// \[X̐ݒ.
	D3D12_RESOURCE_DESC desc2;
	ZeroMemory(&desc2, sizeof(desc2));
	desc2.Dimension = D3D12_RESOURCE_DIMENSION_BUFFER;
	desc2.Alignment = 0;
	desc2.Width = 0x100;
	desc2.Height = 1;
	desc2.DepthOrArraySize = 1;
	desc2.MipLevels = 1;
	desc2.Format = DXGI_FORMAT_UNKNOWN;
	desc2.SampleDesc.Count = 1;
	desc2.SampleDesc.Quality = 0;
	desc2.Layout = D3D12_TEXTURE_LAYOUT_ROW_MAJOR;
	desc2.Flags = D3D12_RESOURCE_FLAG_NONE;

	// \[X𐶐.
	HRESULT hr = device->m_pDevice->CreateCommittedResource(&prop, D3D12_HEAP_FLAG_NONE, &desc2, D3D12_RESOURCE_STATE_GENERIC_READ, NULL, IID_ID3D12Resource, (void**)&ChaResourceObject->m_pConstantBufferMaterial);

	// 萔obt@r[̐ݒ.
	D3D12_CONSTANT_BUFFER_VIEW_DESC bufferDesc = {};
	bufferDesc.BufferLocation = ChaResourceObject->m_pConstantBufferMaterial->GetGPUVirtualAddress();
	bufferDesc.SizeInBytes = 0x100;

	// 萔obt@r[𐶐.
	int64_t res_num = 0;
	D3D12_CPU_DESCRIPTOR_HANDLE handle = ChaResourceObject->ResManager->CreateCPUHandle(&res_num);
	device->m_pDevice->CreateConstantBufferView(&bufferDesc, handle);
	ChaResourceObject->constant_buffer_material_num = (UINT)res_num;

	// }bv. AvP[VI܂ Unmap Ȃ.
	hr = ChaResourceObject->m_pConstantBufferMaterial->Map(0, NULL, (void**)&ChaResourceObject->constant_buffer_material_begin);

	//////////////////////////////////////////////////////////////////
	//RX^gobt@쐬

	// \[X̐ݒ.
	ZeroMemory(&desc2, sizeof(desc2));
	desc2.Dimension = D3D12_RESOURCE_DIMENSION_BUFFER;
	desc2.Alignment = 0;
	desc2.Width = ((int)sizeof(ConstantBufferJoint) % 256 + 1) * 256;
	desc2.Height = 1;
	desc2.DepthOrArraySize = 1;
	desc2.MipLevels = 1;
	desc2.Format = DXGI_FORMAT_UNKNOWN;
	desc2.SampleDesc.Count = 1;
	desc2.SampleDesc.Quality = 0;
	desc2.Layout = D3D12_TEXTURE_LAYOUT_ROW_MAJOR;
	desc2.Flags = D3D12_RESOURCE_FLAG_NONE;

	// \[X𐶐.
	hr = device->m_pDevice->CreateCommittedResource(&prop, D3D12_HEAP_FLAG_NONE, &desc2, D3D12_RESOURCE_STATE_GENERIC_READ, NULL, IID_ID3D12Resource, (void**)&ChaResourceObject->m_pConstantBufferJoint);

	// 萔obt@r[̐ݒ.
	bufferDesc.BufferLocation = ChaResourceObject->m_pConstantBufferJoint->GetGPUVirtualAddress();
	bufferDesc.SizeInBytes = ((int)sizeof(ConstantBufferJoint) % 256 + 1) * 256;

	// 萔obt@r[𐶐.
	handle = ChaResourceObject->ResManager->CreateCPUHandle(&res_num);
	device->m_pDevice->CreateConstantBufferView(&bufferDesc, handle);
	ChaResourceObject->constant_buffer_joint_num = (UINT)res_num;

	// }bv. AvP[VI܂ Unmap Ȃ.
	hr = ChaResourceObject->m_pConstantBufferJoint->Map(0, NULL, (void**)&ChaResourceObject->constant_buffer_joint_begin);

	ChaColliderObject = new CChaColliderObject();

	if (collider_object != NULL) {

		wcscpy_s(ChaColliderObject->ModelID, SIZE_CHAR_MAX, collider_object->ModelID);
		ChaColliderObject->ResourceOrigin = ChaResourceObject;
		ChaColliderObject->ResManager = collider_object->ResManager;

		bool collider_mesh_only = true;
		for (int i = 0; i <= collider_object->ColliderGeometry->PushPos - 1; i++) {

			CColliderGeometry* org_gmt = *(CColliderGeometry**)collider_object->ColliderGeometry->GetData(i);
			CColliderGeometry* gmt = new CColliderGeometry();

			wcscpy_s(gmt->GeometryID, SIZE_CHAR_MAX, org_gmt->GeometryID);
			gmt->DataType = DATA_TYPE_COPY;
			gmt->BindShapeMatrix = org_gmt->BindShapeMatrix;
			gmt->VertexCount = org_gmt->VertexCount;
			gmt->Buffer = org_gmt->Buffer;
			gmt->TransformedBuffer = new char[sizeof(CColliderVertex) * org_gmt->VertexIndexCount];
			memset(gmt->TransformedBuffer, 0, sizeof(CColliderVertex) * org_gmt->VertexIndexCount);
			gmt->VecFloatArray = org_gmt->VecFloatArray;
			gmt->PolygonData = org_gmt->PolygonData;
			gmt->Weights = org_gmt->Weights;

			gmt->ColliderPos[0] = org_gmt->ColliderPos[0];
			gmt->ColliderPos[1] = org_gmt->ColliderPos[1];
			gmt->TransformedColliderPos[0] = org_gmt->TransformedColliderPos[0];
			gmt->TransformedColliderPos[1] = org_gmt->TransformedColliderPos[1];
			gmt->WeightCount = org_gmt->WeightCount;
			gmt->ColliderType = org_gmt->ColliderType;
			gmt->VertexIndexCount = org_gmt->VertexIndexCount;
			gmt->R = org_gmt->R;

			if (gmt->PolygonData->PushPos == 0)
				collider_mesh_only = false;

			ChaColliderObject->ColliderGeometry->Push((void*)&gmt);
		}

		ChaColliderObject->CenterPos = collider_object->CenterPos;
		ChaColliderObject->MaxPos = collider_object->MaxPos;
		ChaColliderObject->MinPos = collider_object->MinPos;
		ChaColliderObject->Length = collider_object->Length;

		// 萔obt@𐶐.
		// q[vvpeB̐ݒ.
		D3D12_HEAP_PROPERTIES prop;
		ZeroMemory(&prop, sizeof(prop));
		prop.Type = D3D12_HEAP_TYPE_UPLOAD;
		prop.CPUPageProperty = D3D12_CPU_PAGE_PROPERTY_UNKNOWN;
		prop.MemoryPoolPreference = D3D12_MEMORY_POOL_UNKNOWN;
		prop.CreationNodeMask = 1;
		prop.VisibleNodeMask = 1;

		// \[X̐ݒ.
		D3D12_RESOURCE_DESC desc2;
		ZeroMemory(&desc2, sizeof(desc2));
		desc2.Dimension = D3D12_RESOURCE_DIMENSION_BUFFER;
		desc2.Alignment = 0;
		desc2.Width = 0x100;
		desc2.Height = 1;
		desc2.DepthOrArraySize = 1;
		desc2.MipLevels = 1;
		desc2.Format = DXGI_FORMAT_UNKNOWN;
		desc2.SampleDesc.Count = 1;
		desc2.SampleDesc.Quality = 0;
		desc2.Layout = D3D12_TEXTURE_LAYOUT_ROW_MAJOR;
		desc2.Flags = D3D12_RESOURCE_FLAG_NONE;

		// \[X𐶐.
		HRESULT hr = device->m_pDevice->CreateCommittedResource(&prop, D3D12_HEAP_FLAG_NONE, &desc2, D3D12_RESOURCE_STATE_GENERIC_READ, NULL, IID_ID3D12Resource, (void**)&ChaColliderObject->m_pConstantBufferColliderParam);

		// 萔obt@r[̐ݒ.
		D3D12_CONSTANT_BUFFER_VIEW_DESC bufferDesc = {};
		bufferDesc.BufferLocation = ChaColliderObject->m_pConstantBufferColliderParam->GetGPUVirtualAddress();
		bufferDesc.SizeInBytes = 0x100;

		// 萔obt@r[𐶐.
		int64_t res_num = 0;
		D3D12_CPU_DESCRIPTOR_HANDLE handle = ChaColliderObject->ResManager->CreateCPUHandle(&res_num);
		device->m_pDevice->CreateConstantBufferView(&bufferDesc, handle);
		ChaColliderObject->constant_buffer_collider_param_num = (UINT)res_num;

		// }bv. AvP[VI܂ Unmap Ȃ.
		hr = ChaColliderObject->m_pConstantBufferColliderParam->Map(0, NULL, (void**)&ChaColliderObject->constant_buffer_collider_param_begin);

		if (collider_mesh_only == false) {
			// 萔obt@𐶐.
			// q[vvpeB̐ݒ.

			// \[X̐ݒ.
			desc2.Width = 0x100 * 3 * sizeof(XMFLOAT4);

			// \[X𐶐.
			HRESULT hr = device->m_pDevice->CreateCommittedResource(&prop, D3D12_HEAP_FLAG_NONE, &desc2, D3D12_RESOURCE_STATE_GENERIC_READ, NULL, IID_ID3D12Resource, (void**)&ChaColliderObject->m_pConstantBufferCollider);

			// 萔obt@r[̐ݒ.
			D3D12_CONSTANT_BUFFER_VIEW_DESC bufferDesc = {};
			bufferDesc.BufferLocation = ChaColliderObject->m_pConstantBufferCollider->GetGPUVirtualAddress();
			bufferDesc.SizeInBytes = 0x100 * 3 * sizeof(XMFLOAT4);

			// 萔obt@r[𐶐.
			int64_t res_num = 0;
			D3D12_CPU_DESCRIPTOR_HANDLE handle = ChaColliderObject->ResManager->CreateCPUHandle(&res_num);
			device->m_pDevice->CreateConstantBufferView(&bufferDesc, handle);
			ChaColliderObject->constant_buffer_collider_num = (UINT)res_num;

			// }bv. AvP[VI܂ Unmap Ȃ.
			hr = ChaColliderObject->m_pConstantBufferCollider->Map(0, NULL, (void**)&ChaColliderObject->constant_buffer_collider_begin);
		}
	}

	SwapChaDataObject->InsTail((void*)ChaDataObject);
	SwapChaResourceObject->InsTail((void*)ChaResourceObject);
	SwapChaColliderObject->InsTail((void*)ChaColliderObject);

	int64_t swap_id = 0;
	SwapID->Push((void*)&swap_id);

	return true;
}

bool CCharacterBase::CheckID(const wchar_t* id) {

	if (wcscmp(ID, id) == 0)
		return true;

	return false;
}

bool CCharacterBase::CheckCollision() {

	if (ChaColliderObject == NULL)
		return false;

	XMFLOAT4 near_point, near_vector;
	float dist_z, dist_xy;
	float scale_r = ChaResourceObject->Scale.w;

	CollisionZ = false;
	CollisionXY = false;
	ZCollisionObject = NULL;
	XYCollisionObject = NULL;
	CollisionNormalXY = XMFLOAT4(0, 0, 0, 0);
	CollisionNormalZ = XMFLOAT4(0, 0, 0, 0);
	CollisionPosXY = XMFLOAT4(0, 0, 0, 0);
	CollisionPosZ = XMFLOAT4(0, 0, 0, 0);
	DistZ = 0.0f;
	DistXY = 0.0f;

	float MaxDistZ, MaxDistXY, dist;
	MaxDistZ = -10000.0f;
	MaxDistXY = -10000.0f;

	for (int i = 1; i <= DispWindow->ObjectManager->CharacterList->GetSize(); i++) {

		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)DispWindow->ObjectManager->CharacterList->GetAt(i))->Data;
		if (wcscmp(ID, obj->ID) == 0) {
			continue;
		}
		if (obj->ChaColliderObject == NULL)
			continue;
		if (obj->CollisionCheck == false)
			continue;
		if (InsArea(ChaColliderObject, obj->ChaColliderObject) == false)
			continue;

		for (int j = 0; j <= ChaColliderObject->ColliderGeometry->PushPos - 1; j++) {

			CColliderGeometry* gmt = *(CColliderGeometry**)ChaColliderObject->ColliderGeometry->GetData(j);
			if (gmt->ColliderType == COLLIDER_TYPE_MESH)
				continue;
			for (int k = 0; k <= obj->ChaColliderObject->ColliderGeometry->PushPos - 1; k++) {

				CColliderGeometry* target_gmt = *(CColliderGeometry**)obj->ChaColliderObject->ColliderGeometry->GetData(k);
				float target_gmt_scale_r = obj->ChaResourceObject->Scale.w;

				if (target_gmt->ColliderType == COLLIDER_TYPE_SPHERE) {
					if (gmt->ColliderType == COLLIDER_TYPE_SPHERE) {
						bool collision = CalcDistPointPoint(XMFLOAT4(target_gmt->TransformedColliderPos[0].Pos.x, target_gmt->TransformedColliderPos[0].Pos.y, target_gmt->TransformedColliderPos[0].Pos.z, target_gmt->R * target_gmt_scale_r), XMFLOAT4(gmt->TransformedColliderPos[0].Pos.x, gmt->TransformedColliderPos[0].Pos.y, gmt->TransformedColliderPos[0].Pos.z, gmt->R * scale_r), &near_point, &dist);
						if (collision == true) {
							XMVECTOR vec = XMVector3Normalize(XMVectorSet(near_point.x - target_gmt->TransformedColliderPos[0].Pos.x, near_point.y - target_gmt->TransformedColliderPos[0].Pos.y, near_point.z - target_gmt->TransformedColliderPos[0].Pos.z, 0.0f));
							float dot = abs(XMVectorGetX(XMVector3Dot(vec, XMVectorSet(0, 0, 1, 0))));
							if (dot > 0.5f && dist > MaxDistZ) {
								CollisionNormalZ = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
								CollisionPosZ = near_point;
								CollisionZ = true;
								DistZ = dist;
								MaxDistZ = dist;
								ZCollisionObject = obj;
							}
							if ( dot < 0.7f && dist > MaxDistXY) {
								CollisionNormalXY = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
								CollisionPosXY = near_point;
								CollisionXY = true;
								DistXY = dist;
								MaxDistXY = dist;
								XYCollisionObject = obj;
							}
						}
					}
					if (gmt->ColliderType == COLLIDER_TYPE_CAPSULE) {
						bool collision = CalcDistPointLine(XMFLOAT4(target_gmt->TransformedColliderPos[0].Pos.x, target_gmt->TransformedColliderPos[0].Pos.y, target_gmt->TransformedColliderPos[0].Pos.z, target_gmt->R * target_gmt_scale_r), XMFLOAT4(gmt->TransformedColliderPos[0].Pos.x, gmt->TransformedColliderPos[0].Pos.y, gmt->TransformedColliderPos[0].Pos.z, gmt->R * scale_r), XMFLOAT4(gmt->TransformedColliderPos[1].Pos.x, gmt->TransformedColliderPos[1].Pos.y, gmt->TransformedColliderPos[1].Pos.z, gmt->R * scale_r), &near_point, &dist);
						if (collision == true) {
							XMVECTOR vec = XMVector3Normalize(XMVectorSet(near_point.x - target_gmt->TransformedColliderPos[0].Pos.x, near_point.y - target_gmt->TransformedColliderPos[0].Pos.y, near_point.z - target_gmt->TransformedColliderPos[0].Pos.z, 0.0f));
							float dot = abs(XMVectorGetX(XMVector3Dot(vec, XMVectorSet(0, 0, 1, 0))));
							if (dot > 0.5f && dist > MaxDistZ) {
								CollisionNormalZ = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
								CollisionPosZ = near_point;
								CollisionZ = true;
								DistZ = dist;
								MaxDistZ = dist;
								ZCollisionObject = obj;
							}
							if (dot < 0.7f && dist > MaxDistXY) {
								CollisionNormalXY = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
								CollisionPosXY = near_point;
								CollisionXY = true;
								DistXY = dist;
								MaxDistXY = dist;
								XYCollisionObject = obj;
							}
						}
					}
				}
				if (target_gmt->ColliderType == COLLIDER_TYPE_CAPSULE) {
					if (gmt->ColliderType == COLLIDER_TYPE_SPHERE) {
						bool collision = CalcDistPointLine(XMFLOAT4(gmt->TransformedColliderPos[0].Pos.x, gmt->TransformedColliderPos[0].Pos.y, gmt->TransformedColliderPos[0].Pos.z, gmt->R * scale_r), XMFLOAT4(target_gmt->TransformedColliderPos[0].Pos.x, target_gmt->TransformedColliderPos[0].Pos.y, target_gmt->TransformedColliderPos[0].Pos.z, target_gmt->R * target_gmt_scale_r), XMFLOAT4(target_gmt->TransformedColliderPos[1].Pos.x, target_gmt->TransformedColliderPos[1].Pos.y, target_gmt->TransformedColliderPos[1].Pos.z, target_gmt->R * target_gmt_scale_r), &near_point, &dist);
						if (collision == true) {
							XMVECTOR vec = XMVector3Normalize(XMVectorSet(near_point.x - gmt->TransformedColliderPos[0].Pos.x, near_point.y - gmt->TransformedColliderPos[0].Pos.y, near_point.z - gmt->TransformedColliderPos[0].Pos.z, 0.0f));
							float dot = abs(XMVectorGetX(XMVector3Dot(vec, XMVectorSet(0, 0, 1, 0))));
							if (dot > 0.5f && dist > MaxDistZ) {
								CollisionNormalZ = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
								CollisionPosZ = near_point;
								CollisionZ = true;
								DistZ = dist;
								MaxDistZ = dist;
								ZCollisionObject = obj;
							}
							if (dot < 0.7f && dist > MaxDistXY) {
								CollisionNormalXY = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
								CollisionPosXY = near_point;
								CollisionXY = true;
								DistXY = dist;
								MaxDistXY = dist;
								XYCollisionObject = obj;
							}
						}
					}
					if (gmt->ColliderType == COLLIDER_TYPE_CAPSULE) {
						bool collision = CalcDistLineLine(XMFLOAT4(gmt->TransformedColliderPos[0].Pos.x, gmt->TransformedColliderPos[0].Pos.y, gmt->TransformedColliderPos[0].Pos.z, gmt->R * scale_r), XMFLOAT4(gmt->TransformedColliderPos[1].Pos.x, gmt->TransformedColliderPos[1].Pos.y, gmt->TransformedColliderPos[1].Pos.z, gmt->R * scale_r), XMFLOAT4(target_gmt->TransformedColliderPos[0].Pos.x, target_gmt->TransformedColliderPos[0].Pos.y, target_gmt->TransformedColliderPos[0].Pos.z, target_gmt->R * target_gmt_scale_r), XMFLOAT4(target_gmt->TransformedColliderPos[1].Pos.x, target_gmt->TransformedColliderPos[1].Pos.y, target_gmt->TransformedColliderPos[1].Pos.z, target_gmt->R * target_gmt_scale_r), &near_point, &near_vector, &dist);
						if (collision == true) {
							XMVECTOR vec = XMVector3Normalize(XMVectorSet(near_vector.x, near_vector.y, near_vector.z, 0.0f));
							float dot = abs(XMVectorGetX(XMVector3Dot(vec, XMVectorSet(0, 0, 1, 0))));
							if (dot > 0.5f && dist > MaxDistZ) {
								CollisionNormalZ = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
								CollisionPosZ = near_point;
								CollisionZ = true;
								DistZ = dist;
								MaxDistZ = dist;
								ZCollisionObject = obj;
							}
							if (dot < 0.7f && dist > MaxDistXY) {
								CollisionNormalXY = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
								CollisionPosXY = near_point;
								CollisionXY = true;
								DistXY = dist;
								MaxDistXY = dist;
								XYCollisionObject = obj;
							}
						}
					}
				}
				if (target_gmt->ColliderType == COLLIDER_TYPE_MESH) {
					if (gmt->ColliderType == COLLIDER_TYPE_SPHERE) {
						for (int l = 0; l <= target_gmt->VertexIndexCount - 1; l += 3) {

							CColliderVertex vtx1, vtx2, vtx3;
							memcpy_s(&vtx1, sizeof(CColliderVertex), &target_gmt->TransformedBuffer[0] + l * sizeof(CColliderVertex), sizeof(CColliderVertex));
							memcpy_s(&vtx2, sizeof(CColliderVertex), &target_gmt->TransformedBuffer[0] + (l + 1) * sizeof(CColliderVertex), sizeof(CColliderVertex));
							memcpy_s(&vtx3, sizeof(CColliderVertex), &target_gmt->TransformedBuffer[0] + (l + 2) * sizeof(CColliderVertex), sizeof(CColliderVertex));

							if (InsArea(ChaColliderObject, vtx1, vtx2, vtx3) == false)
								continue;

							XMFLOAT4 Normal = XMFLOAT4((vtx1.Normal.x + vtx2.Normal.x + vtx3.Normal.x) / 3.0f, (vtx1.Normal.y + vtx2.Normal.y + vtx3.Normal.y) / 3.0f, (vtx1.Normal.z + vtx2.Normal.z + vtx3.Normal.z) / 3.0f, 1.0f);

							bool collision = CalcDistPointPolygon(XMFLOAT4(gmt->TransformedColliderPos[0].Pos.x, gmt->TransformedColliderPos[0].Pos.y, gmt->TransformedColliderPos[0].Pos.z, gmt->R * scale_r), XMFLOAT4(vtx1.Pos.x, vtx1.Pos.y, vtx1.Pos.z, 0.0f), XMFLOAT4(vtx2.Pos.x, vtx2.Pos.y, vtx2.Pos.z, 0.0f), XMFLOAT4(vtx3.Pos.x, vtx3.Pos.y, vtx3.Pos.z, 0.0f), Normal, &near_point, &dist);
							if (collision == true) {
								XMVECTOR vec = XMVector3Normalize(XMVectorSet(near_point.x - gmt->TransformedColliderPos[0].Pos.x, near_point.y - gmt->TransformedColliderPos[0].Pos.y, near_point.z - gmt->TransformedColliderPos[0].Pos.z, 0.0f));
								float dot = abs(XMVectorGetX(XMVector3Dot(vec, XMVectorSet(0, 0, 1, 0))));
								if (dot > 0.5f && dist > MaxDistZ) {
									CollisionNormalZ = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
									CollisionPosZ = near_point;
									CollisionZ = true;
									DistZ = dist;
									MaxDistZ = dist;
									ZCollisionObject = obj;
								}
								if (dot < 0.7f && dist > MaxDistXY) {
									CollisionNormalXY = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
									CollisionPosXY = near_point;
									CollisionXY = true;
									DistXY = dist;
									MaxDistXY = dist;
									XYCollisionObject = obj;
								}
							}
						}
					}
					if (gmt->ColliderType == COLLIDER_TYPE_CAPSULE) {
						for (int l = 0; l <= target_gmt->VertexIndexCount - 1; l += 3) {

							CColliderVertex vtx1, vtx2, vtx3;
							memcpy_s(&vtx1, sizeof(CColliderVertex), &target_gmt->TransformedBuffer[0] + l * sizeof(CColliderVertex), sizeof(CColliderVertex));
							memcpy_s(&vtx2, sizeof(CColliderVertex), &target_gmt->TransformedBuffer[0] + (l + 1) * sizeof(CColliderVertex), sizeof(CColliderVertex));
							memcpy_s(&vtx3, sizeof(CColliderVertex), &target_gmt->TransformedBuffer[0] + (l + 2) * sizeof(CColliderVertex), sizeof(CColliderVertex));

							if (InsArea(ChaColliderObject, vtx1, vtx2, vtx3) == false)
								continue;

							XMFLOAT4 Normal = XMFLOAT4((vtx1.Normal.x + vtx2.Normal.x + vtx3.Normal.x) / 3.0f, (vtx1.Normal.y + vtx2.Normal.y + vtx3.Normal.y) / 3.0f, (vtx1.Normal.z + vtx2.Normal.z + vtx3.Normal.z) / 3.0f, 1.0f);

							bool collision = CalcDistLinePolygon(XMFLOAT4(gmt->TransformedColliderPos[0].Pos.x, gmt->TransformedColliderPos[0].Pos.y, gmt->TransformedColliderPos[0].Pos.z, gmt->R * scale_r), XMFLOAT4(gmt->TransformedColliderPos[1].Pos.x, gmt->TransformedColliderPos[1].Pos.y, gmt->TransformedColliderPos[1].Pos.z, gmt->R * scale_r), XMFLOAT4(vtx1.Pos.x, vtx1.Pos.y, vtx1.Pos.z, 0.0f), XMFLOAT4(vtx2.Pos.x, vtx2.Pos.y, vtx2.Pos.z, 0.0f), XMFLOAT4(vtx3.Pos.x, vtx3.Pos.y, vtx3.Pos.z, 0.0f), Normal, &near_point, &dist);
							if (collision == true) {
								XMVECTOR vec = XMVector3Normalize(XMVectorSet(Normal.x, Normal.y, Normal.z, 0.0f));
								float dot = abs(XMVectorGetX(XMVector3Dot(vec, XMVectorSet(0, 0, 1, 0))));
								if (dot > 0.5f && dist > MaxDistZ) {
									CollisionNormalZ = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
									CollisionPosZ = near_point;
									CollisionZ = true;
									DistZ = dist;
									MaxDistZ = dist;
									ZCollisionObject = obj;
								}
								if (dot < 0.7f && dist > MaxDistXY) {
									CollisionNormalXY = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
									CollisionPosXY = near_point;
									CollisionXY = true;
									DistXY = dist;
									MaxDistXY = dist;
									XYCollisionObject = obj;
								}
							}
						}
					}
				}
			}
		}
	}

	for (int i = 1; i <= DispWindow->ObjectManager->ObjectList->GetSize(); i++) {

		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)DispWindow->ObjectManager->ObjectList->GetAt(i))->Data;
		if (wcscmp(ID, obj->ID) == 0) {
			continue;
		}
		if (obj->ChaColliderObject == NULL)
			continue;
		if (obj->CollisionCheck == false)
			continue;
		if (InsArea(ChaColliderObject, obj->ChaColliderObject) == false)
			continue;

		for (int j = 0; j <= ChaColliderObject->ColliderGeometry->PushPos - 1; j++) {

			CColliderGeometry* gmt = *(CColliderGeometry**)ChaColliderObject->ColliderGeometry->GetData(j);
			if (gmt->ColliderType == COLLIDER_TYPE_MESH)
				continue;

			for (int k = 0; k <= obj->ChaColliderObject->ColliderGeometry->PushPos - 1; k++) {

				CColliderGeometry* target_gmt = *(CColliderGeometry**)obj->ChaColliderObject->ColliderGeometry->GetData(k);
				float target_gmt_scale_r = obj->ChaResourceObject->Scale.w;

				if (target_gmt->ColliderType == COLLIDER_TYPE_SPHERE) {
					if (gmt->ColliderType == COLLIDER_TYPE_SPHERE) {
						bool collision = CalcDistPointPoint(XMFLOAT4(target_gmt->TransformedColliderPos[0].Pos.x, target_gmt->TransformedColliderPos[0].Pos.y, target_gmt->TransformedColliderPos[0].Pos.z, target_gmt->R * target_gmt_scale_r), XMFLOAT4(gmt->TransformedColliderPos[0].Pos.x, gmt->TransformedColliderPos[0].Pos.y, gmt->TransformedColliderPos[0].Pos.z, gmt->R * scale_r), &near_point, &dist);
						if (collision == true) {
							XMVECTOR vec = XMVector3Normalize(XMVectorSet(near_point.x - target_gmt->TransformedColliderPos[0].Pos.x, near_point.y - target_gmt->TransformedColliderPos[0].Pos.y, near_point.z - target_gmt->TransformedColliderPos[0].Pos.z, 0.0f));
							float dot = abs(XMVectorGetX(XMVector3Dot(vec, XMVectorSet(0, 0, 1, 0))));
							if (dot > 0.5f && dist > MaxDistZ) {
								CollisionNormalZ = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
								CollisionPosZ = near_point;
								CollisionZ = true;
								DistZ = dist;
								MaxDistZ = dist;
								ZCollisionObject = obj;
							}
							if (dot < 0.7f && dist > MaxDistXY) {
								CollisionNormalXY = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
								CollisionPosXY = near_point;
								CollisionXY = true;
								DistXY = dist;
								MaxDistXY = dist;
								XYCollisionObject = obj;
							}
						}
					}
					if (gmt->ColliderType == COLLIDER_TYPE_CAPSULE) {
						bool collision = CalcDistPointLine(XMFLOAT4(target_gmt->TransformedColliderPos[0].Pos.x, target_gmt->TransformedColliderPos[0].Pos.y, target_gmt->TransformedColliderPos[0].Pos.z, target_gmt->R * target_gmt_scale_r), XMFLOAT4(gmt->TransformedColliderPos[0].Pos.x, gmt->TransformedColliderPos[0].Pos.y, gmt->TransformedColliderPos[0].Pos.z, gmt->R * scale_r), XMFLOAT4(gmt->TransformedColliderPos[1].Pos.x, gmt->TransformedColliderPos[1].Pos.y, gmt->TransformedColliderPos[1].Pos.z, gmt->R * scale_r), &near_point, &dist);
						if (collision == true) {
							XMVECTOR vec = XMVector3Normalize(XMVectorSet(near_point.x - target_gmt->TransformedColliderPos[0].Pos.x, near_point.y - target_gmt->TransformedColliderPos[0].Pos.y, near_point.z - target_gmt->TransformedColliderPos[0].Pos.z, 0.0f));
							float dot = abs(XMVectorGetX(XMVector3Dot(vec, XMVectorSet(0, 0, 1, 0))));
							if (dot > 0.5f && dist > MaxDistZ) {
								CollisionNormalZ = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
								CollisionPosZ = near_point;
								CollisionZ = true;
								DistZ = dist;
								MaxDistZ = dist;
								ZCollisionObject = obj;
							}
							if (dot < 0.7f && dist > MaxDistXY) {
								CollisionNormalXY = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
								CollisionPosXY = near_point;
								CollisionXY = true;
								DistXY = dist;
								MaxDistXY = dist;
								XYCollisionObject = obj;
							}
						}
					}
				}
				if (target_gmt->ColliderType == COLLIDER_TYPE_CAPSULE) {
					if (gmt->ColliderType == COLLIDER_TYPE_SPHERE) {
						bool collision = CalcDistPointLine(XMFLOAT4(gmt->TransformedColliderPos[0].Pos.x, gmt->TransformedColliderPos[0].Pos.y, gmt->TransformedColliderPos[0].Pos.z, gmt->R * scale_r), XMFLOAT4(target_gmt->TransformedColliderPos[0].Pos.x, target_gmt->TransformedColliderPos[0].Pos.y, target_gmt->TransformedColliderPos[0].Pos.z, target_gmt->R * target_gmt_scale_r), XMFLOAT4(target_gmt->TransformedColliderPos[1].Pos.x, target_gmt->TransformedColliderPos[1].Pos.y, target_gmt->TransformedColliderPos[1].Pos.z, target_gmt->R * target_gmt_scale_r), &near_point, &dist);
						if (collision == true) {
							XMVECTOR vec = XMVector3Normalize(XMVectorSet(near_point.x - gmt->TransformedColliderPos[0].Pos.x, near_point.y - gmt->TransformedColliderPos[0].Pos.y, near_point.z - gmt->TransformedColliderPos[0].Pos.z, 0.0f));
							float dot = abs(XMVectorGetX(XMVector3Dot(vec, XMVectorSet(0, 0, 1, 0))));
							if (dot > 0.5f && dist > MaxDistZ) {
								CollisionNormalZ = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
								CollisionPosZ = near_point;
								CollisionZ = true;
								DistZ = dist;
								MaxDistZ = dist;
								ZCollisionObject = obj;
							}
							if (dot < 0.7f && dist > MaxDistXY) {
								CollisionNormalXY = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
								CollisionPosXY = near_point;
								CollisionXY = true;
								DistXY = dist;
								MaxDistXY = dist;
								XYCollisionObject = obj;
							}
						}
					}
					if (gmt->ColliderType == COLLIDER_TYPE_CAPSULE) {
						bool collision = CalcDistLineLine(XMFLOAT4(gmt->TransformedColliderPos[0].Pos.x, gmt->TransformedColliderPos[0].Pos.y, gmt->TransformedColliderPos[0].Pos.z, gmt->R * scale_r), XMFLOAT4(gmt->TransformedColliderPos[1].Pos.x, gmt->TransformedColliderPos[1].Pos.y, gmt->TransformedColliderPos[1].Pos.z, gmt->R * scale_r), XMFLOAT4(target_gmt->TransformedColliderPos[0].Pos.x, target_gmt->TransformedColliderPos[0].Pos.y, target_gmt->TransformedColliderPos[0].Pos.z, target_gmt->R * target_gmt_scale_r), XMFLOAT4(target_gmt->TransformedColliderPos[1].Pos.x, target_gmt->TransformedColliderPos[1].Pos.y, target_gmt->TransformedColliderPos[1].Pos.z, target_gmt->R * target_gmt_scale_r), &near_point, &near_vector, &dist);
						if (collision == true) {
							XMVECTOR vec = XMVector3Normalize(XMVectorSet(near_vector.x, near_vector.y, near_vector.z, 0.0f));
							float dot = abs(XMVectorGetX(XMVector3Dot(vec, XMVectorSet(0, 0, 1, 0))));
							if (dot > 0.5f && dist > MaxDistZ) {
								CollisionNormalZ = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
								CollisionPosZ = near_point;
								CollisionZ = true;
								DistZ = dist;
								MaxDistZ = dist;
								ZCollisionObject = obj;
							}
							if (dot < 0.7f && dist > MaxDistXY) {
								CollisionNormalXY = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
								CollisionPosXY = near_point;
								CollisionXY = true;
								DistXY = dist;
								MaxDistXY = dist;
								XYCollisionObject = obj;
							}
						}
					}
				}
				if (target_gmt->ColliderType == COLLIDER_TYPE_MESH) {
					if (gmt->ColliderType == COLLIDER_TYPE_SPHERE) {
						for (int l = 0; l <= target_gmt->VertexIndexCount - 1; l += 3) {

							CColliderVertex vtx1, vtx2, vtx3;
							memcpy_s(&vtx1, sizeof(CColliderVertex), &target_gmt->TransformedBuffer[0] + l * sizeof(CColliderVertex), sizeof(CColliderVertex));
							memcpy_s(&vtx2, sizeof(CColliderVertex), &target_gmt->TransformedBuffer[0] + (l + 1) * sizeof(CColliderVertex), sizeof(CColliderVertex));
							memcpy_s(&vtx3, sizeof(CColliderVertex), &target_gmt->TransformedBuffer[0] + (l + 2) * sizeof(CColliderVertex), sizeof(CColliderVertex));

							if (InsArea(ChaColliderObject, vtx1, vtx2, vtx3) == false)
								continue;

							XMFLOAT4 Normal = XMFLOAT4((vtx1.Normal.x + vtx2.Normal.x + vtx3.Normal.x) / 3.0f, (vtx1.Normal.y + vtx2.Normal.y + vtx3.Normal.y) / 3.0f, (vtx1.Normal.z + vtx2.Normal.z + vtx3.Normal.z) / 3.0f, 1.0f);

							bool collision = CalcDistPointPolygon(XMFLOAT4(gmt->TransformedColliderPos[0].Pos.x, gmt->TransformedColliderPos[0].Pos.y, gmt->TransformedColliderPos[0].Pos.z, gmt->R * scale_r), XMFLOAT4(vtx1.Pos.x, vtx1.Pos.y, vtx1.Pos.z, 0.0f), XMFLOAT4(vtx2.Pos.x, vtx2.Pos.y, vtx2.Pos.z, 0.0f), XMFLOAT4(vtx3.Pos.x, vtx3.Pos.y, vtx3.Pos.z, 0.0f), Normal, &near_point, &dist);
							if (collision == true) {
								XMVECTOR vec = XMVector3Normalize(XMVectorSet(near_point.x - gmt->TransformedColliderPos[0].Pos.x, near_point.y - gmt->TransformedColliderPos[0].Pos.y, near_point.z - gmt->TransformedColliderPos[0].Pos.z, 0.0f));
								float dot = abs(XMVectorGetX(XMVector3Dot(vec, XMVectorSet(0, 0, 1, 0))));
								if (dot > 0.5f && dist > MaxDistZ) {
									CollisionNormalZ = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
									CollisionPosZ = near_point;
									CollisionZ = true;
									DistZ = dist;
									MaxDistZ = dist;
									ZCollisionObject = obj;
								}
								if (dot < 0.7f && dist > MaxDistXY) {
									CollisionNormalXY = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
									CollisionPosXY = near_point;
									CollisionXY = true;
									DistXY = dist;
									MaxDistXY = dist;
									XYCollisionObject = obj;
								}
							}
						}
					}
					if (gmt->ColliderType == COLLIDER_TYPE_CAPSULE) {
						for (int l = 0; l <= target_gmt->VertexIndexCount - 1; l += 3) {

							CColliderVertex vtx1, vtx2, vtx3;
							memcpy_s(&vtx1, sizeof(CColliderVertex), &target_gmt->TransformedBuffer[0] + l * sizeof(CColliderVertex), sizeof(CColliderVertex));
							memcpy_s(&vtx2, sizeof(CColliderVertex), &target_gmt->TransformedBuffer[0] + (l + 1) * sizeof(CColliderVertex), sizeof(CColliderVertex));
							memcpy_s(&vtx3, sizeof(CColliderVertex), &target_gmt->TransformedBuffer[0] + (l + 2) * sizeof(CColliderVertex), sizeof(CColliderVertex));

							if (InsArea(ChaColliderObject, vtx1, vtx2, vtx3) == false)
								continue;

							XMFLOAT4 Normal = XMFLOAT4((vtx1.Normal.x + vtx2.Normal.x + vtx3.Normal.x) / 3.0f, (vtx1.Normal.y + vtx2.Normal.y + vtx3.Normal.y) / 3.0f, (vtx1.Normal.z + vtx2.Normal.z + vtx3.Normal.z) / 3.0f, 1.0f);

							bool collision = CalcDistLinePolygon(XMFLOAT4(gmt->TransformedColliderPos[0].Pos.x, gmt->TransformedColliderPos[0].Pos.y, gmt->TransformedColliderPos[0].Pos.z, gmt->R * scale_r), XMFLOAT4(gmt->TransformedColliderPos[1].Pos.x, gmt->TransformedColliderPos[1].Pos.y, gmt->TransformedColliderPos[1].Pos.z, gmt->R * scale_r), XMFLOAT4(vtx1.Pos.x, vtx1.Pos.y, vtx1.Pos.z, 0.0f), XMFLOAT4(vtx2.Pos.x, vtx2.Pos.y, vtx2.Pos.z, 0.0f), XMFLOAT4(vtx3.Pos.x, vtx3.Pos.y, vtx3.Pos.z, 0.0f), Normal, &near_point, &dist);
							if (collision == true) {
								XMVECTOR vec = XMVector3Normalize(XMVectorSet(Normal.x, Normal.y, Normal.z, 0.0f));
								float dot = abs(XMVectorGetX(XMVector3Dot(vec, XMVectorSet(0, 0, 1, 0))));
								if (dot > 0.5f && dist > MaxDistZ) {
									CollisionNormalZ = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
									CollisionPosZ = near_point;
									CollisionZ = true;
									DistZ = dist;
									MaxDistZ = dist;
									ZCollisionObject = obj;
								}
								if (dot < 0.7f && dist > MaxDistXY) {
									CollisionNormalXY = XMFLOAT4(XMVectorGetX(vec), XMVectorGetY(vec), XMVectorGetZ(vec), 1.0f);
									CollisionPosXY = near_point;
									CollisionXY = true;
									DistXY = dist;
									MaxDistXY = dist;
									XYCollisionObject = obj;
								}
							}
						}
					}
				}
			}
		}
	}

	return true;
}

bool CCharacterBase::ShowObject(bool show) {

	DrawObject = show;

	return true;
}

CCharacterBase* CCharacterBase::GetChaObject(const wchar_t* id) {

	if (DispWindow == NULL || DispWindow->ObjectManager == NULL )
		return NULL;

	for (int i = 1; i <= DispWindow->ObjectManager->CharacterList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)DispWindow->ObjectManager->CharacterList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			return obj;
		}
	}
	for (int i = 1; i <= DispWindow->ObjectManager->ObjectList->GetSize(); i++) {
		CCharacterBase* obj = (CCharacterBase*)((CListDataA*)DispWindow->ObjectManager->ObjectList->GetAt(i))->Data;
		if (wcscmp(id, obj->ID) == 0) {
			return obj;
		}
	}

	return NULL;
}


bool CCharacterBase::SetCollisionCheck(bool check) {

	CollisionCheck = check;

	return true;
}

XMFLOAT4 CCharacterBase::GetScaling() {

	if (ChaResourceObject == NULL)
		return XMFLOAT4( 0, 0, 0, 0 );

	return ChaResourceObject->Scale;
}

bool CCharacterBase::SetScaling(XMFLOAT4 scale) {

	if (ChaResourceObject == NULL)
		return false;

	for (int i = 1; i <= SwapChaResourceObject->GetSize(); i++) {
		CChaResourceObject* obj = (CChaResourceObject*)((CListDataA*)SwapChaResourceObject->GetAt(i))->Data;
		obj->Scale.x = scale.x;
		obj->Scale.y = scale.y;
		obj->Scale.z = scale.z;
		obj->Scale.w = scale.w;
	}
	
	return true;
}

bool CCharacterBase::AddScaling(XMFLOAT4 scale) {

	if (ChaResourceObject == NULL)
		return false;

	for (int i = 1; i <= SwapChaResourceObject->GetSize(); i++) {
		CChaResourceObject* obj = (CChaResourceObject*)((CListDataA*)SwapChaResourceObject->GetAt(i))->Data;
		obj->Scale.x += scale.x;
		obj->Scale.y += scale.y;
		obj->Scale.z += scale.z;
		obj->Scale.w += scale.w;

	}
	
	return true;
}

XMFLOAT4 CCharacterBase::GetRotation() {

	if (ChaResourceObject == NULL)
		return XMFLOAT4(0, 0, 0, 0);

	return ChaResourceObject->Rotation;
}

bool CCharacterBase::SetRotation(XMFLOAT4 rot) {

	if (ChaResourceObject == NULL)
		return false;

	for (int i = 1; i <= SwapChaResourceObject->GetSize(); i++) {
		CChaResourceObject* obj = (CChaResourceObject*)((CListDataA*)SwapChaResourceObject->GetAt(i))->Data;
		obj->Rotation.x = rot.x;
		obj->Rotation.y = rot.y;
		obj->Rotation.z = rot.z;
	}
	
	return true;
}

bool CCharacterBase::AddRotation(XMFLOAT4 rot) {

	if (ChaResourceObject == NULL)
		return false;

	for (int i = 1; i <= SwapChaResourceObject->GetSize(); i++) {
		CChaResourceObject* obj = (CChaResourceObject*)((CListDataA*)SwapChaResourceObject->GetAt(i))->Data;
		obj->Rotation.x += rot.x;
		obj->Rotation.y += rot.y;
		obj->Rotation.z += rot.z;
	}

	return true;
}

XMFLOAT4 CCharacterBase::GetPosition() {

	if (ChaResourceObject == NULL)
		return XMFLOAT4(0, 0, 0, 0);

	return ChaResourceObject->Position;
}

bool CCharacterBase::SetPosition(XMFLOAT4 point) {

	if (ChaResourceObject == NULL)
		return false;

	for (int i = 1; i <= SwapChaResourceObject->GetSize(); i++) {
		CChaResourceObject* obj = (CChaResourceObject*)((CListDataA*)SwapChaResourceObject->GetAt(i))->Data;
		obj->Position.x = point.x;
		obj->Position.y = point.y;
		obj->Position.z = point.z;
	}
	
	return true;
}

bool CCharacterBase::AddPosition(XMFLOAT4 point) {

	if (ChaResourceObject == NULL)
		return false;

	for (int i = 1; i <= SwapChaResourceObject->GetSize(); i++) {
		CChaResourceObject* obj = (CChaResourceObject*)((CListDataA*)SwapChaResourceObject->GetAt(i))->Data;
		obj->Position.x += point.x;
		obj->Position.y += point.y;
		obj->Position.z += point.z;
	}
	
	return true;
}

XMFLOAT4 CCharacterBase::GetVector() {

	return XMFLOAT4( VecX, VecY, VecZ, 0 );
}

bool CCharacterBase::SetVector(XMFLOAT4 vec) {

	VecX = vec.x;
	VecY = vec.y;
	VecZ = vec.z;

	return true;
}

bool CCharacterBase::AddVector(XMFLOAT4 vec) {

	VecX += vec.x;
	VecY += vec.y;
	VecZ += vec.z;

	return true;
}

float CCharacterBase::GetVelocity() {

	return Velocity;
}

bool CCharacterBase::SetVelocity(float velocity) {

	Velocity = velocity;

	return true;
}

bool CCharacterBase::AddVelocity(float velocity) {

	Velocity += velocity;

	return true;
}

bool CCharacterBase::SetFrameCount(int count) {

	if (ChaResourceObject == NULL)
		return false;

	for (int i = 1; i <= SwapChaResourceObject->GetSize(); i++) {
		CChaResourceObject* obj = (CChaResourceObject*)((CListDataA*)SwapChaResourceObject->GetAt(i))->Data;
		obj->FrameCount = count;
	}

	return true;
}

bool CCharacterBase::SetCurrentAnimation(const wchar_t* anim_id, int change_frame, float speed, bool refrain, bool model_swapped ) {

	for (int i = 0; i <= AnimationID->PushPos - 1; i++) {
		CVector* animation_id = *(CVector**)AnimationID->GetData(i);
		CChaResourceObject* res_object = (CChaResourceObject*)((CListDataA*)SwapChaResourceObject->GetAt(i + 1))->Data;
		for (int j = 0; j <= animation_id->PushPos - 1; j++) {
			wchar_t* id = *(wchar_t**)animation_id->GetData(j);
			if (wcscmp(id, anim_id) == 0) {
				wmemset(CurrentAnimationID, 0, SIZE_CHAR_MAX);
				wcscpy_s(CurrentAnimationID, SIZE_CHAR_MAX, anim_id);
				res_object->SetCurrentAnimation(j, change_frame, speed, refrain, model_swapped );
				return true;
			}
		}
	}

	return false;
}

bool CCharacterBase::SetRefrainSec(const wchar_t* anim_id, float sec) {

	for (int i = 0; i <= AnimationID->PushPos - 1; i++) {
		CVector* animation_id = *(CVector**)AnimationID->GetData(i);
		CChaResourceObject* res_object = (CChaResourceObject*)((CListDataA*)SwapChaResourceObject->GetAt(i + 1))->Data;
		for (int j = 0; j <= animation_id->PushPos - 1; j++) {
			wchar_t* id = *(wchar_t**)animation_id->GetData(j);
			if (wcscmp(id, anim_id) == 0) {
				res_object->RefrainSec = sec;
				return true;
			}
		}
	}

	return false;
}

bool CCharacterBase::IsAnimationFinished(const wchar_t* anim_id) {

	for (int i = 0; i <= AnimationID->PushPos - 1; i++) {
		CVector* animation_id = *(CVector**)AnimationID->GetData(i);
		CChaResourceObject* res_object = (CChaResourceObject*)((CListDataA*)SwapChaResourceObject->GetAt(i + 1))->Data;
		for (int j = 0; j <= animation_id->PushPos - 1; j++) {
			wchar_t* id = *(wchar_t**)animation_id->GetData(j);
			if (wcscmp(id, anim_id) == 0) {
				if (res_object->AnimationFinished == true)
					return true;
				return false;
			}
		}
	}

	return true;
}

void CCharacterBase::PreAction() {
}

void CCharacterBase::Action() {
}

void CCharacterBase::OnKeyDown(UINT nChar) {
}

void CCharacterBase::OnKeyUp(UINT nChar) {
}

void CCharacterBase::OnLButtonDown(UINT nFlag, CPoint point) {
}

void CCharacterBase::OnLButtonUp(UINT nFlag, CPoint point) {
}

void CCharacterBase::OnRButtonDown(UINT nFlag, CPoint point) {
}

void CCharacterBase::OnRButtonUp(UINT nFlag, CPoint point) {
}
