/////////////////////////////////////////////////
//
//  filename: CameraBase.cpp
//  author:Chafumi Touji
//  date: 2021/07/30 ver1.00
//
/////////////////////////////////////////////////

#include "defcha3d.h"

CCameraBase::CCameraBase() {

	AtX = 0;
	AtY = 0;
	AtZ = 0;

	EyePosX = 0.0f;
	EyePosY = 0.0f;
	EyePosZ = 0.0f;

	RotationX = ToAngle( 3.14159265f / 2.0f - 0.5f );
	RotationY = 0.000f;
	RotationZ = ToAngle( 3.14159265f - 0.4f );
	CameraHeight = 0.2f;
	Zoom = 6.0f;

	Width = FULLHD_WIDTH;
	Height = FULLHD_HEIGHT;
	Aspect = (float)FULLHD_WIDTH / (float)FULLHD_HEIGHT;
	ViewAngle = 45.0f;

	LightPosX = -15.0f;
	LightPosY = 15.0f;
	LightPosZ = 15.0f;
}

CCameraBase::CCameraBase( int width, int height ) {

	AtX = 0;
	AtY = 0;
	AtZ = 0;

	EyePosX = 0.0f;
	EyePosY = 0.0f;
	EyePosZ = 0.0f;

	RotationX = ToAngle(3.14159265f / 2.0f - 0.5f);
	RotationY = 0.000f;
	RotationZ = ToAngle(3.14159265f - 0.4f);
	CameraHeight = 0.2f;
	Zoom = 6.0f;

	Width = width;
	Height = height;
	Aspect = (float)width / (float)height;
	ViewAngle = 45.0f;

	LightPosX = -15.0f;
	LightPosY = 15.0f;
	LightPosZ = 15.0f;
}

CCameraBase::~CCameraBase() {

}

bool CCameraBase::SetCamera( CCommonDevice *device ) {

	matWorld = XMMatrixIdentity();
	matView = XMMatrixIdentity();
	matProj = XMMatrixIdentity();

	XMVECTOR at = XMVectorSet(0, 0, 0, 1.0f);
	XMVECTOR eye = XMVectorSet(LightPosX, LightPosY, LightPosZ, 1.0f);
	XMVECTOR up = XMVectorSet(0, 0, 1, 1.0f);
	matView = XMMatrixLookAtLH(eye, at, up);
	XMMATRIX scaling = XMMatrixScaling(-1, 1, 1);
	matView *= scaling;

	matProj = XMMatrixPerspectiveFovLH(ToRadian(ViewAngle), 1.0f, 1.0f, 50.0f);

	XMStoreFloat4x4(&device->constant_buffer.MatLight, XMMatrixTranspose(matView));
	XMStoreFloat4x4(&device->constant_buffer.MatProjLight, XMMatrixTranspose(matProj));

	////////////////////////////////////////////////////////////////

	EyeX = (float)(cos(ToRadian(RotationZ)) * sin(ToRadian(RotationX)) * Zoom);
	EyeY = (float)(sin(ToRadian(RotationZ)) * sin(ToRadian(RotationX)) * Zoom);
	EyeZ = (float)(cos(ToRadian(RotationX)) * Zoom + CameraHeight);

	at = XMVectorSet(AtX, AtY, CameraHeight + AtZ, 1.0f);
	eye = XMVectorSet(EyePosX, EyePosY, EyePosZ, 1.0f);
	matView = XMMatrixLookAtLH(eye, at, up);
	matView *= scaling;

	matProj = XMMatrixPerspectiveFovLH(ToRadian(ViewAngle), Aspect, 1.0f, 50.0f);

	XMStoreFloat4x4(&device->constant_buffer.MatWorld, XMMatrixTranspose(matWorld));
	XMStoreFloat4x4(&device->constant_buffer.MatView, XMMatrixTranspose(matView));
	XMStoreFloat4x4(&device->constant_buffer.MatProj, XMMatrixTranspose(matProj));

	for (int i = 0; i <= 15; i++) {
		device->constant_buffer.LightPos[i] = XMFLOAT4(0, 0, 0, 0);
		device->constant_buffer.LightColor[i] = XMFLOAT4(0, 0, 0, 0);
	}
	device->constant_buffer.LightPos[0] = XMFLOAT4(LightPosX, LightPosY, LightPosZ, 0.0f);
	device->constant_buffer.LightColor[0] = XMFLOAT4(1, 1, 1, 0.5f);

	///////////////////////////////////////////////////////////

	device->constant_buffer.ShaderParam1 = XMFLOAT4((float)Width, (float)Height, 0, 0);

	device->m_pCmdList->SetGraphicsRootConstantBufferView(0, device->m_pConstantBuffer->GetGPUVirtualAddress());
	memcpy(device->constant_buffer_begin, &device->constant_buffer, sizeof(device->constant_buffer));

	return true;
}

bool CCameraBase::SetCameraforShadowMap(CCommonDevice* device) {

	matWorld = XMMatrixIdentity();
	matView = XMMatrixIdentity();
	matProj = XMMatrixIdentity();

	XMVECTOR at = XMVectorSet(0, 0, 0, 1.0f);
	XMVECTOR eye = XMVectorSet(LightPosX, LightPosY, LightPosZ, 1.0f);
	XMVECTOR up = XMVectorSet(0, 0, 1, 1.0f);
	matView = XMMatrixLookAtLH(eye, at, up);
	XMMATRIX scaling = XMMatrixScaling(-1, 1, 1);
	matView *= scaling;

	matProj = XMMatrixPerspectiveFovLH(ToRadian(ViewAngle), 1.0f, 1.0f, 50.0f);

	XMStoreFloat4x4(&device->constant_buffer.MatWorld, XMMatrixTranspose(matWorld));
	XMStoreFloat4x4(&device->constant_buffer.MatView, XMMatrixTranspose(matView));
	XMStoreFloat4x4(&device->constant_buffer.MatProj, XMMatrixTranspose(matProj));
	XMStoreFloat4x4(&device->constant_buffer.MatLight, XMMatrixTranspose(matView));
	XMStoreFloat4x4(&device->constant_buffer.MatProjLight, XMMatrixTranspose(matProj));

	for (int i = 0; i <= 15; i++) {
		device->constant_buffer.LightPos[i] = XMFLOAT4(0, 0, 0, 0);
		device->constant_buffer.LightColor[i] = XMFLOAT4(0, 0, 0, 0);
	}
	device->constant_buffer.LightPos[0] = XMFLOAT4(LightPosX, LightPosY, LightPosZ, 0.0f);
	device->constant_buffer.LightColor[0] = XMFLOAT4(1, 1, 1, 0.5f);

	device->constant_buffer.ShaderParam1 = XMFLOAT4((float)Width, (float)Height, 0, 0);

	device->m_pCmdList->SetGraphicsRootConstantBufferView(0, device->m_pConstantBuffer->GetGPUVirtualAddress());
	memcpy(device->constant_buffer_begin, &device->constant_buffer, sizeof(device->constant_buffer));

	return true;
}

bool CCameraBase::SetEyePos(float x, float y, float z) {

	EyePosX = x;
	EyePosY = y;
	EyePosZ = z;

	return true;
}

bool CCameraBase::SetCameraAt(float x, float y, float z) {

	AtX = x;
	AtY = y;
	AtZ = z;

	return true;
}

bool CCameraBase::SetCameraRot(float x, float y, float z) {

	RotationX = x;
	RotationY = y;
	RotationZ = z;
	
	return true;
}

bool CCameraBase::SetZoom(float zoom) {

	Zoom = zoom;

	return true;
}

