////////////////////////////////////////////////////////
// filename: CListA.cpp
// author: Chafumi Touji
// version: 1.0.1
// date: 2021/07/26
////////////////////////////////////////////////////////

#include "defcha3d.h"
#include "CListA.h"

////////////////////////////////////////////////////////////////////////////////////////

CListA::CListA(){

	CurrentNum = 0;
	ListSize = 0;
	Head = Tail = CurrentPos = NULL;
}

CListA::~CListA(){

	DeleteAll();
	CurrentNum = ListSize = 0;
	Head = Tail = CurrentPos = NULL;
}

/////////////////////////////////////////////////////////////////////////////////////////

CListDataA *CListA::GetData(){
	
	return CurrentPos;
}

CListDataA *CListA::GetHead(){

	return Head;
}

CListDataA *CListA::GetTail(){

	return Tail;
}

CListDataA *CListA::SetNext(){

	if( ListSize <= 0 )
		return NULL;

	if( CurrentPos == NULL )
		return NULL;

	CurrentPos = CurrentPos->Next;
	CurrentNum++;

	return CurrentPos;
}

CListDataA *CListA::SetPrev(){

	if( ListSize <= 0 )
		return NULL;

	if( CurrentPos == NULL )
		return NULL;

	CurrentPos = CurrentPos->Prev;
	CurrentNum--;

	return CurrentPos;
}

CListDataA *CListA::InsData( void *data ){

	return InsData(data, 0);
}

CListDataA *CListA::InsTail( void *data ){

	return InsTail(data, 0);
}

CListDataA *CListA::InsHead( void *data ){

	return InsHead(data, 0);
}

CListDataA *CListA::InsData(void *data, int id ){

	if (CurrentPos == Tail)
		return InsTail(data, id );

	CListDataA *new_element = NULL;
	new_element = new CListDataA();
	new_element->Data = data;
	new_element->ID = id;
	if (CurrentPos == NULL && ListSize <= 0){
		Head = Tail = CurrentPos = new_element;
		CurrentNum = 1;
	}
	else{
		if (CurrentPos == Tail)
			Tail = new_element;
		new_element->Next = CurrentPos->Next;
		new_element->Prev = CurrentPos;
		if (CurrentPos->Next != NULL)
			CurrentPos->Next->Prev = new_element;
		CurrentPos->Next = new_element;
	}

	ListSize++;

	return new_element;
}

CListDataA *CListA::InsTail(void *data, int id ){

	CListDataA *new_element = NULL;
	new_element = new CListDataA();
	new_element->Data = data;
	new_element->ID = id;
	if (CurrentPos == NULL && ListSize <= 0){
		Head = Tail = CurrentPos = new_element;
		CurrentNum = 1;
	}
	else{
		new_element->Next = NULL;
		new_element->Prev = Tail;
		Tail->Next = new_element;
		Tail = new_element;
	}
	ListSize++;

	return new_element;
}

CListDataA *CListA::InsHead(void *data, int id ){

	CListDataA *new_element = NULL;
	new_element = new CListDataA();
	new_element->Data = data;
	new_element->ID = id;
	if (CurrentPos == NULL && ListSize <= 0){
		Head = Tail = CurrentPos = new_element;
		CurrentNum = 1;
	}
	else{
		new_element->Next = Head;
		new_element->Prev = NULL;
		Head->Prev = new_element;
		Head = new_element;
		CurrentNum++;
	}
	ListSize++;

	return new_element;
}

bool CListA::SetAt(int num){

	if( num <= 0 )
		return NULL;

	if( num > ListSize )
		return NULL;

	if( CurrentPos == NULL || num == 1 ){
		CurrentPos = Head;
		CurrentNum = 1;
	}

	if( num > CurrentNum ){
		while( num != CurrentNum )
			SetNext();
	}
	else if( num < CurrentNum ){
		while( num != CurrentNum )
			SetPrev();
	}

	return true;
}

CListDataA *CListA::GetAt( int num ){

	//num͂PListSize܂ŁB

	if( num <= 0 )
		return NULL;

	if( num > ListSize )
		return NULL;

	CListDataA *tmp = NULL;
	tmp = CurrentPos;
	if( num < CurrentNum ){
		while( num != CurrentNum ){
			tmp = tmp->Prev;
			num++;
		}
	}
	else if( num > CurrentNum ){
		while( num != CurrentNum ){
			tmp = tmp->Next;
			num--;
		}
	}

	return tmp;
}

CListDataA *CListA::GetByID(int id){

	for (int i = 0; i <= ListSize - 1; i++){
		CListDataA *tmp = GetAt(i + 1);
		if (tmp->ID == id)
			return tmp;
	}

	return NULL;
}

bool CListA::DeleteAll(){
	
	CurrentPos = Head;
	CListDataA *tmp = NULL;
	tmp = CurrentPos;
	while( tmp != NULL )
		tmp = DeleteData();

	return true;
}

CListDataA *CListA::Delete(int num){

	int new_current = CurrentNum;
	if (new_current > num || new_current == ListSize )
		new_current--;

	SetAt(num);
	DeleteData();
	SetAt(new_current);
	CurrentNum = new_current;

	return NULL;
}

CListDataA *CListA::DeleteByID(int id){

	for (int i = 0; i <= ListSize - 1; i++){
		CListDataA *tmp = GetAt(i + 1);
		if (tmp->ID == id){
			SetAt(i + 1);
			DeleteData();
			if (CurrentNum > i + 1)
				CurrentNum = i + 1;
			if (ListSize <= 0)
				CurrentNum = 0;

			return NULL;
		}
	}

	return NULL;
}

CListDataA *CListA::DeleteData(){

	if( ListSize <= 0 )
		return NULL;

	if( Head == NULL )
		return NULL;

	if( CurrentPos == Head ){
		Head = CurrentPos->Next;
		delete CurrentPos;
		CurrentPos = Head;
		if( Head != NULL )
			Head->Prev = NULL;
		ListSize--;
	}
	else if( CurrentPos == Tail ){
		Tail = CurrentPos->Prev;
		delete CurrentPos->Data;
		delete CurrentPos;
		CurrentPos = Tail;
		Tail->Next = NULL;
		CurrentNum--;
		ListSize--;
	}
	else{
		CListDataA *tmp = NULL;
		tmp = CurrentPos->Prev;
		CurrentPos->Next->Prev = CurrentPos->Prev;
		CurrentPos->Prev->Next = CurrentPos->Next;
		delete CurrentPos->Data;
		delete CurrentPos;
		CurrentPos = tmp;
		CurrentNum--;
		ListSize--;
	}

	return CurrentPos;
}

CListDataA *CListA::DeleteHead(){

	int current_num = CurrentNum;
	SetAt( 1 );
	DeleteData();
	SetAt( current_num - 1 );
	return CurrentPos;
}


bool CListA::IsHead(){

	if( ListSize <= 0 )
		return false;

	if( CurrentPos == Head )
		return true;

	return false;
}

bool CListA::IsTail(){

	if( ListSize <= 0 )
		return false;

	if( CurrentPos == Tail )
		return true;

	return false;
}

bool CListA::Find( void *data ){

	if( ListSize <= 0 )
		return false;

	SetAt( 1 );
	do{
		void *d = GetData()->Data;
		if( d == data )
			return true;
		SetNext();
	}while( IsTail() == false );

	return false;
}

