/////////////////////////////////////////////////
//
//  filename: CommonDevice.cpp
//  author:Chafumi Touji
//  date: 2021/06/30 ver1.00
//
/////////////////////////////////////////////////

#include "defcha3d.h"

CCommonDevice::CCommonDevice() {

	m_pDevice = NULL;
	m_pCmdQue = NULL;
	m_pCmdAlloc = NULL;
	m_pCmdList = NULL;
	m_pFactory = NULL;
	m_pAdapter = NULL;
	m_pSwapChain = NULL;
	m_pFence = NULL;
	VertexBufferView = NULL;
	m_pRTVHeap = NULL;
	m_pDepthHeap = NULL;
	m_pTmpHeap = NULL;
	m_pTmpTexture = NULL;
	m_pToonHeap = NULL;
	m_pToonTexture = NULL;
	m_pToonDepthHeap = NULL;
	m_pToonDepthTexture = NULL;
	m_pColliderHeap = NULL;
	m_pColliderTexture = NULL;
	m_pShadowMapHeap = NULL;
	m_pShadowMapTexture = NULL;
	m_pDepthStencilView = NULL;
	m_pVertexBuffer = NULL;
	m_pHeap = NULL;
	m_pConstantBuffer = NULL;
	constant_buffer_begin = NULL;
	Signature = NULL;
	Error = NULL;
	RootSignature = NULL;
	m_pVS1Blob = NULL;
	m_pVS2Blob = NULL;
	m_pVS3Blob = NULL;
	m_pVS4Blob = NULL;
	m_pVS5Blob = NULL;
	m_pVS6Blob = NULL;
	m_pPS1Blob = NULL;
	m_pPS2Blob = NULL;
	m_pPS3Blob = NULL;
	m_pPS4Blob = NULL;
	m_pPS5Blob = NULL;
	m_pPS6Blob = NULL;
	m_pPipeLineState1 = NULL;
	m_pPipeLineState2 = NULL;
	m_pPipeLineState3 = NULL;
	m_pPipeLineState4 = NULL;
	m_pPipeLineState5 = NULL;
	m_pPipeLineState6 = NULL;
	m_pSurface = NULL;
	ResManager = NULL;
	m_pDepthStencilView = NULL;

	::CoInitialize(NULL);
}

CCommonDevice::~CCommonDevice() {

	ReleaseCommonDevice();

	::CoUninitialize();
}

/////////////////////////////////////////////////////////////////////////////

bool CCommonDevice::CreateCommonDevice( HWND m_hWnd, int res_width, int res_height ) {

//  fobOp
//	DebugLayer = nullptr;
//	D3D12GetDebugInterface(IID_PPV_ARGS(&DebugLayer));
//	DebugLayer->EnableDebugLayer();
//	DebugLayer->Release();

	///////////////////////////////////////////////////////////////////////
	//foCX̏

	//t@Ng[쐬
	HRESULT hr = CreateDXGIFactory(IID_IDXGIFactory4, (void**)&m_pFactory);

	int adapterIndex = 0;    //񋓂foCX̃CfbNX
	bool adapter_found = false;

	// ړĨfoCXT
	while (m_pFactory->EnumAdapters1(adapterIndex, &m_pAdapter) != DXGI_ERROR_NOT_FOUND) {
		DXGI_ADAPTER_DESC1 desc;
		m_pAdapter->GetDesc1(&desc);  // foCX̏擾

		hr = D3D12CreateDevice(m_pAdapter, D3D_FEATURE_LEVEL_11_0, __uuidof(ID3D12Device), nullptr);
		if (hr == S_OK) {
			adapter_found = true;
			break;
		}

		adapterIndex += 1;
	}

	if (adapter_found == false) {
		hr = m_pFactory->EnumWarpAdapter(IID_PPV_ARGS(&m_pAdapter));
	}

	hr = D3D12CreateDevice(m_pAdapter, D3D_FEATURE_LEVEL_11_0, IID_ID3D12Device1, (void**)&m_pDevice);


	/////////////////////////////////////////////////////////////////////////////
	//R}hL[쐬

	D3D12_COMMAND_QUEUE_DESC desc;
	ZeroMemory(&desc, sizeof(desc));
	desc.Flags = D3D12_COMMAND_QUEUE_FLAG_NONE;
	desc.Type = D3D12_COMMAND_LIST_TYPE_DIRECT;
	hr = m_pDevice->CreateCommandQueue(&desc, IID_ID3D12CommandQueue, (void**)&m_pCmdQue);

	//tFX쐬
	m_pDevice->CreateFence(0, D3D12_FENCE_FLAG_NONE, IID_ID3D12Fence1, (void**)&m_pFence);
	FenceValue = 1;

	//tFXCxg쐬
	FenceEvent = CreateEvent(nullptr, FALSE, FALSE, nullptr);

	// R}hAP[^𐶐.
	hr = m_pDevice->CreateCommandAllocator(D3D12_COMMAND_LIST_TYPE_DIRECT, IID_ID3D12CommandAllocator, (void**)&m_pCmdAlloc);
	m_pCmdAlloc->Reset();

	// R}hXg𐶐.
	hr = m_pDevice->CreateCommandList(0, D3D12_COMMAND_LIST_TYPE_DIRECT, m_pCmdAlloc, nullptr, IID_ID3D12CommandList, (void**)&m_pCmdList);

	m_pCmdList->Close();

	////////////////////////////////////////////////////////////////////////////
	//Xbv`FC쐬

	DXGI_SWAP_CHAIN_DESC desc2;
	ZeroMemory(&desc2, sizeof(desc2));
	desc2.BufferCount = 2;
	desc2.BufferDesc.Width = res_width;
	desc2.BufferDesc.Height = res_height;
	desc2.BufferDesc.Format = DXGI_FORMAT_R8G8B8A8_UNORM;
	desc2.BufferUsage = DXGI_USAGE_RENDER_TARGET_OUTPUT;
	desc2.SwapEffect = DXGI_SWAP_EFFECT_FLIP_DISCARD;
	desc2.OutputWindow = m_hWnd;
	desc2.SampleDesc.Count = 1;
	desc2.Windowed = TRUE;

	IDXGISwapChain* tmpSwapChain;
	hr = m_pFactory->CreateSwapChain(m_pCmdQue, &desc2, (IDXGISwapChain**)&tmpSwapChain);
	hr = tmpSwapChain->QueryInterface(__uuidof(IDXGISwapChain3), (void**)&m_pSwapChain);
	tmpSwapChain->Release();

	FrameIndex = m_pSwapChain->GetCurrentBackBufferIndex();


	///////////////////////////////////////////////////////////////////////////////////
	//_[^[Qbg쐬

	D3D12_DESCRIPTOR_HEAP_DESC desc3;
	ZeroMemory(&desc3, sizeof(desc3));
	desc3.NumDescriptors = 2;
	desc3.Type = D3D12_DESCRIPTOR_HEAP_TYPE_RTV;
	desc3.Flags = D3D12_DESCRIPTOR_HEAP_FLAG_NONE;

	// _[^[Qbgr[pfBXNv^q[v𐶐.
	hr = m_pDevice->CreateDescriptorHeap(&desc3, IID_ID3D12DescriptorHeap, (void**)&m_pRTVHeap);

	// _[^[Qbgr[̃fBXNv^TCY擾.
	RTVDescriptorSize = m_pDevice->GetDescriptorHandleIncrementSize(D3D12_DESCRIPTOR_HEAP_TYPE_RTV);

	// _[^[Qbgr[𐶐.
	D3D12_CPU_DESCRIPTOR_HANDLE handle = m_pRTVHeap->GetCPUDescriptorHandleForHeapStart();
	D3D12_RENDER_TARGET_VIEW_DESC desc4;
	ZeroMemory(&desc4, sizeof(desc4));
	desc4.Format = DXGI_FORMAT_R8G8B8A8_UNORM;
	desc4.ViewDimension = D3D12_RTV_DIMENSION_TEXTURE2D;
	desc4.Texture2D.MipSlice = 0;
	desc4.Texture2D.PlaneSlice = 0;

	// t[obt@[v.
	for (int i = 0; i <= 1; i++) {
		// obNobt@擾.
		hr = m_pSwapChain->GetBuffer(i, IID_ID3D12Resource, (void**)&m_pRenderTarget[i]);
		// _[^[Qbgr[𐶐.
		m_pDevice->CreateRenderTargetView(m_pRenderTarget[i], &desc4, handle);
		handle.ptr += RTVDescriptorSize;
	}

	/////////////////////////////////////////////////////////////////////////////////
	//fvXobt@쐬

	// [xXeVr[pfBXNv^q[v̐ݒ.
	D3D12_DESCRIPTOR_HEAP_DESC desc5;
	ZeroMemory(&desc5, sizeof(desc5));
	desc5.NumDescriptors = 1;
	desc5.Flags = D3D12_DESCRIPTOR_HEAP_FLAG_NONE;
	desc5.Type = D3D12_DESCRIPTOR_HEAP_TYPE_DSV;
	// [xXeVr[pfBXNv^q[v𐶐.
	hr = m_pDevice->CreateDescriptorHeap(&desc5, IID_ID3D12DescriptorHeap, (void**)&m_pDepthHeap);
	// [xXeVr[̃fBXNv^TCY擾.
	DepthDescriptorSize = m_pDevice->GetDescriptorHandleIncrementSize(D3D12_DESCRIPTOR_HEAP_TYPE_DSV);

	// [xXeVr[𐶐.

	// q[vvpeB̐ݒ.
	D3D12_HEAP_PROPERTIES prop;
	ZeroMemory(&prop, sizeof(prop));
	prop.Type = D3D12_HEAP_TYPE_DEFAULT;
	prop.CPUPageProperty = D3D12_CPU_PAGE_PROPERTY_UNKNOWN;
	prop.MemoryPoolPreference = D3D12_MEMORY_POOL_UNKNOWN;
	prop.CreationNodeMask = 1;
	prop.VisibleNodeMask = 1;

	// \[X̐ݒ.
	D3D12_RESOURCE_DESC desc6;
	ZeroMemory(&desc6, sizeof(desc6));
	desc6.Dimension = D3D12_RESOURCE_DIMENSION_TEXTURE2D;
	desc6.Alignment = 0;
	desc6.Width = res_width * 2.0f;
	desc6.Height = res_height * 2.0f;
	desc6.DepthOrArraySize = 1;
	desc6.MipLevels = 0;
	desc6.Format = DXGI_FORMAT_D32_FLOAT;
	desc6.SampleDesc.Count = 1;
	desc6.SampleDesc.Quality = 0;
	desc6.Flags = D3D12_RESOURCE_FLAG_ALLOW_DEPTH_STENCIL;
	desc6.Layout = D3D12_TEXTURE_LAYOUT_UNKNOWN;

	// NAl̐ݒ.
	ZeroMemory(&DSVClearValue, sizeof(DSVClearValue));
	DSVClearValue.Format = DXGI_FORMAT_D32_FLOAT;
	DSVClearValue.DepthStencil.Depth = 1.0f;
	DSVClearValue.DepthStencil.Stencil = 0;

	// \[X𐶐.
	hr = m_pDevice->CreateCommittedResource(&prop, D3D12_HEAP_FLAG_NONE, &desc6, D3D12_RESOURCE_STATE_DEPTH_WRITE, &DSVClearValue, IID_PPV_ARGS(&m_pDepthStencilView));

	// [xXeVr[̐ݒ.
	D3D12_DEPTH_STENCIL_VIEW_DESC dsvDesc;
	ZeroMemory(&dsvDesc, sizeof(dsvDesc));
	dsvDesc.Format = DXGI_FORMAT_D32_FLOAT;
	dsvDesc.ViewDimension = D3D12_DSV_DIMENSION_TEXTURE2D;
	dsvDesc.Texture2D.MipSlice = 0;
	dsvDesc.Flags = D3D12_DSV_FLAG_NONE;

	// [xXeVr[𐶐.
	m_pDevice->CreateDepthStencilView(m_pDepthStencilView, &dsvDesc, m_pDepthHeap->GetCPUDescriptorHandleForHeapStart());

	//////////////////////////////////////////////////////////////////////////////
	//RX^gobt@쐬

	// 萔obt@pfBXNv^[q[v𐶐.
	D3D12_DESCRIPTOR_HEAP_DESC desc7;
	ZeroMemory(&desc7, sizeof(desc7));
	desc7.NumDescriptors = 1000;
	desc7.Flags = D3D12_DESCRIPTOR_HEAP_FLAG_SHADER_VISIBLE;
	desc7.Type = D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV;
	hr = m_pDevice->CreateDescriptorHeap(&desc7, IID_ID3D12DescriptorHeap, (void**)&m_pHeap);

	//\[X}l[W[
	ResManager = new CResManager();
	ResManager->Init(m_pDevice, m_pHeap);

	// 萔obt@𐶐.
	// q[vvpeB̐ݒ.
	ZeroMemory(&prop, sizeof(prop));
	prop.Type = D3D12_HEAP_TYPE_UPLOAD;
	prop.CPUPageProperty = D3D12_CPU_PAGE_PROPERTY_UNKNOWN;
	prop.MemoryPoolPreference = D3D12_MEMORY_POOL_UNKNOWN;
	prop.CreationNodeMask = 1;
	prop.VisibleNodeMask = 1;

	// \[X̐ݒ.
	D3D12_RESOURCE_DESC desc8;
	ZeroMemory(&desc8, sizeof(desc8));
	desc8.Dimension = D3D12_RESOURCE_DIMENSION_BUFFER;
	desc8.Alignment = 0;
	desc8.Width = 0x100 * 10;
	desc8.Height = 1;
	desc8.DepthOrArraySize = 1;
	desc8.MipLevels = 1;
	desc8.Format = DXGI_FORMAT_UNKNOWN;
	desc8.SampleDesc.Count = 1;
	desc8.SampleDesc.Quality = 0;
	desc8.Layout = D3D12_TEXTURE_LAYOUT_ROW_MAJOR;
	desc8.Flags = D3D12_RESOURCE_FLAG_NONE;

	// \[X𐶐.
	hr = m_pDevice->CreateCommittedResource(&prop, D3D12_HEAP_FLAG_NONE, &desc8, D3D12_RESOURCE_STATE_GENERIC_READ, NULL, IID_ID3D12Resource, (void**)&m_pConstantBuffer);

	// 萔obt@r[̐ݒ.
	D3D12_CONSTANT_BUFFER_VIEW_DESC bufferDesc = {};
	bufferDesc.BufferLocation = m_pConstantBuffer->GetGPUVirtualAddress();
	bufferDesc.SizeInBytes = 0x100 * 10;

	// 萔obt@r[𐶐.
	handle = ResManager->CreateCPUHandle(&constant_buffer_begin_num);
	m_pDevice->CreateConstantBufferView(&bufferDesc, handle);

	// }bv. AvP[VI܂ Unmap Ȃ.
	hr = m_pConstantBuffer->Map(0, NULL, (void**)&constant_buffer_begin);
	HRESULT h = hr;

	//////////////////////////////////////////////////////////////////////////////
	//obt@쐬

	// NAl̐ݒ.
	ZeroMemory(&ClearValue1, sizeof(ClearValue1));
	ClearValue1.Format = DXGI_FORMAT_R8G8B8A8_UNORM;
	ClearValue1.Color[0] = 0.8f;
	ClearValue1.Color[1] = 0.8f;
	ClearValue1.Color[2] = 0.8f;
	ClearValue1.Color[3] = 1.0f;

	ZeroMemory(&prop, sizeof(prop));
	prop.Type = D3D12_HEAP_TYPE_UPLOAD;
	prop.CPUPageProperty = D3D12_CPU_PAGE_PROPERTY_UNKNOWN;
	prop.MemoryPoolPreference = D3D12_MEMORY_POOL_UNKNOWN;
	prop.CreationNodeMask = 1;
	prop.VisibleNodeMask = 1;

	// \[X̐ݒ.
	D3D12_RESOURCE_DESC desc_buffer;
	ZeroMemory(&desc_buffer, sizeof(desc_buffer));
	desc_buffer.Dimension = D3D12_RESOURCE_DIMENSION_BUFFER;
	desc_buffer.Alignment = 0;
	desc_buffer.Width = sizeof(CScreenVertex) * 4;
	desc_buffer.Height = 1;
	desc_buffer.DepthOrArraySize = 1;
	desc_buffer.MipLevels = 1;
	desc_buffer.Format = DXGI_FORMAT_UNKNOWN;
	desc_buffer.SampleDesc.Count = 1;
	desc_buffer.SampleDesc.Quality = 0;
	desc_buffer.Layout = D3D12_TEXTURE_LAYOUT_ROW_MAJOR;
	desc_buffer.Flags = D3D12_RESOURCE_FLAG_NONE;

	// \[X𐶐.
	ID3D12Resource* vertex_buffer;
	hr = m_pDevice->CreateCommittedResource(&prop, D3D12_HEAP_FLAG_NONE, &desc_buffer, D3D12_RESOURCE_STATE_GENERIC_READ, NULL, IID_PPV_ARGS(&vertex_buffer));

	CScreenVertex* buffer = new CScreenVertex[4];
	memset(buffer, 0, sizeof(CScreenVertex) * 4);
	buffer[0].Pos.x = -1;
	buffer[0].Pos.y = 1;
	buffer[0].Tex.x = 0;
	buffer[0].Tex.y = 0;
	buffer[1].Pos.x = 1;
	buffer[1].Pos.y = 1;
	buffer[1].Tex.x = 1;
	buffer[1].Tex.y = 0;
	buffer[2].Pos.x = -1;
	buffer[2].Pos.y = -1;
	buffer[2].Tex.x = 0;
	buffer[2].Tex.y = 1;
	buffer[3].Pos.x = 1;
	buffer[3].Pos.y = -1;
	buffer[3].Tex.x = 1;
	buffer[3].Tex.y = 1;

	UINT8* pData;
	hr = vertex_buffer->Map(0, NULL, (void**)(&pData));
	memcpy(pData, &buffer[0], sizeof(CScreenVertex) * 4);
	vertex_buffer->Unmap(0, NULL);

	// _obt@r[̐ݒ.
	VertexBufferView = new D3D12_VERTEX_BUFFER_VIEW;
	VertexBufferView->BufferLocation = vertex_buffer->GetGPUVirtualAddress();
	VertexBufferView->StrideInBytes = sizeof(CScreenVertex);
	VertexBufferView->SizeInBytes = sizeof(CScreenVertex) * 4;

	///////////////////////////////////////////////////////////////////////////
	//ꎞop̃VF[_[\[X쐬

	ZeroMemory(&prop, sizeof(prop));
	prop.Type = D3D12_HEAP_TYPE_DEFAULT;
	prop.CPUPageProperty = D3D12_CPU_PAGE_PROPERTY_UNKNOWN;
	prop.MemoryPoolPreference = D3D12_MEMORY_POOL_UNKNOWN;
	prop.CreationNodeMask = 1;
	prop.VisibleNodeMask = 1;

	// \[X̐ݒ.
	D3D12_RESOURCE_DESC desc_tex;
	ZeroMemory(&desc_tex, sizeof(desc_tex));
	desc_tex.Dimension = D3D12_RESOURCE_DIMENSION_TEXTURE2D;
	desc_tex.Alignment = 0;
	desc_tex.Width = res_width;
	desc_tex.Height = res_height;
	desc_tex.DepthOrArraySize = 1;
	desc_tex.MipLevels = 0;
	desc_tex.Format = DXGI_FORMAT_R8G8B8A8_UNORM;
	desc_tex.SampleDesc.Count = 1;
	desc_tex.SampleDesc.Quality = 0;
	desc_tex.Layout = D3D12_TEXTURE_LAYOUT_UNKNOWN;
	desc_tex.Flags = D3D12_RESOURCE_FLAG_ALLOW_RENDER_TARGET;

	hr = m_pDevice->CreateCommittedResource(&prop, D3D12_HEAP_FLAG_NONE, &desc_tex, D3D12_RESOURCE_STATE_RENDER_TARGET, &ClearValue1, IID_PPV_ARGS(&m_pTmpTexture));

	D3D12_DESCRIPTOR_HEAP_DESC desc_tmp;
	ZeroMemory(&desc_tmp, sizeof(desc_tmp));
	desc_tmp.NumDescriptors = 1;
	desc_tmp.Type = D3D12_DESCRIPTOR_HEAP_TYPE_RTV;
	desc_tmp.Flags = D3D12_DESCRIPTOR_HEAP_FLAG_NONE;

	// _[^[Qbgr[pfBXNv^q[v𐶐.
	hr = m_pDevice->CreateDescriptorHeap(&desc_tmp, IID_ID3D12DescriptorHeap, (void**)&m_pTmpHeap);

	D3D12_RENDER_TARGET_VIEW_DESC desc_rtv;
	ZeroMemory(&desc_rtv, sizeof(desc_rtv));
	desc_rtv.ViewDimension = D3D12_RTV_DIMENSION_TEXTURE2D;
	desc_rtv.Format = DXGI_FORMAT_R8G8B8A8_UNORM;

	handleTmpRTV = m_pTmpHeap->GetCPUDescriptorHandleForHeapStart();
	m_pDevice->CreateRenderTargetView(m_pTmpTexture, &desc_rtv, handleTmpRTV);

	D3D12_SHADER_RESOURCE_VIEW_DESC descSRV;
	ZeroMemory(&descSRV, sizeof(descSRV));
	descSRV.Format = DXGI_FORMAT_R8G8B8A8_UNORM;
	descSRV.ViewDimension = D3D12_SRV_DIMENSION_TEXTURE2D;
	descSRV.Texture2D.MipLevels = 1;
	descSRV.Texture2D.MostDetailedMip = 0;
	descSRV.Texture2D.PlaneSlice = 0;
	descSRV.Texture2D.ResourceMinLODClamp = 0.0F;
	descSRV.Shader4ComponentMapping = D3D12_DEFAULT_SHADER_4_COMPONENT_MAPPING;

	handleTmpSRV = ResManager->CreateCPUHandle(&TmpSRVNum);
	m_pDevice->CreateShaderResourceView(m_pTmpTexture, &descSRV, handleTmpSRV);

	///////////////////////////////////////////////////////////////////////////
	//RC_[p̈ꎞop̃VF[_[\[X쐬

	ZeroMemory(&prop, sizeof(prop));
	prop.Type = D3D12_HEAP_TYPE_DEFAULT;
	prop.CPUPageProperty = D3D12_CPU_PAGE_PROPERTY_UNKNOWN;
	prop.MemoryPoolPreference = D3D12_MEMORY_POOL_UNKNOWN;
	prop.CreationNodeMask = 1;
	prop.VisibleNodeMask = 1;

	// \[X̐ݒ.
	ZeroMemory(&desc_tex, sizeof(desc_tex));
	desc_tex.Dimension = D3D12_RESOURCE_DIMENSION_TEXTURE2D;
	desc_tex.Alignment = 0;
	desc_tex.Width = res_width;
	desc_tex.Height = res_height;
	desc_tex.DepthOrArraySize = 1;
	desc_tex.MipLevels = 0;
	desc_tex.Format = DXGI_FORMAT_R8G8B8A8_UNORM;
	desc_tex.SampleDesc.Count = 1;
	desc_tex.SampleDesc.Quality = 0;
	desc_tex.Layout = D3D12_TEXTURE_LAYOUT_UNKNOWN;
	desc_tex.Flags = D3D12_RESOURCE_FLAG_ALLOW_RENDER_TARGET;

	ZeroMemory(&ClearValue2, sizeof(ClearValue2));
	ClearValue2.Format = DXGI_FORMAT_R8G8B8A8_UNORM;
	ClearValue2.DepthStencil.Depth = 1.0f;
	ClearValue2.DepthStencil.Stencil = 0;
	ClearValue2.Color[0] = 0.0f;
	ClearValue2.Color[1] = 0.0f;
	ClearValue2.Color[2] = 0.0f;
	ClearValue2.Color[3] = 0.0f;

	hr = m_pDevice->CreateCommittedResource(&prop, D3D12_HEAP_FLAG_NONE, &desc_tex, D3D12_RESOURCE_STATE_RENDER_TARGET, &ClearValue2, IID_PPV_ARGS(&m_pColliderTexture));

	ZeroMemory(&desc_tmp, sizeof(desc_tmp));
	desc_tmp.NumDescriptors = 1;
	desc_tmp.Type = D3D12_DESCRIPTOR_HEAP_TYPE_RTV;
	desc_tmp.Flags = D3D12_DESCRIPTOR_HEAP_FLAG_NONE;

	// _[^[Qbgr[pfBXNv^q[v𐶐.
	hr = m_pDevice->CreateDescriptorHeap(&desc_tmp, IID_ID3D12DescriptorHeap, (void**)&m_pColliderHeap);

	ZeroMemory(&desc_rtv, sizeof(desc_rtv));
	desc_rtv.ViewDimension = D3D12_RTV_DIMENSION_TEXTURE2D;
	desc_rtv.Format = DXGI_FORMAT_R8G8B8A8_UNORM;

	handleColliderRTV = m_pColliderHeap->GetCPUDescriptorHandleForHeapStart();
	m_pDevice->CreateRenderTargetView(m_pColliderTexture, &desc_rtv, handleColliderRTV);

	ZeroMemory(&descSRV, sizeof(descSRV));
	descSRV.Format = DXGI_FORMAT_R8G8B8A8_UNORM;
	descSRV.ViewDimension = D3D12_SRV_DIMENSION_TEXTURE2D;
	descSRV.Texture2D.MipLevels = 1;
	descSRV.Texture2D.MostDetailedMip = 0;
	descSRV.Texture2D.PlaneSlice = 0;
	descSRV.Texture2D.ResourceMinLODClamp = 0.0F;
	descSRV.Shader4ComponentMapping = D3D12_DEFAULT_SHADER_4_COMPONENT_MAPPING;

	handleColliderSRV = ResManager->CreateCPUHandle(&ColliderSRVNum);
	m_pDevice->CreateShaderResourceView(m_pColliderTexture, &descSRV, handleColliderSRV);

	///////////////////////////////////////////////////////////////////////////
	//g[VF[_p̈ꎞop̃VF[_[\[X쐬

	ZeroMemory(&prop, sizeof(prop));
	prop.Type = D3D12_HEAP_TYPE_DEFAULT;
	prop.CPUPageProperty = D3D12_CPU_PAGE_PROPERTY_UNKNOWN;
	prop.MemoryPoolPreference = D3D12_MEMORY_POOL_UNKNOWN;
	prop.CreationNodeMask = 1;
	prop.VisibleNodeMask = 1;

	// \[X̐ݒ.
	ZeroMemory(&desc_tex, sizeof(desc_tex));
	desc_tex.Dimension = D3D12_RESOURCE_DIMENSION_TEXTURE2D;
	desc_tex.Alignment = 0;
	desc_tex.Width = res_width;
	desc_tex.Height = res_height;
	desc_tex.DepthOrArraySize = 1;
	desc_tex.MipLevels = 0;
	desc_tex.Format = DXGI_FORMAT_R32G32B32A32_FLOAT;
	desc_tex.SampleDesc.Count = 1;
	desc_tex.SampleDesc.Quality = 0;
	desc_tex.Layout = D3D12_TEXTURE_LAYOUT_UNKNOWN;
	desc_tex.Flags = D3D12_RESOURCE_FLAG_ALLOW_RENDER_TARGET;

	ZeroMemory(&ClearValue3, sizeof(ClearValue3));
	ClearValue3.Format = DXGI_FORMAT_R32G32B32A32_FLOAT;
	ClearValue3.DepthStencil.Depth = 1.0f;
	ClearValue3.DepthStencil.Stencil = 0;
	ClearValue3.Color[0] = 0.0f;
	ClearValue3.Color[1] = 0.0f;
	ClearValue3.Color[2] = 0.0f;
	ClearValue3.Color[3] = 0.0f;

	hr = m_pDevice->CreateCommittedResource(&prop, D3D12_HEAP_FLAG_NONE, &desc_tex, D3D12_RESOURCE_STATE_RENDER_TARGET, &ClearValue3, IID_PPV_ARGS(&m_pToonTexture));
	hr = m_pDevice->CreateCommittedResource(&prop, D3D12_HEAP_FLAG_NONE, &desc_tex, D3D12_RESOURCE_STATE_RENDER_TARGET, &ClearValue3, IID_PPV_ARGS(&m_pToonDepthTexture));

	ZeroMemory(&desc_tmp, sizeof(desc_tmp));
	desc_tmp.NumDescriptors = 1;
	desc_tmp.Type = D3D12_DESCRIPTOR_HEAP_TYPE_RTV;
	desc_tmp.Flags = D3D12_DESCRIPTOR_HEAP_FLAG_NONE;

	// _[^[Qbgr[pfBXNv^q[v𐶐.
	hr = m_pDevice->CreateDescriptorHeap(&desc_tmp, IID_ID3D12DescriptorHeap, (void**)&m_pToonHeap);
	hr = m_pDevice->CreateDescriptorHeap(&desc_tmp, IID_ID3D12DescriptorHeap, (void**)&m_pToonDepthHeap);

	ZeroMemory(&desc_rtv, sizeof(desc_rtv));
	desc_rtv.ViewDimension = D3D12_RTV_DIMENSION_TEXTURE2D;
	desc_rtv.Format = DXGI_FORMAT_R32G32B32A32_FLOAT;

	handleToonRTV = m_pToonHeap->GetCPUDescriptorHandleForHeapStart();
	m_pDevice->CreateRenderTargetView(m_pToonTexture, &desc_rtv, handleToonRTV);

	handleToonDepthRTV = m_pToonDepthHeap->GetCPUDescriptorHandleForHeapStart();
	m_pDevice->CreateRenderTargetView(m_pToonDepthTexture, &desc_rtv, handleToonDepthRTV);

	ZeroMemory(&descSRV, sizeof(descSRV));
	descSRV.Format = DXGI_FORMAT_R32G32B32A32_FLOAT;
	descSRV.ViewDimension = D3D12_SRV_DIMENSION_TEXTURE2D;
	descSRV.Texture2D.MipLevels = 1;
	descSRV.Texture2D.MostDetailedMip = 0;
	descSRV.Texture2D.PlaneSlice = 0;
	descSRV.Texture2D.ResourceMinLODClamp = 0.0F;
	descSRV.Shader4ComponentMapping = D3D12_DEFAULT_SHADER_4_COMPONENT_MAPPING;

	handleToonSRV = ResManager->CreateCPUHandle(&ToonSRVNum);
	m_pDevice->CreateShaderResourceView(m_pToonTexture, &descSRV, handleToonSRV);

	handleToonDepthSRV = ResManager->CreateCPUHandle(&ToonDepthSRVNum);
	m_pDevice->CreateShaderResourceView(m_pToonDepthTexture, &descSRV, handleToonDepthSRV);

	///////////////////////////////////////////////////////////////////////////
	//VhE}bvp̃VF[_[\[X쐬

	ZeroMemory(&prop, sizeof(prop));
	prop.Type = D3D12_HEAP_TYPE_DEFAULT;
	prop.CPUPageProperty = D3D12_CPU_PAGE_PROPERTY_UNKNOWN;
	prop.MemoryPoolPreference = D3D12_MEMORY_POOL_UNKNOWN;
	prop.CreationNodeMask = 1;
	prop.VisibleNodeMask = 1;

	// \[X̐ݒ.
	ZeroMemory(&desc_tex, sizeof(desc_tex));
	desc_tex.Dimension = D3D12_RESOURCE_DIMENSION_TEXTURE2D;
	desc_tex.Alignment = 0;
	desc_tex.Width = res_width * 2.0f;
	desc_tex.Height = res_height * 2.0f;
	desc_tex.DepthOrArraySize = 1;
	desc_tex.MipLevels = 0;
	desc_tex.Format = DXGI_FORMAT_R32G32B32A32_FLOAT;
	desc_tex.SampleDesc.Count = 1;
	desc_tex.SampleDesc.Quality = 0;
	desc_tex.Layout = D3D12_TEXTURE_LAYOUT_UNKNOWN;
	desc_tex.Flags = D3D12_RESOURCE_FLAG_ALLOW_RENDER_TARGET;

	hr = m_pDevice->CreateCommittedResource(&prop, D3D12_HEAP_FLAG_NONE, &desc_tex, D3D12_RESOURCE_STATE_RENDER_TARGET, &ClearValue3, IID_PPV_ARGS(&m_pShadowMapTexture));

	ZeroMemory(&desc_tmp, sizeof(desc_tmp));
	desc_tmp.NumDescriptors = 1;
	desc_tmp.Type = D3D12_DESCRIPTOR_HEAP_TYPE_RTV;
	desc_tmp.Flags = D3D12_DESCRIPTOR_HEAP_FLAG_NONE;

	// _[^[Qbgr[pfBXNv^q[v𐶐.
	hr = m_pDevice->CreateDescriptorHeap(&desc_tmp, IID_ID3D12DescriptorHeap, (void**)&m_pShadowMapHeap);

	ZeroMemory(&desc_rtv, sizeof(desc_rtv));
	desc_rtv.ViewDimension = D3D12_RTV_DIMENSION_TEXTURE2D;
	desc_rtv.Format = DXGI_FORMAT_R32G32B32A32_FLOAT;

	handleShadowMapRTV = m_pShadowMapHeap->GetCPUDescriptorHandleForHeapStart();
	m_pDevice->CreateRenderTargetView(m_pShadowMapTexture, &desc_rtv, handleShadowMapRTV);

	ZeroMemory(&descSRV, sizeof(descSRV));
	descSRV.Format = DXGI_FORMAT_R32G32B32A32_FLOAT;
	descSRV.ViewDimension = D3D12_SRV_DIMENSION_TEXTURE2D;
	descSRV.Texture2D.MipLevels = 1;
	descSRV.Texture2D.MostDetailedMip = 0;
	descSRV.Texture2D.PlaneSlice = 0;
	descSRV.Texture2D.ResourceMinLODClamp = 0.0F;
	descSRV.Shader4ComponentMapping = D3D12_DEFAULT_SHADER_4_COMPONENT_MAPPING;

	handleShadowMapSRV = ResManager->CreateCPUHandle(&ShadowMapSRVNum);
	m_pDevice->CreateShaderResourceView(m_pShadowMapTexture, &descSRV, handleShadowMapSRV);

	///////////////////////////////////////////////////////////////////////////////////
	//VOl`쐬

	// fBXNv^W̐ݒ.
	D3D12_DESCRIPTOR_RANGE range[5];
	memset(range, 0, sizeof(range));
	range[0].RangeType = D3D12_DESCRIPTOR_RANGE_TYPE_SRV;
	range[0].NumDescriptors = 1;
	range[0].BaseShaderRegister = 0;
	range[0].RegisterSpace = 0;
	range[0].OffsetInDescriptorsFromTableStart = D3D12_DESCRIPTOR_RANGE_OFFSET_APPEND;
	range[1].RangeType = D3D12_DESCRIPTOR_RANGE_TYPE_SRV;
	range[1].NumDescriptors = 1;
	range[1].BaseShaderRegister = 2;
	range[1].RegisterSpace = 0;
	range[1].OffsetInDescriptorsFromTableStart = D3D12_DESCRIPTOR_RANGE_OFFSET_APPEND;
	range[2].RangeType = D3D12_DESCRIPTOR_RANGE_TYPE_SRV;
	range[2].NumDescriptors = 1;
	range[2].BaseShaderRegister = 3;
	range[2].RegisterSpace = 0;
	range[2].OffsetInDescriptorsFromTableStart = D3D12_DESCRIPTOR_RANGE_OFFSET_APPEND;
	range[3].RangeType = D3D12_DESCRIPTOR_RANGE_TYPE_SRV;
	range[3].NumDescriptors = 1;
	range[3].BaseShaderRegister = 4;
	range[3].RegisterSpace = 0;
	range[4].OffsetInDescriptorsFromTableStart = D3D12_DESCRIPTOR_RANGE_OFFSET_APPEND;
	range[4].RangeType = D3D12_DESCRIPTOR_RANGE_TYPE_SRV;
	range[4].NumDescriptors = 1;
	range[4].BaseShaderRegister = 5;
	range[4].RegisterSpace = 0;
	range[4].OffsetInDescriptorsFromTableStart = D3D12_DESCRIPTOR_RANGE_OFFSET_APPEND;

	// [gp[^̐ݒ.
	D3D12_ROOT_PARAMETER root_param[10];
	root_param[0].ParameterType = D3D12_ROOT_PARAMETER_TYPE_CBV;
	root_param[0].ShaderVisibility = D3D12_SHADER_VISIBILITY_ALL;
	root_param[0].Descriptor.ShaderRegister = 0;
	root_param[0].Descriptor.RegisterSpace = 0;
	root_param[1].ParameterType = D3D12_ROOT_PARAMETER_TYPE_CBV;
	root_param[1].ShaderVisibility = D3D12_SHADER_VISIBILITY_ALL;
	root_param[1].Descriptor.ShaderRegister = 1;
	root_param[1].Descriptor.RegisterSpace = 0;
	root_param[2].ParameterType = D3D12_ROOT_PARAMETER_TYPE_CBV;
	root_param[2].ShaderVisibility = D3D12_SHADER_VISIBILITY_ALL;
	root_param[2].Descriptor.ShaderRegister = 2;
	root_param[2].Descriptor.RegisterSpace = 0;
	root_param[3].ParameterType = D3D12_ROOT_PARAMETER_TYPE_CBV;
	root_param[3].ShaderVisibility = D3D12_SHADER_VISIBILITY_ALL;
	root_param[3].Descriptor.ShaderRegister = 3;
	root_param[3].Descriptor.RegisterSpace = 0;
	root_param[4].ParameterType = D3D12_ROOT_PARAMETER_TYPE_CBV;
	root_param[4].ShaderVisibility = D3D12_SHADER_VISIBILITY_ALL;
	root_param[4].Descriptor.ShaderRegister = 4;
	root_param[4].Descriptor.RegisterSpace = 0;
	root_param[5].ParameterType = D3D12_ROOT_PARAMETER_TYPE_DESCRIPTOR_TABLE;
	root_param[5].ShaderVisibility = D3D12_SHADER_VISIBILITY_ALL;
	root_param[5].DescriptorTable.NumDescriptorRanges = 1;
	root_param[5].DescriptorTable.pDescriptorRanges = &range[0];
	root_param[6].ParameterType = D3D12_ROOT_PARAMETER_TYPE_DESCRIPTOR_TABLE;
	root_param[6].ShaderVisibility = D3D12_SHADER_VISIBILITY_ALL;
	root_param[6].DescriptorTable.NumDescriptorRanges = 1;
	root_param[6].DescriptorTable.pDescriptorRanges = &range[1];
	root_param[7].ParameterType = D3D12_ROOT_PARAMETER_TYPE_DESCRIPTOR_TABLE;
	root_param[7].ShaderVisibility = D3D12_SHADER_VISIBILITY_ALL;
	root_param[7].DescriptorTable.NumDescriptorRanges = 1;
	root_param[7].DescriptorTable.pDescriptorRanges = &range[2];
	root_param[8].ParameterType = D3D12_ROOT_PARAMETER_TYPE_DESCRIPTOR_TABLE;
	root_param[8].ShaderVisibility = D3D12_SHADER_VISIBILITY_ALL;
	root_param[8].DescriptorTable.NumDescriptorRanges = 1;
	root_param[8].DescriptorTable.pDescriptorRanges = &range[3];
	root_param[9].ParameterType = D3D12_ROOT_PARAMETER_TYPE_DESCRIPTOR_TABLE;
	root_param[9].ShaderVisibility = D3D12_SHADER_VISIBILITY_ALL;
	root_param[9].DescriptorTable.NumDescriptorRanges = 1;
	root_param[9].DescriptorTable.pDescriptorRanges = &range[4];

	D3D12_STATIC_SAMPLER_DESC sampleDesc = {};
	sampleDesc.AddressU = D3D12_TEXTURE_ADDRESS_MODE_WRAP;
	sampleDesc.AddressV = D3D12_TEXTURE_ADDRESS_MODE_WRAP;
	sampleDesc.AddressW = D3D12_TEXTURE_ADDRESS_MODE_WRAP;
	sampleDesc.BorderColor = D3D12_STATIC_BORDER_COLOR_TRANSPARENT_BLACK;
	sampleDesc.Filter = D3D12_FILTER_MIN_MAG_MIP_LINEAR;
	sampleDesc.ComparisonFunc = D3D12_COMPARISON_FUNC_NEVER;
	sampleDesc.MaxLOD = D3D12_FLOAT32_MAX;
	sampleDesc.MinLOD = 0.0f;
	sampleDesc.ShaderVisibility = D3D12_SHADER_VISIBILITY_ALL;
	sampleDesc.ShaderRegister = 0;
	sampleDesc.MaxAnisotropy = 16;

	// [gVOj`̐ݒ.
	D3D12_ROOT_SIGNATURE_DESC root_sig_desc;
	ZeroMemory(&root_sig_desc, sizeof(root_sig_desc));
	root_sig_desc.NumParameters = _countof(root_param);
	root_sig_desc.pStaticSamplers = &sampleDesc;
	root_sig_desc.NumStaticSamplers = 1;
	root_sig_desc.pParameters = root_param;
	root_sig_desc.Flags = D3D12_ROOT_SIGNATURE_FLAG_ALLOW_INPUT_ASSEMBLER_INPUT_LAYOUT;

	// VACY.
	hr = D3D12SerializeRootSignature(&root_sig_desc, D3D_ROOT_SIGNATURE_VERSION_1, &Signature, &Error);
	hr = m_pDevice->CreateRootSignature(0, Signature->GetBufferPointer(), Signature->GetBufferSize(), IID_ID3D12RootSignature, (void**)&RootSignature);
	if (hr != S_OK) {
		hr = m_pDevice->GetDeviceRemovedReason();
		return false;
	}

	////////////////////////////////////////////////////////////////////////////////////
	// pCvCXe[g̐.

	// RpCςݒ_VF[_ǂݍ.
	hr = D3DReadFileToBlob(L"shader/vs1.cso", (ID3DBlob**)&m_pVS1Blob);
	hr = D3DReadFileToBlob(L"shader/ps1.cso", (ID3DBlob**)&m_pPS1Blob);
	hr = D3DReadFileToBlob(L"shader/vs2.cso", (ID3DBlob**)&m_pVS2Blob);
	hr = D3DReadFileToBlob(L"shader/ps2.cso", (ID3DBlob**)&m_pPS2Blob);
	hr = D3DReadFileToBlob(L"shader/vs3.cso", (ID3DBlob**)&m_pVS3Blob);
	hr = D3DReadFileToBlob(L"shader/ps3.cso", (ID3DBlob**)&m_pPS3Blob);
	hr = D3DReadFileToBlob(L"shader/vs4.cso", (ID3DBlob**)&m_pVS4Blob);
	hr = D3DReadFileToBlob(L"shader/ps4.cso", (ID3DBlob**)&m_pPS4Blob);
	hr = D3DReadFileToBlob(L"shader/vs5.cso", (ID3DBlob**)&m_pVS5Blob);
	hr = D3DReadFileToBlob(L"shader/ps5.cso", (ID3DBlob**)&m_pPS5Blob);
	hr = D3DReadFileToBlob(L"shader/vs6.cso", (ID3DBlob**)&m_pVS6Blob);
	hr = D3DReadFileToBlob(L"shader/ps6.cso", (ID3DBlob**)&m_pPS6Blob);

	// ̓CAEg̐ݒ.
	D3D12_INPUT_ELEMENT_DESC inputElements1[] = {
		// texcood 0̓eNX`UVłB
		// texcood 1`8̓{[̃EFCg͂܂BWEIGHT_BONE_APPLY_NUM̐texcoordKv܂B(default = 8)

		{ "POSITION", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "NORMAL", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "COLOR", 0, DXGI_FORMAT_R32G32B32A32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 0, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 1, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 2, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 3, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 4, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 5, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 6, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 7, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 8, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
	};

	D3D12_INPUT_ELEMENT_DESC inputElements2[] = {
		{ "POSITION", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "NORMAL", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 0, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
	};

	D3D12_INPUT_ELEMENT_DESC inputElements3[] = {
		{ "POSITION", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "NORMAL", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 0, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 1, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 2, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 3, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 4, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 5, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 6, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 7, DXGI_FORMAT_R32G32_FLOAT, 0, D3D12_APPEND_ALIGNED_ELEMENT, D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA, 0 },
	};

	// X^CU[Xe[g̐ݒ.
	D3D12_RASTERIZER_DESC descRS;
	ZeroMemory(&descRS, sizeof(descRS));
	descRS.FillMode = D3D12_FILL_MODE_SOLID;
	descRS.CullMode = D3D12_CULL_MODE_NONE;
	descRS.FrontCounterClockwise = FALSE;
	descRS.DepthBias = D3D12_DEFAULT_DEPTH_BIAS;
	descRS.DepthBiasClamp = D3D12_DEFAULT_DEPTH_BIAS_CLAMP;
	descRS.SlopeScaledDepthBias = D3D12_DEFAULT_SLOPE_SCALED_DEPTH_BIAS;
	descRS.DepthClipEnable = TRUE;
	descRS.MultisampleEnable = FALSE;
	descRS.AntialiasedLineEnable = FALSE;
	descRS.ForcedSampleCount = 0;
	descRS.ConservativeRaster = D3D12_CONSERVATIVE_RASTERIZATION_MODE_OFF;

	// _[^[Qbg̃uhݒ.
	D3D12_RENDER_TARGET_BLEND_DESC descRTBS = {};
	descRTBS.BlendEnable = TRUE;
	descRTBS.LogicOpEnable = FALSE;
	descRTBS.RenderTargetWriteMask = D3D12_COLOR_WRITE_ENABLE_ALL;
	descRTBS.SrcBlend = D3D12_BLEND_SRC_ALPHA;
	descRTBS.DestBlend = D3D12_BLEND_INV_SRC_ALPHA;
	descRTBS.BlendOp = D3D12_BLEND_OP_ADD;
	descRTBS.SrcBlendAlpha = D3D12_BLEND_ONE;
	descRTBS.DestBlendAlpha = D3D12_BLEND_ZERO;
	descRTBS.BlendOpAlpha = D3D12_BLEND_OP_ADD;
	descRTBS.RenderTargetWriteMask = D3D12_COLOR_WRITE_ENABLE_ALL;
	descRTBS.LogicOpEnable = FALSE;
	descRTBS.LogicOp = D3D12_LOGIC_OP_NOOP;

	// uhXe[g̐ݒ.
	D3D12_BLEND_DESC descBS;
	ZeroMemory(&descBS, sizeof(descBS));
	descBS.AlphaToCoverageEnable = FALSE;
	descBS.IndependentBlendEnable = FALSE;
	for (UINT i = 0; i <= D3D12_SIMULTANEOUS_RENDER_TARGET_COUNT - 1; i++) {
		descBS.RenderTarget[i] = descRTBS;
	}

	// pCvCXe[g̐ݒ.
	D3D12_GRAPHICS_PIPELINE_STATE_DESC pipeline_desc;
	ZeroMemory(&pipeline_desc, sizeof(pipeline_desc));
	pipeline_desc.InputLayout = { inputElements1, _countof(inputElements1) };
	pipeline_desc.pRootSignature = RootSignature;
	pipeline_desc.VS = { m_pVS1Blob->GetBufferPointer(), m_pVS1Blob->GetBufferSize() };
	pipeline_desc.PS = { m_pPS1Blob->GetBufferPointer(), m_pPS1Blob->GetBufferSize() };
	pipeline_desc.RasterizerState = descRS;
	pipeline_desc.BlendState = descBS;
	pipeline_desc.SampleMask = UINT_MAX;
	pipeline_desc.PrimitiveTopologyType = D3D12_PRIMITIVE_TOPOLOGY_TYPE_TRIANGLE;
	pipeline_desc.NumRenderTargets = 1;
	pipeline_desc.RTVFormats[0] = DXGI_FORMAT_R8G8B8A8_UNORM;
	pipeline_desc.DSVFormat = DXGI_FORMAT_D32_FLOAT;
	pipeline_desc.SampleDesc.Count = 1;
	pipeline_desc.DepthStencilState.DepthEnable = TRUE;
	pipeline_desc.DepthStencilState.StencilEnable = FALSE;
	pipeline_desc.DepthStencilState.DepthFunc = D3D12_COMPARISON_FUNC_LESS_EQUAL;
	pipeline_desc.DepthStencilState.DepthWriteMask = D3D12_DEPTH_WRITE_MASK_ALL;
	hr = m_pDevice->CreateGraphicsPipelineState(&pipeline_desc, IID_PPV_ARGS(&m_pPipeLineState1));

	pipeline_desc.InputLayout = { inputElements3, _countof(inputElements3) };
	pipeline_desc.DSVFormat = DXGI_FORMAT_D32_FLOAT;
	pipeline_desc.SampleDesc.Count = 1;
	pipeline_desc.DepthStencilState.DepthEnable = TRUE;
	pipeline_desc.DepthStencilState.StencilEnable = FALSE;
	pipeline_desc.DepthStencilState.DepthFunc = D3D12_COMPARISON_FUNC_LESS_EQUAL;
	pipeline_desc.DepthStencilState.DepthWriteMask = D3D12_DEPTH_WRITE_MASK_ALL;
	pipeline_desc.VS = { m_pVS4Blob->GetBufferPointer(), m_pVS4Blob->GetBufferSize() };
	pipeline_desc.PS = { m_pPS4Blob->GetBufferPointer(), m_pPS4Blob->GetBufferSize() };
	hr = m_pDevice->CreateGraphicsPipelineState(&pipeline_desc, IID_PPV_ARGS(&m_pPipeLineState4));

	//g[VF[_`
	pipeline_desc.InputLayout = { inputElements1, _countof(inputElements1) };
	pipeline_desc.RTVFormats[0] = DXGI_FORMAT_R32G32B32A32_FLOAT;
	pipeline_desc.RTVFormats[1] = DXGI_FORMAT_R32G32B32A32_FLOAT;
	pipeline_desc.NumRenderTargets = 2;
	pipeline_desc.VS = { m_pVS6Blob->GetBufferPointer(), m_pVS6Blob->GetBufferSize() };
	pipeline_desc.PS = { m_pPS6Blob->GetBufferPointer(), m_pPS6Blob->GetBufferSize() };
	hr = m_pDevice->CreateGraphicsPipelineState(&pipeline_desc, IID_PPV_ARGS(&m_pPipeLineState6));

	//VhE}bv`
	pipeline_desc.InputLayout = { inputElements1, _countof(inputElements1) };
	pipeline_desc.RTVFormats[0] = DXGI_FORMAT_R32G32B32A32_FLOAT;
	pipeline_desc.RTVFormats[1] = DXGI_FORMAT_UNKNOWN;
	pipeline_desc.NumRenderTargets = 1;
	pipeline_desc.VS = { m_pVS5Blob->GetBufferPointer(), m_pVS5Blob->GetBufferSize() };
	pipeline_desc.PS = { m_pPS5Blob->GetBufferPointer(), m_pPS5Blob->GetBufferSize() };
	hr = m_pDevice->CreateGraphicsPipelineState(&pipeline_desc, IID_PPV_ARGS(&m_pPipeLineState5));

	//_O̍
	ZeroMemory(&pipeline_desc, sizeof(pipeline_desc));
	pipeline_desc.InputLayout = { inputElements2, _countof(inputElements2) };
	pipeline_desc.pRootSignature = RootSignature;
	pipeline_desc.RTVFormats[0] = DXGI_FORMAT_R8G8B8A8_UNORM;
	pipeline_desc.VS = { m_pVS2Blob->GetBufferPointer(), m_pVS2Blob->GetBufferSize() };
	pipeline_desc.PS = { m_pPS2Blob->GetBufferPointer(), m_pPS2Blob->GetBufferSize() };
	pipeline_desc.RasterizerState = descRS;
	pipeline_desc.BlendState = descBS;
	pipeline_desc.SampleMask = UINT_MAX;
	pipeline_desc.PrimitiveTopologyType = D3D12_PRIMITIVE_TOPOLOGY_TYPE_TRIANGLE;
	pipeline_desc.NumRenderTargets = 1;
	pipeline_desc.DSVFormat = DXGI_FORMAT_D32_FLOAT;
	pipeline_desc.SampleDesc.Count = 1;
	pipeline_desc.DepthStencilState.DepthEnable = TRUE;
	pipeline_desc.DepthStencilState.DepthFunc = D3D12_COMPARISON_FUNC_LESS_EQUAL;
	pipeline_desc.DepthStencilState.DepthWriteMask = D3D12_DEPTH_WRITE_MASK_ALL;
	hr = m_pDevice->CreateGraphicsPipelineState(&pipeline_desc, IID_PPV_ARGS(&m_pPipeLineState2));

	//RC_[\p
	ZeroMemory(&pipeline_desc, sizeof(pipeline_desc));
	pipeline_desc.InputLayout = { inputElements2, _countof(inputElements2) };
	pipeline_desc.pRootSignature = RootSignature;
	pipeline_desc.VS = { m_pVS3Blob->GetBufferPointer(), m_pVS3Blob->GetBufferSize() };
	pipeline_desc.PS = { m_pPS3Blob->GetBufferPointer(), m_pPS3Blob->GetBufferSize() };
	pipeline_desc.RasterizerState = descRS;
	pipeline_desc.BlendState = descBS;
	pipeline_desc.SampleMask = UINT_MAX;
	pipeline_desc.PrimitiveTopologyType = D3D12_PRIMITIVE_TOPOLOGY_TYPE_TRIANGLE;
	pipeline_desc.NumRenderTargets = 1;
	pipeline_desc.RTVFormats[0] = DXGI_FORMAT_R8G8B8A8_UNORM;
	pipeline_desc.DSVFormat = DXGI_FORMAT_D32_FLOAT;
	pipeline_desc.SampleDesc.Count = 1;
	pipeline_desc.DepthStencilState.DepthEnable = FALSE;
	pipeline_desc.DepthStencilState.DepthFunc = D3D12_COMPARISON_FUNC_LESS_EQUAL;
	pipeline_desc.DepthStencilState.DepthWriteMask = D3D12_DEPTH_WRITE_MASK_ALL;
	hr = m_pDevice->CreateGraphicsPipelineState(&pipeline_desc, IID_PPV_ARGS(&m_pPipeLineState3));

	return true;
}

bool CCommonDevice::ReleaseCommonDevice() {

	delete VertexBufferView;
	delete constant_buffer_begin;

	SAFE_RELEASE(m_pDevice);
	SAFE_RELEASE(m_pCmdQue);
	SAFE_RELEASE(m_pCmdList);
	SAFE_RELEASE(m_pFactory);
	SAFE_RELEASE(m_pAdapter);
	SAFE_RELEASE(m_pSwapChain);
	SAFE_RELEASE(m_pFence);
	SAFE_RELEASE(m_pRTVHeap);
	SAFE_RELEASE(m_pDepthHeap);
	SAFE_RELEASE(m_pTmpHeap);
	SAFE_RELEASE(m_pTmpTexture);
	SAFE_RELEASE(m_pToonHeap);
	SAFE_RELEASE(m_pToonTexture);
	SAFE_RELEASE(m_pToonDepthHeap);
	SAFE_RELEASE(m_pToonDepthTexture);
	SAFE_RELEASE(m_pColliderHeap);
	SAFE_RELEASE(m_pColliderTexture);
	SAFE_RELEASE(m_pShadowMapHeap);
	SAFE_RELEASE(m_pShadowMapTexture);
	SAFE_RELEASE(m_pDepthStencilView);
	SAFE_RELEASE(m_pRenderTarget[1]);
	SAFE_RELEASE(m_pRenderTarget[2]);
	SAFE_RELEASE(m_pVertexBuffer);
	SAFE_RELEASE(m_pHeap);
	SAFE_RELEASE(m_pConstantBuffer);
	SAFE_RELEASE(Signature);
	SAFE_RELEASE(Error);
	SAFE_RELEASE(RootSignature);
	SAFE_RELEASE(m_pVS1Blob);
	SAFE_RELEASE(m_pVS2Blob);
	SAFE_RELEASE(m_pVS3Blob);
	SAFE_RELEASE(m_pVS4Blob);
	SAFE_RELEASE(m_pVS5Blob);
	SAFE_RELEASE(m_pVS6Blob);
	SAFE_RELEASE(m_pPS1Blob);
	SAFE_RELEASE(m_pPS2Blob);
	SAFE_RELEASE(m_pPS3Blob);
	SAFE_RELEASE(m_pPS4Blob);
	SAFE_RELEASE(m_pPS5Blob);
	SAFE_RELEASE(m_pPS6Blob);
	SAFE_RELEASE(m_pPipeLineState1);
	SAFE_RELEASE(m_pPipeLineState2);
	SAFE_RELEASE(m_pPipeLineState3);
	SAFE_RELEASE(m_pPipeLineState4);
	SAFE_RELEASE(m_pPipeLineState5);
	SAFE_RELEASE(m_pPipeLineState6);
	SAFE_RELEASE(m_pDepthStencilView);
	SAFE_RELEASE(m_pSurface);

	if( ResManager != NULL )
		delete ResManager;

	return true;
}
