#pragma once
////////////////////////////////////////////////////////
// filename: ChaColliderObject.h
// author: Chafumi Touji
// version: 1.0.0
// date: 2021/04/01
////////////////////////////////////////////////////////

#ifndef __CHARECOLLIDEROBJECT_H__
#define __CHARECOLLIDEROBJECT_H__

struct ConstantBufferCollider {

	XMFLOAT4		ColliderPos[COLLIDER_POS_MAX][2];
	XMFLOAT4		ColliderParam[COLLIDER_POS_MAX];
};

struct CColliderVertex{

	float3 Pos;
	float3 Normal;
	float2 Weight[WEIGHT_BONE_APPLY_NUM];
};

class CColliderPolygonData {
public:

	wchar_t VertexID[SIZE_CHAR_MAX];
	wchar_t NormalID[SIZE_CHAR_MAX];
	ID3D12Resource* VertexBuffer;
	D3D12_VERTEX_BUFFER_VIEW* VertexBufferView;
	CVector* VertexIndex;
	CVector* NormalIndex;
	int		PgnVtxCount;

public:

	CColliderPolygonData();
	~CColliderPolygonData();
};

class CColliderGeometry {
public:

	wchar_t	GeometryID[SIZE_CHAR_MAX];
	XMMATRIX	BindShapeMatrix;
	int		VertexCount;

	char* Buffer;
	char* TransformedBuffer;
	CVector* VecFloatArray;
	CVector* PolygonData;
	int64_t*** Weights;

	CColliderVertex	ColliderPos[2];
	CColliderVertex TransformedColliderPos[2];
	int		WeightCount;
	int		ColliderType;
	float	R;

public:

	CColliderGeometry();
	~CColliderGeometry();
	CFloatArray* GetFloatArray(wchar_t* id);
};

class CChaColliderObject {
public:

	wchar_t	ModelID[SIZE_CHAR_MAX];
	CChaResourceObject* ResourceOrigin;
	CResManager* ResManager;
	CVector* ColliderGeometry;

	ID3D12Resource* m_pConstantBufferCollider;
	ConstantBufferMaterial* constant_buffer_collider_begin;
	UINT	constant_buffer_collider_num;

public:
	CChaColliderObject();
	~CChaColliderObject();
	bool LoadCollider(const wchar_t* filename);
	bool CreateResource(ID3D12Device* device, CChaResourceObject* object_origin, CResManager* ResManager);
	bool Draw(ID3D12GraphicsCommandList* CmdList, XMMATRIX matWorld, XMMATRIX matView, XMMATRIX matProj, ID3D12PipelineState *pp_state_point, ID3D12PipelineState *pp_state_mesh );
	bool Transform();
	CColliderVertex VertexTransform(CColliderVertex vertex, XMMATRIX bind_shape_matrix );
};

#endif