Texture2D TexDiffuse : register(t0);
SamplerState sampleDiffuse : register(s0);

Texture2D TexDepth : register(t1);
SamplerState sampleDepth : register(s1);


cbuffer ConstantBuffer1 : register(b0) {

	matrix	MatWorld;
	matrix	MatView;
	matrix	MatProj;
	float4	LightColor[16];
	float4	LightPos[16];
	float4	EyePos;
}

cbuffer ConstantBuffer2 : register(b1) {

	float4 Ambient;
	float4 Diffuse;
	float4 Specular;
	float4 AlphaParam;
}

cbuffer ConstantBuffer3 : register(b2) {

	float4			ToneLightPos;
	matrix			BindShapeMatrix;
	matrix			MatTransform;
	matrix			BoneMatrix[255];
}

////////////////////////////////////////////////////////

struct VertexIn {

	float3 Pos : POSITION;
	float3 Normal : NORMAL;
	float4 Color : COLOR;
	float2 Tex : TEXCOORD;
	float2 Weight0 : TEXCOORD1;
	float2 Weight1 : TEXCOORD2;
	float2 Weight2 : TEXCOORD3;
	float2 Weight3 : TEXCOORD4;
	float2 Weight4 : TEXCOORD5;
	float2 Weight5 : TEXCOORD6;
	float2 Weight6 : TEXCOORD7;
	float2 Weight7 : TEXCOORD8;
};

struct VertexOut {

	float4 Pos : SV_POSITION;
	float3 VtxPos : POSITION0;
	float3 Normal : POSITION1;
	float4 Color : COLOR0;
	float2 Tex : TEXCOORD0;
};

/////////////////////////////////////////////////////////////////////

VertexOut vs_main1(VertexIn IN) {

	VertexOut OUT;

	float4 vtx = float4(IN.Pos, 1.0f);
	float4 normal = float4(IN.Normal, 1.0f);
	float4 vtx_tmp = float4(0, 0, 0, 0);
	float4 normal_tmp = float4(0, 0, 0, 0);

	vtx = mul(vtx, BindShapeMatrix);
	normal = mul(normal, BindShapeMatrix);

	int joint0 = (int)(IN.Weight0.x + 0.0001f);
	int joint1 = (int)(IN.Weight1.x + 0.0001f);
	int joint2 = (int)(IN.Weight2.x + 0.0001f);
	int joint3 = (int)(IN.Weight3.x + 0.0001f);
	int joint4 = (int)(IN.Weight4.x + 0.0001f);
	int joint5 = (int)(IN.Weight5.x + 0.0001f);
	int joint6 = (int)(IN.Weight6.x + 0.0001f);
	int joint7 = (int)(IN.Weight7.x + 0.0001f);

	float w0 = clamp(IN.Weight0.y, 0.0f, 1.0f);
	float w1 = clamp(IN.Weight1.y, 0.0f, 1.0f);
	float w2 = clamp(IN.Weight2.y, 0.0f, 1.0f);
	float w3 = clamp(IN.Weight3.y, 0.0f, 1.0f);
	float w4 = clamp(IN.Weight4.y, 0.0f, 1.0f);
	float w5 = clamp(IN.Weight5.y, 0.0f, 1.0f);
	float w6 = clamp(IN.Weight6.y, 0.0f, 1.0f);
	float w7 = clamp(IN.Weight7.y, 0.0f, 1.0f);

	bool add_weight = false;
	float4 v = float4(0, 0, 0, 0);
	float4 n = float4(0, 0, 0, 0);

	if (w0 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint0]);
		n = mul(normal, BoneMatrix[joint0]);
		v *= w0;
		n *= w0;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w1 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint1]);
		n = mul(normal, BoneMatrix[joint1]);
		v *= w1;
		n *= w1;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w2 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint2]);
		n = mul(normal, BoneMatrix[joint2]);
		v *= w2;
		n *= w2;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w3 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint3]);
		n = mul(normal, BoneMatrix[joint3]);
		v *= w3;
		n *= w3;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w4 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint4]);
		n = mul(normal, BoneMatrix[joint4]);
		v *= w4;
		n *= w4;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w5 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint5]);
		n = mul(normal, BoneMatrix[joint5]);
		v *= w5;
		n *= w5;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w6 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint6]);
		n = mul(normal, BoneMatrix[joint6]);
		v *= w6;
		n *= w6;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w7 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint7]);
		n = mul(normal, BoneMatrix[joint7]);
		v *= w7;
		n *= w7;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}

	if (add_weight == true) {
		vtx = vtx_tmp;
		normal = normal_tmp;
	}

	vtx = mul(vtx, MatTransform);
	OUT.VtxPos = vtx.xyz;
	vtx = mul(vtx, MatWorld);
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;
	OUT.Normal = normal.xyz;
	OUT.Color = float4(0, 0, 0, 1);
	OUT.Color = IN.Color;
	OUT.Tex = IN.Tex;

	return OUT;
}

/////////////////////////////////////////////////////////////////////////

float4 ps_main1(VertexOut input) : SV_Target0{

	//fBt[YJ[̏o

	float4 color = float4(0, 0, 0, 1);
	float4 tex_color = TexDiffuse.Sample(sampleDiffuse, input.Tex);
	float4 light_color = float4(0, 0, 0, 1);
	float4 dif = float4(0, 0, 0, 0);
	float4 amb = float4(0, 0, 0, 0);
	float4 spec = float4(0, 0, 0, 0);

	float count = 0;
	for (int i = 0; i <= 15; i++) {

		if (LightColor[i].w < 0.001f)
			continue;

		float specular_power = 0.2f;
		float ambient_power = 3.0f;
		float light_power = LightColor[i].w;
		float3 L = normalize(-LightPos[i].xyz - input.Normal.xyz);
		float3 N = normalize(input.Normal.xyz);
		float LN = dot(L, N);
		float3 R = normalize(2 * LN * N - normalize(-LightPos[i].xyz));
		float3 V = normalize(EyePos.xyz);
		float RV = saturate(dot(R, V));
		amb += tex_color * ambient_power;
		dif += saturate(LN * tex_color);
		spec += saturate(specular_power * pow(RV, 5.0));

		float dist = pow(input.VtxPos.x - LightPos[i].x, 2.0f) + pow(input.VtxPos.y - LightPos[i].y, 2.0f) + pow(input.VtxPos.z - LightPos[i].z, 2.0f);
		float power = LightColor[i].w * 30.0f / (1.0f + dist);

		light_color.rgb += power * LightColor[i].rgb;

		count++;
	}
	amb.rgb /= max(count, 1.0f);
	dif.rgb /= max(count, 1.0f);
	spec.rgb /= max(count, 1.0f);
	light_color.rgb /= max(count, 1.0f);

	color.rgb = (light_color.rgb + 0.2f) * (amb.rgb + dif.rgb + spec.rgb);
	color.rgb = clamp(color.rgb, 0.0f, 1.0f);
	color.a = tex_color.a;

	return color;
}
