/////////////////////////////////////////////////
//
//  filename: StdAfx.h
//  author: 
//  date: 2018/04/03 ver1.00
//		  2020/03/22 ver1.02
//
/////////////////////////////////////////////////

#ifndef __STDAFX_H__
#define __STDAFX_H__

#include <Windows.h>
#include <windowsx.h>
#include <atlimage.h>
#include <locale.h>
#include <atlstr.h>
#include <stdio.h>
#include <stdlib.h>
#include <gdiplus.h>
#include <Richedit.h>
#include <tchar.h>

#include <imm.h>
#pragma comment(lib, "imm32.lib")

#include <mmsystem.h>
#pragma comment(lib, "winmm.lib")

using namespace Gdiplus;

#include <d3d12.h>
#include <dxgi1_4.h>
#include <D3Dcompiler.h>
#include <math.h>
#include <DirectXMath.h>

#pragma comment(lib, "d3d12.lib")
#pragma comment(lib, "dxgi.lib")
#pragma comment(lib, "d3dcompiler.lib")
#pragma comment(lib, "windowscodecs.lib")
#pragma comment(lib, "dxguid.lib")

using namespace DirectX;

#include "defcha3dcore.h"
#pragma comment( lib, "Cha3DCoreLib1.14.1.lib")

#define SIZE_CHAR_MAX		1024
#define SAFE_RELEASE(p) { if( p ) { (p)->Release(); (p) = NULL;}}

#define COLOR_TRANSPARENT_R		255
#define COLOR_TRANSPARENT_G		255
#define COLOR_TRANSPARENT_B		255
#define SELECT_LIST_ITEM_DISP_NUM	8
#define ANIMATION_LIST_DISP_NUM		16

#define OPEN_TYPE_UNKNOWN		0
#define OPEN_TYPE_LOAD_MODEL	1
#define OPEN_TYPE_WRITE_MODEL	2
#define OPEN_TYPE_LOAD_ANIMATION	3
#define OPEN_TYPE_WRITE_ANIMATION	4

////////////////////////////////////////////////////////////////////

#define APP_TITLE					_T("ModelViewer")
#define APP_NAME					"ModelViewer ver1.55"
#define DEFAULT_MODEL_NAME			L"coco1.43a.dae"
#define EXT_MODEL					L".mdl"
#define EXT_ANIM					L".ani"
#define EXT_DAE						L".dae"
#define UNDEFINED_FILE_NAME			L"̖ݒ"

#define MV_FILE_TYPE_UNKNOWN			0
#define MV_FILE_TYPE_MODEL				1
#define MV_FILE_TYPE_ANIMATION			2
#define MV_FILE_TYPE_COLLADA			3
#define MV_FILE_TYPE_DIRECTORY			4

#endif