/////////////////////////////////////////////////
//
//  filename: DispWindow.h
//  author:Chafumi Touji
//  date: 2020/03/09 ver1.00
//
/////////////////////////////////////////////////

#ifndef __DISPWINDOW_H__
#define __DISPWINDOW_H__

struct Vertex {

	float3 Pos;
	float3 Normal;
	float4 Color;
	float2 UV;
	float2 Weight[WEIGHT_BONE_APPLY_NUM];
};

struct ConstantBuffer1 {

	XMFLOAT4X4	MatWorld;
	XMFLOAT4X4	MatView;
	XMFLOAT4X4	MatProj;
	XMFLOAT4	LightColor[16];
	XMFLOAT4	LightPos[16];
	XMFLOAT4	EyePos;
};

class CConfig;

class CDispWindow {
public:

	ID3D12Device1* m_pDevice;
	ID3D12CommandQueue* m_pCmdQue;
	ID3D12CommandAllocator* m_pCmdAlloc;
	ID3D12GraphicsCommandList* m_pCmdList;
	IDXGIFactory4* m_pFactory;
	IDXGIAdapter1* m_pAdapter;
	IDXGISwapChain3* m_pSwapChain;
	ID3D12Fence1* m_pFence;
	HANDLE						FenceEvent;
	UINT64						FenceValue;
	D3D12_RECT					ScissorRect;
	UINT64						FrameIndex;

	ID3D12DescriptorHeap* m_pRTVHeap;
	int							RTVDescriptorSize;
	ID3D12DescriptorHeap* m_pDepthHeap;
	int							DepthDescriptorSize;

	ID3D12Resource* m_pDepthStencilView;
	ID3D12Resource* m_pRenderTarget[2];
	ID3D12Resource* m_pVertexBuffer;
	D3D12_VERTEX_BUFFER_VIEW	VertexBufferView;

	ID3D12DescriptorHeap* m_pHeap;
	CResManager* ResManager;

	ID3D12Resource* m_pConstantBuffer;
	ConstantBuffer1			constant_buffer;
	ConstantBuffer1* constant_buffer_begin;
	int64_t							constant_buffer_begin_num;

	ID3DBlob* Signature;
	ID3DBlob* Error;
	ID3D12RootSignature* RootSignature;
	ID3DBlob* m_pVS1Blob, * m_pVS2Blob, * m_pPS1Blob, * m_pPS2Blob;

	ID3D12PipelineState* m_pPipeLineState;

	IDXGISurface1* m_pSurface;


	CChaDataObject* ChaDataObject;
	CChaResourceObject* ChaResourceObject;

	XMMATRIX					matWorld;
	XMMATRIX					matView;
	XMMATRIX					matProj;

	wchar_t						Path[SIZE_CHAR_MAX];
	XMFLOAT4						BKColor;
	XMFLOAT3						Eye;
	float						Zoom;
	float						CameraHeight;

	float						RotationX;
	float						RotationY;
	float						RotationZ;

	HWND			m_hWnd;
	UINT			TimerID;

	int				Width, Height;
	int				DisplayWidth, DisplayHeight;
	bool			LButtonDown;
	bool			RButtonDown;
	CPoint			DownPoint;

	bool			Rock;
	bool			ReloadRock;

	float			EyePosX, EyePosY;
	float			LightPosX, LightPosY, LightPosZ;

	bool			IsFullScreen;
	bool			BackFullScreen;
	bool			IsTransparent;
	int				TransparentR, TransparentG, TransparentB;

	CDispWindow();
	~CDispWindow();
	bool SetParam(CConfig* config);
	bool InitD3D();
	bool ReleaseD3D();
	bool CreateWnd(HWND parent_wnd, int x, int y, int w, int h);
	bool Render();

public:
	void OnPaint();
	void OnKeyDown(UINT nChar);
	void OnLButtonDown(UINT nFlag, CPoint point);
	void OnLButtonUp(UINT nFlag, CPoint point);
	void OnRButtonDown(UINT nFlag, CPoint point);
	void OnRButtonUp(UINT nFlag, CPoint point);
	void OnMouseMove(UINT nFlag, CPoint point);
	void OnMouseWheel(UINT key, int delta, CPoint point);
	void OnSize(UINT nType, int cx, int cy);
	void WaitForGPU();

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT DispWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	static void CALLBACK  TimeUpdateCallback(UINT timer_id, UINT msg, LPTIMECALLBACK user, DWORD_PTR data1, DWORD_PTR data2);
};

#endif