////////////////////////////////////////////////////////
// filename: defcha3dcore.h
// author: Chafumi Touji
// version: 1.0.0
// date: 2020/03/05
////////////////////////////////////////////////////////

#ifndef __DEFCHA3DCORE_H__
#define __DEFCHA3DCORE_H__

#define _XM_NO_INTRINSICS_

#define SIZE_CHAR_MAX	1024
#define FLOAT_STRING_SIZE	8 * 16
#define INDEX_STRING_SIZE	8 * 16
#define WEIGHT_BONE_APPLY_NUM	8
#define BONE_JOINT_NUM_MAX		255

#define CHAMODEL_EXT_NAME	L".mdl"
#define CHAANIMATION_EXT_NAME	L".ani"

#define READ_MODE_INIT 0
#define READ_MODE_MATERIAL 1 
#define READ_MODE_TEXTURE 1 
#define READ_MODE_GEOMETRY 1 
#define READ_MODE_POLYGON_DATA 1 
#define READ_MODE_WEIGHTS 1 
#define READ_MODE_BONE 1 

#define TEX_ID_SIZE_MAX		15
#define TAB_MARGIN_SIZE		300
#define ANIMATION_KEY_TIME_SIZE_MAX		10000

#define SIZE_CBV_SRV_UAV_ARRAY		2000


#include <stdint.h>
#include <stdio.h>
#include <locale.h>
#include <tchar.h>
#include <math.h>

#include <d3d12.h>
#include <dxgi1_4.h>
#include <D3Dcompiler.h>
#include <DirectXMath.h>
#include <gdiplus.h>

#pragma comment(lib, "d3d12.lib")
#pragma comment(lib, "dxgi.lib")
#pragma comment(lib, "d3dcompiler.lib")
#pragma comment(lib,"gdiplus.lib")

using namespace Gdiplus; 
using namespace DirectX;

#import "msxml6.dll"
using namespace MSXML2;

#define SAFE_RELEASE(p) { if( p ) { (p)->Release(); (p) = NULL;}}

#include "common.h"
#include "CVector.h"
#include "defcha3dcore.h"
#include "ResManager.h"
#include "ChaDataObject.h"
#include "ChaResourceObject.h"

////////////////////////////////////////////////////////////

#define BONE_TYPE_UNKNOWN	0
#define BONE_TYPE_NODE		1
#define BONE_TYPE_JOINT		2

#define COLLADA_ANIMATION_ID_DEFAULT	L"ColladaAnim_001"

#endif