////////////////////////////////////////////////////////
// filename: ResManager.cpp
// author: Chafumi Touji
// version: 1.0.0
// date: 2021/03/11
////////////////////////////////////////////////////////

#include "defcha3dcore.h"
#include "ResManager.h"

CResManager::CResManager() {

	memset(ResArray, 0, sizeof(byte) * SIZE_CBV_SRV_UAV_ARRAY);
	m_pHeap = NULL;
}

CResManager::~CResManager() {

}

bool CResManager::Init(ID3D12Device *device, ID3D12DescriptorHeap *heap ) {

	m_pHeap = heap;
	CPUHandleStart = heap->GetCPUDescriptorHandleForHeapStart();
	GPUHandleStart = heap->GetGPUDescriptorHandleForHeapStart();
	BlockSize = device->GetDescriptorHandleIncrementSize(D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV);

	return true;
}

D3D12_CPU_DESCRIPTOR_HANDLE CResManager::CreateCPUHandle(int64_t *num) {

	D3D12_CPU_DESCRIPTOR_HANDLE handle = CPUHandleStart;

	int insert_num = 0;
	while (insert_num <= SIZE_CBV_SRV_UAV_ARRAY - 1) {

		if (ResArray[insert_num] == 0) {
			ResArray[insert_num] = 1;
			handle.ptr += BlockSize * insert_num;
			*num = insert_num;
			return handle;
		}

		insert_num++;
	}

	handle.ptr = 0;
	return handle;
}

D3D12_CPU_DESCRIPTOR_HANDLE CResManager::GetCPUHandle(int64_t num) {

	D3D12_CPU_DESCRIPTOR_HANDLE handle = CPUHandleStart;
	handle.ptr += num * BlockSize;

	return handle;
}

D3D12_GPU_DESCRIPTOR_HANDLE CResManager::GetGPUHandle(int64_t num) {

	D3D12_GPU_DESCRIPTOR_HANDLE handle = GPUHandleStart;
	handle.ptr += num * BlockSize;

	return handle;
}

bool CResManager::FreeResourceNum(int64_t num) {

	ResArray[num] = 0;

	return true;
}