////////////////////////////////////////////////////////
// filename: CCommonDevice.h
// author: Chafumi Touji
// version: 1.0.0
// date: 2020/07/11
////////////////////////////////////////////////////////

#ifndef __CCOMMONDEVICE_H__
#define __CCOMMONDEVICE_H__

struct ConstantBuffer1{

	XMFLOAT4X4	MatWorld;
	XMFLOAT4X4	MatView;
	XMFLOAT4X4	MatProj;
	XMFLOAT4	LightColor[LIGHT_NUM_MAX];
	XMFLOAT4	LightPos[LIGHT_NUM_MAX];
	XMFLOAT4	EyePos;
};

class CCommonDevice{
public:

	int			Width;
	int			Height;
	float			RotationX;
	float			RotationY;
	float			RotationZ;

	XMMATRIX					matWorld;
	XMMATRIX					matView;
	XMMATRIX					matProj;
	float3							Eye;
	float3							At;
	float3							Move;
	float								Zoom;
	float								SightAngle;

	int			MSAA_Quality;
	int			MSAA_Count;

	XMFLOAT4		PathPoint;
	XMFLOAT4		Point;
	XMFLOAT4		PrevPoint;
	XMFLOAT4		ControlPathPoint;
	XMFLOAT4		PrevPathPoint;
	int			PathCount;
	int			Path_t_Count;
	int			PathSliceSize;
	float			CameraRotationZ;

	XMFLOAT4					ShaderLight[LIGHT_NUM_MAX];
	XMFLOAT4					ShaderLightPos[LIGHT_NUM_MAX];

	ID3D11Device				*m_pDevice;
	ID3D11DeviceContext			*m_pDeviceContext;
	IDXGIDevice1				*m_pDXGI;
	IDXGIAdapter				*m_pAdapter;
	IDXGIFactory				*m_pFactory;
	IDXGISwapChain				*m_pSwapChain;
	ID3D11Texture2D				*m_pBackBuffer;
	ID3D11Texture2D				*m_pDiffuseTexture, *m_pDiffuse2Texture, *m_pToneTexture, *m_pEffectTexture, *m_pSkyTexture;
	ID3D11RenderTargetView		*m_pRenderTargetView;
	ID3D11RenderTargetView		*m_pDiffuseRenderTargetView, *m_pDiffuse2RenderTargetView, *m_pToneRenderTargetView, *m_pEffectRenderTargetView, *m_pSkyRenderTargetView;
	ID3D11RenderTargetView		*m_pGDIRenderTargetView;
	ID3D11DepthStencilView		*m_pDepthStencilView, *m_pReadOnlyDepthStencilView;
	ID3D11Texture2D				*m_pDepthBuffer, *m_pReadOnlyDepthBuffer;
	ID3D11Texture2D				*m_pDepthTexture, *m_pToneDepthTexture;
	ID3D11Texture2D				*m_pGDITexture;
	ID3D11ShaderResourceView	*m_pDiffuseShaderResourceView, *m_pDiffuse2ShaderResourceView, *m_pToneShaderResourceView, *m_pEffectShaderResourceView, *m_pSkyShaderResourceView;
	ID3D11ShaderResourceView	*m_pDepthShaderResourceView, *m_pToneDepthShaderResourceView;
	ID3D11ShaderResourceView	*m_pGDIShaderResourceView;
	ID3D11RenderTargetView		*m_pDepthRenderTargetView, *m_pToneDepthRenderTargetView;
	ID3D11InputLayout			*m_pLayout1, *m_pLayout2;
	ID3D11VertexShader			*m_pVtxShader1, *m_pVtxShader1_1, *m_pVtxShader1_2, *m_pVtxShader1_3, *m_pVtxShader1_4, *m_pVtxShader1_5, *m_pVtxShader1_6,
												*m_pVtxShader2, *m_pVtxShader3, *m_pVtxShader3_1;
	ID3D11PixelShader			*m_pPxShader1, *m_pPxShader2, *m_pPxShader3, *m_pPxShader4, *m_pPxShader5, *m_pPxShader6,
											*m_pPxShader7, *m_pPxShader8, *m_pPxShader9, *m_pPxShader10, *m_pPxShader11, *m_pPxShader12,
											*m_pPxShader13, *m_pPxShader14, *m_pPxShader15;
	ID3D11Buffer				*m_pConstantBuffer1;
	ID3D11SamplerState			*m_pSampleState;
	ID3D11RasterizerState		*m_pRasterizeState;
	ID3D11BlendState			*m_pBlendState1, *m_pBlendState2;
	IDXGISurface1				*m_pSurface;
	ID3D11Buffer				*VertexBuffer;

public:

	CCommonDevice();
	~CCommonDevice();
	bool CreateDevice( HWND m_hWnd, int width, int height );
	bool SetViewParam( float screen_width, float screen_heigth, float aspect );
	int CameraMove(XMFLOAT4 *path1, int point_num1, int path_slice_size );
	int CameraMoveSwing(XMFLOAT4 *path1, int point_num1, int path_slice_size);
};

#endif