/////////////////////////////////////////////////
//
//  filename: StdAfx.h
//  author: 
//  date: 2018/04/03 ver1.00
//		  2020/03/22 ver1.02
//
/////////////////////////////////////////////////

#ifndef __STDAFX_H__
#define __STDAFX_H__

#define _WIN32_LEAN_AND_MEAN_

#include <Windows.h>
#include <windowsx.h>
#include <atlimage.h>
#include <locale.h>
#include <atlstr.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <gdiplus.h>
#include <Richedit.h>

#include <imm.h>
#pragma comment(lib, "imm32.lib")

#include <mmsystem.h>
#pragma comment(lib, "winmm.lib")

using namespace Gdiplus;

#include "cha3d/defcha3dcore.h"
#pragma comment( lib, "Cha3DCoreLib1.10.lib")

#include "chasound/ChaSound.h"
#pragma comment( lib, "ChaSoundLib1.4.lib")

#include <math.h>
#include <xnamath.h>

#define RESOLUTION_WIDTH		1920.0f
#define RESOLUTION_HEIGHT	1080.0f

#define SIZE_CHAR_MAX		1024
#define COLOR_TRANSPARENT_R		255
#define COLOR_TRANSPARENT_G		255
#define COLOR_TRANSPARENT_B		255
#define SELECT_LIST_ITEM_DISP_NUM	8
#define ANIMATION_LIST_DISP_NUM		16

#define OPEN_TYPE_UNKNOWN		0
#define OPEN_TYPE_LOAD_MODEL	1
#define OPEN_TYPE_WRITE_MODEL	2
#define OPEN_TYPE_LOAD_ANIMATION	3
#define OPEN_TYPE_WRITE_ANIMATION	4

#define LIGHT_NUM_MAX		16

#define STATUS_INIT			1
#define STATUS_LOADING		2
#define STATUS_RUN			3

#define SUZUNE_APPROACH_DISTANCE		5.0f
#define PATH_SLICE_SIZE		20
#define ROUSOKU_TEXTURE_SIZE				256
#define SUZUNE_APPEAR_RATE					0.75

#define FRAME_RATE	1000.0f / 60.0f

////////////////////////////////////////////////////////////////////

#define APP_TITLE					_T("SuzuneToOnigokko")
#define APP_NAME					"Suzune_to_Onigokko1.0"
#define DEFAULT_MODEL_NAME			L"washitu1.mdl"
#define DEFAULT_SUZUNE_NAME		L"suzune.mdl"
#define SUZUNE_ANIM_1				L"suzune_a.ani"
#define SUZUNE_ANIM_2				L"suzune_b.ani"
#define SUZUNE_ANIM_3				L"suzune_c.ani"
#define EXT_MODEL					L".mdl"
#define EXT_ANIM					L".ani"
#define EXT_DAE						L".dae"
#define UNDEFINED_FILE_NAME			L"̖ݒ"
#define DEFAULT_SE_PATH_NAME			L"sound"
#define DEFAULT_SE1_FILE_NAME			L"suzumushi.mp3"

#define FILE_TYPE_UNKNOWN			0
#define FILE_TYPE_MODEL				1
#define FILE_TYPE_ANIMATION			2
#define FILE_TYPE_COLLADA			3
#define FILE_TYPE_DIRECTORY			4

#define IMG_PATH			L"img"
#define TEXTURE_CLOUD_NAME			L"cloud.png"
#define TEXTURE_STAR_NAME			L"star.png"
#define TEXTURE_MOON_NAME			L"moon.png"
#define TEXTURE_PARTICLE_NAME	L"momiji.png"
#define DEFAULT_MODEL_NAME_1		L"washitu2.mdl"
#define DEFAULT_MODEL_NAME_2		L"washitu3.mdl"
#define DEFAULT_MODEL_NAME_3		L"washitu4.mdl"

#endif