/////////////////////////////////////////////////
//
//  filename: DispWindow.h
//  author:Chafumi Touji
//  date: 2020/03/09 ver1.00
//
/////////////////////////////////////////////////

#ifndef __DISPWINDOW_H__
#define __DISPWINDOW_H__

class CConfig;

class CDispWindow{
public:

	CCommonDevice				*CommonDevice;
	CChaDataObject				*ChaDataObject1, *ChaDataObject2, *ChaDataObject3, *ChaDataObject4, *SuzuneData;
	CChaResourceObject		*ChaResourceObject1, *ChaResourceObject2, *ChaResourceObject3, *ChaResourceObject4, *SuzuneRes;
	CSky									*Sky;
	CPointLight 						**PointLight;
	CVolumeLight					*VolumeLight;
	C2DEffect							*RousokuEffect, *SuzuneEffect;
	CParticle							*ParticleKaede1, *ParticleKaede2;

	CPCMAudio						*SE1;

	XMFLOAT4						*CurrentPath, *NextPath;
	int									 CurrentPathNum, NextPathNum;
	float									SuzuneEffectMoveX;

	XMFLOAT4				*Path1, *Path2, *Path3, *Path4, *Path5, *Path6, *Path7, *Path8, *Path9, *Path10, *Path11, *Path12, *Path13, *Path14;
	int							Path1Num, Path2Num, Path3Num, Path4Num, Path5Num, Path6Num, Path7Num, Path8Num, Path9Num, Path10Num, Path11Num, Path12Num, Path13Num, Path14Num;

	int							PointLightNum;
	bool							IsAnimated;
	float4						BKColor;
	wchar_t					Path[SIZE_CHAR_MAX];

	HWND			m_hWnd;
	UINT			TimerID;
	float			FramePerSec;
	int				Status;

	int			Width, Height;
	int			DisplayWidth, DisplayHeight;
	int			ScreenWidth, ScreenHeight;
	bool			LButtonDown;
	bool			RButtonDown;
	CPoint		DownPoint;

	float			DisplayResolution;
	float			ShadowMapResolution;
	float			VolumeLightResolution;
	int			FPS;
	bool			DrawShadowMap;

	HANDLE				Thread;
	bool			Rock;
	bool			ReloadRock;
	bool			IsFullScreen;
	bool			BackFullScreen;
	bool			IsTransparent;
	int			TransparentR, TransparentG, TransparentB;

	bool			ToLeft;
	bool			SuzuneAppear;
	float			SuzuneAlpha;

	CDispWindow();
	~CDispWindow();
	bool SetParam(CConfig *config);
	bool CreateWnd(HWND parent_wnd, int x, int y, int w, int h);
	bool InitLoad();
	bool Render();
	bool UpdateShaderLight();
	bool CameraMove();
	bool SetSuzunePos();

public:
	void OnPaint();
	bool UpdateSpawChain();
	void OnKeyDown(UINT nChar);
	void OnLButtonDown(UINT nFlag, CPoint point);
	void OnLButtonUp(UINT nFlag, CPoint point);
	void OnRButtonDown(UINT nFlag, CPoint point);
	void OnRButtonUp(UINT nFlag, CPoint point);
	void OnMouseMove(UINT nFlag, CPoint point);
	void OnMouseWheel(UINT key, int delta, CPoint point);
	void OnSize(UINT nType, int cx, int cy);
	static unsigned __stdcall ThreadInitLoad(LPVOID pParam);

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT DispWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	static void CALLBACK  TimeUpdateCallback(UINT timer_id, UINT msg, LPTIMECALLBACK user, DWORD_PTR data1, DWORD_PTR data2);
};

#endif