/////////////////////////////////////////////////
//
//  filename: DispWindow.cpp
//  author:Chafumi Touji
//  date: 2020/03/09 ver1.00
//
/////////////////////////////////////////////////

#include "StdAfx.h"
#include "Main.h"
#include "cha3d/defcha3dcore.h"
#include "MainWindow.h"
#include "CustomButton.h"
#include "DispWindow.h"
#include "Config.h"

CDispWindow::CDispWindow(){

	LButtonDown = false;
	RButtonDown = false;
	TimerID = 0;
	DownPoint = CPoint(0, 0);
	FramePerSec = 0.0f;
	Status = STATUS_INIT;

	Width = 0;
	Height = 0;
	IsFullScreen = false;
	BackFullScreen = false;
	IsTransparent = false;

	TransparentR = COLOR_TRANSPARENT_R;
	TransparentG = COLOR_TRANSPARENT_G;
	TransparentB = COLOR_TRANSPARENT_B;

	ChaDataObject1 = NULL;
	ChaResourceObject1 = NULL;
	ChaDataObject2 = NULL;
	ChaResourceObject2 = NULL;
	ChaDataObject3 = NULL;
	ChaResourceObject3 = NULL;

	DisplayWidth = ::GetSystemMetrics(SM_CXSCREEN);
	DisplayHeight = ::GetSystemMetrics(SM_CYSCREEN);

	Rock = false;
	ReloadRock = false;

	DisplayResolution = 1.0f;
	VolumeLightResolution = 1.0f;
	ShadowMapResolution = 1.0f;
	DrawShadowMap = true;
	FPS = (int)(1000.0f / 60.0f);

	CommonDevice = NULL;
	PointLight = NULL;
	Sky = NULL;
	VolumeLight = NULL;
	
	Path1Num = 33;
	Path1 = new XMFLOAT4[Path1Num];
	Path1[0] = XMFLOAT4(0, 0, 2, 0);
	Path1[1] = XMFLOAT4(0, -1, 2, 0);
	Path1[2] = XMFLOAT4(0, -2, 2, 0);
	Path1[3] = XMFLOAT4(0, -3, 2, 0);
	Path1[4] = XMFLOAT4(0, -4, 2, 0);
	Path1[5] = XMFLOAT4(0, -5, 2, 0);
	Path1[6] = XMFLOAT4(0, -6, 2, 0);
	Path1[7] = XMFLOAT4(0, -7, 2, 0);
	Path1[8] = XMFLOAT4(0, -8, 2, 0);
	Path1[9] = XMFLOAT4(0, -9, 2, 0);
	Path1[10] = XMFLOAT4(0, -10, 2, 0);
	Path1[11] = XMFLOAT4(0, -11, 2, 0);
	Path1[12] = XMFLOAT4(0, -12, 2, 0);
	Path1[13] = XMFLOAT4(0, -13, 2, 0);
	Path1[14] = XMFLOAT4(1, -13, 2, 0);
	Path1[15] = XMFLOAT4(2, -13, 2, 0);
	Path1[16] = XMFLOAT4(3, -13, 2, 0);
	Path1[17] = XMFLOAT4(4, -13, 2, 0);
	Path1[18] = XMFLOAT4(5, -13, 2, 0);
	Path1[19] = XMFLOAT4(6, -13, 2, 0);
	Path1[20] = XMFLOAT4(6, -12, 2, 0);
	Path1[21] = XMFLOAT4(6, -11, 2, 0);
	Path1[22] = XMFLOAT4(6, -10, 2, 0);
	Path1[23] = XMFLOAT4(6, -9, 2, 0);
	Path1[24] = XMFLOAT4(6, -8, 2, 0);
	Path1[25] = XMFLOAT4(6, -7, 2, 0);
	Path1[26] = XMFLOAT4(6, -6, 2, 0);
	Path1[27] = XMFLOAT4(6, -5, 2, 0);
	Path1[28] = XMFLOAT4(6, -4, 2, 0);
	Path1[29] = XMFLOAT4(6, -3, 2, 0);
	Path1[30] = XMFLOAT4(6, -2, 2, 0);
	Path1[31] = XMFLOAT4(6, -1, 2, 0);
	Path1[32] = XMFLOAT4(6, 0, 2, 0); 

	Path2Num = 25;
	Path2 = new XMFLOAT4[Path2Num];
	Path2[0] = XMFLOAT4(6, 0, 2, 0);
	Path2[1] = XMFLOAT4(6, 1, 2, 0);
	Path2[2] = XMFLOAT4(6, 2, 2, 0);
	Path2[3] = XMFLOAT4(6, 3, 2, 0);
	Path2[4] = XMFLOAT4(6, 4, 2, 0);
	Path2[5] = XMFLOAT4(6, 5, 2, 0);
	Path2[6] = XMFLOAT4(6, 6, 2, 0);
	Path2[7] = XMFLOAT4(6, 7, 2, 0);
	Path2[8] = XMFLOAT4(6, 8, 2, 0);
	Path2[9] = XMFLOAT4(6, 9, 2, 0);
	Path2[10] = XMFLOAT4(6, 10, 2, 0);
	Path2[11] = XMFLOAT4(6, 11, 2, 0);
	Path2[12] = XMFLOAT4(6, 12, 2, 0);
	Path2[13] = XMFLOAT4(6, 13, 2, 0);
	Path2[14] = XMFLOAT4(6, 14, 2, 0);
	Path2[15] = XMFLOAT4(6, 15, 2, 0);
	Path2[16] = XMFLOAT4(6, 16, 2, 0);
	Path2[17] = XMFLOAT4(6, 17, 2, 0);
	Path2[18] = XMFLOAT4(6, 18.25, 2, 0);
	Path2[19] = XMFLOAT4(6, 19.5, 2, 0);
	Path2[20] = XMFLOAT4(5, 19.5, 2, 0);
	Path2[21] = XMFLOAT4(4, 19.5, 2, 0);
	Path2[22] = XMFLOAT4(3, 19.5, 2, 0);
	Path2[23] = XMFLOAT4(2, 19.5, 2, 0);
	Path2[24] = XMFLOAT4(1, 19.5, 2, 0);

	Path3Num = 27;
	Path3 = new XMFLOAT4[Path3Num];
	Path3[0] = XMFLOAT4(1, 19.5, 2, 0);
	Path3[1] = XMFLOAT4(0, 19.5, 2, 0);
	Path3[2] = XMFLOAT4(-1, 19.5, 2, 0);
	Path3[3] = XMFLOAT4(-2, 19.5, 2, 0);
	Path3[4] = XMFLOAT4(-3, 19.5, 2, 0);
	Path3[5] = XMFLOAT4(-4, 19.5, 2, 0);
	Path3[6] = XMFLOAT4(-5, 19.5, 2, 0);
	Path3[7] = XMFLOAT4(-6, 19.5, 2, 0);
	Path3[8] = XMFLOAT4(-6, 18.25, 2, 0);
	Path3[9] = XMFLOAT4(-6, 17, 2, 0);
	Path3[10] = XMFLOAT4(-6, 16, 2, 0);
	Path3[11] = XMFLOAT4(-6, 15, 2, 0);
	Path3[12] = XMFLOAT4(-6, 14, 2, 0);
	Path3[13] = XMFLOAT4(-6, 13, 2, 0);
	Path3[14] = XMFLOAT4(-6, 12, 2, 0);
	Path3[15] = XMFLOAT4(-6, 11, 2, 0);
	Path3[16] = XMFLOAT4(-6, 10, 2, 0);
	Path3[17] = XMFLOAT4(-6, 9, 2, 0);
	Path3[18] = XMFLOAT4(-6, 8, 2, 0);
	Path3[19] = XMFLOAT4(-6, 7, 2, 0);
	Path3[20] = XMFLOAT4(-6, 6, 2, 0);
	Path3[21] = XMFLOAT4(-6, 5, 2, 0);
	Path3[22] = XMFLOAT4(-6, 4, 2, 0);
	Path3[23] = XMFLOAT4(-6, 3, 2, 0);
	Path3[24] = XMFLOAT4(-6, 2, 2, 0);
	Path3[25] = XMFLOAT4(-6, 1, 2, 0);
	Path3[26] = XMFLOAT4(-6, 0, 2, 0);

	Path4Num = 39;
	Path4 = new XMFLOAT4[Path4Num];
	Path4[0] = XMFLOAT4(-6, 0, 2, 0);
	Path4[1] = XMFLOAT4(-6, -1, 2, 0);
	Path4[2] = XMFLOAT4(-6, -2, 2, 0);
	Path4[3] = XMFLOAT4(-6, -3, 2, 0);
	Path4[4] = XMFLOAT4(-6, -4, 2, 0);
	Path4[5] = XMFLOAT4(-6, -5, 2, 0);
	Path4[6] = XMFLOAT4(-6, -6, 2, 0);
	Path4[7] = XMFLOAT4(-6, -7, 2, 0);
	Path4[8] = XMFLOAT4(-6, -8, 2, 0);
	Path4[9] = XMFLOAT4(-6, -9, 2, 0);
	Path4[10] = XMFLOAT4(-6, -10, 2, 0);
	Path4[11] = XMFLOAT4(-6, -11, 2, 0);
	Path4[12] = XMFLOAT4(-6, -12, 2, 0);
	Path4[13] = XMFLOAT4(-6, -13, 2, 0);
	Path4[14] = XMFLOAT4(-5, -13, 2, 0);
	Path4[15] = XMFLOAT4(-4, -13, 2, 0);
	Path4[16] = XMFLOAT4(-3, -13, 2, 0);
	Path4[17] = XMFLOAT4(-2, -13, 2, 0);
	Path4[18] = XMFLOAT4(-1, -13, 2, 0);
	Path4[19] = XMFLOAT4(0, -13, 2, 0);
	Path4[20] = XMFLOAT4(1, -13, 2, 0);
	Path4[21] = XMFLOAT4(2, -13, 2, 0);
	Path4[22] = XMFLOAT4(3, -13, 2, 0);
	Path4[23] = XMFLOAT4(4, -13, 2, 0);
	Path4[24] = XMFLOAT4(5, -13, 2, 0);
	Path4[25] = XMFLOAT4(6, -13, 2, 0);
	Path4[26] = XMFLOAT4(6, -12, 2, 0);
	Path4[27] = XMFLOAT4(6, -11, 2, 0);
	Path4[28] = XMFLOAT4(6, -10, 2, 0);
	Path4[29] = XMFLOAT4(6, -9, 2, 0);
	Path4[30] = XMFLOAT4(6, -8, 2, 0);
	Path4[31] = XMFLOAT4(6, -7, 2, 0);
	Path4[32] = XMFLOAT4(6, -6, 2, 0);
	Path4[33] = XMFLOAT4(6, -5, 2, 0);
	Path4[34] = XMFLOAT4(6, -4, 2, 0);
	Path4[35] = XMFLOAT4(6, -3, 2, 0);
	Path4[36] = XMFLOAT4(6, -2, 2, 0);
	Path4[37] = XMFLOAT4(6, -1, 2, 0);
	Path4[38] = XMFLOAT4(6, 0, 2, 0);

	Path5Num = 25;
	Path5 = new XMFLOAT4[Path5Num];
	Path5[0] = XMFLOAT4(6, 0, 2, 0);
	Path5[1] = XMFLOAT4(6, 1, 2, 0);
	Path5[2] = XMFLOAT4(6, 2, 2, 0);
	Path5[3] = XMFLOAT4(6, 3, 2, 0);
	Path5[4] = XMFLOAT4(6, 4, 2, 0);
	Path5[5] = XMFLOAT4(6, 5, 2, 0);
	Path5[6] = XMFLOAT4(6, 6, 2, 0);
	Path5[7] = XMFLOAT4(6, 7, 2, 0);
	Path5[8] = XMFLOAT4(6, 8, 2, 0);
	Path5[9] = XMFLOAT4(6, 9, 2, 0);
	Path5[10] = XMFLOAT4(5, 9, 2, 0);
	Path5[11] = XMFLOAT4(4, 9, 2, 0);
	Path5[12] = XMFLOAT4(3, 9, 2, 0);
	Path5[13] = XMFLOAT4(2, 9, 2, 0);
	Path5[14] = XMFLOAT4(1, 9, 2, 0);
	Path5[15] = XMFLOAT4(0, 9, 2, 0);
	Path5[16] = XMFLOAT4(0, 8, 2, 0);
	Path5[17] = XMFLOAT4(0, 7, 2, 0);
	Path5[18] = XMFLOAT4(0, 6, 2, 0);
	Path5[19] = XMFLOAT4(0, 5, 2, 0);
	Path5[20] = XMFLOAT4(0, 4, 2, 0);
	Path5[21] = XMFLOAT4(0, 3, 2, 0);
	Path5[22] = XMFLOAT4(0, 2, 2, 0);
	Path5[23] = XMFLOAT4(0, 1, 2, 0);
	Path5[24] = XMFLOAT4(0, 0, 2, 0);

	Path6Num = 33;
	Path6 = new XMFLOAT4[Path6Num];
	Path6[0] = XMFLOAT4(0, 0, 2, 0);
	Path6[1] = XMFLOAT4(0, -1, 2, 0);
	Path6[2] = XMFLOAT4(0, -2, 2, 0);
	Path6[3] = XMFLOAT4(0, -3, 2, 0);
	Path6[4] = XMFLOAT4(0, -4, 2, 0);
	Path6[5] = XMFLOAT4(0, -5, 2, 0);
	Path6[6] = XMFLOAT4(0, -6, 2, 0);
	Path6[7] = XMFLOAT4(0, -7, 2, 0);
	Path6[8] = XMFLOAT4(0, -8, 2, 0);
	Path6[9] = XMFLOAT4(0, -9, 2, 0);
	Path6[10] = XMFLOAT4(0, -10, 2, 0);
	Path6[11] = XMFLOAT4(0, -11, 2, 0);
	Path6[12] = XMFLOAT4(0, -12, 2, 0);
	Path6[13] = XMFLOAT4(0, -13, 2, 0);
	Path6[14] = XMFLOAT4(-1, -13, 2, 0);
	Path6[15] = XMFLOAT4(-2, -13, 2, 0);
	Path6[16] = XMFLOAT4(-3, -13, 2, 0);
	Path6[17] = XMFLOAT4(-4, -13, 2, 0);
	Path6[18] = XMFLOAT4(-5, -13, 2, 0);
	Path6[19] = XMFLOAT4(-6, -13, 2, 0);
	Path6[20] = XMFLOAT4(-6, -12, 2, 0);
	Path6[21] = XMFLOAT4(-6, -11, 2, 0);
	Path6[22] = XMFLOAT4(-6, -10, 2, 0);
	Path6[23] = XMFLOAT4(-6, -9, 2, 0);
	Path6[24] = XMFLOAT4(-6, -8, 2, 0);
	Path6[25] = XMFLOAT4(-6, -7, 2, 0);
	Path6[26] = XMFLOAT4(-6, -6, 2, 0);
	Path6[27] = XMFLOAT4(-6, -5, 2, 0);
	Path6[28] = XMFLOAT4(-6, -4, 2, 0);
	Path6[29] = XMFLOAT4(-6, -3, 2, 0);
	Path6[30] = XMFLOAT4(-6, -2, 2, 0);
	Path6[31] = XMFLOAT4(-6, -1, 2, 0);
	Path6[32] = XMFLOAT4(-6, 0, 2, 0);

	Path7Num = 27;
	Path7 = new XMFLOAT4[Path7Num];
	Path7[0] = XMFLOAT4(-6, 0, 2, 0);
	Path7[1] = XMFLOAT4(-6, 1, 2, 0);
	Path7[2] = XMFLOAT4(-6, 2, 2, 0);
	Path7[3] = XMFLOAT4(-6, 3, 2, 0);
	Path7[4] = XMFLOAT4(-6, 4, 2, 0);
	Path7[5] = XMFLOAT4(-6, 5, 2, 0);
	Path7[6] = XMFLOAT4(-6, 6, 2, 0);
	Path7[7] = XMFLOAT4(-6, 7, 2, 0);
	Path7[8] = XMFLOAT4(-6, 8, 2, 0);
	Path7[9] = XMFLOAT4(-6, 9, 2, 0);
	Path7[10] = XMFLOAT4(-6, 10, 2, 0);
	Path7[11] = XMFLOAT4(-6, 11, 2, 0);
	Path7[12] = XMFLOAT4(-6, 12, 2, 0);
	Path7[13] = XMFLOAT4(-6, 13, 2, 0);
	Path7[14] = XMFLOAT4(-6, 14, 2, 0);
	Path7[15] = XMFLOAT4(-6, 15, 2, 0);
	Path7[16] = XMFLOAT4(-6, 16, 2, 0);
	Path7[17] = XMFLOAT4(-6, 17, 2, 0);
	Path7[18] = XMFLOAT4(-6, 18.25, 2, 0);
	Path7[19] = XMFLOAT4(-6, 19.5, 2, 0);
	Path7[20] = XMFLOAT4(-5, 19.5, 2, 0);
	Path7[21] = XMFLOAT4(-4, 19.5, 2, 0);
	Path7[22] = XMFLOAT4(-3, 19.5, 2, 0);
	Path7[23] = XMFLOAT4(-2, 19.5, 2, 0);
	Path7[24] = XMFLOAT4(-1, 19.5, 2, 0);
	Path7[25] = XMFLOAT4(0, 19.5, 2, 0);
	Path7[26] = XMFLOAT4(1, 19.5, 2, 0);

	Path8Num = 31;
	Path8 = new XMFLOAT4[Path8Num];
	Path8[0] = XMFLOAT4(1, 19.5, 2, 0);
	Path8[1] = XMFLOAT4(2, 19.5, 2, 0);
	Path8[2] = XMFLOAT4(3, 19.5, 2, 0);
	Path8[3] = XMFLOAT4(4, 19.5, 2, 0);
	Path8[4] = XMFLOAT4(5, 19.5, 2, 0);
	Path8[5] = XMFLOAT4(6, 19.5, 2, 0);
	Path8[6] = XMFLOAT4(6, 18.25, 2, 0);
	Path8[7] = XMFLOAT4(6, 17, 2, 0);
	Path8[8] = XMFLOAT4(6, 16, 2, 0);
	Path8[9] = XMFLOAT4(6, 15, 2, 0);
	Path8[10] = XMFLOAT4(6, 14, 2, 0);
	Path8[11] = XMFLOAT4(6, 13, 2, 0);
	Path8[12] = XMFLOAT4(6, 12, 2, 0);
	Path8[13] = XMFLOAT4(6, 11, 2, 0);
	Path8[14] = XMFLOAT4(6, 10, 2, 0);
	Path8[15] = XMFLOAT4(6, 9, 2, 0);
	Path8[16] = XMFLOAT4(5, 9, 2, 0);
	Path8[17] = XMFLOAT4(4, 9, 2, 0);
	Path8[18] = XMFLOAT4(3, 9, 2, 0);
	Path8[19] = XMFLOAT4(2, 9, 2, 0);
	Path8[20] = XMFLOAT4(1, 9, 2, 0);
	Path8[21] = XMFLOAT4(0, 9, 2, 0);
	Path8[22] = XMFLOAT4(0, 8, 2, 0);
	Path8[23] = XMFLOAT4(0, 7, 2, 0);
	Path8[24] = XMFLOAT4(0, 6, 2, 0);
	Path8[25] = XMFLOAT4(0, 5, 2, 0);
	Path8[26] = XMFLOAT4(0, 4, 2, 0);
	Path8[27] = XMFLOAT4(0, 3, 2, 0);
	Path8[28] = XMFLOAT4(0, 2, 2, 0);
	Path8[29] = XMFLOAT4(0, 1, 2, 0);
	Path8[30] = XMFLOAT4(0, 0, 2, 0);

	Path9Num = 25;
	Path9 = new XMFLOAT4[Path9Num];
	Path9[0] = XMFLOAT4(1, 19.5, 2, 0);
	Path9[1] = XMFLOAT4(2, 19.5, 2, 0);
	Path9[2] = XMFLOAT4(3, 19.5, 2, 0);
	Path9[3] = XMFLOAT4(4, 19.5, 2, 0);
	Path9[4] = XMFLOAT4(5, 19.5, 2, 0);
	Path9[5] = XMFLOAT4(6, 19.5, 2, 0);
	Path9[6] = XMFLOAT4(6, 18.25, 2, 0);
	Path9[7] = XMFLOAT4(6, 17, 2, 0);
	Path9[8] = XMFLOAT4(6, 16, 2, 0);
	Path9[9] = XMFLOAT4(6, 15, 2, 0);
	Path9[10] = XMFLOAT4(6, 14, 2, 0);
	Path9[11] = XMFLOAT4(6, 13, 2, 0);
	Path9[12] = XMFLOAT4(6, 12, 2, 0);
	Path9[13] = XMFLOAT4(6, 11, 2, 0);
	Path9[14] = XMFLOAT4(6, 10, 2, 0);
	Path9[15] = XMFLOAT4(6, 9, 2, 0);
	Path9[16] = XMFLOAT4(6, 8, 2, 0);
	Path9[17] = XMFLOAT4(6, 7, 2, 0);
	Path9[18] = XMFLOAT4(6, 6, 2, 0);
	Path9[19] = XMFLOAT4(6, 5, 2, 0);
	Path9[20] = XMFLOAT4(6, 4, 2, 0);
	Path9[21] = XMFLOAT4(6, 3, 2, 0);
	Path9[22] = XMFLOAT4(6, 2, 2, 0);
	Path9[23] = XMFLOAT4(6, 1, 2, 0);
	Path9[24] = XMFLOAT4(6, 0, 2, 0);

	Path10Num = 33;
	Path10 = new XMFLOAT4[Path10Num];
	Path10[0] = XMFLOAT4(6, 0, 2, 0);
	Path10[1] = XMFLOAT4(6, -1, 2, 0);
	Path10[2] = XMFLOAT4(6, -2, 2, 0);
	Path10[3] = XMFLOAT4(6, -3, 2, 0);
	Path10[4] = XMFLOAT4(6, -4, 2, 0);
	Path10[5] = XMFLOAT4(6, -5, 2, 0);
	Path10[6] = XMFLOAT4(6, -6, 2, 0);
	Path10[7] = XMFLOAT4(6, -7, 2, 0);
	Path10[8] = XMFLOAT4(6, -8, 2, 0);
	Path10[9] = XMFLOAT4(6, -9, 2, 0);
	Path10[10] = XMFLOAT4(6, -10, 2, 0);
	Path10[11] = XMFLOAT4(6, -11, 2, 0);
	Path10[12] = XMFLOAT4(6, -12, 2, 0);
	Path10[13] = XMFLOAT4(6, -13, 2, 0);
	Path10[14] = XMFLOAT4(5, -13, 2, 0);
	Path10[15] = XMFLOAT4(4, -13, 2, 0);
	Path10[16] = XMFLOAT4(3, -13, 2, 0);
	Path10[17] = XMFLOAT4(2, -13, 2, 0);
	Path10[18] = XMFLOAT4(1, -13, 2, 0);
	Path10[19] = XMFLOAT4(0, -13, 2, 0);
	Path10[20] = XMFLOAT4(0, -12, 2, 0);
	Path10[21] = XMFLOAT4(0, -11, 2, 0);
	Path10[22] = XMFLOAT4(0, -10, 2, 0);
	Path10[23] = XMFLOAT4(0, -9, 2, 0);
	Path10[24] = XMFLOAT4(0, -8, 2, 0);
	Path10[25] = XMFLOAT4(0, -7, 2, 0);
	Path10[26] = XMFLOAT4(0, -6, 2, 0);
	Path10[27] = XMFLOAT4(0, -5, 2, 0);
	Path10[28] = XMFLOAT4(0, -4, 2, 0);
	Path10[29] = XMFLOAT4(0, -3, 2, 0);
	Path10[30] = XMFLOAT4(0, -2, 2, 0);
	Path10[31] = XMFLOAT4(0, -1, 2, 0);
	Path10[32] = XMFLOAT4(0, 0, 2, 0);

	Path11Num = 39;
	Path11 = new XMFLOAT4[Path11Num];
	Path11[0] = XMFLOAT4(6, 0, 2, 0);
	Path11[1] = XMFLOAT4(6, -1, 2, 0);
	Path11[2] = XMFLOAT4(6, -2, 2, 0);
	Path11[3] = XMFLOAT4(6, -3, 2, 0);
	Path11[4] = XMFLOAT4(6, -4, 2, 0);
	Path11[5] = XMFLOAT4(6, -5, 2, 0);
	Path11[6] = XMFLOAT4(6, -6, 2, 0);
	Path11[7] = XMFLOAT4(6, -7, 2, 0);
	Path11[8] = XMFLOAT4(6, -8, 2, 0);
	Path11[9] = XMFLOAT4(6, -9, 2, 0);
	Path11[10] = XMFLOAT4(6, -10, 2, 0);
	Path11[11] = XMFLOAT4(6, -11, 2, 0);
	Path11[12] = XMFLOAT4(6, -12, 2, 0);
	Path11[13] = XMFLOAT4(6, -13, 2, 0);
	Path11[14] = XMFLOAT4(5, -13, 2, 0);
	Path11[15] = XMFLOAT4(4, -13, 2, 0);
	Path11[16] = XMFLOAT4(3, -13, 2, 0);
	Path11[17] = XMFLOAT4(2, -13, 2, 0);
	Path11[18] = XMFLOAT4(1, -13, 2, 0);
	Path11[19] = XMFLOAT4(0, -13, 2, 0);
	Path11[20] = XMFLOAT4(-1, -13, 2, 0);
	Path11[21] = XMFLOAT4(-2, -13, 2, 0);
	Path11[22] = XMFLOAT4(-3, -13, 2, 0);
	Path11[23] = XMFLOAT4(-4, -13, 2, 0);
	Path11[24] = XMFLOAT4(-5, -13, 2, 0);
	Path11[25] = XMFLOAT4(-6, -13, 2, 0);
	Path11[26] = XMFLOAT4(-6, -12, 2, 0);
	Path11[27] = XMFLOAT4(-6, -11, 2, 0);
	Path11[28] = XMFLOAT4(-6, -10, 2, 0);
	Path11[29] = XMFLOAT4(-6, -9, 2, 0);
	Path11[30] = XMFLOAT4(-6, -8, 2, 0);
	Path11[31] = XMFLOAT4(-6, -7, 2, 0);
	Path11[32] = XMFLOAT4(-6, -6, 2, 0);
	Path11[33] = XMFLOAT4(-6, -5, 2, 0);
	Path11[34] = XMFLOAT4(-6, -4, 2, 0);
	Path11[35] = XMFLOAT4(-6, -3, 2, 0);
	Path11[36] = XMFLOAT4(-6, -2, 2, 0);
	Path11[37] = XMFLOAT4(-6, -1, 2, 0);
	Path11[38] = XMFLOAT4(-6, 0, 2, 0);

	Path12Num = 31;
	Path12 = new XMFLOAT4[Path12Num];
	Path12[0] = XMFLOAT4(0, 0, 2, 0);
	Path12[1] = XMFLOAT4(0, 1, 2, 0);
	Path12[2] = XMFLOAT4(0, 2, 2, 0);
	Path12[3] = XMFLOAT4(0, 3, 2, 0);
	Path12[4] = XMFLOAT4(0, 4, 2, 0);
	Path12[5] = XMFLOAT4(0, 5, 2, 0);
	Path12[6] = XMFLOAT4(0, 6, 2, 0);
	Path12[7] = XMFLOAT4(0, 7, 2, 0);
	Path12[8] = XMFLOAT4(0, 8, 2, 0);
	Path12[9] = XMFLOAT4(0, 9, 2, 0);
	Path12[10] = XMFLOAT4(1, 9, 2, 0);
	Path12[11] = XMFLOAT4(2, 9, 2, 0);
	Path12[12] = XMFLOAT4(3, 9, 2, 0);
	Path12[13] = XMFLOAT4(4, 9, 2, 0);
	Path12[14] = XMFLOAT4(5, 9, 2, 0);
	Path12[15] = XMFLOAT4(6, 9, 2, 0);
	Path12[16] = XMFLOAT4(6, 10, 2, 0);
	Path12[17] = XMFLOAT4(6, 11, 2, 0);
	Path12[18] = XMFLOAT4(6, 12, 2, 0);
	Path12[19] = XMFLOAT4(6, 13, 2, 0);
	Path12[20] = XMFLOAT4(6, 14, 2, 0);
	Path12[21] = XMFLOAT4(6, 15, 2, 0);
	Path12[22] = XMFLOAT4(6, 16, 2, 0);
	Path12[23] = XMFLOAT4(6, 17, 2, 0);
	Path12[24] = XMFLOAT4(6, 18.25, 2, 0);
	Path12[25] = XMFLOAT4(6, 19.5, 2, 0);
	Path12[26] = XMFLOAT4(5, 19.5, 2, 0);
	Path12[27] = XMFLOAT4(4, 19.5, 2, 0);
	Path12[28] = XMFLOAT4(3, 19.5, 2, 0);
	Path12[29] = XMFLOAT4(2, 19.5, 2, 0);
	Path12[30] = XMFLOAT4(1, 19.5, 2, 0);

	Path13Num = 25;
	Path13 = new XMFLOAT4[Path13Num];
	Path13[0] = XMFLOAT4(0, 0, 2, 0);
	Path13[1] = XMFLOAT4(0, 1, 2, 0);
	Path13[2] = XMFLOAT4(0, 2, 2, 0);
	Path13[3] = XMFLOAT4(0, 3, 2, 0);
	Path13[4] = XMFLOAT4(0, 4, 2, 0);
	Path13[5] = XMFLOAT4(0, 5, 2, 0);
	Path13[6] = XMFLOAT4(0, 6, 2, 0);
	Path13[7] = XMFLOAT4(0, 7, 2, 0);
	Path13[8] = XMFLOAT4(0, 8, 2, 0);
	Path13[9] = XMFLOAT4(0, 9, 2, 0);
	Path13[10] = XMFLOAT4(1, 9, 2, 0);
	Path13[11] = XMFLOAT4(2, 9, 2, 0);
	Path13[12] = XMFLOAT4(3, 9, 2, 0);
	Path13[13] = XMFLOAT4(4, 9, 2, 0);
	Path13[14] = XMFLOAT4(5, 9, 2, 0);
	Path13[15] = XMFLOAT4(6, 9, 2, 0);
	Path13[16] = XMFLOAT4(6, 8, 2, 0);
	Path13[17] = XMFLOAT4(6, 7, 2, 0);
	Path13[18] = XMFLOAT4(6, 6, 2, 0);
	Path13[19] = XMFLOAT4(6, 5, 2, 0);
	Path13[20] = XMFLOAT4(6, 4, 2, 0);
	Path13[21] = XMFLOAT4(6, 3, 2, 0);
	Path13[22] = XMFLOAT4(6, 2, 2, 0);
	Path13[23] = XMFLOAT4(6, 1, 2, 0);
	Path13[24] = XMFLOAT4(6, 0, 2, 0);

	Path14Num = 33;
	Path14 = new XMFLOAT4[Path14Num];
	Path14[0] = XMFLOAT4(-6, 0, 2, 0);
	Path14[1] = XMFLOAT4(-6, -1, 2, 0);
	Path14[2] = XMFLOAT4(-6, -2, 2, 0);
	Path14[3] = XMFLOAT4(-6, -3, 2, 0);
	Path14[4] = XMFLOAT4(-6, -4, 2, 0);
	Path14[5] = XMFLOAT4(-6, -5, 2, 0);
	Path14[6] = XMFLOAT4(-6, -6, 2, 0);
	Path14[7] = XMFLOAT4(-6, -7, 2, 0);
	Path14[8] = XMFLOAT4(-6, -8, 2, 0);
	Path14[9] = XMFLOAT4(-6, -9, 2, 0);
	Path14[10] = XMFLOAT4(-6, -10, 2, 0);
	Path14[11] = XMFLOAT4(-6, -11, 2, 0);
	Path14[12] = XMFLOAT4(-6, -12, 2, 0);
	Path14[13] = XMFLOAT4(-6, -13, 2, 0);
	Path14[14] = XMFLOAT4(-5, -13, 2, 0);
	Path14[15] = XMFLOAT4(-4, -13, 2, 0);
	Path14[16] = XMFLOAT4(-3, -13, 2, 0);
	Path14[17] = XMFLOAT4(-2, -13, 2, 0);
	Path14[18] = XMFLOAT4(-1, -13, 2, 0);
	Path14[19] = XMFLOAT4(0, -13, 2, 0);
	Path14[20] = XMFLOAT4(0, -12, 2, 0);
	Path14[21] = XMFLOAT4(0, -11, 2, 0);
	Path14[22] = XMFLOAT4(0, -10, 2, 0);
	Path14[23] = XMFLOAT4(0, -9, 2, 0);
	Path14[24] = XMFLOAT4(0, -8, 2, 0);
	Path14[25] = XMFLOAT4(0, -7, 2, 0);
	Path14[26] = XMFLOAT4(0, -6, 2, 0);
	Path14[27] = XMFLOAT4(0, -5, 2, 0);
	Path14[28] = XMFLOAT4(0, -4, 2, 0);
	Path14[29] = XMFLOAT4(0, -3, 2, 0);
	Path14[30] = XMFLOAT4(0, -2, 2, 0);
	Path14[31] = XMFLOAT4(0, -1, 2, 0);
	Path14[32] = XMFLOAT4(0, 0, 2, 0);

	SuzuneEffectMoveX = 0.0f;
	srand((unsigned int)time(NULL));

	SE1 = NULL;

	::CoInitialize(NULL);
}

CDispWindow::~CDispWindow(){

	timeKillEvent(TimerID);

	if (SE1 != NULL){
		SE1->Close(1);
		delete SE1;
	}
}

/////////////////////////////////////////////////////////////////////////////

bool CDispWindow::SetParam(CConfig *config){

	wcscpy_s(Path, SIZE_CHAR_MAX, config->Path);
	BKColor.x = (float)config->ViewerBKColorR / 255.0f;
	BKColor.y = (float)config->ViewerBKColorG / 255.0f;
	BKColor.z = (float)config->ViewerBKColorB / 255.0f;
	BKColor.w = (float)config->ViewerBKColorA / 255.0f;
	CommonDevice->RotationX = config->RotationX;
	CommonDevice->RotationZ = config->RotationZ;
	CommonDevice->Eye.x = config->EyePosX;
	CommonDevice->Eye.y = config->EyePosY;
	CommonDevice->Eye.z = config->EyePosZ;
	CommonDevice->At.x = config->AtX;
	CommonDevice->At.y = config->AtY;
	CommonDevice->At.z = config->AtZ;
	ScreenWidth = config->ScreenWidth;
	ScreenHeight = config->ScreenHeight;
	DisplayResolution = config->DisplayResolution;
	VolumeLightResolution = config->VolumeLightResolution;
	ShadowMapResolution = config->ShadowMapResolution;
	DrawShadowMap = config->DrawShadowMap;
	FPS = (int) ( 1000.0f / (float) config->FrameRate );

	return true;
}

bool CDispWindow::CreateWnd(HWND ParentWnd, int x, int y, int w, int h){

	WNDCLASSEX wcx;
	memset(&wcx, 0, sizeof(WNDCLASSEX));
	wcx.style = CS_HREDRAW | CS_VREDRAW;
	wcx.cbSize = sizeof(WNDCLASSEX);
	wcx.hInstance = NULL;
	wcx.hIcon = NULL;
	wcx.lpszMenuName = NULL;
	wcx.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcx.lpfnWndProc = &CDispWindow::WindowProc;
	wcx.lpszClassName = L"CLASS_DISPWINDOW";
	RegisterClassEx(&wcx);

	Width = w;
	Height = h;
	m_hWnd = CreateWindowEx(WS_EX_LEFT, L"CLASS_DISPWINDOW", _T("ModelViewer"), WS_CHILD, x, y, w, h, ParentWnd, NULL, NULL, NULL);
	::SetWindowLongPtr(m_hWnd, GWLP_USERDATA, (UINT_PTR) this);

	wchar_t path[SIZE_CHAR_MAX];
	wmemset(path, 0, SIZE_CHAR_MAX);
	wcscpy_s(path, SIZE_CHAR_MAX, theApp->MainWindow->Config->SEPath);
	wcscat_s(path, SIZE_CHAR_MAX, L"\\");
	wcscat_s(path, SIZE_CHAR_MAX, theApp->MainWindow->Config->SE1FileName);
	SE1 = new CPCMAudio();
	SE1->Init(NULL, 0);
	SE1->Open(path, 1);

	::ShowWindow(m_hWnd, SW_SHOW);
	if (TimerID == 0)
		TimerID = ::timeSetEvent(FPS, 100, (LPTIMECALLBACK)TimeUpdateCallback, (DWORD_PTR) this, TIME_PERIODIC);

	return true;
}

UINT  CDispWindow::ThreadInitLoad(LPVOID pParam){

	CDispWindow *disp_wnd = (CDispWindow *)pParam;

	//////////////////////////////////////////////////

	float resolution = theApp->MainWindow->Config->DisplayResolution;
	float width = theApp->MainWindow->Config->ScreenWidth;
	float height = theApp->MainWindow->Config->ScreenHeight;

	disp_wnd->CommonDevice = new CCommonDevice();
	disp_wnd->CommonDevice->CreateDevice(disp_wnd->m_hWnd, width * resolution, height * resolution );

	disp_wnd->SetParam(theApp->MainWindow->Config);

	//////////////////////////////////////////////////////////
	//GtFNg쐬

	disp_wnd->RousokuEffect = new C2DEffect();
	disp_wnd->RousokuEffect->CreateResource(disp_wnd->CommonDevice, 0.6f);
	disp_wnd->RousokuEffect->EffectPosNum = 6;
	disp_wnd->RousokuEffect->EffectPos = new XMFLOAT4[disp_wnd->RousokuEffect->EffectPosNum];
	disp_wnd->RousokuEffect->EffectPos[0] = XMFLOAT4(6.55, -13.6, 2.1, 0);
	disp_wnd->RousokuEffect->EffectPos[1] = XMFLOAT4(6.55, 5.1, 2.1, 0);
	disp_wnd->RousokuEffect->EffectPos[2] = XMFLOAT4(6.55, 20.3, 2.1, 0);
	disp_wnd->RousokuEffect->EffectPos[3] = XMFLOAT4(-6.7, 20.25, 2.1, 0);
	disp_wnd->RousokuEffect->EffectPos[4] = XMFLOAT4(-6.7, 2.2, 2.1, 0);
	disp_wnd->RousokuEffect->EffectPos[5] = XMFLOAT4(-6.7, -13.6, 2.1, 0);
	disp_wnd->RousokuEffect->EffectColor = XMFLOAT4(1.0f, 0.4f, 0.2f, 1.0f);

	disp_wnd->SuzuneEffect = new C2DEffect();
	disp_wnd->SuzuneEffect->CreateResource(disp_wnd->CommonDevice, 5.0f);
	disp_wnd->SuzuneEffect->CreateEffectParam();
	disp_wnd->SuzuneEffect->EffectPosNum = 1;
	disp_wnd->SuzuneEffect->EffectPos = new XMFLOAT4[disp_wnd->SuzuneEffect->EffectPosNum];

	//////////////////////////////////////////////////////////
	//p[eBN쐬

	wchar_t *img_path = theApp->MainWindow->Config->ImgPath;
	wchar_t *texture_particle_name = theApp->MainWindow->Config->TextureParticleName;

	disp_wnd->ParticleKaede1 = new CParticle();
	disp_wnd->ParticleKaede1->CreateResource(disp_wnd->CommonDevice, img_path, texture_particle_name, XMFLOAT4(0, -40, 15, 0), XMFLOAT4(25, 25, 5, 0), 300, 300, 0.3f);
	disp_wnd->ParticleKaede2 = new CParticle();
	disp_wnd->ParticleKaede2->CreateResource(disp_wnd->CommonDevice, img_path, texture_particle_name, XMFLOAT4(20, 10, 15, 0), XMFLOAT4(10, 40, 5, 0), 100, 300, 0.3f);

	//////////////////////////////////////////////////////////
	//|CgCg쐬

	disp_wnd->PointLightNum = 3;
	disp_wnd->PointLight = (CPointLight **) new CPointLight*[3];
	for (int i = 0; i <= disp_wnd->PointLightNum - 1; i++)
		disp_wnd->PointLight[i] = new CPointLight();

	disp_wnd->PointLight[0]->CreatePointLight(disp_wnd->CommonDevice, -3, -10.8, 0.5, 0.5f, disp_wnd->ShadowMapResolution, (int) 800 * disp_wnd->DisplayResolution );
	disp_wnd->PointLight[1]->CreatePointLight(disp_wnd->CommonDevice, -3, -2.8, 0.5, 0.5f, disp_wnd->ShadowMapResolution, (int)800 * disp_wnd->DisplayResolution);
	disp_wnd->PointLight[2]->CreatePointLight(disp_wnd->CommonDevice, 3.2, 5.2, 0.5, 0.5f, disp_wnd->ShadowMapResolution, (int)800 * disp_wnd->DisplayResolution);
	disp_wnd->PointLight[0]->SetShadowFar(3.0f);
	disp_wnd->PointLight[0]->SetShadowPower(1.5f);
	disp_wnd->PointLight[1]->SetShadowFar(3.0f);
	disp_wnd->PointLight[1]->SetShadowPower(1.5f);
	disp_wnd->PointLight[2]->SetShadowFar(3.0f);
	disp_wnd->PointLight[2]->SetShadowPower(1.5f);
	disp_wnd->PointLight[0]->SetLightColor(1.0f, 0.8f, 0.7f);
	disp_wnd->PointLight[1]->SetLightColor(1.0f, 0.8f, 0.7f);
	disp_wnd->PointLight[2]->SetLightColor(1.0f, 0.8f, 0.7f);

	//////////////////////////////////////////////////////////////
	//VF[_[Cgݒ

	disp_wnd->CommonDevice->ShaderLight[0] = XMFLOAT4(1.0, 0.8, 0.6, 1.0f); //sP
	disp_wnd->CommonDevice->ShaderLightPos[0] = XMFLOAT4(-3.5, -10.8, 1.0, 0);
	disp_wnd->CommonDevice->ShaderLight[1] = XMFLOAT4(1.0, 0.8, 0.6, 1.0f); //sQ
	disp_wnd->CommonDevice->ShaderLightPos[1] = XMFLOAT4(-3.5, -2.8, 1.0, 0);
	disp_wnd->CommonDevice->ShaderLight[2] = XMFLOAT4(1.0, 0.8, 0.6, 2.0f); //sR
	disp_wnd->CommonDevice->ShaderLightPos[2] = XMFLOAT4(3.2, 5.8, 1.0, 0);
	disp_wnd->CommonDevice->ShaderLight[3] = XMFLOAT4(1.0, 0.8, 0.6, 1.0f); //XCP
	disp_wnd->CommonDevice->ShaderLightPos[3] = XMFLOAT4(-7.0, 20.0, 1.5, 0);
	disp_wnd->CommonDevice->ShaderLight[4] = XMFLOAT4(1.0, 0.8, 0.6, 1.0f); //XCQ
	disp_wnd->CommonDevice->ShaderLightPos[4] = XMFLOAT4(-7.0, 3.0, 1.5, 0);
	disp_wnd->CommonDevice->ShaderLight[5] = XMFLOAT4(1.0, 0.8, 0.6, 1.0f); //XCR
	disp_wnd->CommonDevice->ShaderLightPos[5] = XMFLOAT4(7.0, 20.0, 2.5, 0);
	disp_wnd->CommonDevice->ShaderLight[6] = XMFLOAT4(1.0, 0.8, 0.6, 1.0f); //XCS
	disp_wnd->CommonDevice->ShaderLightPos[6] = XMFLOAT4(7.0, 5.0, 2.5, 0);
	disp_wnd->CommonDevice->ShaderLight[7] = XMFLOAT4(1.0, 0.8, 0.6, 1.0f); //XCT
	disp_wnd->CommonDevice->ShaderLightPos[7] = XMFLOAT4(7.0, -14.0, 2.5, 0);
	disp_wnd->CommonDevice->ShaderLight[8] = XMFLOAT4(1.0, 0.8, 0.6, 1.0f); //XCU
	disp_wnd->CommonDevice->ShaderLightPos[8] = XMFLOAT4(-7.0, -14.0, 2.5, 0);
	disp_wnd->CommonDevice->ShaderLight[9] = XMFLOAT4(1.0, 0.8, 0.7, 50.0f); //ƖP
	disp_wnd->CommonDevice->ShaderLightPos[9] = XMFLOAT4(26.0, 19.0, 2.0, 0);
	disp_wnd->CommonDevice->ShaderLight[10] = XMFLOAT4(1.0, 0.8, 0.7, 50.0f); //ƖQ
	disp_wnd->CommonDevice->ShaderLightPos[10] = XMFLOAT4(12.0, -55.0, 3.0, 0);
	disp_wnd->CommonDevice->ShaderLight[11] = XMFLOAT4(1.0, 0.8, 0.7, 50.0f); //ƖR
	disp_wnd->CommonDevice->ShaderLightPos[11] = XMFLOAT4(-15.0, -47.0, 3.0, 0);
	disp_wnd->CommonDevice->ShaderLight[12] = XMFLOAT4(1.0, 0.8, 0.7, 50.0f); //Ɩ4
	disp_wnd->CommonDevice->ShaderLightPos[12] = XMFLOAT4(26.0, -30.0, 4.0, 0);
	disp_wnd->CommonDevice->ShaderLight[13] = XMFLOAT4(1.0, 0.8, 0.7, 50.0f); //Ɩ5
	disp_wnd->CommonDevice->ShaderLightPos[13] = XMFLOAT4(-18.0, -25.0, 3.0, 0);
	disp_wnd->CommonDevice->ShaderLight[14] = XMFLOAT4(0, 0, 0, 0); //NULL
	disp_wnd->CommonDevice->ShaderLightPos[14] = XMFLOAT4(0, 0, 0, 0);
	disp_wnd->CommonDevice->ShaderLight[15] = XMFLOAT4(0, 0, 0, 0); //NULL
	disp_wnd->CommonDevice->ShaderLightPos[15] = XMFLOAT4(0, 0, 0, 0);

	/////////////////////////////////////////////////////////////////////////////

	srand((unsigned int)time(NULL));
	int rand_hour = rand() % 4 + 16;
	int rand_min = rand() % 40;
	disp_wnd->Sky = new CSky();
	wchar_t *texture_cloud_name = theApp->MainWindow->Config->TextureCloudName;
	wchar_t *texture_star_name = theApp->MainWindow->Config->TextureStarName;
	wchar_t *texture_moon_name = theApp->MainWindow->Config->TextureMoonName;
	disp_wnd->Sky->SetInitParam(20, 20);
	disp_wnd->Sky->CreateResource(disp_wnd->CommonDevice, img_path, texture_cloud_name, texture_star_name, texture_moon_name);
	disp_wnd->Sky->SetMoonPos(-20, -300, 70);
	disp_wnd->Sky->SetSunPos(50, 300, -60);
	disp_wnd->Sky->SetMoonCrescentRate(0);
	disp_wnd->Sky->SetSceneTime(rand_hour, rand_min, 0);
	disp_wnd->Sky->SetCloudAlpha(3.5);

	////////////////////////////////////////////////////////////////////////////////

	disp_wnd->VolumeLight = new CVolumeLight();
	disp_wnd->VolumeLight->CreateResource(disp_wnd->CommonDevice, disp_wnd->VolumeLightResolution);

	////////////////////////////////////////////////////////////////////////////////

	disp_wnd->IsAnimated = false; //LN^[Aj[Vsꍇtrueݒ肵ĂB

	wchar_t path[SIZE_CHAR_MAX];
	::GetCurrentDirectory(SIZE_CHAR_MAX, path);

	::SetCurrentDirectory(L"./model/suzune");

	disp_wnd->SuzuneData = new CChaDataObject();
	disp_wnd->SuzuneData->LoadModel(DEFAULT_SUZUNE_NAME);
	disp_wnd->SuzuneData->LoadAnimation(SUZUNE_ANIM_1);
	disp_wnd->SuzuneData->LoadAnimation(SUZUNE_ANIM_2);
	disp_wnd->SuzuneData->LoadAnimation(SUZUNE_ANIM_3);
	disp_wnd->SuzuneRes = new CChaResourceObject();
	disp_wnd->SuzuneRes->CreateResource(disp_wnd->CommonDevice, disp_wnd->SuzuneData, true);

	::SetCurrentDirectory(L"../..");
	::SetCurrentDirectory(L"./model/washitu");

	disp_wnd->ChaDataObject1 = new CChaDataObject();
	disp_wnd->ChaDataObject1->LoadModel(DEFAULT_MODEL_NAME);
	disp_wnd->ChaResourceObject1 = new CChaResourceObject();
	disp_wnd->ChaResourceObject1->CreateResource(disp_wnd->CommonDevice, disp_wnd->ChaDataObject1, false);

	disp_wnd->ChaDataObject2 = new CChaDataObject();
	disp_wnd->ChaDataObject2->LoadModel(DEFAULT_MODEL_NAME_1);
	disp_wnd->ChaResourceObject2 = new CChaResourceObject();
	disp_wnd->ChaResourceObject2->CreateResource(disp_wnd->CommonDevice, disp_wnd->ChaDataObject2, false);

	disp_wnd->ChaDataObject3 = new CChaDataObject();
	disp_wnd->ChaDataObject3->LoadModel(DEFAULT_MODEL_NAME_2);
	disp_wnd->ChaResourceObject3 = new CChaResourceObject();
	disp_wnd->ChaResourceObject3->CreateResource(disp_wnd->CommonDevice, disp_wnd->ChaDataObject3, false);

	disp_wnd->ChaDataObject4 = new CChaDataObject();
	disp_wnd->ChaDataObject4->LoadModel(DEFAULT_MODEL_NAME_3);
	disp_wnd->ChaResourceObject4 = new CChaResourceObject();
	disp_wnd->ChaResourceObject4->CreateResource(disp_wnd->CommonDevice, disp_wnd->ChaDataObject4, false);

	::SetCurrentDirectory(L"../..");

	///////////////////////////////////////////////////////////
	//pXݒ

	srand((unsigned int)time(NULL));
	int select = rand() % 2;
	int select2 = rand() % 2;
	if (select == 1){
		disp_wnd->CurrentPath = disp_wnd->Path1;
		disp_wnd->CurrentPathNum = disp_wnd->Path1Num;
		if (select2 == 1){
			disp_wnd->NextPath = disp_wnd->Path2;
			disp_wnd->NextPathNum = disp_wnd->Path2Num;
		}
		else{
			disp_wnd->NextPath = disp_wnd->Path5;
			disp_wnd->NextPathNum = disp_wnd->Path5Num;
		}
	}
	else{
		disp_wnd->CurrentPath = disp_wnd->Path6;
		disp_wnd->CurrentPathNum = disp_wnd->Path6Num;
		disp_wnd->NextPath = disp_wnd->Path7;
		disp_wnd->NextPathNum = disp_wnd->Path7Num;
	}
	disp_wnd->SuzuneRes->SetCurrentAnimation(1, 1, 1, false);
	disp_wnd->SuzuneRes->AnimationFinished = true;
	disp_wnd->SetSuzunePos();
	disp_wnd->CameraMove();
	disp_wnd->CameraMove();

	disp_wnd->Status = STATUS_RUN;

	disp_wnd->SE1->Play(1);

	return true;
}

void CALLBACK  CDispWindow::TimeUpdateCallback(UINT timer_id, UINT msg, LPTIMECALLBACK user, DWORD_PTR data1, DWORD_PTR data2){

	CDispWindow *disp_wnd = (CDispWindow *)user;

	static bool init_load = false;
	if (init_load == false){
		init_load = true;
		disp_wnd->Status = STATUS_LOADING;

		::InvalidateRect(theApp->MainWindow->m_hWnd, NULL, false);
		::UpdateWindow(theApp->MainWindow->m_hWnd);

		disp_wnd->Thread = (HANDLE)_beginthreadex(NULL, 0, ThreadInitLoad, (void *)disp_wnd, 0, NULL);
	}

	if (disp_wnd->Status == STATUS_RUN){

		if (disp_wnd != NULL && disp_wnd->ChaResourceObject1 != NULL){
			disp_wnd->ChaResourceObject1->FrameCount += 3;
			disp_wnd->UpdateShaderLight();
		}
		if (disp_wnd != NULL && disp_wnd->Sky != NULL)
			disp_wnd->Sky->UpdateFrame();
		if (disp_wnd != NULL && disp_wnd->SuzuneRes != NULL)
			disp_wnd->SuzuneRes->FrameCount += 3;

		disp_wnd->CameraMove();

		::InvalidateRect(disp_wnd->m_hWnd, NULL, false);
		::UpdateWindow(disp_wnd->m_hWnd);
	}
}

LRESULT CDispWindow::WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam){

	CDispWindow *disp_wnd = (CDispWindow *) ::GetWindowLongPtr(hwnd, GWLP_USERDATA);
	if (disp_wnd != NULL)
		disp_wnd->DispWindowProc(hwnd, message, wParam, lParam);

	return DefWindowProc(hwnd, message, wParam, lParam);
}

LRESULT CDispWindow::DispWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam){

	int width = 0;
	int height = 0;
	int x = 0;
	int y = 0;
	int delta = 0;
	int key = 0;

	switch (message){
	case WM_PAINT:
		OnPaint();
		break;
	case WM_SIZE:
		width = GET_X_LPARAM(lParam);
		height = GET_Y_LPARAM(lParam);
		OnSize((UINT)wParam, width, height);
		break;
	case WM_LBUTTONDOWN:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		OnLButtonDown((UINT)wParam, CPoint(x, y));
		break;
	case WM_LBUTTONUP:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		OnLButtonUp((UINT)wParam, CPoint(x, y));
		break;
	case WM_RBUTTONDOWN:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		OnRButtonDown((UINT)wParam, CPoint(x, y));
		break;
	case WM_RBUTTONUP:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		OnRButtonUp((UINT)wParam, CPoint(x, y));
		break;
	case WM_MOUSEMOVE:
		::SetFocus(m_hWnd);
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		OnMouseMove((UINT)wParam, CPoint(x, y));
		break;
	case WM_MOUSEWHEEL:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		key = GET_KEYSTATE_WPARAM(wParam);
		delta = GET_WHEEL_DELTA_WPARAM(wParam);
		OnMouseWheel(key, delta, CPoint(x, y));
		break;
	case WM_KEYDOWN:
		OnKeyDown(wParam);
		break;
	default:
		break;
	}

	return 0;
}

void CDispWindow::OnKeyDown(UINT nChar){

	if (nChar == 32 /* enter */){

		if (IsTransparent == false){
			BackFullScreen = theApp->MainWindow->IsMaximized;
			IsFullScreen = true;
			ShowCursor(false);
		}
		else{
			IsFullScreen = BackFullScreen;
			ShowCursor(true);
		}

		IsTransparent = !IsTransparent;
		if (IsFullScreen == true){
			::ShowWindow(theApp->MainWindow->m_hWnd, SW_MAXIMIZE);
			theApp->MainWindow->OnSize(SIZE_MAXIMIZED, DisplayWidth, DisplayHeight);
		}
		else{
			::ShowWindow(theApp->MainWindow->m_hWnd, SW_RESTORE);
			theApp->MainWindow->OnSize(SIZE_RESTORED, Width, Height);
		}
		::InvalidateRect(m_hWnd, NULL, false);
		::UpdateWindow(m_hWnd);
	}
}

void CDispWindow::OnSize(UINT nType, int cx, int cy){

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

bool CDispWindow::UpdateShaderLight(){

	static float time = 0.0f;
	time += 0.03f;
	if (time > 3.14159265f * 2.0f)
		time = 0.0f;

	float light_power_0 = 0.4f + sin(time + 2.36) * 0.05f;
	float light_power_1 = 0.4f + sin(time + 5.24) * 0.05f;
	float light_power_2 = 0.4f + sin(time + 4.58) * 0.05f;
	float light_power_3 = 0.8f + sin(time + 0.24) * 0.3f;
	float light_power_4 = 0.8f + sin(time + 3.89) * 0.3f;
	float light_power_5 = 0.8f + sin(time + 5.36) * 0.3f;
	float light_power_6 = 0.8f + sin(time + 7.47) * 0.3f;
	float light_power_7 = 0.8f + sin(time + 2.38) * 0.3f;
	float light_power_8 = 0.8f + sin(time + 5.79) * 0.3f;
	float light_power_9 = 50.0f + sin(time + 1.35) * 10.0f;
	float light_power_10 = 50.0f + sin(time + 3.24) * 10.0f;
	float light_power_11 = 50.0f + sin(time + 5.87) * 10.0f;
	float light_power_12 = 50.0f + sin(time + 1.34) * 10.0f;
	float light_power_13 = 50.0f + sin(time + 6.46) * 10.0f;

	PointLight[0]->SetPower(light_power_0);
	PointLight[1]->SetPower(light_power_1);
	PointLight[2]->SetPower(light_power_2);

	CommonDevice->ShaderLight[0] = XMFLOAT4(0.9, 0.6, 0.4, light_power_0); //sP
	CommonDevice->ShaderLight[1] = XMFLOAT4(0.9, 0.6, 0.4, light_power_1); //sQ
	CommonDevice->ShaderLight[2] = XMFLOAT4(0.9, 0.6, 0.4, light_power_2); //sR
	CommonDevice->ShaderLight[3] = XMFLOAT4(0.9, 0.6, 0.4, light_power_3); //XCP
	CommonDevice->ShaderLight[4] = XMFLOAT4(0.9, 0.6, 0.4, light_power_4); //XCQ
	CommonDevice->ShaderLight[5] = XMFLOAT4(0.9, 0.6, 0.4, light_power_5); //XCR
	CommonDevice->ShaderLight[6] = XMFLOAT4(0.9, 0.6, 0.4, light_power_6); //XCS
	CommonDevice->ShaderLight[7] = XMFLOAT4(0.9, 0.6, 0.4, light_power_7); //XCT
	CommonDevice->ShaderLight[8] = XMFLOAT4(0.9, 0.6, 0.4, light_power_8); //XCU
	CommonDevice->ShaderLight[9] = XMFLOAT4(1.0, 0.8, 0.7, light_power_9); //ƖP
	CommonDevice->ShaderLight[10] = XMFLOAT4(1.0, 0.8, 0.7, light_power_10); //ƖQ
	CommonDevice->ShaderLight[11] = XMFLOAT4(1.0, 0.8, 0.7, light_power_11); //ƖR
	CommonDevice->ShaderLight[12] = XMFLOAT4(1.0, 0.8, 0.7, light_power_12); //Ɩ4
	CommonDevice->ShaderLight[13] = XMFLOAT4(1.0, 0.8, 0.7, light_power_13); //Ɩ5

	return true;
}

bool CDispWindow::Render(){

	float wh = (float)Height / (float)Width;
	if (theApp->MainWindow->IsMaximized == true){
		wh = (float)ScreenHeight / (float)ScreenWidth;
	}

	CommonDevice->SetViewParam(ScreenWidth * DisplayResolution, ScreenHeight * DisplayResolution, 1.0f / wh);

	D3D11_VIEWPORT vp;
	vp.Width = ScreenWidth * DisplayResolution;
	vp.Height = ScreenHeight * DisplayResolution;
	vp.TopLeftX = 0;
	vp.TopLeftY = 0;
	vp.MinDepth = 0.0f;
	vp.MaxDepth = 1.0f;
	CommonDevice->m_pDeviceContext->RSSetViewports(1, &vp);

	// VhE}bv
	static bool init_load = false;
	if (PointLight != NULL && init_load == false){

		init_load = true; //ŏɂP񂾂VhE}bv쐬B

		for (int i = 0; i <= PointLightNum - 1; i++)
			PointLight[i]->DrawShadowMap(CommonDevice, ChaResourceObject1);
	}

	///////////////////////////////////////////////////////////////
	//VhE̕`

	if (DrawShadowMap == true){
		for (int i = 0; i <= PointLightNum - 1; i++){
			PointLight[i]->Draw(CommonDevice, ChaResourceObject4);
		}
	}

	float clear_color[4] = { 0, 0, 0, 0 };
	CommonDevice->m_pDeviceContext->ClearRenderTargetView(CommonDevice->m_pDiffuseRenderTargetView, clear_color);
	CommonDevice->m_pDeviceContext->ClearRenderTargetView(CommonDevice->m_pDiffuse2RenderTargetView, clear_color);
	CommonDevice->m_pDeviceContext->ClearRenderTargetView(CommonDevice->m_pEffectRenderTargetView, clear_color);
	CommonDevice->m_pDeviceContext->ClearRenderTargetView(CommonDevice->m_pToneRenderTargetView, clear_color);
	CommonDevice->m_pDeviceContext->ClearRenderTargetView(CommonDevice->m_pDepthRenderTargetView, clear_color);
	CommonDevice->m_pDeviceContext->ClearRenderTargetView(CommonDevice->m_pSkyRenderTargetView, clear_color);
	CommonDevice->m_pDeviceContext->ClearDepthStencilView(CommonDevice->m_pDepthStencilView, D3D11_CLEAR_DEPTH | D3D11_CLEAR_STENCIL, 1.0, 0.0f);
	CommonDevice->m_pDeviceContext->ClearDepthStencilView(CommonDevice->m_pReadOnlyDepthStencilView, D3D11_CLEAR_DEPTH | D3D11_CLEAR_STENCIL, 1.0, 0);

	ID3D11RenderTargetView *rtview[2] = { CommonDevice->m_pDiffuseRenderTargetView, CommonDevice->m_pDepthRenderTargetView };

	////////////////////////////////////////////////////////////////////////
	//bV̕`

	CommonDevice->m_pDeviceContext->RSSetState(CommonDevice->m_pRasterizeState);
	CommonDevice->m_pDeviceContext->OMSetBlendState(CommonDevice->m_pBlendState1, NULL, 0xffffffff);
	CommonDevice->m_pDeviceContext->VSSetConstantBuffers(0, 1, &CommonDevice->m_pConstantBuffer1);
	CommonDevice->m_pDeviceContext->PSSetConstantBuffers(0, 1, &CommonDevice->m_pConstantBuffer1);

	if (IsAnimated == true)
		CommonDevice->m_pDeviceContext->VSSetShader(CommonDevice->m_pVtxShader1, NULL, 0);
	else
		CommonDevice->m_pDeviceContext->VSSetShader(CommonDevice->m_pVtxShader1_1, NULL, 0);

	/*-------------------------------------*/
	//̕`

	CommonDevice->m_pDeviceContext->OMSetRenderTargets(2, rtview, CommonDevice->m_pDepthStencilView);
	CommonDevice->m_pDeviceContext->PSSetShader(CommonDevice->m_pPxShader1, NULL, 0);

	if (ChaResourceObject1 != NULL){
		ChaResourceObject1->UpdateTransform();
		ChaResourceObject1->Draw(CommonDevice);
	}

	/*-------------------------------------*/
	//q̕`

	ID3D11RenderTargetView *rtview2[] = { CommonDevice->m_pDiffuse2RenderTargetView };
	CommonDevice->m_pDeviceContext->ClearRenderTargetView(CommonDevice->m_pDiffuse2RenderTargetView, clear_color);
	CommonDevice->m_pDeviceContext->OMSetRenderTargets(1, rtview2, CommonDevice->m_pDepthStencilView);
	CommonDevice->m_pDeviceContext->PSSetShader(CommonDevice->m_pPxShader8, NULL, 0);

	if (ChaResourceObject2 != NULL){
		ChaResourceObject2->UpdateTransform();
		ChaResourceObject2->Draw(CommonDevice);
	}

	if (ChaResourceObject3 != NULL){
		ChaResourceObject3->UpdateTransform();
		ChaResourceObject3->Draw(CommonDevice);
	}

	/*-------------------------------------*/
	//鉹̕`
	
	ID3D11RenderTargetView *rtview1[2] = { CommonDevice->m_pToneRenderTargetView, CommonDevice->m_pToneDepthRenderTargetView };
	CommonDevice->m_pDeviceContext->ClearRenderTargetView(CommonDevice->m_pToneRenderTargetView, clear_color);
	CommonDevice->m_pDeviceContext->ClearRenderTargetView(CommonDevice->m_pToneDepthRenderTargetView, clear_color);
	CommonDevice->m_pDeviceContext->OMSetRenderTargets(2, rtview1, CommonDevice->m_pDepthStencilView);
	CommonDevice->m_pDeviceContext->PSSetShader(CommonDevice->m_pPxShader11, NULL, 0);
	
	CommonDevice->m_pDeviceContext->VSSetShader(CommonDevice->m_pVtxShader1, NULL, 0);

	if (SuzuneRes != NULL ){
		SuzuneRes->SetToneLightPos(SuzuneRes->Position.x - 5, SuzuneRes->Position.y - 5, SuzuneRes->Position.z + 5);
		SuzuneRes->UpdateTransform();
		if( SuzuneAppear == true )
			SuzuneRes->Draw(CommonDevice);
	}

	/*-------------------------------------*/
	//XC`

	CommonDevice->m_pDeviceContext->ClearRenderTargetView(CommonDevice->m_pEffectRenderTargetView, clear_color);
	CommonDevice->m_pDeviceContext->OMSetRenderTargets(1, &CommonDevice->m_pEffectRenderTargetView, CommonDevice->m_pReadOnlyDepthStencilView);

	if (SuzuneAppear == true){
		CommonDevice->m_pDeviceContext->CopyResource((ID3D11Resource *)CommonDevice->m_pReadOnlyDepthBuffer, (ID3D11Resource *)CommonDevice->m_pDepthBuffer);
		CommonDevice->m_pDeviceContext->PSSetShader(CommonDevice->m_pPxShader15, NULL, 0);
		SuzuneEffect->Draw(CommonDevice);
	}

	///////////////////////////////////////////////////////////////
	//̕`

	if (Sky != NULL){
		CommonDevice->m_pDeviceContext->OMSetRenderTargets(1, &CommonDevice->m_pSkyRenderTargetView, CommonDevice->m_pDepthStencilView);
		Sky->Draw(CommonDevice);
	}

	CommonDevice->m_pDeviceContext->CopyResource((ID3D11Resource *)CommonDevice->m_pReadOnlyDepthBuffer, (ID3D11Resource *)CommonDevice->m_pDepthBuffer);
	CommonDevice->m_pDeviceContext->PSSetShader(CommonDevice->m_pPxShader13, NULL, 0);
	RousokuEffect->Draw(CommonDevice);

	/*-------------------------------------*/
	//p[eBN`

	ParticleKaede1->Draw(CommonDevice);
	ParticleKaede2->Draw(CommonDevice);

	if (IsAnimated == true)
		CommonDevice->m_pDeviceContext->VSSetShader(CommonDevice->m_pVtxShader1, NULL, 0);
	else
		CommonDevice->m_pDeviceContext->VSSetShader(CommonDevice->m_pVtxShader1_1, NULL, 0);

	/////////////////////////////////////////////////////////////
	//{[Cg

	if (VolumeLight != NULL){
		VolumeLight->DrawVolumeLight(CommonDevice, PointLight[0]);
		VolumeLight->DrawVolumeLight(CommonDevice, PointLight[1]);
		VolumeLight->DrawVolumeLight(CommonDevice, PointLight[2]);
	}

	/////////////////////////////////////////////////////////////
	// _O

	float clear_color2[4] = { 0, 0, 0, 0 };
	CommonDevice->m_pDeviceContext->OMSetRenderTargets(1, &CommonDevice->m_pRenderTargetView, NULL);
	CommonDevice->m_pDeviceContext->ClearRenderTargetView(CommonDevice->m_pRenderTargetView, clear_color2);
	CommonDevice->m_pDeviceContext->VSSetShader(CommonDevice->m_pVtxShader2, NULL, 0);
	CommonDevice->m_pDeviceContext->PSSetShader(CommonDevice->m_pPxShader2, NULL, 0);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(0, 1, &CommonDevice->m_pDiffuseShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(2, 1, &PointLight[0]->m_pShadowMapSoftShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(3, 1, &PointLight[1]->m_pShadowMapSoftShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(4, 1, &PointLight[2]->m_pShadowMapSoftShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(8, 1, &PointLight[0]->m_pVolumeLightShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(9, 1, &PointLight[1]->m_pVolumeLightShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(10, 1, &PointLight[2]->m_pVolumeLightShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(11, 1, &CommonDevice->m_pToneShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(12, 1, &CommonDevice->m_pToneDepthShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(13, 1, &CommonDevice->m_pDiffuse2ShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(14, 1, &CommonDevice->m_pEffectShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(15, 1, &CommonDevice->m_pSkyShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetSamplers(0, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(1, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(2, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(3, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(4, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(8, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(9, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(10, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(11, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(12, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(13, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(14, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(15, 1, &CommonDevice->m_pSampleState);

	UINT stride = sizeof(CVertex);
	UINT offset = 0;
	CommonDevice->m_pDeviceContext->IASetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);

	CommonDevice->m_pDeviceContext->IASetVertexBuffers(0, 1, &CommonDevice->VertexBuffer, &stride, &offset);
	CommonDevice->m_pDeviceContext->Draw(4, 0);

	return true;
}

void CDispWindow::OnPaint(){

	if (Status != STATUS_RUN)
		return;

	Rock = false;

	PAINTSTRUCT ps;
	HDC hdc = ::BeginPaint(m_hWnd, &ps);
	if (CommonDevice != NULL && CommonDevice->m_pDevice != NULL && Rock == false ){

		///////////////////////////////////////////////////////////
		//t[[gvZ

		SYSTEMTIME	st;
		::GetSystemTime(&st);

		unsigned int t = st.wSecond * 1000 + st.wMilliseconds;
		static unsigned int prev_time = 0;
		static unsigned int count_sec = 0;
		if (prev_time > t)
			prev_time -= 60 * 1000;
		int interval = t - prev_time;
		count_sec += interval;
		prev_time = t;
		static int count_frame = 0;
		count_frame++;
		if (count_sec > 1000){

			FramePerSec = (float)count_frame * 1000.0f / (float)count_sec;
			count_frame = 0;
			count_sec = 0;

			::InvalidateRect(theApp->MainWindow->m_hWnd, NULL, false);
			::UpdateWindow(theApp->MainWindow->m_hWnd);
		}

		Rock = true;
		Render();
		CommonDevice->m_pSwapChain->Present(0, 0);
		Rock = false;
	}
	::EndPaint(m_hWnd, &ps);
}

bool CDispWindow::CameraMove(){

	int result = CommonDevice->CameraMoveSwing( CurrentPath, CurrentPathNum, PATH_SLICE_SIZE );

	SetSuzunePos();

	if (result == CAMERA_MOVE_REACH_END){
		CurrentPath = NextPath;
		CurrentPathNum = NextPathNum;
		CommonDevice->PathCount = 0;
		CommonDevice->Path_t_Count = 10000;

		srand((unsigned int)time(NULL));
		int select = rand() % 2;

		if (NextPath == Path1){
			if (select == 1){
				NextPath = Path2;
				NextPathNum = Path2Num;
			}
			else{
				NextPath = Path5;
				NextPathNum = Path5Num;
			}
		}
		else if (NextPath == Path2){
			NextPath = Path3;
			NextPathNum = Path3Num;
		}
		else if (NextPath == Path3){
			if (select == 1){
				NextPath = Path4;
				NextPathNum = Path4Num;
			}
			else{
				NextPath = Path14;
				NextPathNum = Path14Num;
			}
		}
		else if (NextPath == Path4){
			if (select == 1){
				NextPath = Path2;
				NextPathNum = Path2Num;
			}
			else{
				NextPath = Path5;
				NextPathNum = Path5Num;
			}
		}
		else if (NextPath == Path5){
			if (select == 1){
				NextPath = Path1;
				NextPathNum = Path1Num;
			}
			else{
				NextPath = Path6;
				NextPathNum = Path6Num;
			}
		}
		else if (NextPath == Path6){
			NextPath = Path7;
			NextPathNum = Path7Num;
		}
		else if (NextPath == Path7){
			if (select == 1){
				NextPath = Path8;
				NextPathNum = Path8Num;
			}
			else{
				NextPath = Path9;
				NextPathNum = Path9Num;
			}
		}
		else if (NextPath == Path8){
			if (select == 1){
				NextPath = Path6;
				NextPathNum = Path6Num;
			}
			else{
				NextPath = Path1;
				NextPathNum = Path1Num;
			}
		}
		else if (NextPath == Path9){
			if (select == 1){
				NextPath = Path10;
				NextPathNum = Path10Num;
			}
			else{
				NextPath = Path11;
				NextPathNum = Path11Num;
			}
		}
		else if (NextPath == Path10){
			if (select == 1){
				NextPath = Path12;
				NextPathNum = Path12Num;
			}
			else{
				NextPath = Path13;
				NextPathNum = Path13Num;
			}
		}
		else if (NextPath == Path11){
			NextPath = Path7;
			NextPathNum = Path7Num;
		}
		else if (NextPath == Path12){
			NextPath = Path3;
			NextPathNum = Path3Num;
		}
		else if (NextPath == Path13){
			if (select == 1){
				NextPath = Path10;
				NextPathNum = Path10Num;
			}
			else{
				NextPath = Path11;
				NextPathNum = Path11Num;
			}
		}
		else if (NextPath == Path14){
			if (select == 1){
				NextPath = Path12;
				NextPathNum = Path12Num;
			}
			else{
				NextPath = Path13;
				NextPathNum = Path13Num;
			}
		}
	}

	return true;
}

bool CDispWindow::SetSuzunePos(){

	float dist = sqrt(pow(CommonDevice->Eye.x - SuzuneRes->Position.x, 2.0f) + pow(CommonDevice->Eye.y - SuzuneRes->Position.y, 2.0f) + pow(CommonDevice->Eye.z - SuzuneRes->Position.z, 2.0f));

	if (SuzuneRes->CurrentAnimationNum == 1 || SuzuneRes->CurrentAnimationNum == 2){
		if (SuzuneRes->AnimationFinished == false){
			SuzuneAlpha -= 0.1f;
			SuzuneRes->SetAlpha(SuzuneAlpha);
			if (ToLeft == true)
				SuzuneEffectMoveX -= 0.2f;
			else
				SuzuneEffectMoveX += 0.2f;
			float vec_x = cos(ToRadian(SuzuneRes->Rotation.z - 90.0f)) * SuzuneEffectMoveX;
			float vec_y = sin(ToRadian(SuzuneRes->Rotation.z - 90.0f)) * SuzuneEffectMoveX;
			SuzuneEffect->EffectPos[0] = XMFLOAT4(SuzuneRes->Position.x + vec_x, SuzuneRes->Position.y + vec_y, SuzuneRes->Position.z, 0);
		}
		else{

			float rand_appear = ((float) ( rand() % 1000 )) / 1000.0f;
			if (rand_appear < SUZUNE_APPEAR_RATE)
				SuzuneAppear = true;
			else
				SuzuneAppear = false;

			if (NextPath == Path1){
				SuzuneRes->SetScale(0.5f, 0.5f, 0.5f);
				SuzuneRes->SetPosition(-1, -12.5, 1.5);
				SuzuneRes->SetRotation(0, 0, -90);
				SuzuneRes->SetCurrentAnimation(0, 15, 1.0f, true);
				ToLeft = false;
				SuzuneAlpha = 1.0f;
				SuzuneRes->SetAlpha(SuzuneAlpha);
				SuzuneEffect->EffectPos[0] = SuzuneRes->Position;
				SuzuneEffectMoveX = 0.0f;
			}
			else if (NextPath == Path2){
				SuzuneRes->SetScale(0.5f, 0.5f, 0.5f);
				SuzuneRes->SetPosition(5, 19, 1.5);
				SuzuneRes->SetRotation(0, 0, 90);
				SuzuneRes->SetCurrentAnimation(0, 15, 1.0f, true);
				ToLeft = true;
				SuzuneAlpha = 1.0f;
				SuzuneRes->SetAlpha(SuzuneAlpha);
				SuzuneEffect->EffectPos[0] = SuzuneRes->Position;
				SuzuneEffectMoveX = 0.0f;
			}
			else if (NextPath == Path3){
				SuzuneRes->SetScale(0.5f, 0.5f, 0.5f);
				SuzuneRes->SetPosition(-5, 19, 1.5);
				SuzuneRes->SetRotation(0, 0, 180);
				SuzuneRes->SetCurrentAnimation(0, 15, 1.0f, true);
				ToLeft = true;
				SuzuneAlpha = 1.0f;
				SuzuneRes->SetAlpha(SuzuneAlpha);
				SuzuneEffect->EffectPos[0] = SuzuneRes->Position;
				SuzuneEffectMoveX = 0.0f;
			}
			else if (NextPath == Path4){
				SuzuneRes->SetScale(0.5f, 0.5f, 0.5f);
				SuzuneRes->SetPosition(-5.5, -12.5, 1.5);
				SuzuneRes->SetRotation(0, 0, -90);
				SuzuneRes->SetCurrentAnimation(0, 15, 1.0f, true);
				ToLeft = true;
				SuzuneAlpha = 1.0f;
				SuzuneRes->SetAlpha(SuzuneAlpha);
				SuzuneEffect->EffectPos[0] = SuzuneRes->Position;
				SuzuneEffectMoveX = 0.0f;
			}
			else if (NextPath == Path5){
				SuzuneRes->SetScale(0.5f, 0.5f, 0.5f);
				SuzuneRes->SetPosition(5.5, 8, 1.5);
				SuzuneRes->SetRotation(0, 0, 90);
				SuzuneRes->SetCurrentAnimation(0, 15, 1.0f, true);
				ToLeft = true;
				SuzuneAlpha = 1.0f;
				SuzuneRes->SetAlpha(SuzuneAlpha);
				SuzuneEffect->EffectPos[0] = SuzuneRes->Position;
				SuzuneEffectMoveX = 0.0f;
			}
			else if (NextPath == Path6){
				SuzuneRes->SetScale(0.5f, 0.5f, 0.5f);
				SuzuneRes->SetPosition(-1, -12.5, 1.5);
				SuzuneRes->SetRotation(0, 0, -90);
				SuzuneRes->SetCurrentAnimation(0, 15, 1.0f, true);
				ToLeft = false;
				SuzuneAlpha = 1.0f;
				SuzuneRes->SetAlpha(SuzuneAlpha);
				SuzuneEffect->EffectPos[0] = SuzuneRes->Position;
				SuzuneEffectMoveX = 0.0f;
			}
			else if (NextPath == Path7){
				SuzuneRes->SetScale(0.5f, 0.5f, 0.5f);
				SuzuneRes->SetPosition(-5, 19, 1.5);
				SuzuneRes->SetRotation(0, 0, 90);
				SuzuneRes->SetCurrentAnimation(0, 15, 1.0f, true);
				ToLeft = false;
				SuzuneAlpha = 1.0f;
				SuzuneRes->SetAlpha(SuzuneAlpha);
				SuzuneEffect->EffectPos[0] = SuzuneRes->Position;
				SuzuneEffectMoveX = 0.0f;
			}
			else if (NextPath == Path8){
				SuzuneRes->SetScale(0.5f, 0.5f, 0.5f);
				SuzuneRes->SetPosition(5, 19, 1.5);
				SuzuneRes->SetRotation(0, 0, 0);
				SuzuneRes->SetCurrentAnimation(0, 15, 1.0f, true);
				ToLeft = false;
				SuzuneAlpha = 1.0f;
				SuzuneRes->SetAlpha(SuzuneAlpha);
				SuzuneEffect->EffectPos[0] = SuzuneRes->Position;
				SuzuneEffectMoveX = 0.0f;
			}
			else if (NextPath == Path9){
				SuzuneRes->SetScale(0.5f, 0.5f, 0.5f);
				SuzuneRes->SetPosition(5, -12.5, 1.5);
				SuzuneRes->SetRotation(0, 0, -90);
				SuzuneRes->SetCurrentAnimation(0, 15, 1.0f, true);
				ToLeft = false;
				SuzuneAlpha = 1.0f;
				SuzuneRes->SetAlpha(SuzuneAlpha);
				SuzuneEffect->EffectPos[0] = SuzuneRes->Position;
				SuzuneEffectMoveX = 0.0f;
			}
			else if (NextPath == Path10){
				SuzuneRes->SetScale(0.5f, 0.5f, 0.5f);
				SuzuneRes->SetPosition(5, -12.5, 1.5);
				SuzuneRes->SetRotation(0, 0, -90);
				SuzuneRes->SetCurrentAnimation(0, 15, 1.0f, true);
				ToLeft = false;
				SuzuneAlpha = 1.0f;
				SuzuneRes->SetAlpha(SuzuneAlpha);
				SuzuneEffect->EffectPos[0] = SuzuneRes->Position;
				SuzuneEffectMoveX = 0.0f;
			}
			else if (NextPath == Path11){
				SuzuneRes->SetScale(0.5f, 0.5f, 0.5f);
				SuzuneRes->SetPosition(5, -12.5, 1.5);
				SuzuneRes->SetRotation(0, 0, -90);
				SuzuneRes->SetCurrentAnimation(0, 15, 1.0f, true);
				ToLeft = false;
				SuzuneAlpha = 1.0f;
				SuzuneRes->SetAlpha(SuzuneAlpha);
				SuzuneEffect->EffectPos[0] = SuzuneRes->Position;
				SuzuneEffectMoveX = 0.0f;
			}
			else if (NextPath == Path12){
				SuzuneRes->SetScale(0.5f, 0.5f, 0.5f);
				SuzuneRes->SetPosition(1, 8, 1.5);
				SuzuneRes->SetRotation(0, 0, 90);
				SuzuneRes->SetCurrentAnimation(0, 15, 1.0f, true);
				ToLeft = false;
				SuzuneAlpha = 1.0f;
				SuzuneRes->SetAlpha(SuzuneAlpha);
				SuzuneEffect->EffectPos[0] = SuzuneRes->Position;
				SuzuneEffectMoveX = 0.0f;
			}
			else if (NextPath == Path13){
				SuzuneRes->SetScale(0.5f, 0.5f, 0.5f);
				SuzuneRes->SetPosition(1, 8, 1.5);
				SuzuneRes->SetRotation(0, 0, 90);
				SuzuneRes->SetCurrentAnimation(0, 15, 1.0f, true);
				ToLeft = false;
				SuzuneAlpha = 1.0f;
				SuzuneRes->SetAlpha(SuzuneAlpha);
				SuzuneEffect->EffectPos[0] = SuzuneRes->Position;
				SuzuneEffectMoveX = 0.0f;
			}
			else if (NextPath == Path14){
				SuzuneRes->SetScale(0.5f, 0.5f, 0.5f);
				SuzuneRes->SetPosition(1, -12.5, 1.5);
				SuzuneRes->SetRotation(0, 0, 0);
				SuzuneRes->SetCurrentAnimation(0, 15, 1.0f, true);
				ToLeft = true;
				SuzuneAlpha = 1.0f;
				SuzuneRes->SetAlpha(SuzuneAlpha);
				SuzuneEffect->EffectPos[0] = SuzuneRes->Position;
				SuzuneEffectMoveX = 0.0f;
			}
		}
	}
	else if (dist < SUZUNE_APPROACH_DISTANCE){
		if (ToLeft == true)
			SuzuneRes->SetCurrentAnimation(1, 15, 3.0f, false);
		else
			SuzuneRes->SetCurrentAnimation(2, 15, 3.0f, false);
		return true;
	}

	return true;
}

void CDispWindow::OnLButtonDown(UINT nFlag, CPoint point){

	LButtonDown = true;

	::ClientToScreen(m_hWnd, &point);
	DownPoint = point;
	LButtonDown = true;
	::SetCapture(m_hWnd);

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CDispWindow::OnRButtonDown(UINT nFlag, CPoint point){

	RButtonDown = true;

	::ClientToScreen(m_hWnd, &point);
	DownPoint = point;
	RButtonDown = true;
	::SetCapture(m_hWnd);

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CDispWindow::OnLButtonUp(UINT nFlag, CPoint point){

	::ReleaseCapture();
	LButtonDown = false;

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CDispWindow::OnRButtonUp(UINT nFlag, CPoint point){

	::ReleaseCapture();
	RButtonDown = false;

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CDispWindow::OnMouseMove(UINT nFlag, CPoint point){

	::ClientToScreen(m_hWnd, &point);

	if (RButtonDown == true){
		int move_x = point.x - DownPoint.x;
		int move_y = point.y - DownPoint.y;
		CommonDevice->RotationX -= move_y * 0.03f;
		CommonDevice->RotationZ -= move_x * 0.03f;

		int rot_x = (int)(CommonDevice->RotationX / (3.14159265f * 2.0f));
		CommonDevice->RotationX -= ((float)rot_x) * 3.14159265f * 2.0f;
		if (CommonDevice->RotationX < 0.001f)
			CommonDevice->RotationX = 0.001f;
		if (CommonDevice->RotationX > 3.14159265f / 2.0f)
			CommonDevice->RotationX = 3.14159265f / 2.0f;

		int rot_z = (int)(CommonDevice->RotationZ / (3.14159265f * 2.0f));
		CommonDevice->RotationZ -= ((float)rot_z) * 3.14159265f * 2.0f;
	}
	else if (LButtonDown == true){
		int move_x = point.x - DownPoint.x;
		int move_y = point.y - DownPoint.y;

		float m_x = move_x * 10.0f;
		float m_y = move_y * 10.0f;
		if (theApp->MainWindow->IsMaximized == true){
			m_x /= (float)DisplayWidth;
			m_y /= (float)DisplayHeight;
		}
		else{
			m_x /= (float)Width;
			m_y /= (float)Height;
		}
		float m_z = 0.0f;

		XMVECTOR vec;
		XMVECTOR at = XMVectorSet(CommonDevice->At.x, CommonDevice->At.y, CommonDevice->At.z, 0.0f);
		XMVECTOR up = XMVectorSet(0, 0, 1, 0.0f);
		XMVECTOR eye = XMVectorSet(CommonDevice->Eye.x + CommonDevice->At.x, CommonDevice->Eye.y + CommonDevice->At.y, CommonDevice->Eye.z + CommonDevice->At.z, 0.0f);
		XMMATRIX view = XMMatrixInverse(&vec, XMMatrixLookAtLH(eye, at, up));
		XMVECTOR move = XMVector4Transform(XMVectorSet(m_x, m_y, 0.0f, 0.0f), view);

		float mx = XMVectorGetX(move);
		float my = XMVectorGetY(move);
		float mz = XMVectorGetZ(move);

		CommonDevice->At.x += mx;
		CommonDevice->At.y += my;
		CommonDevice->At.z += mz;
		CommonDevice->Move.x += mx;
		CommonDevice->Move.y += my;
		CommonDevice->Move.z += mz;
	}

	DownPoint = point;

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CDispWindow::OnMouseWheel(UINT nFlag, int zDelta, CPoint point){

	CommonDevice->Zoom -= ((float)zDelta) * 0.01f;
	if (CommonDevice->Zoom < 0.1f)
		CommonDevice->Zoom = 0.1f;

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}