/////////////////////////////////////////////////
//
//  filename: Config.h
//  author:Chafumi Touji 
//  date: 2020/03/13 ver1.00
//
/////////////////////////////////////////////////

#ifndef __CONFIG_H__
#define __CONFIG_H__

class CConfig{
public:

	int		ScreenWidth, ScreenHeight;
	float		RotationX, RotationZ, EyePosX, EyePosY, EyePosZ, AtX, AtY, AtZ;
	float		SuzuneAppearRate;
	float		DisplayResolution;
	float		ShadowMapResolution;
	float		VolumeLightResolution;
	int		FrameRate;
	bool		DrawShadowMap;
	int		BKColorA, BKColorR, BKColorG, BKColorB;
	int		TextColorA, TextColorR, TextColorG, TextColorB;
	int		BarColorA, BarColorR, BarColorG, BarColorB;
	int		ViewerBKColorA, ViewerBKColorR, ViewerBKColorG, ViewerBKColorB;
	int		MenuBKColorA, MenuBKColorR, MenuBKColorG, MenuBKColorB;
	int		MenuTextColorA, MenuTextColorR, MenuTextColorG, MenuTextColorB;

	wchar_t		Path[SIZE_CHAR_MAX];
	wchar_t		ExtModel[SIZE_CHAR_MAX];
	wchar_t		ExtAnim[SIZE_CHAR_MAX];
	wchar_t		ExtDae[SIZE_CHAR_MAX];
	wchar_t		SEPath[SIZE_CHAR_MAX];

	wchar_t		ImgPath[SIZE_CHAR_MAX];
	wchar_t		TextureCloudName[SIZE_CHAR_MAX];
	wchar_t		TextureStarName[SIZE_CHAR_MAX];
	wchar_t		TextureMoonName[SIZE_CHAR_MAX];
	wchar_t		TextureParticleName[SIZE_CHAR_MAX];
	wchar_t		SE1FileName[SIZE_CHAR_MAX];

	CConfig();
	~CConfig();

public:
	bool GetParamI( int *value, char *name, char *param1, char *param2);
	bool GetParamF(float *value, char *name, char *param1, char *param2);
	bool GetParamB(bool *value, char *name, char *param1, char *param2);
	bool GetParamS(wchar_t *str, char *name, char *param1, char *param2);
	bool WriteParamI(FILE *file, char *param1, int value);
	bool WriteParamF(FILE *file, char *param1, float value);
	bool WriteParamB(FILE *file, char *param1, bool value);
	bool WriteParamS(FILE *file, char *param1, wchar_t *str);
	bool LoadConfigFile(wchar_t *filename);
	bool WriteConfigFile(wchar_t *filename);
};

#endif