/////////////////////////////////////////////////
//
//  filename: Config.cpp
//  author:Chafumi Touji 
//  date: 2020/03/13 ver1.00
//
/////////////////////////////////////////////////

#include "StdAfx.h"
#include "Config.h"

CConfig::CConfig(){

	wmemset(Path, 0, SIZE_CHAR_MAX);
	wmemset(SEPath, 0, SIZE_CHAR_MAX);
	wmemset(ImgPath, 0, SIZE_CHAR_MAX);
	wmemset(SE1FileName, 0, SIZE_CHAR_MAX);
	wmemset(TextureCloudName, 0, SIZE_CHAR_MAX);
	wmemset(TextureStarName, 0, SIZE_CHAR_MAX);
	wmemset(TextureMoonName, 0, SIZE_CHAR_MAX);
	wcscpy_s(Path, SIZE_CHAR_MAX, DEFAULT_MODEL_NAME);
	wcscpy_s(SEPath, SIZE_CHAR_MAX, DEFAULT_SE_PATH_NAME);
	wcscpy_s(ImgPath, SIZE_CHAR_MAX, IMG_PATH);
	wcscpy_s(SE1FileName, SIZE_CHAR_MAX, DEFAULT_SE1_FILE_NAME);
	wcscpy_s(TextureCloudName, SIZE_CHAR_MAX, TEXTURE_CLOUD_NAME);
	wcscpy_s(TextureStarName, SIZE_CHAR_MAX, TEXTURE_STAR_NAME);
	wcscpy_s(TextureMoonName, SIZE_CHAR_MAX, TEXTURE_MOON_NAME);
	wcscpy_s(TextureParticleName, SIZE_CHAR_MAX, TEXTURE_PARTICLE_NAME);
	BKColorA = 255;
	BKColorR = 140;
	BKColorG = 110;
	BKColorB = 110;
	TextColorA = 255;
	TextColorR = 200;
	TextColorG = 180;
	TextColorB = 180;
	BarColorA = 255;
	BarColorR = 100;
	BarColorG = 70;
	BarColorB = 70;
	ViewerBKColorA = 255;
	ViewerBKColorR = 220;
	ViewerBKColorG = 220;
	ViewerBKColorB = 220;
	MenuBKColorA = 255;
	MenuBKColorR = 110;
	MenuBKColorG = 80;
	MenuBKColorB = 80;
	MenuTextColorA = 255;
	MenuTextColorR = 220;
	MenuTextColorG = 200;
	MenuTextColorB = 200;
	RotationX = 1.5f;
	RotationZ = 1.5f;
	EyePosX = 0.0f;
	EyePosY = -2.5f;
	EyePosZ = 1.5f;
	AtX = EyePosX;
	AtY = EyePosY - 1.0f;
	AtZ = EyePosZ;
 	ScreenWidth = RESOLUTION_WIDTH;
	ScreenHeight = RESOLUTION_HEIGHT;
	SuzuneAppearRate = SUZUNE_APPEAR_RATE;
	DisplayResolution = 0.8f;
	ShadowMapResolution = 1.0f;
	VolumeLightResolution = 0.2f;
	FrameRate = (int) 60.0f;
	DrawShadowMap = true;

	wmemset(ExtModel, 0, SIZE_CHAR_MAX);
	wmemset(ExtAnim, 0, SIZE_CHAR_MAX);
	wmemset(ExtDae, 0, SIZE_CHAR_MAX);
	wcscpy_s(ExtModel, SIZE_CHAR_MAX, EXT_MODEL);
	wcscpy_s(ExtAnim, SIZE_CHAR_MAX, EXT_ANIM);
	wcscpy_s(ExtDae, SIZE_CHAR_MAX, EXT_DAE);

}

CConfig::~CConfig(){

}

bool CConfig::LoadConfigFile(wchar_t *filename){

	FILE *file = NULL;

	_wfopen_s(&file, filename, L"r");
	if (file == NULL)
		return false;

	char *ctx;
	char line[SIZE_CHAR_MAX];
	char *param1;
	char *param2;
	while (fgets(line, SIZE_CHAR_MAX, file) != NULL){
		param1 = strtok_s(line, " =", &ctx);
		param2 = strtok_s(NULL, " =\n", &ctx);
		GetParamS(Path, "ModelPath", param1, param2);
		GetParamS(ImgPath, "ImgPath", param1, param2);
		GetParamS(SEPath, "SEPath", param1, param2);
		GetParamS(TextureCloudName, "TextureCloudName", param1, param2);
		GetParamS(TextureStarName, "TextureStarName", param1, param2);
		GetParamS(TextureMoonName, "TextureMoonName", param1, param2);
		GetParamS(TextureParticleName, "TextureParticleName", param1, param2);
		GetParamS(SE1FileName, "SE1FileName", param1, param2);
		GetParamI(&BKColorA, "BKColorA", param1, param2);
		GetParamI(&BKColorR, "BKColorR", param1, param2);
		GetParamI(&BKColorG, "BKColorG", param1, param2);
		GetParamI(&BKColorB, "BKColorB", param1, param2);
		GetParamI(&TextColorA, "TextColorA", param1, param2);
		GetParamI(&TextColorR, "TextColorR", param1, param2);
		GetParamI(&TextColorG, "TextColorG", param1, param2);
		GetParamI(&TextColorB, "TextColorB", param1, param2);
		GetParamI(&BarColorA, "BarColorA", param1, param2);
		GetParamI(&BarColorR, "BarColorR", param1, param2);
		GetParamI(&BarColorG, "BarColorG", param1, param2);
		GetParamI(&BarColorB, "BarColorB", param1, param2);
		GetParamI(&ViewerBKColorA, "ViewerBKColorA", param1, param2);
		GetParamI(&ViewerBKColorR, "ViewerBKColorR", param1, param2);
		GetParamI(&ViewerBKColorG, "ViewerBKColorG", param1, param2);
		GetParamI(&ViewerBKColorB, "ViewerBKColorB", param1, param2);
		GetParamI(&MenuBKColorA, "MenuBKColorA", param1, param2);
		GetParamI(&MenuBKColorR, "MenuBKColorR", param1, param2);
		GetParamI(&MenuBKColorG, "MenuBKColorG", param1, param2);
		GetParamI(&MenuBKColorB, "MenuBKColorB", param1, param2);
		GetParamI(&MenuTextColorA, "MenuTextColorA", param1, param2);
		GetParamI(&MenuTextColorR, "MenuTextColorR", param1, param2);
		GetParamI(&MenuTextColorG, "MenuTextColorG", param1, param2);
		GetParamI(&MenuTextColorB, "MenuTextColorB", param1, param2);
		GetParamF(&SuzuneAppearRate, "SuzuneAppearRate", param1, param2);
		GetParamF(&DisplayResolution, "DisplayResolution", param1, param2);
		GetParamF(&ShadowMapResolution, "ShadowMapResolution", param1, param2);
		GetParamF(&VolumeLightResolution, "VolumeLightResolution", param1, param2);
		GetParamI(&FrameRate, "FPS", param1, param2);
		GetParamB(&DrawShadowMap, "DrawShadowMap", param1, param2);
		GetParamF(&RotationX, "RotationX", param1, param2);
		GetParamF(&RotationZ, "RotationZ", param1, param2);
		GetParamF(&EyePosX, "EyePosX", param1, param2);
		GetParamF(&EyePosY, "EyePosY", param1, param2);
		GetParamF(&EyePosZ, "EyePosZ", param1, param2);
		GetParamF(&AtX, "AtX", param1, param2);
		GetParamF(&AtY, "AtY", param1, param2);
		GetParamF(&AtZ, "AtZ", param1, param2);
		GetParamS(ExtModel, "ExtModel", param1, param2);
		GetParamS(ExtAnim, "ExtAnim", param1, param2);
		GetParamS(ExtDae, "ExtDae", param1, param2);
		GetParamI(&ScreenWidth, "ScreenWidth", param1, param2);
		GetParamI(&ScreenHeight, "ScreenHeight", param1, param2);
	}

	fclose(file);

	return true;
}

bool CConfig::GetParamI( int *value, char *name, char *param1, char *param2){

	if (strcmp(param1, name) == 0){
		*value = atoi(param2);
	}

	return true;
}

bool CConfig::GetParamF(float *value, char *name, char *param1, char *param2){

	if (strcmp(param1, name) == 0){
		*value = atof(param2);
	}

	return true;
}

bool CConfig::GetParamB(bool *value, char *name, char *param1, char *param2){

	if (strcmp(param1, name) == 0){
		if (strcmp(param2, "true") == 0 || strcmp(param2, "1") == 0 || strcmp(param2, "TRUE") == 0)
			*value = true;
		else
			*value = false;
	}

	return true;
}

bool CConfig::GetParamS(wchar_t *str, char *name, char *param1, char *param2){

	size_t size;
	if (strcmp(name, param1) == 0){
		mbstowcs_s(&size, str, SIZE_CHAR_MAX, param2, SIZE_CHAR_MAX);
	}

	return true;
}

bool CConfig::WriteParamI(FILE *file, char *param1, int value){

	char paramline[SIZE_CHAR_MAX];
	memset(paramline, 0, SIZE_CHAR_MAX);

	char data[SIZE_CHAR_MAX];
	memset(data, 0, SIZE_CHAR_MAX);

	strcpy_s(paramline, SIZE_CHAR_MAX, param1);
	sprintf_s(data, "%d", value);
	strcat_s(paramline, SIZE_CHAR_MAX, data);
	strcat_s(paramline, SIZE_CHAR_MAX, "\n");
	fputs(paramline, file);

	return true;
}

bool CConfig::WriteParamF(FILE *file, char *param1, float value){

	char paramline[SIZE_CHAR_MAX];
	memset(paramline, 0, SIZE_CHAR_MAX);

	char data[SIZE_CHAR_MAX];
	memset(data, 0, SIZE_CHAR_MAX);

	strcpy_s(paramline, SIZE_CHAR_MAX, param1);
	sprintf_s(data, "%.6f", value);
	strcat_s(paramline, SIZE_CHAR_MAX, data);
	strcat_s(paramline, SIZE_CHAR_MAX, "\n");
	fputs(paramline, file);

	return true;
}

bool CConfig::WriteParamB(FILE *file, char *param1, bool value){

	char paramline[SIZE_CHAR_MAX];
	memset(paramline, 0, SIZE_CHAR_MAX);

	char data[SIZE_CHAR_MAX];
	memset(data, 0, SIZE_CHAR_MAX);

	strcpy_s(paramline, SIZE_CHAR_MAX, param1);
	if ( value == true )
		sprintf_s(data, "true");
	else
		sprintf_s(data, "false");
	strcat_s(paramline, SIZE_CHAR_MAX, data);
	strcat_s(paramline, SIZE_CHAR_MAX, "\n");
	fputs(paramline, file);

	return true;
}

bool CConfig::WriteParamS(FILE *file, char *param1, wchar_t *str){

	char paramline[SIZE_CHAR_MAX];
	memset(paramline, 0, SIZE_CHAR_MAX);

	char data[SIZE_CHAR_MAX];
	memset(data, 0, SIZE_CHAR_MAX);
	size_t size;
	if (str != NULL)
		wcstombs_s(&size, data, SIZE_CHAR_MAX, str, SIZE_CHAR_MAX);

	strcpy_s(paramline, SIZE_CHAR_MAX, param1);
	strcat_s(paramline, SIZE_CHAR_MAX, data);
	strcat_s(paramline, SIZE_CHAR_MAX, "\n");
	fputs(paramline, file);

	return true;
}

bool CConfig::WriteConfigFile(wchar_t *filename){

	FILE *file;
	
	_wfopen_s(&file, filename, L"w");
	if (file == NULL)
		return false;

	WriteParamI(file, "ScreenWidth = ", ScreenWidth);
	WriteParamI(file, "ScreenHeight = ", ScreenHeight);
	WriteParamI(file, "FPS = ", FrameRate);
	WriteParamB(file, "DrawShadowMap = ", DrawShadowMap);
	WriteParamF(file, "SuzuneAppearRate = ", SuzuneAppearRate);
	WriteParamF(file, "DisplayResolution = ", DisplayResolution);
	WriteParamF(file, "ShadowMapResolution = ", ShadowMapResolution);
	WriteParamF(file, "VolumeLightResolution = ", VolumeLightResolution);
	WriteParamS(file, "ModelPath = ", Path);
	WriteParamS(file, "ExtModel = ", ExtModel);
	WriteParamS(file, "ExtAnim = ", ExtAnim);
	WriteParamS(file, "ExtDae = ", ExtDae);
	WriteParamS(file, "ImgPath = ", ImgPath);
	WriteParamS(file, "TextureCloudName = ", TextureCloudName);
	WriteParamS(file, "TextureStarName = ", TextureStarName);
	WriteParamS(file, "TextureMoonName = ", TextureMoonName);
	WriteParamS(file, "TextureParticleName = ", TextureParticleName);
	WriteParamS(file, "SEPath = ", SEPath);
	WriteParamS(file, "SE1FileName = ", SE1FileName);
	WriteParamI(file, "BKColorA = ", BKColorA);
	WriteParamI(file, "BKColorR = ", BKColorR);
	WriteParamI(file, "BKColorG = ", BKColorG);
	WriteParamI(file, "BKColorB = ", BKColorB);
	WriteParamI(file, "TextColorA = ", TextColorA);
	WriteParamI(file, "TextColorR = ", TextColorR);
	WriteParamI(file, "TextColorG = ", TextColorG);
	WriteParamI(file, "TextColorB = ", TextColorB);
	WriteParamI(file, "BarColorA = ", BarColorA);
	WriteParamI(file, "BarColorR = ", BarColorR);
	WriteParamI(file, "BarColorG = ", BarColorG);
	WriteParamI(file, "BarColorB = ", BarColorB);
	WriteParamI(file, "ViewerBKColorA = ", ViewerBKColorA);
	WriteParamI(file, "ViewerBKColorR = ", ViewerBKColorR);
	WriteParamI(file, "ViewerBKColorG = ", ViewerBKColorG);
	WriteParamI(file, "ViewerBKColorB = ", ViewerBKColorB);
	WriteParamI(file, "MenuBKColorA = ", MenuBKColorA);
	WriteParamI(file, "MenuBKColorR = ", MenuBKColorR);
	WriteParamI(file, "MenuBKColorG = ", MenuBKColorG);
	WriteParamI(file, "MenuBKColorB = ", MenuBKColorB);
	WriteParamI(file, "MenuTextColorA = ", MenuTextColorA);
	WriteParamI(file, "MenuTextColorR = ", MenuTextColorR);
	WriteParamI(file, "MenuTextColorG = ", MenuTextColorG);
	WriteParamI(file, "MenuTextColorB = ", MenuTextColorB);
	WriteParamF(file, "RotationX = ", RotationX);
	WriteParamF(file, "RotationZ = ", RotationZ);
	WriteParamF(file, "EyePosX = ", EyePosX);
	WriteParamF(file, "EyePosY = ", EyePosY);
	WriteParamF(file, "EyePosZ = ", EyePosZ);
	WriteParamF(file, "AtX = ", AtX);
	WriteParamF(file, "AtY = ", AtY);
	WriteParamF(file, "AtZ = ", AtZ);

	fclose(file);

	return true;
}
