
Texture2D txDiffuse : register(t0);
SamplerState samDiffuse : register(s0);

Texture2D txDepth : register(t1);
SamplerState samDepth : register(s1);

cbuffer ConstantBuffer1 : register(b0){

	matrix	MatWorld;
	matrix	MatView;
	matrix	MatProj;
	float4	Light;
}

cbuffer ConstantBuffer2 : register(b1){

	float4 Ambient;
	float4 Diffuse;
	float4 Specular;
}

cbuffer ConstantBuffer3 : register(b2){

	matrix BindShapeMatrix;
	matrix BoneMatrix[255];
}

////////////////////////////////////////////////////////

struct VertexIn{

	float3 Pos : POSITION;
	float3 Normal : NORMAL;
	float4 Color : COLOR;
	float2 Tex : TEXCOORD;
	float2 Weight0 : TEXCOORD1;
	float2 Weight1 : TEXCOORD2;
	float2 Weight2 : TEXCOORD3;
	float2 Weight3 : TEXCOORD4;
	float2 Weight4 : TEXCOORD5;
	float2 Weight5 : TEXCOORD6;
	float2 Weight6 : TEXCOORD7;
	float2 Weight7 : TEXCOORD8;
};

struct VertexOut{

	float4 Pos : SV_POSITION;
	float3 VtxPos : POSITION0;
	float3 Normal : POSITION1;
	float4 Color : COLOR0;
	float2 Tex : TEXCOORD0;
};

struct PsOutput{

	float4 Color : SV_Target0;
	float4 Depth : SV_Target1;
};

VertexOut vs_main1(VertexIn IN){

	VertexOut OUT;

	float4 vtx = float4(IN.Pos, 1.0f);
	float4 normal = float4(IN.Normal, 1.0f);
	float4 vtx_tmp = float4(0, 0, 0, 0);
	float4 normal_tmp = float4(0, 0, 0, 0);

	vtx = mul(vtx, BindShapeMatrix);
	normal = mul(normal, BindShapeMatrix);

	int joint0 = (int)(IN.Weight0.x + 0.0001f);
	int joint1 = (int)(IN.Weight1.x + 0.0001f);
	int joint2 = (int)(IN.Weight2.x + 0.0001f);
	int joint3 = (int)(IN.Weight3.x + 0.0001f);
	int joint4 = (int)(IN.Weight4.x + 0.0001f);
	int joint5 = (int)(IN.Weight5.x + 0.0001f);
	int joint6 = (int)(IN.Weight6.x + 0.0001f);
	int joint7 = (int)(IN.Weight7.x + 0.0001f);

	float w0 = clamp(IN.Weight0.y, 0.0f, 1.0f);
	float w1 = clamp(IN.Weight1.y, 0.0f, 1.0f);
	float w2 = clamp(IN.Weight2.y, 0.0f, 1.0f);
	float w3 = clamp(IN.Weight3.y, 0.0f, 1.0f);
	float w4 = clamp(IN.Weight4.y, 0.0f, 1.0f);
	float w5 = clamp(IN.Weight5.y, 0.0f, 1.0f);
	float w6 = clamp(IN.Weight6.y, 0.0f, 1.0f);
	float w7 = clamp(IN.Weight7.y, 0.0f, 1.0f);
	
	bool add_weight = false;
	float4 v = float4(0, 0, 0, 0);
	float4 n = float4(0, 0, 0, 0);

	if (w0 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint0]);
		n = mul(normal, BoneMatrix[joint0]);
		v *= w0;
		n *= w0;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w1 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint1]);
		n = mul(normal, BoneMatrix[joint1]);
		v *= w1;
		n *= w1;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w2 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint2]);
		n = mul(normal, BoneMatrix[joint2]);
		v *= w2;
		n *= w2;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w3 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint3]);
		n = mul(normal, BoneMatrix[joint3]);
		v *= w3;
		n *= w3;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w4 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint4]);
		n = mul(normal, BoneMatrix[joint4]);
		v *= w4;
		n *= w4;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w5 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint5]);
		n = mul(normal, BoneMatrix[joint5]);
		v *= w5;
		n *= w5;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w6 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint6]);
		n = mul(normal, BoneMatrix[joint6]);
		v *= w6;
		n *= w6;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w7 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint7]);
		n = mul(normal, BoneMatrix[joint7]);
		v *= w7;
		n *= w7;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}

	if (add_weight == true){
		vtx = vtx_tmp;
		normal = normal_tmp;
	}

	OUT.VtxPos = vtx;
	vtx = mul(vtx, MatWorld);
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);

	OUT.Pos = vtx;
	OUT.Normal = normal;
	OUT.Color = float4( 0, 0, 0, 1 );
	OUT.Tex = IN.Tex;

	return OUT;
}

VertexOut vs_main2(VertexIn IN){

	VertexOut OUT;

	OUT.Pos = float4( IN.Pos, 1.0f );
	OUT.Normal = IN.Normal;
	OUT.VtxPos = IN.Pos;
	OUT.Color = float4(0, 0, 0, 1);
	OUT.Tex = IN.Tex;

	return OUT;
}

/////////////////////////////////////////////////////////////////////////

PsOutput ps_main1(VertexOut input){

	PsOutput output;

	input.Tex.y = -input.Tex.y;
	float4 tex_color = txDiffuse.Sample(samDiffuse, input.Tex);
	float4 diffuse = Diffuse;
	tex_color.rgb += Diffuse.rgb * (1.0f - tex_color.a);
	tex_color.a = max(tex_color.a, diffuse.a);

	//fBt[YJ[
	float light_power = 1.0f;
	float3 L = normalize(Light.xyz + input.Normal.xyz);
	float3 N = normalize(input.Normal.xyz);
	float LN = dot(L, N);
	float4 diff = saturate(LN * tex_color);

	//g[VF[_
	float3 vec1 = normalize( Light.xyz - input.VtxPos.xyz);
	float d = dot(vec1, normalize(input.Normal.xyz));
	if (d < -0.1){
		tex_color.gb *= 0.7f;
		tex_color.r *= 0.8f;
	}
	else if (d < 0.5f){
		tex_color.gb *= 0.9f;
		tex_color.r *= 0.95f;
	}

	tex_color.rgb = tex_color.rgb;// *0.7f + diff.rgb * 0.3f;

	if (tex_color.r < 0.001 && tex_color.g < 0.001 && tex_color.b < 0.001){
		tex_color = input.Color;
	}
	if (tex_color.r >= 0.98 && tex_color.g >= 0.98 && tex_color.b >= 0.98){
		tex_color.rgb = 0.96;
	}

	output.Color = tex_color;
	output.Depth = float4( input.Pos.z / input.Pos.w, 0, 0, 1);

	return output;
}

float4 ps_main2(VertexOut input) : SV_Target0{
	
	float4 tex_color = txDiffuse.Sample(samDiffuse, input.Tex.xy);

	//GbW̋E`

	float tex_x = 1.0f / 400.0f;
	float tex_y = 1.0f / 400.0f;

	float4 d_center = txDepth.Sample(samDepth, input.Tex.xy);
	float4 d0 = txDepth.Sample(samDepth, input.Tex.xy + float2(-tex_x * 0.8f, -tex_y * 0.8f));
	float4 d1 = txDepth.Sample(samDepth, input.Tex.xy + float2(0.0f, -tex_y));
	float4 d2 = txDepth.Sample(samDepth, input.Tex.xy + float2(tex_x * 0.8f, -tex_y * 0.8f));
	float4 d3 = txDepth.Sample(samDepth, input.Tex.xy + float2(tex_x, 0.0f));
	float4 d4 = txDepth.Sample(samDepth, input.Tex.xy + float2(tex_x * 0.8f, tex_y * 0.8f));
	float4 d5 = txDepth.Sample(samDepth, input.Tex.xy + float2(0.0f, tex_y));
	float4 d6 = txDepth.Sample(samDepth, input.Tex.xy + float2(-tex_x * 0.8f, tex_y * 0.8f));
	float4 d7 = txDepth.Sample(samDepth, input.Tex.xy + float2(-tex_x, 0.0f));

	float D0 = ( d_center.x - d0.x) / max(abs(d4.x - d_center.x), 0.00005f );
	float D1 = ( d_center.x - d1.x) / max(abs(d5.x - d_center.x), 0.00005f);
	float D2 = ( d_center.x - d2.x) / max(abs(d6.x - d_center.x), 0.00005f);
	float D3 = ( d_center.x - d3.x) / max(abs(d7.x - d_center.x), 0.00005f);

	float d_max = max(D0, D1);
	d_max = max(d_max, D2);
	d_max = max(d_max, D3);

	if ( d_max > 10.0f){
		tex_color.gb *= 0.5;
		tex_color.r *= 0.6;
	}

	return tex_color;
}

