///////////////////////////////////////////////////
// filename:PCMAudio.h
// author: Chafumi Touji
// version: 1.0.1
// date: 2018/09/27
//		 2020/02/04
///////////////////////////////////////////////////

#ifndef __PCMAUDIO_H__
#define __PCMAUDIO_H__

class CListA;
class CAudioData;

class CPCMAudio{
public:
	LPDIRECTSOUND					lpDSound;
	CListA									*AudioList;
	double									*FFTLeft;
	double									*FFTRight;
	int										FFTCount;
	int										CurrentID;

private:
	int										StartID;
	LPDIRECTSOUNDBUFFER		lpDSoundBufferPrimary;
	HWND									WndDSound;
	WAVEFORMATEX					WFE_Primary;
	UINT									FFTTimerID;
	HWND									ParentWnd;
	double									**FFTLeftBack;
	double									**FFTRightBack;
	double									*ReTempLeft;
	double									*ReTempRight;
	double									*ImTempLeft;
	double									*ImTempRight;
	int										*SampleLeft;
	int										*SampleRight;
	LONG									Volume;
	bool										IsMute;

public:
	CPCMAudio();
	CPCMAudio(int sample_count, int ave_count );
	~CPCMAudio();
	bool Init( HWND parent_wnd, int start_id );
	bool Open(wchar_t *filename, int id );
	bool Open(wchar_t *filename, int id, CAudioData *data );
	bool Play(int id);
	bool Stop( int id );
	bool Pause( int id );
	bool Seek( int id, double pos);
	bool Close( int id);
	bool Mute(bool do_mute);
	bool SetPlayOnce( int id, bool play_once);
	bool GetPlayOnce( int id);
	int GetTotalTime( int id );
	double GetPlayingTime( int id );
	int GetStatus(int id);
	double GetPlayPos( int id );
	double GetVolume( int id );
	bool SetVolume( int id, double volume);
	bool SetLoop( int id, bool loop);
	bool GetLoop( int id );
	int GetID( int num );
	int GetListSize(){ if (AudioList != NULL) return AudioList->ListSize; return -1; }

private:
	bool CreateWnd();
	bool CreatePrimaryBuffer();

protected:
	static void __stdcall  FFTUpdateCallback(UINT timer_id, UINT msg, LPTIMECALLBACK user, DWORD_PTR data1, DWORD_PTR data2);
};

class CAudioData{
public:

	void				*AudioData;
	int				AudioType;
	wchar_t		*Path;
	wchar_t		*FileName;

public:
	CAudioData(){
		AudioData = NULL;
		AudioType = AUDIO_TYPE_UNKNOWN;
		Path = new wchar_t[SIZE_CHAR_MAX];
		FileName = new wchar_t[SIZE_CHAR_MAX];
		wmemset(Path, 0, SIZE_CHAR_MAX);
		wmemset(FileName, 0, SIZE_CHAR_MAX);
	}
	~CAudioData(){
		delete[] Path;
		delete[] FileName;
	}
};

#endif
