///////////////////////////////////////////////////
// filename:OggAudio.h
// author: Chafumi Touji
// version: 1.0.1
// date: 2018/09/27
//		 2020/02/04
///////////////////////////////////////////////////

#ifndef __OGGAUDIO_H__
#define __OGGAUDIO_H__

class COggAudio{
private:
	int												ID;
	int												StartID;
	HWND											ParentWnd;
	OggVorbis_File								OVF;
	LPDIRECTSOUNDBUFFER				lpDSoundBufferSecondary;
	LPWAVEFORMATEX						WFE_Secondary;
	HANDLE										Thread;
	char												*SampleBuffer;
	int												TotalTime;
	int												PlayingPos;
	int												Status;
	bool												Loop;
	double											Volume;
	bool												PlayOnce;

public:
	COggAudio();
	~COggAudio();
	bool Open(CPCMAudio *audio, wchar_t *filename, HWND parent_wnd, int id, int start_id );
	bool Play();
	bool Pause();
	bool Stop();
	bool Close();
	bool Mute(bool do_mute);
	bool Seek(double pos);
	int GetTotalTime();
	double GetPlayingTime();
	int GetBufferPos();
	int GetStatus();
	double GetPlayPos();
	double GetVolume();
	bool SetVolume(double volume, bool is_mute );
	bool SetLoop(bool loop);
	bool GetLoop();
	bool SetPlayOnce(bool play_once);
	bool GetPlayOnce();
	bool GetSample(int *sample_left, int *sample_right, int sample_count);
	int GetID(){ return ID; };

private:
	bool CreateOggSoundBuffer(LPDIRECTSOUND lpDSound, LPDIRECTSOUNDBUFFER *lpBuffer, LPWSTR filename);
	static unsigned __stdcall  ThreadOggStream(LPVOID pParam);
	bool BeginStreamOgg();

};

#endif