////////////////////////////////////////////////////////
// filename: ChaSound.h
// author: Chafumi Touji
// version: 1.0.1
// date: 2012/04/09
//		 2020/02/04
////////////////////////////////////////////////////////

#ifndef __CHASOUND_H__
#define __CHASOUND_H__

#include <windows.h>
#include <wchar.h>
#include <MMSystem.h>
#include <mmreg.h>
#include <msacm.h>
#include <math.h>
#include <dsound.h>
#include <process.h>
#include <vorbisfile.h>
#pragma comment(lib, "dsound.lib")
#pragma comment(lib, "winmm.lib")
#pragma comment(lib, "msacm32.lib")
#pragma comment(lib, "libogg_static.lib")
#pragma comment(lib, "libvorbis_static.lib")
#pragma comment(lib, "libvorbisfile_static.lib")

#define SIZE_CHAR_MAX						512
#define AUDIO_TYPE_UNKNOWN			0
#define AUDIO_TYPE_WAVE					1
#define AUDIO_TYPE_MP3						2
#define AUDIO_TYPE_OGG						3

#define AUDIO_STATUS_CLOSE				0
#define AUDIO_STATUS_INIT					1
#define AUDIO_STATUS_PAUSE				2
#define AUDIO_STATUS_PLAYING			3
#define AUDIO_STATUS_STOP					4
#define AUDIO_STATUS_SEEK					5

#define OGG_BUFFER_SIZE						4096 * 30
#define PCMAUDIO_TIME_UPDATE_MILLISEC		100
#define PCMAUDIO_FFT_UPDATE_MILLISEC		50
#define MP3_STREAM_BUFFER_SIZE		1024 * 1000
#define MP3_BLOCK_NUM						32
#define WAVE_DATA_MARGIN_SIZE		256
#define FFT_AVE_COUNT						5
#define FFT_COUNT									32
#define FFT_SAMPLE_COUNT					2048

#define NOTIFY_PLAY_FINISHED			10050

#include "CListA.h"
#include "PCMAudio.h"
#include "WAVEAudio.h"
#include "MP3Audio.h"
#include "OggAudio.h"

///////////////////////////////////////////////////////////////////////////////

#define SAFE_RELEASE(p) { if( p != NULL ) { (p)->Release(); (p) = NULL;}}
#define PLAY_TIME						1

#endif
