////////////////////////////////////////////////////////
// filename: ChaResourceObject.h
// author: Chafumi Touji
// version: 1.0.0
// date: 2020/03/08
////////////////////////////////////////////////////////

#ifndef __CHARESOURCEOBJECT_H__
#define __CHARESOURCEOBJECT_H__

struct ConstantBufferMaterial{

	XMFLOAT4		Ambient;
	XMFLOAT4		Diffuse;
	XMFLOAT4		Specular;
	XMFLOAT4		AlphaParam;
};

struct ConstantBufferBoneJoint{

	XMFLOAT4			ToneLightPos;
	XMFLOAT4X4		BindShapeMatrix;
	XMFLOAT4X4		MatTransform;
	XMFLOAT4X4		BoneMatrix[BONE_JOINT_NUM_MAX];
};

class CMaterialResource{
public:	
	float4 diffuse;
	float4 ambient;
	float4 emmition;
	float4 specular;
	ID3D11Texture2D *Texture;
	ID3D11ShaderResourceView *ShaderResourceView;

public:
	CMaterialResource();
	~CMaterialResource();
};

class CGeometryResource{
public:

	ID3D11Buffer	*VertexBuffer;
	CVector	*IndexBuffer;
	CVector	*Material;
	CVector *IndexCount;
	XMMATRIX BindShapeMatrix;
	int		WeightCount;

	XMFLOAT4	ObjectRect[8];
	XMFLOAT4	CenterPos;
	float				Length;

public:
	CGeometryResource();
	~CGeometryResource();
	bool Inside( float x, float y, float z );
};

class CBoneResource{
public:

	wchar_t ID[SIZE_CHAR_MAX];
	wchar_t Name[SIZE_CHAR_MAX];

	XMMATRIX	JointParam;
	XMMATRIX	InvBindMatrix;
	XMMATRIX	JointParamTransformed;
	XMMATRIX	PrevJointParamTransformed;
	XMMATRIX	BoneMatrix;

	CVector			*ChildBone;
	CBoneResource	*ParentBone;
	int					Type;
	bool					ChangeNewAnimation;
	int					ChangeFrameCount;
	int					NowChangeFrameCount;

public:

	CBoneResource();
	~CBoneResource();
};

class CAnimationResource{
public:

	wchar_t AnimationID[SIZE_CHAR_MAX];
	CVector *BoneAnimation;

public:

	CAnimationResource();
	~CAnimationResource();
};

class CBoneAnimationResource{
public:

	wchar_t Target[SIZE_CHAR_MAX];
	CBoneResource *TargetBone;

	CVector *KeyTime;
	CVector *PoseMatrix;

public:

	CBoneAnimationResource();
	~CBoneAnimationResource();
};

class CChaResourceObject{
public:

	wchar_t	ModelID[SIZE_CHAR_MAX];
	int		CurrentAnimationNum;

	bool	IsAnimated;
	bool Refrain;
	bool AnimationFinished;
	float AnimationSpeed;
	float Alpha;
	XMMATRIX		TransformMatrix;
	XMFLOAT4		Scale;
	XMFLOAT4		Rotation;
	XMFLOAT4		Position;
	XMFLOAT4		ToneLightPosition;

	UINT	FrameCount;
	CVector	*GeometryResource;
	CVector	*TextureOrigin;
	CVector	*ShaderResourceOrigin;
	CVector *ControlBone;
	CVector *BoneArray;
	CVector *AnimationList;

	ID3D11Buffer *m_pConstantBuffer1; //}eÃfBt[Yݒp
	ID3D11Buffer *m_pConstantBuffer2; //{[̃WCg}gNXݒp

public:
	CChaResourceObject();
	~CChaResourceObject();
	bool CreateResource( CCommonDevice *device, CChaDataObject *object, bool is_animated );
	bool Draw( CCommonDevice *device );
	bool SetScale(float scale_x, float scale_y, float scale_z);
	bool SetRotation(float angle_x, float angle_y, float angle_z);
	bool SetPosition(float pos_x, float pos_y, float pos_z);
	bool SetToneLightPos(float pos_x, float pos_y, float pos_z);
	bool SetAlpha(float alpha);
	bool UpdateTransform();
	bool CopyAnimation(CChaDataObject *object);
	bool CopyAnimation(CChaDataObject *object, int anim_num );
	bool SetCurrentAnimation(int num, int change_frame_count, float anim_speed, bool refrain );

private:
	bool BoneInit(CBoneResource *bone);
	bool CopyControlBone(CChaDataObject *object);
	bool CopyChildBone(CBone *parent, CBoneResource *parent_res);
	bool BoneTransform(CBoneResource *bone);
	XMMATRIX GetAnimationMatrix(CBoneAnimationResource *bone_anim, float sec, int *finishied );
	XMMATRIX CalcInterPauseLinear(XMMATRIX matrix1, XMMATRIX matrix2, float t);
	CBoneResource *FindBoneByID(wchar_t *search_name);
};
#endif