////////////////////////////////////////////////////////
// filename: CParticle.h
// author: Chafumi Touji
// version: 1.0.0
// date: 2020/09/03
////////////////////////////////////////////////////////

#ifndef __CPARTICLE_H__
#define __CPARTICLE_H__

struct ConstantBufferParticle{

	XMFLOAT4X4	MatParticle;
	XMFLOAT4		ParticleColor;
	XMFLOAT4		ParticleParam1;
};

class CParticleData{
public:

	int		ID;
	int		Count;
	int		CountMax;
	float		x, y, z;
	float		rot_x, rot_y, rot_z;
	float		vec_x, vec_y, vec_z;
	float		r_vec_x, r_vec_y, r_vec_z;
	float		alpha;

public:

	CParticleData();
	~CParticleData();
	bool Update();
	bool InitParticle( int id, int init_count, int count_max, XMFLOAT4 center, XMFLOAT4 field_range );
};

class CParticle{
public:

	int					ParticleNum;
	CParticleData	*ParticleData;

	XMFLOAT4		Center;
	XMFLOAT4		FieldRange;
	int					CountMax;

	ID3D11Texture2D					*m_pParticleTexture;
	ID3D11ShaderResourceView	*m_pParticleShaderResourceView;
	ID3D11Buffer							*ParticleBuffer;
	ID3D11Buffer							*m_pConstantBufferParticle;

public:

	CParticle();
	~CParticle();
	bool CreateResource(CCommonDevice *device, wchar_t *path, wchar_t *texture_particle_name, XMFLOAT4 center, XMFLOAT4 field_range, int particle_num, int count_max, float size );
	bool Update();
	bool Draw(CCommonDevice *device);
};

#endif