////////////////////////////////////////////////////////
// filename: C2DEffect.h
// author: Chafumi Touji
// version: 1.0.0
// date: 2020/09/02
////////////////////////////////////////////////////////

#ifndef __2DEFFECT_H__
#define __2DEFFECT_H__

struct ConstantBufferEffect{

	XMFLOAT4X4	MatEffect;
	XMFLOAT4		EffectColor;
	XMFLOAT4		EffectParam1;
	XMFLOAT4		EffectParam2[SIZE_EFFECT_PARAM2];
};

class C2DEffect{
public:

	int									EffectPosNum;
	int									EffectParamNum;
	XMFLOAT4						*EffectPos;
	XMFLOAT4						EffectColor;
	XMFLOAT4						*EffectParam;
	float									Time;

	ID3D11Texture2D				*m_pEffectTexture;
	ID3D11RenderTargetView		*m_pEffectRenderTargetView;
	ID3D11ShaderResourceView	*m_pEffectShaderResourceView;
	ID3D11Buffer				*EffectBuffer;
	ID3D11Buffer								*m_pConstantBufferEffect;

public:

	C2DEffect();
	~C2DEffect();
	bool CreateResource( CCommonDevice *device, float size );
	bool CreateEffectParam();
	bool Update();
	bool EffectParamUpdate(int num);
	bool EffectParamInit(int num);
	bool Draw(CCommonDevice *device);
};

#endif