////////////////////////////////////////////////////////
// filename: defcha3dcore.h
// author: Chafumi Touji
// version: 1.0.0
// date: 2020/03/05
////////////////////////////////////////////////////////

#ifndef __DEFCHA3DCORE_H__
#define __DEFCHA3DCORE_H__

#define _XM_NO_INTRINSICS_

#define DEFAULT_ZOOM		6.0f

#define SIZE_CHAR_MAX	1024
#define FLOAT_STRING_SIZE	8 * 16
#define INDEX_STRING_SIZE	8 * 16
#define WEIGHT_BONE_APPLY_NUM	8
#define BONE_JOINT_NUM_MAX		255

#define CHAMODEL_EXT_NAME	L".mdl"
#define CHAANIMATION_EXT_NAME	L".ani"

#define READ_MODE_INIT 0
#define READ_MODE_MATERIAL 1 
#define READ_MODE_TEXTURE 1 
#define READ_MODE_GEOMETRY 1 
#define READ_MODE_POLYGON_DATA 1 
#define READ_MODE_WEIGHTS 1 
#define READ_MODE_BONE 1 

#define TEX_ID_SIZE_MAX		15
#define TAB_MARGIN_SIZE		300
#define ANIMATION_KEY_TIME_SIZE_MAX		10000

#define DEFAULT_POINT_LIGHT_TEXTUER_SIZE		800
#define VOLUME_LIGHT_RESOLUTION		0.4f
#define SHADOW_MAP_RESOLUTION			0.2f

#define SKY_SIZE_DEFAULT		1000
#define SKY_DIV_COUNT_DEFAULT		16
#define SKY_TEXTURE_SIZE_DEFAULT	2000

#define CAMERA_MOVE_INVALID		0
#define CAMERA_MOVE_DONE			1
#define CAMERA_MOVE_REACH_END	2

#include <stdio.h>
#include <locale.h>
#include <tchar.h>
#include <d3dx11.h>
#include <d3dx11tex.h>
#include <math.h>
#include <xnamath.h>

#pragma comment( lib, "d3d11.lib" )
#pragma comment( lib, "d3dx11.lib" )

using namespace std;

#import "msxml3.dll"
using namespace MSXML2;

#define SAFE_RELEASE(p) { if( p ) { (p)->Release(); (p) = NULL;}}

////////////////////////////////////////////////////////////

#define BONE_TYPE_UNKNOWN	0
#define BONE_TYPE_NODE		1
#define BONE_TYPE_JOINT		2

#define LIGHT_NUM_MAX		16
#define DEFAULT_SUN_SIZE			30.0f
#define DEFAULT_MOON_SIZE		30.0f
#define EFFECT_TEXTURE_SIZE		512
#define PARTICLE_TEXTURE_SIZE		512
#define SIZE_EFFECT_PARAM2			6 * 16

#define COLLADA_ANIMATION_ID_DEFAULT	L"ColladaAnim_001"

#include "common.h"
#include "CCommonDevice.h"
#include "CVector.h"
#include "defcha3dcore.h"
#include "ChaDataObject.h"
#include "ChaResourceObject.h"
#include "CLight.h"
#include "CSky.h"
#include "CVolumeLight.h"
#include "C2DEffect.h"
#include "CParticle.h"

#endif