////////////////////////////////////////////////////////
// filename: CVolumeLight.h
// author: Chafumi Touji
// version: 1.0.0
// date: 2020/08/01
////////////////////////////////////////////////////////

#ifndef __CVOLUMELIGHT_H__
#define __CVOLUMELIGHT_H__

struct ConstantBufferVolumeLight{

	XMFLOAT4X4	MatWorldVL;
	XMFLOAT4X4	MatViewVL;
	XMFLOAT4X4	MatProjVL;
	XMFLOAT4		EyeVL;
	XMFLOAT4		EyePosVL;
	XMFLOAT4		MoveVL;
	XMFLOAT4		VolumeLightParam1;
	XMFLOAT4		VolumeLightParam2;
};

class CVolumeLight{
public:

	float						Width, Height;
	float						Resolution;
	int						PixelInterval;

	ID3D11Buffer				*m_pConstantBufferVolumeLight;
	ConstantBufferVolumeLight	constant_buffer_vl;

	ID3D11Texture2D				*m_pTextureVolumeLightOrg;
	ID3D11RenderTargetView		*m_pVolumeLightOrgRenderTargetView;
	ID3D11ShaderResourceView	*m_pVolumeLightOrgShaderResourceView;

public:
	CVolumeLight();
	~CVolumeLight();
	bool CreateResource(CCommonDevice *device, float resolution );
	bool DrawVolumeLight( CCommonDevice *device, CPointLight *light );
};

#endif