/////////////////////////////////////////////////
//
//  filename: DispWindow.h
//  author:Chafumi Touji
//  date: 2020/03/09 ver1.00
//
/////////////////////////////////////////////////

#ifndef __DISPWINDOW_H__
#define __DISPWINDOW_H__

class CConfig;

class CDispWindow{
public:

	CCommonDevice				*CommonDevice;
	CChaDataObject				*ChaDataObject1, *ChaDataObject2, *ChaDataObject3;
	CChaResourceObject		*ChaResourceObject1, *ChaResourceObject2, *ChaResourceObject3;
	CSky									*Sky;
	CPointLight 						**PointLight;
	CVolumeLight					*VolumeLight;

	int							PointLightNum;
	bool							IsAnimated;
	float4						BKColor;
	wchar_t					Path[SIZE_CHAR_MAX];

	HWND			m_hWnd;
	UINT			TimerID;
	float			FramePerSec;
	int				Status;

	int			Width, Height;
	int			DisplayWidth, DisplayHeight;
	int			ScreenWidth, ScreenHeight;
	bool			LButtonDown;
	bool			RButtonDown;
	CPoint		DownPoint;

	HANDLE				Thread;
	bool			Rock;
	bool			ReloadRock;
	bool			IsFullScreen;
	bool			BackFullScreen;
	bool			IsTransparent;
	int			TransparentR, TransparentG, TransparentB;

	CDispWindow();
	~CDispWindow();
	bool SetParam(CConfig *config);
	bool CreateWnd(HWND parent_wnd, int x, int y, int w, int h);
	bool InitLoad();
	bool Render();
	bool UpdateShaderLight();

public:
	void OnPaint();
	void OnKeyDown(UINT nChar);
	void OnLButtonDown(UINT nFlag, CPoint point);
	void OnLButtonUp(UINT nFlag, CPoint point);
	void OnRButtonDown(UINT nFlag, CPoint point);
	void OnRButtonUp(UINT nFlag, CPoint point);
	void OnMouseMove(UINT nFlag, CPoint point);
	void OnMouseWheel(UINT key, int delta, CPoint point);
	void OnSize(UINT nType, int cx, int cy);
	static unsigned __stdcall ThreadInitLoad(LPVOID pParam);

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT DispWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	static void CALLBACK  TimeUpdateCallback(UINT timer_id, UINT msg, LPTIMECALLBACK user, DWORD_PTR data1, DWORD_PTR data2);
};

#endif