/////////////////////////////////////////////////
//
//  filename: DispWindow.cpp
//  author:Chafumi Touji
//  date: 2020/03/09 ver1.00
//
/////////////////////////////////////////////////

#include "StdAfx.h"
#include "Main.h"
#include "defcha3dcore.h"
#include "MainWindow.h"
#include "MenuWindow.h"
#include "CustomButton.h"
#include "DispWindow.h"
#include "Config.h"

CDispWindow::CDispWindow(){

	LButtonDown = false;
	RButtonDown = false;
	TimerID = 0;
	DownPoint = CPoint(0, 0);
	FramePerSec = 0.0f;
	Status = STATUS_INIT;

	Width = 0;
	Height = 0;
	IsFullScreen = false;
	BackFullScreen = false;
	IsTransparent = false;

	TransparentR = COLOR_TRANSPARENT_R;
	TransparentG = COLOR_TRANSPARENT_G;
	TransparentB = COLOR_TRANSPARENT_B;

	ChaDataObject1 = NULL;
	ChaResourceObject1 = NULL;
	ChaDataObject2 = NULL;
	ChaResourceObject2 = NULL;
	ChaDataObject3 = NULL;
	ChaResourceObject3 = NULL;

	DisplayWidth = ::GetSystemMetrics(SM_CXSCREEN);
	DisplayHeight = ::GetSystemMetrics(SM_CYSCREEN);

	Rock = false;
	ReloadRock = false;

	CommonDevice = NULL;
	PointLight = NULL;
	Sky = NULL;
	VolumeLight = NULL;

	::CoInitialize(NULL);
}

CDispWindow::~CDispWindow(){

	timeKillEvent(TimerID);
}

/////////////////////////////////////////////////////////////////////////////

bool CDispWindow::SetParam(CConfig *config){

	wcscpy_s(Path, SIZE_CHAR_MAX, config->Path);
	BKColor.x = (float)config->ViewerBKColorR / 255.0f;
	BKColor.y = (float)config->ViewerBKColorG / 255.0f;
	BKColor.z = (float)config->ViewerBKColorB / 255.0f;
	BKColor.w = (float)config->ViewerBKColorA / 255.0f;
	CommonDevice->RotationX = config->RotationX;
	CommonDevice->RotationZ = config->RotationZ;
	CommonDevice->Eye.x = config->EyePosX;
	CommonDevice->Eye.y = config->EyePosY;
	CommonDevice->Eye.z = config->EyePosZ;
	CommonDevice->At.x = config->AtX;
	CommonDevice->At.y = config->AtY;
	CommonDevice->At.z = config->AtZ;
	ScreenWidth = config->ScreenWidth;
	ScreenHeight = config->ScreenHeight;

	return true;
}

bool CDispWindow::CreateWnd(HWND ParentWnd, int x, int y, int w, int h){

	WNDCLASSEX wcx;
	memset(&wcx, 0, sizeof(WNDCLASSEX));
	wcx.style = CS_HREDRAW | CS_VREDRAW;
	wcx.cbSize = sizeof(WNDCLASSEX);
	wcx.hInstance = NULL;
	wcx.hIcon = NULL;
	wcx.lpszMenuName = NULL;
	wcx.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcx.lpfnWndProc = &CDispWindow::WindowProc;
	wcx.lpszClassName = L"CLASS_DISPWINDOW";
	RegisterClassEx(&wcx);

	Width = w;
	Height = h;
	m_hWnd = CreateWindowEx(WS_EX_LEFT, L"CLASS_DISPWINDOW", _T("ModelViewer"), WS_CHILD, x, y, w, h, ParentWnd, NULL, NULL, NULL);
	::SetWindowLongPtr(m_hWnd, GWLP_USERDATA, (UINT_PTR) this);

	::ShowWindow(m_hWnd, SW_SHOW);
	if (TimerID == 0)
		TimerID = ::timeSetEvent(FPS, 1, (LPTIMECALLBACK)TimeUpdateCallback, (DWORD_PTR) this, TIME_PERIODIC);

	return true;
}

UINT  CDispWindow::ThreadInitLoad(LPVOID pParam){

	CDispWindow *disp_wnd = (CDispWindow *)pParam;

	//////////////////////////////////////////////////

	disp_wnd->CommonDevice = new CCommonDevice();
	disp_wnd->CommonDevice->CreateDevice(disp_wnd->m_hWnd, RESOLUTION_WIDTH, RESOLUTION_HEIGHT);

	disp_wnd->SetParam(theApp->MainWindow->Config);

	//////////////////////////////////////////////////////////
	//|CgCg쐬

	disp_wnd->PointLightNum = 3;
	disp_wnd->PointLight = (CPointLight **) new CPointLight*[3];
	for (int i = 0; i <= disp_wnd->PointLightNum - 1; i++)
		disp_wnd->PointLight[i] = new CPointLight();

	disp_wnd->PointLight[0]->CreatePointLight(disp_wnd->CommonDevice, -3, -10.8, 2, 0.5f);
	disp_wnd->PointLight[1]->CreatePointLight(disp_wnd->CommonDevice, -3, -2.8, 2, 0.5f);
	disp_wnd->PointLight[2]->CreatePointLight(disp_wnd->CommonDevice, 3.2, 5.2, 2, 0.5f);
	disp_wnd->PointLight[0]->SetShadowFar(2.5f);
	disp_wnd->PointLight[0]->SetShadowPower(1.5f);
	disp_wnd->PointLight[1]->SetShadowFar(2.5f);
	disp_wnd->PointLight[1]->SetShadowPower(1.5f);
	disp_wnd->PointLight[2]->SetShadowFar(2.5f);
	disp_wnd->PointLight[2]->SetShadowPower(1.5f);
	disp_wnd->PointLight[0]->SetLightColor(1.0f, 0.8f, 0.7f);
	disp_wnd->PointLight[1]->SetLightColor(1.0f, 0.8f, 0.7f);
	disp_wnd->PointLight[2]->SetLightColor(1.0f, 0.8f, 0.7f);

	//////////////////////////////////////////////////////////////
	//VF[_[Cgݒ

	disp_wnd->CommonDevice->ShaderLight[0] = XMFLOAT4(1.0, 0.8, 0.6, 1.0f); //sP
	disp_wnd->CommonDevice->ShaderLightPos[0] = XMFLOAT4(-3.5, -10.8, 2.5, 0);
	disp_wnd->CommonDevice->ShaderLight[1] = XMFLOAT4(1.0, 0.8, 0.6, 1.0f); //sQ
	disp_wnd->CommonDevice->ShaderLightPos[1] = XMFLOAT4(-3.5, -2.8, 2.5, 0);
	disp_wnd->CommonDevice->ShaderLight[2] = XMFLOAT4(1.0, 0.8, 0.6, 2.0f); //sR
	disp_wnd->CommonDevice->ShaderLightPos[2] = XMFLOAT4(3.2, 5.8, 2.5, 0);
	disp_wnd->CommonDevice->ShaderLight[3] = XMFLOAT4(1.0, 0.8, 0.6, 1.0f); //XCP
	disp_wnd->CommonDevice->ShaderLightPos[3] = XMFLOAT4(-7.0, 20.0, 1.5, 0);
	disp_wnd->CommonDevice->ShaderLight[4] = XMFLOAT4(1.0, 0.8, 0.6, 1.0f); //XCQ
	disp_wnd->CommonDevice->ShaderLightPos[4] = XMFLOAT4(-7.0, 3.0, 1.5, 0);
	disp_wnd->CommonDevice->ShaderLight[5] = XMFLOAT4(1.0, 0.8, 0.6, 1.0f); //XCR
	disp_wnd->CommonDevice->ShaderLightPos[5] = XMFLOAT4(7.0, 20.0, 2.5, 0);
	disp_wnd->CommonDevice->ShaderLight[6] = XMFLOAT4(1.0, 0.8, 0.6, 1.0f); //XCS
	disp_wnd->CommonDevice->ShaderLightPos[6] = XMFLOAT4(7.0, 5.0, 2.5, 0);
	disp_wnd->CommonDevice->ShaderLight[7] = XMFLOAT4(1.0, 0.8, 0.6, 1.0f); //XCT
	disp_wnd->CommonDevice->ShaderLightPos[7] = XMFLOAT4(7.0, -14.0, 2.5, 0);
	disp_wnd->CommonDevice->ShaderLight[8] = XMFLOAT4(1.0, 0.8, 0.6, 1.0f); //XCU
	disp_wnd->CommonDevice->ShaderLightPos[8] = XMFLOAT4(-7.0, -14.0, 2.5, 0);
	disp_wnd->CommonDevice->ShaderLight[9] = XMFLOAT4(1.0, 0.8, 0.7, 50.0f); //ƖP
	disp_wnd->CommonDevice->ShaderLightPos[9] = XMFLOAT4(26.0, 19.0, 2.0, 0);
	disp_wnd->CommonDevice->ShaderLight[10] = XMFLOAT4(1.0, 0.8, 0.7, 50.0f); //ƖQ
	disp_wnd->CommonDevice->ShaderLightPos[10] = XMFLOAT4(12.0, -55.0, 3.0, 0);
	disp_wnd->CommonDevice->ShaderLight[11] = XMFLOAT4(1.0, 0.8, 0.7, 50.0f); //ƖR
	disp_wnd->CommonDevice->ShaderLightPos[11] = XMFLOAT4(-15.0, -47.0, 3.0, 0);
	disp_wnd->CommonDevice->ShaderLight[12] = XMFLOAT4(1.0, 0.8, 0.7, 50.0f); //Ɩ4
	disp_wnd->CommonDevice->ShaderLightPos[12] = XMFLOAT4(26.0, -30.0, 4.0, 0);
	disp_wnd->CommonDevice->ShaderLight[13] = XMFLOAT4(1.0, 0.8, 0.7, 50.0f); //Ɩ5
	disp_wnd->CommonDevice->ShaderLightPos[13] = XMFLOAT4(-18.0, -25.0, 3.0, 0);
	disp_wnd->CommonDevice->ShaderLight[14] = XMFLOAT4(0, 0, 0, 0); //NULL
	disp_wnd->CommonDevice->ShaderLightPos[14] = XMFLOAT4(0, 0, 0, 0);
	disp_wnd->CommonDevice->ShaderLight[15] = XMFLOAT4(0, 0, 0, 0); //NULL
	disp_wnd->CommonDevice->ShaderLightPos[15] = XMFLOAT4(0, 0, 0, 0);

	/////////////////////////////////////////////////////////////////////////////

	disp_wnd->Sky = new CSky();
	wchar_t *img_path = theApp->MainWindow->Config->ImgPath;
	wchar_t *texture_cloud_name = theApp->MainWindow->Config->TextureCloudName;
	wchar_t *texture_star_name = theApp->MainWindow->Config->TextureStarName;
	wchar_t *texture_moon_name = theApp->MainWindow->Config->TextureMoonName;
	disp_wnd->Sky->SetInitParam(60, 60);
	disp_wnd->Sky->CreateResource(disp_wnd->CommonDevice, img_path, texture_cloud_name, texture_star_name, texture_moon_name);
	disp_wnd->Sky->SetMoonPos(-100, -1000, 120);
	disp_wnd->Sky->SetSunPos(100, 1000, -100);
	disp_wnd->Sky->SetMoonCrescentRate(0);
	disp_wnd->Sky->SetSceneTime(19, 20, 0);
	disp_wnd->Sky->SetCloudAlpha(1.5);

	////////////////////////////////////////////////////////////////////////////////

	disp_wnd->VolumeLight = new CVolumeLight();
	disp_wnd->VolumeLight->CreateResource(disp_wnd->CommonDevice );

	////////////////////////////////////////////////////////////////////////////////

	disp_wnd->IsAnimated = false; //LN^[Aj[Vsꍇtrueݒ肵ĂB

	::SetCurrentDirectory(L"./model/washitu");

	disp_wnd->ChaDataObject1 = new CChaDataObject();
	disp_wnd->ChaDataObject1->LoadDAE(DEFAULT_MODEL_NAME, EXT_DAE);
	disp_wnd->ChaResourceObject1 = new CChaResourceObject();
	disp_wnd->ChaResourceObject1->CreateResource(disp_wnd->CommonDevice, disp_wnd->ChaDataObject1, disp_wnd->IsAnimated);

	disp_wnd->ChaDataObject2 = new CChaDataObject();
	disp_wnd->ChaDataObject2->LoadDAE(SUZUNE_MODEL_NAME_1, EXT_DAE);
	disp_wnd->ChaResourceObject2 = new CChaResourceObject();
	disp_wnd->ChaResourceObject2->CreateResource(disp_wnd->CommonDevice, disp_wnd->ChaDataObject2, disp_wnd->IsAnimated);

	disp_wnd->ChaDataObject3 = new CChaDataObject();
	disp_wnd->ChaDataObject3->LoadDAE(SUZUNE_MODEL_NAME_2, EXT_DAE);
	disp_wnd->ChaResourceObject3 = new CChaResourceObject();
	disp_wnd->ChaResourceObject3->CreateResource(disp_wnd->CommonDevice, disp_wnd->ChaDataObject3, disp_wnd->IsAnimated);

	::SetCurrentDirectory(L"../..");

	disp_wnd->Status = STATUS_RUN;

	return true;
}

void CALLBACK  CDispWindow::TimeUpdateCallback(UINT timer_id, UINT msg, LPTIMECALLBACK user, DWORD_PTR data1, DWORD_PTR data2){

	CDispWindow *disp_wnd = (CDispWindow *)user;

	static bool init_load = false;
	if (init_load == false){
		init_load = true;
		disp_wnd->Status = STATUS_LOADING;

		::InvalidateRect(theApp->MainWindow->m_hWnd, NULL, false);
		::UpdateWindow(theApp->MainWindow->m_hWnd);

		disp_wnd->Thread = (HANDLE)_beginthreadex(NULL, 0, ThreadInitLoad, (void *) disp_wnd, 0, NULL);
	}

	if (disp_wnd->Status == STATUS_RUN){

		if (disp_wnd != NULL && disp_wnd->ChaResourceObject1 != NULL){
			disp_wnd->ChaResourceObject1->FrameCount += 3;
			disp_wnd->UpdateShaderLight();
		}
		if (disp_wnd != NULL && disp_wnd->Sky != NULL)
			disp_wnd->Sky->UpdateFrame();

		::InvalidateRect(disp_wnd->m_hWnd, NULL, false);
		::UpdateWindow(disp_wnd->m_hWnd);
	}

	::InvalidateRect(theApp->MainWindow->MenuWindow->m_hWnd, NULL, false);
	::UpdateWindow(theApp->MainWindow->MenuWindow->m_hWnd);
}

LRESULT CDispWindow::WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam){

	CDispWindow *disp_wnd = (CDispWindow *) ::GetWindowLongPtr(hwnd, GWLP_USERDATA);
	if (disp_wnd != NULL)
		disp_wnd->DispWindowProc(hwnd, message, wParam, lParam);

	return DefWindowProc(hwnd, message, wParam, lParam);
}

LRESULT CDispWindow::DispWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam){

	int width = 0;
	int height = 0;
	int x = 0;
	int y = 0;
	int delta = 0;
	int key = 0;

	switch (message){
	case WM_PAINT:
		OnPaint();
		break;
	case WM_SIZE:
		width = GET_X_LPARAM(lParam);
		height = GET_Y_LPARAM(lParam);
		OnSize((UINT)wParam, width, height);
		break;
	case WM_LBUTTONDOWN:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		OnLButtonDown((UINT)wParam, CPoint(x, y));
		break;
	case WM_LBUTTONUP:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		OnLButtonUp((UINT)wParam, CPoint(x, y));
		break;
	case WM_RBUTTONDOWN:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		OnRButtonDown((UINT)wParam, CPoint(x, y));
		break;
	case WM_RBUTTONUP:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		OnRButtonUp((UINT)wParam, CPoint(x, y));
		break;
	case WM_MOUSEMOVE:
		::SetFocus(m_hWnd);
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		OnMouseMove((UINT)wParam, CPoint(x, y));
		break;
	case WM_MOUSEWHEEL:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		key = GET_KEYSTATE_WPARAM(wParam);
		delta = GET_WHEEL_DELTA_WPARAM(wParam);
		OnMouseWheel(key, delta, CPoint(x, y));
		break;
	case WM_KEYDOWN:
		OnKeyDown(wParam);
		break;
	default:
		break;
	}

	return 0;
}

void CDispWindow::OnKeyDown(UINT nChar){

	if (nChar == 32 /* enter */){

		if (IsTransparent == false){
			BackFullScreen = theApp->MainWindow->IsMaximized;
			IsFullScreen = true;
		}
		else{
			IsFullScreen = BackFullScreen;
		}

		IsTransparent = !IsTransparent;
		if (IsFullScreen == true){
			::ShowWindow(theApp->MainWindow->m_hWnd, SW_MAXIMIZE);
			theApp->MainWindow->OnSize(SIZE_MAXIMIZED, DisplayWidth, DisplayHeight);
		}
		else{
			::ShowWindow(theApp->MainWindow->m_hWnd, SW_RESTORE);
			theApp->MainWindow->OnSize(SIZE_RESTORED, Width, Height);
		}
		::InvalidateRect(m_hWnd, NULL, false);
		::UpdateWindow(m_hWnd);
	}
}

void CDispWindow::OnSize(UINT nType, int cx, int cy){

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

bool CDispWindow::UpdateShaderLight(){

	static float time = 0.0f;
	time += 0.03f;
	if (time > 3.14159265f * 2.0f)
		time = 0.0f;

	float light_power_0 = 0.3f + sin(time + 2.36) * 0.03f;
	float light_power_1 = 0.3f + sin(time + 5.24) * 0.03f;
	float light_power_2 = 0.3f + sin(time + 4.58) * 0.03f;
	float light_power_3 = 0.8f + sin(time + 0.24) * 0.5f;
	float light_power_4 = 0.8f + sin(time + 3.89) * 0.5f;
	float light_power_5 = 0.8f + sin(time + 5.36) * 0.5f;
	float light_power_6 = 0.8f + sin(time + 7.47) * 0.5f;
	float light_power_7 = 0.8f + sin(time + 2.38) * 0.5f;
	float light_power_8 = 0.8f + sin(time + 5.79) * 0.5f;
	float light_power_9 = 50.0f + sin(time + 1.35) * 10.0f;
	float light_power_10 = 50.0f + sin(time + 3.24) * 10.0f;
	float light_power_11 = 50.0f + sin(time + 5.87) * 10.0f;
	float light_power_12 = 50.0f + sin(time + 1.34) * 10.0f;
	float light_power_13 = 50.0f + sin(time + 6.46) * 10.0f;

	PointLight[0]->SetPower(light_power_0);
	PointLight[1]->SetPower(light_power_1);
	PointLight[2]->SetPower(light_power_2);

	CommonDevice->ShaderLight[0] = XMFLOAT4(0.9, 0.6, 0.4, light_power_0); //sP
	CommonDevice->ShaderLight[1] = XMFLOAT4(0.9, 0.6, 0.4, light_power_1); //sQ
	CommonDevice->ShaderLight[2] = XMFLOAT4(0.9, 0.6, 0.4, light_power_2); //sR
	CommonDevice->ShaderLight[3] = XMFLOAT4(0.9, 0.6, 0.4, light_power_3); //XCP
	CommonDevice->ShaderLight[4] = XMFLOAT4(0.9, 0.6, 0.4, light_power_4); //XCQ
	CommonDevice->ShaderLight[5] = XMFLOAT4(0.9, 0.6, 0.4, light_power_5); //XCR
	CommonDevice->ShaderLight[6] = XMFLOAT4(0.9, 0.6, 0.4, light_power_6); //XCS
	CommonDevice->ShaderLight[7] = XMFLOAT4(0.9, 0.6, 0.4, light_power_7); //XCT
	CommonDevice->ShaderLight[8] = XMFLOAT4(0.9, 0.6, 0.4, light_power_8); //XCU
	CommonDevice->ShaderLight[9] = XMFLOAT4(1.0, 0.8, 0.7, light_power_9); //ƖP
	CommonDevice->ShaderLight[10] = XMFLOAT4(1.0, 0.8, 0.7, light_power_10); //ƖQ
	CommonDevice->ShaderLight[11] = XMFLOAT4(1.0, 0.8, 0.7, light_power_11); //ƖR
	CommonDevice->ShaderLight[12] = XMFLOAT4(1.0, 0.8, 0.7, light_power_12); //Ɩ4
	CommonDevice->ShaderLight[13] = XMFLOAT4(1.0, 0.8, 0.7, light_power_13); //Ɩ5

	return true;
}

bool CDispWindow::Render(){

	float wh = (float)Height / (float)Width;
	if (theApp->MainWindow->IsMaximized == true){
		if (IsTransparent == true)
			wh = (float)ScreenHeight / (float)ScreenWidth;
		else
			wh = (float)ScreenHeight / (float)(ScreenWidth - theApp->MainWindow->MenuWindowWidth);
	}

	CommonDevice->SetViewParam(ScreenWidth, ScreenHeight, (float)RESOLUTION_WIDTH / (float)RESOLUTION_HEIGHT);

	D3D11_VIEWPORT vp;
	vp.Width = ScreenWidth;
	vp.Height = ScreenHeight;
	vp.TopLeftX = 0;
	vp.TopLeftY = 0;
	vp.MinDepth = 0.0f;
	vp.MaxDepth = 1.0f;
	CommonDevice->m_pDeviceContext->RSSetViewports(1, &vp);

	// VhE}bv
	static bool init_load = false;
	if (PointLight != NULL && init_load == false){

		init_load = true; //ŏɂP񂾂VhE}bv쐬B

		for (int i = 0; i <= PointLightNum - 1; i++)
			PointLight[i]->DrawShadowMap(CommonDevice, ChaResourceObject1);
	}

	///////////////////////////////////////////////////////////////
	//̕`

	float clear_color[4] = { 0, 0, 0, 0 };
	float clear_color_depth[4] = { 10000.0f, 10000.0f, 0, 0 };

	if (Sky != NULL){
		CommonDevice->m_pDeviceContext->OMSetRenderTargets(1, &CommonDevice->m_pDiffuseRenderTargetView, NULL);
		CommonDevice->m_pDeviceContext->ClearRenderTargetView(CommonDevice->m_pDiffuseRenderTargetView, clear_color);
		Sky->Draw(CommonDevice);
	}

	///////////////////////////////////////////////////////////////
	//VhE̕`

	for (int i = 0; i <= PointLightNum - 1; i++)
		PointLight[i]->Draw(CommonDevice, ChaResourceObject1);

	////////////////////////////////////////////////////////////////////////
	//bV̕`

	CommonDevice->m_pDeviceContext->RSSetState(CommonDevice->m_pRasterizeState);
	CommonDevice->m_pDeviceContext->OMSetBlendState(CommonDevice->m_pBlendState1, NULL, 0xffffffff);
	CommonDevice->m_pDeviceContext->VSSetConstantBuffers(0, 1, &CommonDevice->m_pConstantBuffer1);
	CommonDevice->m_pDeviceContext->PSSetConstantBuffers(0, 1, &CommonDevice->m_pConstantBuffer1);

	if (IsAnimated == true)
		CommonDevice->m_pDeviceContext->VSSetShader(CommonDevice->m_pVtxShader1, NULL, 0);
	else
		CommonDevice->m_pDeviceContext->VSSetShader(CommonDevice->m_pVtxShader1_1, NULL, 0);

	CommonDevice->m_pDeviceContext->ClearDepthStencilView(CommonDevice->m_pDepthStencilView, D3D11_CLEAR_DEPTH | D3D11_CLEAR_STENCIL, 1.0, 0);
	CommonDevice->m_pDeviceContext->ClearRenderTargetView(CommonDevice->m_pDepthRenderTargetView, clear_color_depth);

	ID3D11RenderTargetView *rtview[2] = { CommonDevice->m_pDiffuseRenderTargetView, CommonDevice->m_pDepthRenderTargetView };
	CommonDevice->m_pDeviceContext->OMSetRenderTargets(2, rtview, CommonDevice->m_pDepthStencilView);

	/*-------------------------------------*/
	//̕`

	CommonDevice->m_pDeviceContext->PSSetShader(CommonDevice->m_pPxShader1, NULL, 0);

	if (ChaResourceObject1 != NULL){
		ChaResourceObject1->UpdateTransform();
		ChaResourceObject1->Draw(CommonDevice);
	}

	/*-------------------------------------*/
	//q̕`

	CommonDevice->m_pDeviceContext->PSSetShader(CommonDevice->m_pPxShader8, NULL, 0);

	if (ChaResourceObject2 != NULL){
		ChaResourceObject2->UpdateTransform();
		ChaResourceObject2->Draw(CommonDevice);
	}

	if (ChaResourceObject3 != NULL){
		ChaResourceObject3->UpdateTransform();
		ChaResourceObject3->Draw(CommonDevice);
	}

	/////////////////////////////////////////////////////////////
	//{[Cg

	if (VolumeLight != NULL){
		VolumeLight->DrawVolumeLight(CommonDevice, PointLight[0]);
		VolumeLight->DrawVolumeLight(CommonDevice, PointLight[1]);
		VolumeLight->DrawVolumeLight(CommonDevice, PointLight[2]);
	}

	/////////////////////////////////////////////////////////////
	// _O

	if (IsTransparent == false){
		float clear_color2[4] = { BKColor.x, BKColor.y, BKColor.z, 1.0f };
		CommonDevice->m_pDeviceContext->OMSetRenderTargets(1, &CommonDevice->m_pGDIRenderTargetView, NULL);
		CommonDevice->m_pDeviceContext->ClearRenderTargetView(CommonDevice->m_pGDIRenderTargetView, clear_color2);
		CommonDevice->m_pDeviceContext->OMSetRenderTargets(1, &CommonDevice->m_pRenderTargetView, NULL);
		CommonDevice->m_pDeviceContext->ClearRenderTargetView(CommonDevice->m_pRenderTargetView, clear_color2);
	}
	else{
		float clear_color2[4] = { (float)TransparentR / 255.0f, (float)TransparentG / 255.0f, (float)TransparentB / 255.0f, 1.0f };
		CommonDevice->m_pDeviceContext->OMSetRenderTargets(1, &CommonDevice->m_pGDIRenderTargetView, NULL);
		CommonDevice->m_pDeviceContext->ClearRenderTargetView(CommonDevice->m_pGDIRenderTargetView, clear_color2);
	}

	CommonDevice->m_pDeviceContext->VSSetShader(CommonDevice->m_pVtxShader2, NULL, 0);
	CommonDevice->m_pDeviceContext->PSSetShader(CommonDevice->m_pPxShader2, NULL, 0);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(0, 1, &CommonDevice->m_pDiffuseShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(2, 1, &PointLight[0]->m_pShadowMapSoftShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(3, 1, &PointLight[1]->m_pShadowMapSoftShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(4, 1, &PointLight[2]->m_pShadowMapSoftShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(8, 1, &PointLight[0]->m_pVolumeLightShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(9, 1, &PointLight[1]->m_pVolumeLightShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetShaderResources(10, 1, &PointLight[2]->m_pVolumeLightShaderResourceView);
	CommonDevice->m_pDeviceContext->PSSetSamplers(0, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(1, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(2, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(3, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(4, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(8, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(9, 1, &CommonDevice->m_pSampleState);
	CommonDevice->m_pDeviceContext->PSSetSamplers(10, 1, &CommonDevice->m_pSampleState);

	UINT stride = sizeof(CVertex);
	UINT offset = 0;
	CommonDevice->m_pDeviceContext->IASetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP);

	CommonDevice->m_pDeviceContext->IASetVertexBuffers(0, 1, &CommonDevice->VertexBuffer, &stride, &offset);
	CommonDevice->m_pDeviceContext->Draw(4, 0);

	return true;
}

void CDispWindow::OnPaint(){

	if (Status != STATUS_RUN)
		return;

	Rock = false;

	PAINTSTRUCT ps;
	HDC hdc = ::BeginPaint(m_hWnd, &ps);
	if (CommonDevice != NULL && CommonDevice->m_pDevice != NULL && Rock == false && ReloadRock == false){

		///////////////////////////////////////////////////////////
		//t[[gvZ

		SYSTEMTIME	st;
		::GetSystemTime(&st);

		unsigned int t = st.wSecond * 1000 + st.wMilliseconds;
		static unsigned int prev_time = 0;
		static unsigned int count_sec = 0;
		if (prev_time > t)
			prev_time -= 60 * 1000;
		int interval = t - prev_time;
		count_sec += interval;
		prev_time = t;
		static int count_frame = 0;
		count_frame++;
		if (count_sec > 1000){

			FramePerSec = (float)count_frame * 1000.0f / (float)count_sec;
			count_frame = 0;
			count_sec = 0;

			::InvalidateRect(theApp->MainWindow->m_hWnd, NULL, false);
			::UpdateWindow(theApp->MainWindow->m_hWnd);
		}

		///////////////////////////////////////////////////////////

		static bool prev_transparent = false;

		if (IsTransparent == false){
			Rock = true;
			Render();
			CommonDevice->m_pSwapChain->Present(0, 0);

			if (prev_transparent == true){
				prev_transparent = false;

				HDC hDC = NULL;
				CommonDevice->m_pSurface->GetDC(false, &hDC);
				::StretchBlt(hdc, 0, 0, DisplayWidth, DisplayHeight, hDC, 0, 0, ScreenWidth, ScreenHeight, SRCCOPY);
				CommonDevice->m_pSurface->ReleaseDC(NULL);
			}
			Rock = false;
		}
		else{
			prev_transparent = true;
			Rock = true;
			Render();

			::SetWindowPos(theApp->MainWindow->m_hWnd, HWND_TOPMOST, 0, 0, DisplayWidth, DisplayHeight, SWP_SHOWWINDOW);

			HDC hDC = NULL;
			CommonDevice->m_pSurface->GetDC(false, &hDC);
			::StretchBlt(hdc, 0, 0, DisplayWidth, DisplayHeight, hDC, 0, 0, ScreenWidth, ScreenHeight, SRCCOPY);
			CommonDevice->m_pSurface->ReleaseDC(NULL);

			Rock = false;
		}
	}
	::EndPaint(m_hWnd, &ps);
}

void CDispWindow::OnLButtonDown(UINT nFlag, CPoint point){

	LButtonDown = true;

	::ClientToScreen(m_hWnd, &point);
	DownPoint = point;
	LButtonDown = true;
	::SetCapture(m_hWnd);

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CDispWindow::OnRButtonDown(UINT nFlag, CPoint point){

	RButtonDown = true;

	::ClientToScreen(m_hWnd, &point);
	DownPoint = point;
	RButtonDown = true;
	::SetCapture(m_hWnd);

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CDispWindow::OnLButtonUp(UINT nFlag, CPoint point){

	::ReleaseCapture();
	LButtonDown = false;

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CDispWindow::OnRButtonUp(UINT nFlag, CPoint point){

	::ReleaseCapture();
	RButtonDown = false;

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CDispWindow::OnMouseMove(UINT nFlag, CPoint point){

	::ClientToScreen(m_hWnd, &point);

	if (RButtonDown == true){
		int move_x = point.x - DownPoint.x;
		int move_y = point.y - DownPoint.y;
		CommonDevice->RotationX -= move_y * 0.03f;
		CommonDevice->RotationZ -= move_x * 0.03f;

		int rot_x = (int)(CommonDevice->RotationX / (3.14159265f * 2.0f));
		CommonDevice->RotationX -= ((float)rot_x) * 3.14159265f * 2.0f;
		if (CommonDevice->RotationX < 0.001f)
			CommonDevice->RotationX = 0.001f;
		if (CommonDevice->RotationX > 3.14159265f / 2.0f)
			CommonDevice->RotationX = 3.14159265f / 2.0f;

		int rot_z = (int)(CommonDevice->RotationZ / (3.14159265f * 2.0f));
		CommonDevice->RotationZ -= ((float)rot_z) * 3.14159265f * 2.0f;
	}
	else if (LButtonDown == true){
		int move_x = point.x - DownPoint.x;
		int move_y = point.y - DownPoint.y;

		float m_x = move_x * 10.0f;
		float m_y = move_y * 10.0f;
		if (theApp->MainWindow->IsMaximized == true){
			m_x /= (float)DisplayWidth;
			m_y /= (float)DisplayHeight;
		}
		else{
			m_x /= (float)Width;
			m_y /= (float)Height;
		}
		float m_z = 0.0f;

		XMVECTOR vec;
		XMVECTOR at = XMVectorSet(CommonDevice->At.x, CommonDevice->At.y, CommonDevice->At.z, 0.0f);
		XMVECTOR up = XMVectorSet(0, 0, 1, 0.0f);
		XMVECTOR eye = XMVectorSet(CommonDevice->Eye.x + CommonDevice->At.x, CommonDevice->Eye.y + CommonDevice->At.y, CommonDevice->Eye.z + CommonDevice->At.z, 0.0f);
		XMMATRIX view = XMMatrixInverse(&vec, XMMatrixLookAtLH(eye, at, up));
		XMVECTOR move = XMVector4Transform(XMVectorSet(m_x, m_y, 0.0f, 0.0f), view);

		float mx = XMVectorGetX(move);
		float my = XMVectorGetY(move);
		float mz = XMVectorGetZ(move);

		CommonDevice->At.x += mx;
		CommonDevice->At.y += my;
		CommonDevice->At.z += mz;
		CommonDevice->Move.x += mx;
		CommonDevice->Move.y += my;
		CommonDevice->Move.z += mz;
	}

	DownPoint = point;

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CDispWindow::OnMouseWheel(UINT nFlag, int zDelta, CPoint point){

	CommonDevice->Zoom -= ((float)zDelta) * 0.01f;
	if (CommonDevice->Zoom < 0.1f)
		CommonDevice->Zoom = 0.1f;

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}