/////////////////////////////////////////////////
//
//  filename: CustomButton.jpp
//  author:Chafumi Touji
//  date: 2018/04/03 ver1.00
//		  2020/02/06 ver1.01
//
/////////////////////////////////////////////////

#include "StdAfx.h"
#include "Main.h"
#include "CustomButton.h"
#include "DialogFileSelect.h"
#include "DispWindow.h"
#include "MainWindow.h"
#include "MenuWindow.h"
#include "Config.h"

CCustomButton::CCustomButton(){

	Width = 0;
	Height = 0;
	PosX = PosY = 0;
	LButtonDown = false;
	ButtonImage = NULL;
	ButtonDownImage = NULL;
	FrameEdgeX = 0;
	FrameEdgeY = 0;
	BKColorA = 255;
	BKColorR = 0;
	BKColorG = 0;
	BKColorB = 0;
}

CCustomButton::~CCustomButton(){

}

bool CCustomButton::Action(){

	return true;
}

void CCustomButton::OnLButtonDown(UINT nFlag, CPoint point){

	::SetCapture( m_hWnd );
	LButtonDown = true;

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CCustomButton::OnLButtonUp(UINT nFlag, CPoint point){

	::ReleaseCapture();
	LButtonDown = false;

	Action();

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CCustomButton::OnPaint(){

	PAINTSTRUCT ps;
	HDC hdc = ::BeginPaint(m_hWnd, &ps);
	OnDraw(hdc);
	::EndPaint(m_hWnd, &ps);
}

bool CCustomButton::SetColor(int a, int r, int g, int b){

	BKColorA = a;
	BKColorR = r;
	BKColorG = g;
	BKColorB = b;

	return true;
}

bool CCustomButton::OnDraw(HDC hdc){

	Gdiplus::Graphics *gfc = new Gdiplus::Graphics(hdc);

	Gdiplus::SolidBrush *brush = new Gdiplus::SolidBrush(Gdiplus::Color(BKColorA, BKColorR, BKColorG, BKColorB));
	gfc->FillRectangle(brush, FrameEdgeX, FrameEdgeY, Width, Height);
	delete brush;

	if (LButtonDown == true)
		gfc->DrawImage(ButtonDownImage, FrameEdgeX, FrameEdgeY, Width, Height);
	else
		gfc->DrawImage(ButtonImage, FrameEdgeX, FrameEdgeY, Width, Height);

	delete gfc;

	return true;
}

bool CCustomButton::OnDraw(HDC hdc, int pos_x, int pos_y, int width, int height ){

	Gdiplus::Graphics *gfc = new Gdiplus::Graphics(hdc);

	Gdiplus::SolidBrush *brush = new Gdiplus::SolidBrush(Gdiplus::Color(BKColorA, BKColorR, BKColorG, BKColorB));
	gfc->FillRectangle(brush, pos_x, pos_y, width, height);
	delete brush;

	if (LButtonDown == true)
		gfc->DrawImage(ButtonDownImage, pos_x, pos_y, width, height);
	else
		gfc->DrawImage(ButtonImage, pos_x, pos_y, width, height);

	delete gfc;

	return true;
}

bool CCustomButton::CreateWnd(int x, int y, int w, int h, HWND ParentWnd){

	WNDCLASSEX wcx;
	memset(&wcx, 0, sizeof(WNDCLASSEX));
	wcx.style = CS_HREDRAW | CS_VREDRAW;
	wcx.cbSize = sizeof(WNDCLASSEX);
	wcx.hInstance = NULL;
	wcx.hIcon = NULL;
	wcx.lpszMenuName = NULL;
	wcx.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcx.lpfnWndProc = &CCustomButton::WindowProc;
	wcx.lpszClassName = L"CLASS_CUSTOMBUTTON";
	RegisterClassEx(&wcx);

	PosX = x;
	PosY = y;
	Width = w;
	Height = h;

	m_hWnd = CreateWindowEx(WS_EX_LEFT, L"CLASS_CUSTOMBUTTON", L"", WS_CHILD, PosX, PosY, Width, Height, ParentWnd, NULL, NULL, NULL);
	::SetWindowLongPtr(m_hWnd, GWLP_USERDATA, (UINT_PTR) this);

	::ShowWindow(m_hWnd, SW_SHOW);

	return true;
}

LRESULT CCustomButton::WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam){

	CCustomButton *button = (CCustomButton *) ::GetWindowLongPtr(hwnd, GWLP_USERDATA);
	if (button != NULL)
		button->CustomButtonWindowProc(hwnd, message, wParam, lParam);

	return DefWindowProc(hwnd, message, wParam, lParam);
}

LRESULT CCustomButton::CustomButtonWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam){

	int width = 0;
	int height = 0;
	int x = 0;
	int y = 0;

	switch (message){
	case WM_PAINT:
		OnPaint();
		break;
	case WM_LBUTTONDOWN:
		x = LOWORD(lParam);
		y = HIWORD(lParam);
		OnLButtonDown((UINT)wParam, CPoint(x, y));
		break;
	case WM_LBUTTONUP:
		x = LOWORD(lParam);
		y = HIWORD(lParam);
		OnLButtonUp((UINT)wParam, CPoint(x, y));
		break;
	default:
		break;
	}

	return 0;
}

bool CCustomButton::SetImage(wchar_t* button_img_path, wchar_t * button_down_img_path){

	ButtonImage = Image::FromFile(button_img_path);
	ButtonDownImage = Image::FromFile(button_down_img_path);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonClose::Action(){
	
	if (theApp->MainWindow->Config != NULL){
		::SetCurrentDirectory(theApp->MainWindow->InitDirectory);
		theApp->MainWindow->Config->WriteConfigFile(L"config.ini");
	}

	::SendMessage(theApp->MainWindow->m_hWnd, WM_DESTROY, 0, 0);
	PostQuitMessage(1);

	return true;
}


///////////////////////////////////////////////////////////////////////////////

bool CButtonDialogClose::Action(){

	::EnableWindow(theApp->MainWindow->m_hWnd, true);
	::SetWindowPos(theApp->MainWindow->FileSelectDialog->m_hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOZORDER | SWP_NOMOVE | SWP_NOSIZE | SWP_HIDEWINDOW);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonMinimize::Action(){

	CMainWindow *main_wnd = (CMainWindow *) theApp->MainWindow;
	::ShowWindow(main_wnd->m_hWnd, SW_MINIMIZE);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonMaximize::Action(){

	CMainWindow *main_wnd = (CMainWindow *)theApp->MainWindow;
	if (main_wnd->IsMaximized == true){
		::ShowWindow(main_wnd->m_hWnd, SW_RESTORE);
		main_wnd->IsMaximized = false;
	}
	else{
		::ShowWindow( main_wnd->m_hWnd, SW_MAXIMIZE);
		main_wnd->IsMaximized = true;
	}
	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonModelOpen::Action(){

	theApp->MainWindow->FileSelectDialog->OpenType = OPEN_TYPE_LOAD_MODEL;
	theApp->MainWindow->FileSelectDialog->SelectList->ItemCount = 0;
	theApp->MainWindow->FileSelectDialog->SelectList->ItemBegin = 0;
	theApp->MainWindow->FileSelectDialog->SelectList->SelectedNum = -1;
	theApp->MainWindow->FileSelectDialog->SelectList->ScrollV->BarHeight = 0;
	theApp->MainWindow->FileSelectDialog->SelectList->ScrollV->BarPosY = 0;
	theApp->MainWindow->FileSelectDialog->SelectList->GetItem();

	::EnableWindow(theApp->MainWindow->m_hWnd, false);

	wmemset(theApp->MainWindow->FileSelectDialog->SelectList->CurrentFileName, 0, SIZE_CHAR_MAX);
	wmemset(theApp->MainWindow->FileSelectDialog->SelectList->CurrentPath, 0, SIZE_CHAR_MAX);

	::SetWindowPos(theApp->MainWindow->FileSelectDialog->m_hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_SHOWWINDOW);

	::InvalidateRect(theApp->MainWindow->FileSelectDialog->m_hWnd, NULL, false);
	::UpdateWindow(theApp->MainWindow->FileSelectDialog->m_hWnd);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonModelWrite::Action(){

	theApp->MainWindow->FileSelectDialog->OpenType = OPEN_TYPE_WRITE_MODEL;
	theApp->MainWindow->FileSelectDialog->SelectList->ItemCount = 0;
	theApp->MainWindow->FileSelectDialog->SelectList->ItemBegin = 0;
	theApp->MainWindow->FileSelectDialog->SelectList->SelectedNum = -1;
	theApp->MainWindow->FileSelectDialog->SelectList->ScrollV->BarHeight = 0;
	theApp->MainWindow->FileSelectDialog->SelectList->ScrollV->BarPosY = 0;
	theApp->MainWindow->FileSelectDialog->SelectList->GetItem();

	::EnableWindow(theApp->MainWindow->m_hWnd, false);

	wmemset(theApp->MainWindow->FileSelectDialog->SelectList->CurrentFileName, 0, SIZE_CHAR_MAX);
	wmemset(theApp->MainWindow->FileSelectDialog->SelectList->CurrentPath, 0, SIZE_CHAR_MAX);

	::SetWindowPos(theApp->MainWindow->FileSelectDialog->m_hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_SHOWWINDOW);

	::InvalidateRect(theApp->MainWindow->FileSelectDialog->m_hWnd, NULL, false);
	::UpdateWindow(theApp->MainWindow->FileSelectDialog->m_hWnd);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonAnimOpen::Action(){

	theApp->MainWindow->FileSelectDialog->OpenType = OPEN_TYPE_LOAD_ANIMATION;
	theApp->MainWindow->FileSelectDialog->SelectList->ItemCount = 0;
	theApp->MainWindow->FileSelectDialog->SelectList->ItemBegin = 0;
	theApp->MainWindow->FileSelectDialog->SelectList->SelectedNum = -1;
	theApp->MainWindow->FileSelectDialog->SelectList->ScrollV->BarHeight = 0;
	theApp->MainWindow->FileSelectDialog->SelectList->ScrollV->BarPosY = 0;
	theApp->MainWindow->FileSelectDialog->SelectList->GetItem();

	::EnableWindow(theApp->MainWindow->m_hWnd, false);

	wmemset(theApp->MainWindow->FileSelectDialog->SelectList->CurrentFileName, 0, SIZE_CHAR_MAX);
	wmemset(theApp->MainWindow->FileSelectDialog->SelectList->CurrentPath, 0, SIZE_CHAR_MAX);

	::SetWindowPos(theApp->MainWindow->FileSelectDialog->m_hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_SHOWWINDOW);

	::InvalidateRect(theApp->MainWindow->FileSelectDialog->m_hWnd, NULL, false);
	::UpdateWindow(theApp->MainWindow->FileSelectDialog->m_hWnd);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonAnimWrite::Action(){

	theApp->MainWindow->FileSelectDialog->OpenType = OPEN_TYPE_WRITE_ANIMATION;
	theApp->MainWindow->FileSelectDialog->SelectList->ItemCount = 0;
	theApp->MainWindow->FileSelectDialog->SelectList->ItemBegin = 0;
	theApp->MainWindow->FileSelectDialog->SelectList->SelectedNum = -1;
	theApp->MainWindow->FileSelectDialog->SelectList->ScrollV->BarHeight = 0;
	theApp->MainWindow->FileSelectDialog->SelectList->ScrollV->BarPosY = 0;
	theApp->MainWindow->FileSelectDialog->SelectList->GetItem();

	::EnableWindow(theApp->MainWindow->m_hWnd, false);

	wmemset(theApp->MainWindow->FileSelectDialog->SelectList->CurrentFileName, 0, SIZE_CHAR_MAX);
	wmemset(theApp->MainWindow->FileSelectDialog->SelectList->CurrentPath, 0, SIZE_CHAR_MAX);

	::SetWindowPos(theApp->MainWindow->FileSelectDialog->m_hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_SHOWWINDOW);

	::InvalidateRect(theApp->MainWindow->FileSelectDialog->m_hWnd, NULL, false);
	::UpdateWindow(theApp->MainWindow->FileSelectDialog->m_hWnd);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonDir::Action(){

	//̃fBNgɈړ
	CMainWindow *main_wnd = (CMainWindow *)theApp->MainWindow;

	main_wnd->FileSelectDialog->SelectList->ItemCount = 0;
	main_wnd->FileSelectDialog->SelectList->ItemBegin = 0;
	main_wnd->FileSelectDialog->SelectList->SelectedNum = -1;
	main_wnd->FileSelectDialog->SelectList->ScrollV->BarHeight = 0;
	main_wnd->FileSelectDialog->SelectList->ScrollV->BarPosY = 0;

	wchar_t path[SIZE_CHAR_MAX];
	wmemset(path, 0, SIZE_CHAR_MAX);
	wcscpy_s(path, SIZE_CHAR_MAX, main_wnd->FileSelectDialog->SelectList->CurrentPath);
	int pos = wcslen(path);
	if (pos <= 3 && main_wnd->FileSelectDialog->SelectList->SelectDriveMode == false){
		//hCu擾
		wmemset(main_wnd->FileSelectDialog->SelectList->CurrentFileName, 0, SIZE_CHAR_MAX);
		main_wnd->FileSelectDialog->SelectList->SelectDriveMode = true;
	}
	else{
		//fBNgݒ

		wchar_t c[16];
		wmemset(c, 0, 16);
		while (pos >= 1){
			c[0] = path[pos];
			if (wcscmp(c, L"\\") == 0 || wcscmp(c, L"/") == 0)
				break;
			pos--;
		}
		wmemset(main_wnd->FileSelectDialog->SelectList->CurrentPath, 0, SIZE_CHAR_MAX);
		wmemcpy_s(main_wnd->FileSelectDialog->SelectList->CurrentPath, pos, path, pos);

		wchar_t new_path[SIZE_CHAR_MAX];
		wmemset(new_path, 0, SIZE_CHAR_MAX);
		wcscpy_s(new_path, SIZE_CHAR_MAX, main_wnd->FileSelectDialog->SelectList->CurrentPath);
		wcscat_s(new_path, SIZE_CHAR_MAX, L"\\");
		SetCurrentDirectory(new_path);
		wmemset(main_wnd->FileSelectDialog->SelectList->CurrentFileName, 0, SIZE_CHAR_MAX);
	}

	::InvalidateRect(main_wnd->FileSelectDialog->m_hWnd, NULL, false);
	::UpdateWindow(main_wnd->FileSelectDialog->m_hWnd);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonCancel::Action(){

	::EnableWindow(theApp->MainWindow->m_hWnd, true);
	::SetWindowPos(theApp->MainWindow->FileSelectDialog->m_hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_HIDEWINDOW);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonOK::Action(){
	
	theApp->MainWindow->FileSelectDialog->ConfirmDialog->Execute = false;
	::GetWindowTextW(theApp->MainWindow->FileSelectDialog->EditWnd->m_hWnd, theApp->MainWindow->FileSelectDialog->SelectList->CurrentFileName, SIZE_CHAR_MAX);

	if (wcslen(theApp->MainWindow->FileSelectDialog->SelectList->CurrentFileName) > 0 && theApp->MainWindow->FileSelectDialog->SelectList->FileType != FILE_TYPE_DIRECTORY ){

		wchar_t path[SIZE_CHAR_MAX];
		wmemset(path, 0, SIZE_CHAR_MAX);
		wcscpy_s(path, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->CurrentPath);
		wcscat_s(path, SIZE_CHAR_MAX, L"\\");
		wcscat_s(path, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->CurrentFileName);

		theApp->MainWindow->FileSelectDialog->ConfirmDialog->Execute = true;

		if (theApp->MainWindow->FileSelectDialog->OpenType == OPEN_TYPE_WRITE_MODEL || theApp->MainWindow->FileSelectDialog->OpenType == OPEN_TYPE_WRITE_ANIMATION){

			//㏑mFB

			FILE *file = NULL;
			_wfopen_s(&file, path, L"r");
			if (file != NULL){

				//t@C݂B
				::SetWindowPos(theApp->MainWindow->FileSelectDialog->ConfirmDialog->m_hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_SHOWWINDOW);

				theApp->MainWindow->FileSelectDialog->ConfirmDialog->ConfirmLoop = true;
				::EnableWindow(theApp->MainWindow->FileSelectDialog->m_hWnd, false);

				MSG msg;
				while (GetMessage(&msg, NULL, 0, 0) > 0 && theApp->MainWindow->FileSelectDialog->ConfirmDialog->ConfirmLoop == true){
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
				::SetWindowPos(theApp->MainWindow->FileSelectDialog->ConfirmDialog->m_hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOZORDER | SWP_NOMOVE | SWP_NOSIZE | SWP_HIDEWINDOW);
				::EnableWindow(theApp->MainWindow->FileSelectDialog->m_hWnd, true);

				fclose(file);
			}
		}
	}

	if (theApp->MainWindow->FileSelectDialog->ConfirmDialog->Execute == true){

		//t@CsB

		if (theApp->MainWindow->FileSelectDialog->SelectList->FileType == FILE_TYPE_COLLADA && theApp->MainWindow->FileSelectDialog->OpenType == OPEN_TYPE_LOAD_MODEL){
	
			theApp->MainWindow->DispWindow->ReloadRock == true;
			Sleep(100);

			if (theApp->MainWindow->DispWindow->ChaResourceObject1 != NULL){
				delete theApp->MainWindow->DispWindow->ChaResourceObject1;
				theApp->MainWindow->DispWindow->ChaResourceObject1 = NULL;
			}
			if (theApp->MainWindow->DispWindow->ChaDataObject1 != NULL){
				delete theApp->MainWindow->DispWindow->ChaDataObject1;
				theApp->MainWindow->DispWindow->ChaDataObject1 = NULL;
			}

			wchar_t path[SIZE_CHAR_MAX];
			wmemset(path, 0, SIZE_CHAR_MAX);
			wcscpy_s(path, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->CurrentPath);
			wcscat_s(path, SIZE_CHAR_MAX, L"\\");
			wcscat_s(path, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->CurrentFileName);

			theApp->MainWindow->DispWindow->ChaDataObject1 = new CChaDataObject();
			theApp->MainWindow->DispWindow->ChaDataObject1->LoadDAE(path, theApp->MainWindow->Config->ExtDae);
			theApp->MainWindow->DispWindow->ChaResourceObject1 = new CChaResourceObject();
			theApp->MainWindow->DispWindow->ChaResourceObject1->CreateResource(theApp->MainWindow->DispWindow->CommonDevice, theApp->MainWindow->DispWindow->ChaDataObject1, theApp->MainWindow->DispWindow->IsAnimated);

			for (int i = 0; i <= theApp->MainWindow->DispWindow->PointLightNum - 1; i++)
				theApp->MainWindow->DispWindow->PointLight[i]->UpdateShadowMap = false;

			theApp->MainWindow->DispWindow->ReloadRock == false;

			::InvalidateRect(theApp->MainWindow->MenuWindow->AnimationListWnd->m_hWnd, NULL, false);
			::UpdateWindow(theApp->MainWindow->MenuWindow->AnimationListWnd->m_hWnd);
		}
		if (theApp->MainWindow->FileSelectDialog->SelectList->FileType == FILE_TYPE_MODEL && theApp->MainWindow->FileSelectDialog->OpenType == OPEN_TYPE_LOAD_MODEL){

			theApp->MainWindow->DispWindow->ReloadRock == true;
			Sleep(100);

			if (theApp->MainWindow->DispWindow->ChaResourceObject1 != NULL){
				delete theApp->MainWindow->DispWindow->ChaResourceObject1;
				theApp->MainWindow->DispWindow->ChaResourceObject1 = NULL;
			}
			if (theApp->MainWindow->DispWindow->ChaDataObject1 != NULL){
				delete theApp->MainWindow->DispWindow->ChaDataObject1;
				theApp->MainWindow->DispWindow->ChaDataObject1 = NULL;
			}

			wchar_t path[SIZE_CHAR_MAX];
			wmemset(path, 0, SIZE_CHAR_MAX);
			wcscpy_s(path, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->CurrentPath);
			wcscat_s(path, SIZE_CHAR_MAX, L"\\");
			wcscat_s(path, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->CurrentFileName);

			theApp->MainWindow->DispWindow->ChaDataObject1 = new CChaDataObject();
			theApp->MainWindow->DispWindow->ChaDataObject1->LoadModel(path);
			theApp->MainWindow->DispWindow->ChaResourceObject1 = new CChaResourceObject();
			theApp->MainWindow->DispWindow->ChaResourceObject1->CreateResource(theApp->MainWindow->DispWindow->CommonDevice, theApp->MainWindow->DispWindow->ChaDataObject1, theApp->MainWindow->DispWindow->IsAnimated );

			for (int i = 0; i <= theApp->MainWindow->DispWindow->PointLightNum - 1; i++)
				theApp->MainWindow->DispWindow->PointLight[i]->UpdateShadowMap = false;

			theApp->MainWindow->DispWindow->ReloadRock == false;

			::InvalidateRect(theApp->MainWindow->MenuWindow->AnimationListWnd->m_hWnd, NULL, false);
			::UpdateWindow(theApp->MainWindow->MenuWindow->AnimationListWnd->m_hWnd);
		}
		if ( theApp->MainWindow->FileSelectDialog->OpenType == OPEN_TYPE_WRITE_MODEL){

			wchar_t name[SIZE_CHAR_MAX];
			wmemset(name, 0, SIZE_CHAR_MAX);
			wcscpy_s(name, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->CurrentPath);
			wcscat_s(name, SIZE_CHAR_MAX, L"\\");
			wcscat_s(name, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->CurrentFileName);

			wchar_t file_name[SIZE_CHAR_MAX];
			wmemset(file_name, 0, SIZE_CHAR_MAX);
			wcscpy_s(file_name, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->CurrentFileName);

			wchar_t ext[SIZE_CHAR_MAX];
			wmemset(ext, 0, SIZE_CHAR_MAX);
			wcscpy_s(ext, SIZE_CHAR_MAX, &name[wcslen(name) - 4]);
			if (wcscmp(ext, theApp->MainWindow->FileSelectDialog->SelectList->ExtModel) != 0){
				wcscat_s(name, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->ExtModel);
				wcscpy_s(file_name, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->ExtModel);
			}
		
			if ( wcslen(name) > 0){
				CChaDataObject *object = theApp->MainWindow->DispWindow->ChaDataObject1;
				if (object != NULL){
					object->WriteModel(object->ModelID, name);
				}
			}
		}
		if (theApp->MainWindow->FileSelectDialog->SelectList->FileType == FILE_TYPE_MODEL && theApp->MainWindow->FileSelectDialog->OpenType == OPEN_TYPE_WRITE_MODEL){
		}
		if (theApp->MainWindow->FileSelectDialog->SelectList->FileType == FILE_TYPE_ANIMATION && theApp->MainWindow->FileSelectDialog->OpenType == OPEN_TYPE_LOAD_ANIMATION){

			if (theApp->MainWindow->DispWindow->ChaDataObject1 != NULL){

				theApp->MainWindow->DispWindow->ReloadRock == true;
				Sleep(100);

				wchar_t path[SIZE_CHAR_MAX];
				wmemset(path, 0, SIZE_CHAR_MAX);
				wcscpy_s(path, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->CurrentPath);
				wcscat_s(path, SIZE_CHAR_MAX, L"\\");
				wcscat_s(path, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->CurrentFileName);

				bool result = theApp->MainWindow->DispWindow->ChaDataObject1->LoadAnimation(path);
				if ( result == true )
					theApp->MainWindow->DispWindow->ChaResourceObject1->CopyAnimation(theApp->MainWindow->DispWindow->ChaDataObject1, (int) theApp->MainWindow->DispWindow->ChaDataObject1->AnimationList->PushPos - 1);
				theApp->MainWindow->DispWindow->ReloadRock == false;

				theApp->MainWindow->DispWindow->ChaResourceObject1->SetCurrentAnimation(theApp->MainWindow->DispWindow->ChaResourceObject1->AnimationList->PushPos - 1);
				theApp->MainWindow->MenuWindow->AnimationListWnd->SelectedNum = theApp->MainWindow->DispWindow->ChaResourceObject1->AnimationList->PushPos - 1;

				::InvalidateRect(theApp->MainWindow->MenuWindow->AnimationListWnd->m_hWnd, NULL, false);
				::UpdateWindow(theApp->MainWindow->MenuWindow->AnimationListWnd->m_hWnd);
			}
		}
		if ( theApp->MainWindow->FileSelectDialog->OpenType == OPEN_TYPE_WRITE_ANIMATION){

			wchar_t name[SIZE_CHAR_MAX];
			wmemset(name, 0, SIZE_CHAR_MAX);
			wcscpy_s(name, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->CurrentPath);
			wcscat_s(name, SIZE_CHAR_MAX, L"\\");
			wcscat_s(name, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->CurrentFileName);

			wchar_t file_name[SIZE_CHAR_MAX];
			wmemset(file_name, 0, SIZE_CHAR_MAX);
			wcscpy_s(file_name, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->CurrentFileName);

			wchar_t ext[SIZE_CHAR_MAX];
			wmemset(ext, 0, SIZE_CHAR_MAX);
			wcscpy_s(ext, SIZE_CHAR_MAX, &name[wcslen(name) - 4]);
			if (wcscmp(ext, theApp->MainWindow->FileSelectDialog->SelectList->ExtAnim) != 0){
				wcscat_s(name, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->ExtAnim);
				wcscpy_s(file_name, SIZE_CHAR_MAX, theApp->MainWindow->FileSelectDialog->SelectList->ExtAnim);
			}
			wchar_t anim_name[SIZE_CHAR_MAX];
			wmemset(anim_name, 0, SIZE_CHAR_MAX);
			wmemcpy_s(anim_name, SIZE_CHAR_MAX, file_name, wcslen(file_name) - 4);

			if (wcslen(anim_name) > 0 && wcslen(name) > 0){
				CChaDataObject *object = theApp->MainWindow->DispWindow->ChaDataObject1;
				if (object != NULL)
					object->WriteAnimation(object->ModelID, anim_name, name);
			}
		}

		::EnableWindow(theApp->MainWindow->m_hWnd, true);
		::SetWindowPos(theApp->MainWindow->FileSelectDialog->m_hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOZORDER | SWP_NOMOVE | SWP_NOSIZE | SWP_HIDEWINDOW );
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonConfirmOK::Action(){

	theApp->MainWindow->FileSelectDialog->ConfirmDialog->Execute = true;
	theApp->MainWindow->FileSelectDialog->ConfirmDialog->ConfirmLoop = false;

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonConfirmCancel::Action(){

	theApp->MainWindow->FileSelectDialog->ConfirmDialog->Execute = false;
	theApp->MainWindow->FileSelectDialog->ConfirmDialog->ConfirmLoop = false;

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonConfirmClose::Action(){

	theApp->MainWindow->FileSelectDialog->ConfirmDialog->Execute = false;
	theApp->MainWindow->FileSelectDialog->ConfirmDialog->ConfirmLoop = false;

	return true;
}


