////////////////////////////////////////////////////////
// filename: CLight.h
// author: Chafumi Touji
// version: 1.0.0
// date: 2020/07/11
////////////////////////////////////////////////////////

#ifndef __CLIGHT_H__
#define __CLIGHT_H__

struct ConstantBufferPointLight{

	XMFLOAT4X4	MatLight;
	XMFLOAT4X4	MatLight1;
	XMFLOAT4X4	MatLight2;
	XMFLOAT4X4	MatLight3;
	XMFLOAT4X4	MatLight4;
	XMFLOAT4X4	MatLight5;
	XMFLOAT4X4	MatLight6;
	XMFLOAT4X4	MatProjLight;
	XMFLOAT4	PointLightPos;
	XMFLOAT4	LightColor;
	XMFLOAT4	ShadowParam;
};

class CPointLight{
public:

	XMFLOAT4	LightPos;
	XMFLOAT4	LightColor;
	float		Power;
	float		ShadowFar;
	float		ShadowPower;
	float		AreaSize;
	int			TextureSize;
	bool		UpdateShadowMap;

	ID3D11Buffer				*m_pConstantBufferPointLight;
	ConstantBufferPointLight	constant_buffer_pl;
	XMMATRIX					matLight[6];

	ID3D11Texture2D				**m_pTextureShadowMap;
	ID3D11RenderTargetView		**m_pShadowMapRenderTargetView;
	ID3D11ShaderResourceView	**m_pShadowMapShaderResourceView;
	ID3D11Texture2D				*m_pTextureShadowMapSoft;
	ID3D11RenderTargetView		*m_pShadowMapSoftRenderTargetView;
	ID3D11ShaderResourceView	*m_pShadowMapSoftShaderResourceView;
	ID3D11Texture2D				*m_pTextureShadowMapSoftOrg;
	ID3D11RenderTargetView		*m_pShadowMapSoftOrgRenderTargetView;
	ID3D11ShaderResourceView	*m_pShadowMapSoftOrgShaderResourceView;
	ID3D11Texture2D				*m_pTextureVolumeLight;
	ID3D11RenderTargetView		*m_pVolumeLightRenderTargetView;
	ID3D11ShaderResourceView	*m_pVolumeLightShaderResourceView;

public:
	CPointLight();
	~CPointLight();
	bool CreatePointLight( CCommonDevice *device, float pos_x, float pos_y, float pos_z, float power );
	bool CreatePointLight( CCommonDevice *device, float pos_x, float pos_y, float pos_z, float power, int texture_size );
	bool SetPoint(float pos_x, float pos_y, float pos_z);
	bool SetLightColor(float r, float g, float b);
	bool SetPower(float power);
	bool SetParam(CCommonDevice *device);
	bool DrawShadowMap(CCommonDevice *device, CChaResourceObject *object);
	bool Draw(CCommonDevice *device, CChaResourceObject *object);
	bool SetShadowPower(float power);
	bool SetShadowFar(float len);
	bool WriteSoftShadow(CCommonDevice *device);

private:
	bool CreateResource( CCommonDevice *device );
};

#endif