/////////////////////////////////////////////////
//
//  filename: DialogFileSelect.h
//  author:Chafumi Touji 
//  date: 2020/06/03 ver1.00
//
/////////////////////////////////////////////////

#ifndef __DIALOGFILESELECT_H__
#define __DIALOGFILESELECT_H__

class CConfig;
class CButtonDir;
class CButtonDialogClose;
class CButtonCancel;
class CButtonOK;
class CButtonConfirmClose;
class CButtonConfirmOK;
class CButtonConfirmCancel;

class CConfirmDialog{
public:

	HWND	m_hWnd;

	int Width, Height;
	int DisplayWidth, DisplayHeight;
	int TitleBarHeight;
	float ScaleX, ScaleY;
	float dpiX, dpiY;
	int FrameEdgeX, FrameEdgeY;
	int TransparentR, TransparentG, TransparentB;

	char			*AlphaBMP;
	HDC				MemDC;
	HBITMAP			MemBMP;
	int				BitmapWidth;
	int				BitmapHeight;

	bool ConfirmLoop;
	bool Execute;
	int PosX, PosY;
	int BKColorR, BKColorG, BKColorB, BKColorA;
	int BarColorR, BarColorG, BarColorB, BarColorA;
	int TextColorR, TextColorG, TextColorB, TextColorA;

	CPoint DownPoint;
	bool GetCaption;
	bool LButtonDown;

	CButtonConfirmClose		*ButtonConfirmClose;
	CButtonConfirmCancel	*ButtonConfirmCancel;
	CButtonConfirmOK		*ButtonConfirmOK;

	CConfirmDialog();
	~CConfirmDialog();
	bool SetParam(CConfig *config);
	bool CreateWnd(HWND ParentWnd, int x, int y, int w, int h);
	bool OnDraw(HDC hdc);

public:
	void OnPaint();
	void OnLButtonDown(UINT nFlag, CPoint point);
	void OnLButtonUp(UINT nFlag, CPoint point);
	void OnMouseMove(UINT nFlag, CPoint point);
	void OnSize(UINT nType, int cx, int cy);

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT ConfirmDialogProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
};

class CEditWindow{
public:

	HWND		m_hWnd;

	float		ScaleX, ScaleY;
	float		dpiX, dpiY;
	HFONT		Font;
	FARPROC		OrgProc;

	int			Width, Height;
	int			PosX, PosY;
	int			BKColorR, BKColorG, BKColorB;
	int			TextColorR, TextColorG, TextColorB;
	wchar_t		IMEText[SIZE_CHAR_MAX];

public:
	CEditWindow();
	~CEditWindow();
	bool SetParam(CConfig *config);
	bool CreateWnd(HWND ParentWnd, int x, int y, int w, int h);

protected:
	LRESULT EditWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
};

class CScrollBar{
public:

	HWND m_hWnd;

	int DisplayWidth, DisplayHeight;
	int PosX, PosY, Width, Height;
	int BKColorA, BKColorR, BKColorG, BKColorB;
	int BarPosY, BarHeight;

	CPoint DownPoint;
	bool LButtonDown;

	HDC				MemDC;
	HBITMAP			MemBMP;

public:
	CScrollBar();
	~CScrollBar();
	bool SetParam(CConfig *config);
	bool CreateWnd(HWND ParentWnd, int x, int y, int w, int h, HDC memDC, HBITMAP bitmap );
	bool OnDraw(HDC hdc);
	bool UpdateScrollBar();
	bool DrawRoundRect(Gdiplus::Graphics *gfc, Gdiplus::Pen *pen, int x, int y, int w, int h, int r);
	bool FillRoundRect(Gdiplus::Graphics *gfc, Gdiplus::Brush *brush, int x, int y, int w, int h, int r);

public:
	void OnPaint();
	void OnLButtonDown(UINT nFlag, CPoint point);
	void OnLButtonUp(UINT nFlag, CPoint point);
	void OnMouseMove(UINT nFlag, CPoint point);
	void OnSize(UINT nType, int cx, int cy);

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT ScrollBarProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
};

class CSelectList{
public:

	wchar_t CurrentPath[SIZE_CHAR_MAX];
	wchar_t CurrentFileName[SIZE_CHAR_MAX];
	wchar_t SelectedFile[SIZE_CHAR_MAX];
	wchar_t ExtModel[SIZE_CHAR_MAX];
	wchar_t ExtAnim[SIZE_CHAR_MAX];
	wchar_t ExtDae[SIZE_CHAR_MAX];

	HWND m_hWnd;
	
	CScrollBar	*ScrollV;

	int DisplayWidth, DisplayHeight;
	int PosX, PosY, Width, Height;
	int BKColorA, BKColorR, BKColorG, BKColorB;
	int TextColorA, TextColorR, TextColorG, TextColorB;
	int SelectedNum;

	float ScaleX, ScaleY;
	float dpiX, dpiY;
	int ItemCountMax;
	int ItemBegin;
	int ItemHeight;
	int IconSize;
	int ItemCount;

	CPoint DownPoint;
	bool LButtonDown;

	HDC				MemDC;
	HBITMAP			MemBMP;

	int				FileType;
	bool			SelectDriveMode;

	Image			*Img_Model;
	Image			*Img_Anim;
	Image			*Img_Dir;
	Image			*Img_Dae;

public:
	CSelectList();
	~CSelectList();
	bool SetParam(CConfig *config);
	bool CreateWnd(HWND ParentWnd, int x, int y, int w, int h, HDC memDC, HBITMAP bitmap );
	bool OnDraw(HDC hdc);
	bool GetItem();
	bool DrawItem(Gdiplus::Graphics *gfc);
	int SelectItem(CPoint point);
	bool DBLCLKAction();
	bool GetFileType();

public:
	void OnPaint();
	void OnLButtonDown(UINT nFlag, CPoint point);
	void OnLButtonDBLCLK(UINT nFlag, CPoint point);
	void OnLButtonUp(UINT nFlag, CPoint point);
	void OnMouseMove(UINT nFlag, CPoint point);
	void OnSize(UINT nType, int cx, int cy);
	void OnMouseWheel(UINT nFlag, int zDelta, CPoint point);

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT SelectListProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
};

class CFileSelectDialog{
public:

	HWND	m_hWnd;

	int Width, Height;
	int DisplayWidth, DisplayHeight;
	int TitleBarHeight;
	int TaskBarHeight;
	float ScaleX, ScaleY;
	float dpiX, dpiY;
	int FrameEdgeX, FrameEdgeY;
	int TransparentR, TransparentG, TransparentB;

	char			*AlphaBMP;
	HDC				MemDC;
	HBITMAP			MemBMP;
	int				BitmapWidth;
	int				BitmapHeight;

	int PosX, PosY;
	int BKColorR, BKColorG, BKColorB, BKColorA;
	int BarColorR, BarColorG, BarColorB, BarColorA;
	int TextColorR, TextColorG, TextColorB, TextColorA;

	CPoint DownPoint;
	bool GetCaption;
	bool LButtonDown;
	bool RButtonDown;
	int OpenType;

	CSelectList *SelectList;
	CEditWindow *EditWnd;
	CConfirmDialog *ConfirmDialog;

	CButtonDialogClose		*ButtonDialogClose;
	CButtonDir				*ButtonDir;
	CButtonCancel			*ButtonCancel;
	CButtonOK				*ButtonOK;

	CFileSelectDialog();
	~CFileSelectDialog();
	bool SetParam(CConfig *config);
	bool CreateWnd(HWND ParentWnd, int x, int y, int w, int h);
	bool OnDraw(HDC hdc);
	bool DrawRoundRect(Gdiplus::Graphics *gfc, Gdiplus::Pen *pen, int x, int y, int w, int h, int r);
	bool FillRoundRect(Gdiplus::Graphics *gfc, Gdiplus::Brush *brush, int x, int y, int w, int h, int r);

public:
	void OnPaint();
	void OnLButtonDown(UINT nFlag, CPoint point);
	void OnLButtonUp(UINT nFlag, CPoint point);
	void OnMouseMove(UINT nFlag, CPoint point);
	void OnSize(UINT nType, int cx, int cy);

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT FileSelectDialogProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
};

#endif