////////////////////////////////////////////////////////
// filename: CSky.h
// author: Chafumi Touji
// version: 1.0.0
// date: 2020/07/24
////////////////////////////////////////////////////////

#ifndef __CSKY_H__
#define __CSKY_H__

struct ConstantBufferSky{

	XMFLOAT4X4	MatMoon;
	XMFLOAT4	SkyColor;
	XMFLOAT4	SkyParam;
	XMFLOAT4	SunPos;
	XMFLOAT4	MoonPos;
	XMFLOAT4	CloudParam1;
	XMFLOAT4	CloudParam2[16];
};

class CSky{
public:

	int						SkyWidth, SkyHeight;
	int						SceneTime;
	float						CloudVolume;
	float						CloudAlpha;
	float						CloudVelocity;

	int						VtxBufferSkyCount;
	float						SunSize;
	float						MoonSize;

	XMFLOAT4			SunPos;
	XMFLOAT4			MoonPos;

	ID3D11Texture2D						*m_pTextureCloud, *m_pTextureStar, *m_pTextureMoon;
	ID3D11ShaderResourceView		*m_pCloudShaderResourceView, *m_pStarShaderResourceView, *m_pMoonShaderResourceView;
	ID3D11Buffer								*VtxBufferSky, *VtxBufferMoon;
	ID3D11Buffer								*m_pConstantBufferSky;
	ConstantBufferSky						constant_buffer_sky;

public:
	CSky();
	~CSky();
	bool SetInitParam(float sun_size, float moon_size);
	bool CreateResource(CCommonDevice *device, wchar_t *path, wchar_t *texture_cloud_name, wchar_t *texture_star_name, wchar_t *texture_moon_name );
	bool CreateResource(CCommonDevice *device, int sky_size, int div_count, wchar_t *path, wchar_t *texture_cloud_name, wchar_t *texture_star_name, wchar_t *texture_moon_name );
	bool Draw(CCommonDevice *device);
	bool GetSkyColor(int *r, int *g, int *b);
	bool SetSceneTime(int hour, int min, int sec);
	bool SetCloudVolume(float volume);
	bool SetCloudAlpha(float alpha);
	bool SetCloudVelocity(float velocity);
	bool SetMoonPos(float x, float y, float z);
	bool SetSunPos(float x, float y, float z);
	bool SetMoonCrescentRate(float rate);
	bool UpdateFrame();
};

#endif