
Texture2D TexDiffuse : register(t0);
SamplerState sampleDiffuse : register(s0);

Texture2D TexCloud : register(t0);
SamplerState sampleCloud : register(s0);

Texture2D TexDepth : register(t1);
SamplerState sampleDepth : register(s1);

Texture2D TexVolumeLight : register(t1);
SamplerState sampleVolumeLight : register(s1);

Texture2D TexStar : register(t1);
SamplerState sampleStar : register(s1);

Texture2D TexShadowMap1 : register(t2);
SamplerState sampleShadowMap1 : register(s2);

Texture2D TexMoon : register(t2);
SamplerState sampleMoon : register(s2);

Texture2D TexShadowMap2 : register(t3);
SamplerState sampleShadowMap2 : register(s3);

Texture2D TexShadowMap3 : register(t4);
SamplerState sampleShadowMap3 : register(s4);

Texture2D TexShadowMap4 : register(t5);
SamplerState sampleShadowMap4 : register(s5);

Texture2D TexShadowMap5 : register(t6);
SamplerState sampleShadowMap5 : register(s6);

Texture2D TexShadowMap6 : register(t7);
SamplerState sampleShadowMap6 : register(s7);

Texture2D TexVolumeLight1 : register(t8);
SamplerState sampleVolumeLight1 : register(s8);

Texture2D TexVolumeLight2 : register(t9);
SamplerState sampleVolumeLight2 : register(s9);

Texture2D TexVolumeLight3 : register(t10);
SamplerState sampleVolumeLight3 : register(s10);

cbuffer ConstantBuffer1 : register(b0){

	matrix	MatWorld;
	matrix	MatView;
	matrix	MatProj;
	float4	LightColor[16];
	float4	LightPos[16];
	float4	EyePos;
}

cbuffer ConstantBuffer2 : register(b1){

	float4 Ambient;
	float4 Diffuse;
	float4 Specular;
}

cbuffer ConstantBuffer3 : register(b2){

	matrix BindShapeMatrix;
	matrix BoneMatrix[255];
}

cbuffer ConstantBufferPointLight : register(b3){

	matrix	MatLight;
	matrix	MatLight1;
	matrix	MatLight2;
	matrix	MatLight3;
	matrix	MatLight4;
	matrix	MatLight5;
	matrix	MatLight6;
	matrix	MatProjLight;
	float4	PointLightPos;
	float4	PointLightColor;
	float4	ShadowParam;
}

cbuffer ConstantBufferSky : register(b3){

	matrix	MatMoon;
	float4	SkyColor;
	float4	SkyParam;
	float4	SunPos;
	float4	MoonPos;
	float4	CloudParam1;
	float4	CloudParam2[16];
}

cbuffer ConstantBufferVolumeLight : register(b4){

	matrix		MatWorldVL;
	matrix		MatViewVL;
	matrix		MatProjVL;
	float4		EyeVL;
	float4		MoveVL;
	float4		VolumeLightParam1;
	float4		VolumeLightParam2;
}

////////////////////////////////////////////////////////

struct VertexIn{

	float3 Pos : POSITION;
	float3 Normal : NORMAL;
	float4 Color : COLOR;
	float2 Tex : TEXCOORD;
	float2 Weight0 : TEXCOORD1;
	float2 Weight1 : TEXCOORD2;
	float2 Weight2 : TEXCOORD3;
	float2 Weight3 : TEXCOORD4;
	float2 Weight4 : TEXCOORD5;
	float2 Weight5 : TEXCOORD6;
	float2 Weight6 : TEXCOORD7;
	float2 Weight7 : TEXCOORD8;
};

struct VertexIn_2{

	float3 Pos : POSITION;
	float3 Normal : NORMAL;
	float4 Color : COLOR;
	float2 Tex : TEXCOORD;
};

struct VertexOut{

	float4 Pos : SV_POSITION;
	float3 VtxPos : POSITION0;
	float3 Normal : POSITION1;
	float4 Color : COLOR0;
	float2 Tex : TEXCOORD0;
};

struct PsOutput{

	float4 Color : SV_Target0;
	float4 Depth : SV_Target1;
};

/////////////////////////////////////////////////////////////////////

VertexOut vs_main1(VertexIn IN){

	VertexOut OUT;

	float4 vtx = float4(IN.Pos, 1.0f);
	float4 normal = float4(IN.Normal, 1.0f);
	float4 vtx_tmp = float4(0, 0, 0, 0);
	float4 normal_tmp = float4(0, 0, 0, 0);

	vtx = mul(vtx, BindShapeMatrix);
	normal = mul(normal, BindShapeMatrix);

	int joint0 = (int)(IN.Weight0.x + 0.0001f);
	int joint1 = (int)(IN.Weight1.x + 0.0001f);
	int joint2 = (int)(IN.Weight2.x + 0.0001f);
	int joint3 = (int)(IN.Weight3.x + 0.0001f);
	int joint4 = (int)(IN.Weight4.x + 0.0001f);
	int joint5 = (int)(IN.Weight5.x + 0.0001f);
	int joint6 = (int)(IN.Weight6.x + 0.0001f);
	int joint7 = (int)(IN.Weight7.x + 0.0001f);

	float w0 = clamp(IN.Weight0.y, 0.0f, 1.0f);
	float w1 = clamp(IN.Weight1.y, 0.0f, 1.0f);
	float w2 = clamp(IN.Weight2.y, 0.0f, 1.0f);
	float w3 = clamp(IN.Weight3.y, 0.0f, 1.0f);
	float w4 = clamp(IN.Weight4.y, 0.0f, 1.0f);
	float w5 = clamp(IN.Weight5.y, 0.0f, 1.0f);
	float w6 = clamp(IN.Weight6.y, 0.0f, 1.0f);
	float w7 = clamp(IN.Weight7.y, 0.0f, 1.0f);

	bool add_weight = false;
	float4 v = float4(0, 0, 0, 0);
	float4 n = float4(0, 0, 0, 0);

	if (w0 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint0]);
		n = mul(normal, BoneMatrix[joint0]);
		v *= w0;
		n *= w0;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w1 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint1]);
		n = mul(normal, BoneMatrix[joint1]);
		v *= w1;
		n *= w1;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w2 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint2]);
		n = mul(normal, BoneMatrix[joint2]);
		v *= w2;
		n *= w2;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w3 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint3]);
		n = mul(normal, BoneMatrix[joint3]);
		v *= w3;
		n *= w3;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w4 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint4]);
		n = mul(normal, BoneMatrix[joint4]);
		v *= w4;
		n *= w4;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w5 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint5]);
		n = mul(normal, BoneMatrix[joint5]);
		v *= w5;
		n *= w5;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w6 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint6]);
		n = mul(normal, BoneMatrix[joint6]);
		v *= w6;
		n *= w6;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w7 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint7]);
		n = mul(normal, BoneMatrix[joint7]);
		v *= w7;
		n *= w7;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}

	if (add_weight == true){
		vtx = vtx_tmp;
		normal = normal_tmp;
	}

	OUT.VtxPos = vtx.xyz;
	vtx = mul(vtx, MatWorld);
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;
	OUT.Normal = normal.xyz;
	OUT.Color = float4(0, 0, 0, 1);
	OUT.Tex = IN.Tex;

	return OUT;
}

VertexOut vs_main1_1(VertexIn IN){

	VertexOut OUT;

	//{[Aj[V̕ό`Ȃꍇ̃VF[_ij

	float4 vtx = float4(IN.Pos, 1.0f);

	OUT.VtxPos = vtx.xyz;
	vtx = mul(vtx, MatWorld);
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;

	OUT.Normal = IN.Normal.xyz;
	OUT.Color = float4(0, 0, 0, 1);
	OUT.Tex = IN.Tex;

	return OUT;
}

VertexOut vs_main1_2(VertexIn_2 IN){

	VertexOut OUT;

	//{[Aj[V̕ό`Ȃꍇ̃VF[_
	//iCvbgCAEgȈՔ)

	float4 vtx = float4(IN.Pos, 1.0f);

	OUT.VtxPos = vtx.xyz;
	vtx = mul(vtx, MatWorld);
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;

	OUT.Normal = IN.Normal.xyz;
	OUT.Color = float4(0, 0, 0, 1);
	OUT.Tex = IN.Tex;

	return OUT;
}

VertexOut vs_main1_3(VertexIn_2 IN){

	VertexOut OUT;

	//\p
	//iCvbgCAEgȈՔ)

	float4 vtx = float4(IN.Pos, 1.0f);

	OUT.VtxPos = vtx.xyz;
	vtx = mul(vtx, MatMoon);
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;

	OUT.Normal = IN.Normal.xyz;
	OUT.Color = float4(0, 0, 0, 1);
	OUT.Tex = IN.Tex;

	return OUT;
}

VertexOut vs_main1_4(VertexIn_2 IN){

	VertexOut OUT;

	//{[Cgp
	//iCvbgCAEgȈՔ)

	float4 vtx = float4(IN.Pos, 1.0f);

	OUT.VtxPos = vtx.xyz;
	vtx = mul(vtx, MatViewVL);
	OUT.Pos = vtx;

	OUT.Normal = IN.Normal.xyz;
	OUT.Color = float4(0, 0, 0, 1);
	OUT.Tex = IN.Tex;

	return OUT;
}

VertexOut vs_main2(VertexIn IN){

	VertexOut OUT;

	OUT.Pos = float4(IN.Pos, 1.0f);
	OUT.Normal = IN.Normal;
	OUT.VtxPos = IN.Pos;
	OUT.Color = float4(0, 0, 0, 1);
	OUT.Tex = IN.Tex;

	return OUT;
}

VertexOut vs_main3(VertexIn IN){

	//Cg̃VhE}bvp

	VertexOut OUT;

	float4 vtx = float4(IN.Pos, 1.0f);
	float4 normal = float4(IN.Normal, 1.0f);
	float4 vtx_tmp = float4(0, 0, 0, 1);
	float4 normal_tmp = float4(0, 0, 0, 1);

	vtx = mul(vtx, BindShapeMatrix);
	normal = mul(normal, BindShapeMatrix);

	int joint0 = (int)(IN.Weight0.x + 0.0001f);
	int joint1 = (int)(IN.Weight1.x + 0.0001f);
	int joint2 = (int)(IN.Weight2.x + 0.0001f);
	int joint3 = (int)(IN.Weight3.x + 0.0001f);
	int joint4 = (int)(IN.Weight4.x + 0.0001f);
	int joint5 = (int)(IN.Weight5.x + 0.0001f);
	int joint6 = (int)(IN.Weight6.x + 0.0001f);
	int joint7 = (int)(IN.Weight7.x + 0.0001f);

	float w0 = clamp(IN.Weight0.y, 0.0f, 1.0f);
	float w1 = clamp(IN.Weight1.y, 0.0f, 1.0f);
	float w2 = clamp(IN.Weight2.y, 0.0f, 1.0f);
	float w3 = clamp(IN.Weight3.y, 0.0f, 1.0f);
	float w4 = clamp(IN.Weight4.y, 0.0f, 1.0f);
	float w5 = clamp(IN.Weight5.y, 0.0f, 1.0f);
	float w6 = clamp(IN.Weight6.y, 0.0f, 1.0f);
	float w7 = clamp(IN.Weight7.y, 0.0f, 1.0f);

	bool add_weight = false;
	float4 v = float4(0, 0, 0, 1);
	float4 n = float4(0, 0, 0, 1);

	if (w0 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint0]);
		n = mul(normal, BoneMatrix[joint0]);
		v *= w0;
		n *= w0;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w1 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint1]);
		n = mul(normal, BoneMatrix[joint1]);
		v *= w1;
		n *= w1;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w2 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint2]);
		n = mul(normal, BoneMatrix[joint2]);
		v *= w2;
		n *= w2;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w3 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint3]);
		n = mul(normal, BoneMatrix[joint3]);
		v *= w3;
		n *= w3;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w4 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint4]);
		n = mul(normal, BoneMatrix[joint4]);
		v *= w4;
		n *= w4;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w5 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint5]);
		n = mul(normal, BoneMatrix[joint5]);
		v *= w5;
		n *= w5;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w6 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint6]);
		n = mul(normal, BoneMatrix[joint6]);
		v *= w6;
		n *= w6;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w7 > 0.0000001f){
		v = mul(vtx, BoneMatrix[joint7]);
		n = mul(normal, BoneMatrix[joint7]);
		v *= w7;
		n *= w7;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}

	if (add_weight == true){
		vtx = vtx_tmp;
		normal = normal_tmp;
	}

	vtx = mul(vtx, MatLight);
	vtx = mul(vtx, MatProjLight);

	OUT.Pos = vtx;
	OUT.Normal = normal.xyz;
	OUT.Color = float4(0, 0, 0, 1);
	OUT.Tex = IN.Tex;

	return OUT;
}

VertexOut vs_main3_1(VertexIn IN){

	// {[Aj[VȂꍇ̏ij

	VertexOut OUT;

	float4 vtx = float4(IN.Pos, 1.0f);
	float4 normal = float4(IN.Normal.xyz, 1.0f);

	vtx = mul(vtx, MatLight);
	vtx = mul(vtx, MatProjLight);

	OUT.Pos = vtx;
	OUT.Normal = normal.xyz;
	OUT.Color = float4(0, 0, 0, 1);
	OUT.Tex = IN.Tex;

	return OUT;
}

/////////////////////////////////////////////////////////////////////////

PsOutput ps_main1(VertexOut input){

	//fBt[YJ[̏o

	PsOutput output;

	input.Tex.y = -input.Tex.y;
	float4 color = float4(0, 0, 0, 1);
	float4 tex_color = TexDiffuse.Sample(sampleDiffuse, input.Tex);
	float4 light_color = float4(0, 0, 0, 1);
	float4 dif = float4(0, 0, 0, 0);
	float4 amb = float4(0, 0, 0, 0);
	float4 spec = float4(0, 0, 0, 0);

	float count = 0;
	for (int i = 0; i <= 15; i++){

		if (LightColor[i].w < 0.001f)
			continue;

		float specular_power = 0.2f;
		float ambient_power = 0.3f;
		float light_power = LightColor[i].w;
		float3 L = normalize(-LightPos[i].xyz - input.Normal.xyz);
		float3 N = normalize(input.Normal.xyz);
		float LN = dot(L, N);
		float3 R = normalize(2 * LN * N - normalize(-LightPos[i].xyz));
		float3 V = normalize(EyePos.xyz);
		float RV = saturate(dot(R, V));
		amb += tex_color * ambient_power;
		dif += saturate(LN * tex_color);
		spec += saturate(specular_power * pow(RV, 5.0));

		float dist = pow(input.VtxPos.x - LightPos[i].x, 2.0f) + pow(input.VtxPos.y - LightPos[i].y, 2.0f) + pow(input.VtxPos.z - LightPos[i].z, 2.0f);
		float power = LightColor[i].w * 30.0f / (1.0f + dist);

		light_color.rgb += power * LightColor[i].rgb;

		count++;
	}
	amb.rgb /= max(count, 1.0f);
	dif.rgb /= max(count, 1.0f);
	spec.rgb /= max(count, 1.0f);
	light_color.rgb /= max(count, 1.0f);

	color.rgb = ( light_color.rgb + 0.2f ) * (amb.rgb + dif.rgb + spec.rgb);
	color.rgb = clamp(color.rgb, 0.0f, 1.0f);
	color.a = tex_color.a;

	if (color.r < 0.001 && color.g < 0.001 && color.b < 0.001){
		color = input.Color;
	}
	if (color.r >= 0.98 && color.g >= 0.98 && color.b >= 0.98){
		color.rgb = 0.96;
	}

	output.Color = color;
	output.Depth = float4(input.Pos.z / input.Pos.w, input.Pos.z, 0, 1);

	return output;
}

float4 ps_main2(VertexOut input) : SV_Target0{

	//ŏIIȃ_OB

	float4 color = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy);

	float4 shadow_color1 = TexShadowMap1.Sample(sampleShadowMap1, input.Tex.xy);
	float4 shadow_color2 = TexShadowMap2.Sample(sampleShadowMap2, input.Tex.xy);
	float4 shadow_color3 = TexShadowMap3.Sample(sampleShadowMap3, input.Tex.xy);

	float shadow1 = shadow_color1.r * shadow_color1.g;
	float shadow2 = shadow_color2.r * shadow_color2.g;
	float shadow3 = shadow_color3.r * shadow_color3.g;

	float s1 = 1.0f - shadow1;
	float s2 = 1.0f - shadow2;
	float s3 = 1.0f - shadow3;

	float max_light = max(s1, s2);
	max_light = max(max_light, s3);

	color.rgb *= max_light;

	///////////////////////////////////////
	//{[Cg

	float4 vol_color1 = TexVolumeLight1.Sample(sampleVolumeLight1, input.Tex.xy);
	float4 vol_color2 = TexVolumeLight2.Sample(sampleVolumeLight2, input.Tex.xy);
	float4 vol_color3 = TexVolumeLight3.Sample(sampleVolumeLight3, input.Tex.xy);
	
	color.rgb -= 0.3f;
	color.rgb += vol_color1.rgb + vol_color2.rgb + vol_color3.rgb;
	color.rgb = max(color.rgb, 0.0f);

	if (color.r > 0.98 && color.g > 0.98 && color.b > 0.98)
		color.rgb = 0.96;

	return color;
}

float4 ps_main3(VertexOut input) : SV_Target0{

	//VhE}bv

	return float4(input.Pos.z, input.Pos.w, 0, 1);
}

float4 ps_main4(VertexOut input) : SV_Target0{

	//\tgVhE

	float ShadowFar = ShadowParam.x;
	float ShadowPower = ShadowParam.y;

	float4 center_color = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy);

	float len = center_color.b * 0.001f;
	float col0 = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy + float2(0.0f, 0.0f) * len).r;
	float col1 = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy + float2(1.0f, 0.0f) * len).r;
	float col2 = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy + float2(-1.0f, 0.0f) * len).r;
	float col3 = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy + float2(0.0f, 1.0f) * len).r;
	float col4 = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy + float2(0.0f, -1.0f) * len).r;
	float col5 = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy + float2(1.0f, 1.0f) * len * 0.7f).r;
	float col6 = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy + float2(-1.0f, 1.0f) * len * 0.7f).r;
	float col7 = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy + float2(1.0f, -1.0f) * len * 0.7f).r;
	float col8 = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy + float2(-1.0f, -1.0f) * len * 0.7f).r;
	float col9 = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy + float2(1.0f, 0.0f) * len * 2.0f).r;
	float col10 = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy + float2(-1.0f, 0.0f) * len * 2.0f).r;
	float col11 = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy + float2(0.0f, 1.0f) * len * 2.0f).r;
	float col12 = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy + float2(0.0f, -1.0f) * len * 2.0f).r;
	float col13 = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy + float2(1.0f, 1.0f) * len * 2.0f * 0.7f).r;
	float col14 = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy + float2(-1.0f, 1.0f) * len * 2.0f * 0.7f).r;
	float col15 = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy + float2(1.0f, -1.0f) * len * 2.0f * 0.7f).r;
	float col16 = TexDiffuse.Sample(sampleDiffuse, input.Tex.xy + float2(-1.0f, -1.0f) * len * 2.0f * 0.7f).r;

	col0 = (col0 > 0.001f) ? 1.0f : 0.0f;
	col1 = (col1 > 0.001f) ? 1.0f : 0.0f;
	col2 = (col2 > 0.001f) ? 1.0f : 0.0f;
	col3 = (col3 > 0.001f) ? 1.0f : 0.0f;
	col4 = (col4 > 0.001f) ? 1.0f : 0.0f;
	col5 = (col5 > 0.001f) ? 1.0f : 0.0f;
	col6 = (col6 > 0.001f) ? 1.0f : 0.0f;
	col7 = (col7 > 0.001f) ? 1.0f : 0.0f;
	col8 = (col8 > 0.001f) ? 1.0f : 0.0f;
	col9 = (col9 > 0.001f) ? 1.0f : 0.0f;
	col10 = (col10 > 0.001f) ? 1.0f : 0.0f;
	col11 = (col11 > 0.001f) ? 1.0f : 0.0f;
	col12 = (col12 > 0.001f) ? 1.0f : 0.0f;
	col13 = (col13 > 0.001f) ? 1.0f : 0.0f;
	col14 = (col14 > 0.001f) ? 1.0f : 0.0f;
	col15 = (col15 > 0.001f) ? 1.0f : 0.0f;
	col16 = (col16 > 0.001f) ? 1.0f : 0.0f;

	float alpha = clamp(1.0f - center_color.b * 0.03f / max(ShadowFar, 0.00001f), 0.0f, 1.0f);
	float COL = (col0 + col1 + col2 + col3 + col4 + col5 + col6 + col7 + col8 + col9 + col10 + col11 + col12 + col13 + col14 + col15 + col6) / 17.0f - 0.5f;

	center_color.r = min(max(COL + center_color.b * 0.1f / max(ShadowFar, 0.00001f), 0.0f) * 0.5f * ShadowPower, ShadowPower * alpha);
	center_color.g = min( center_color.g + center_color.b / max( ShadowFar, 0.00001f ), ShadowPower * alpha);
	center_color.a = alpha;

	return center_color;
}

float4 ps_main5(VertexOut input) : SV_Target0{

	////////////////////////////////////////////////////////////////////////
	//VhE}bv

	int face = 0;
	matrix mat_light;
	float4 vec = float4(normalize(input.VtxPos.xyz - PointLightPos.xyz), 1.0f);

	float4 normal1 = float4(-1, 0, 0, 1.0f);
	float4 normal2 = float4(0, -1, 0, 1.0f);
	float4 normal3 = float4(0, 0, -1, 1.0f);
	float4 normal4 = float4(1, 0, 0, 1.0f);
	float4 normal5 = float4(0, 1, 0, 1.0f);
	float4 normal6 = float4(0, 0, 1, 1.0f);

	float d1 = dot(normal1, vec);
	float d2 = dot(normal2, vec);
	float d3 = dot(normal3, vec);
	float d4 = dot(normal4, vec);
	float d5 = dot(normal5, vec);
	float d6 = dot(normal6, vec);

	float d = max(d1, d2);
	d = max(d, d3);
	d = max(d, d4);
	d = max(d, d5);
	d = max(d, d6);

	if (d1 > d - 0.001f){
		face = 1;
		mat_light = MatLight1;
	}
	else if (d2 > d - 0.001f){
		face = 2;
		mat_light = MatLight2;
	}
	else if (d3 > d - 0.001f){
		face = 3;
		mat_light = MatLight3;
	}
	else if (d4 > d - 0.001f){
		face = 4;
		mat_light = MatLight4;
	}
	else if (d5 > d - 0.001f){
		face = 5;
		mat_light = MatLight5;
	}
	else{
		face = 6;
		mat_light = MatLight6;
	}

	float4 shadow_tex = mul(float4(input.VtxPos.xyz, 1.0f), mat_light);
	shadow_tex = mul(shadow_tex, MatProjLight);
	float2 uv = shadow_tex.xy;
	uv /= shadow_tex.w;
	uv = uv * float2(0.5, -0.5) + float2(0.5, 0.5);

	float depth = shadow_tex.z / shadow_tex.w;

	float4 D = float4(0, 0, 0, 0);
	if (face == 1)
		D = TexShadowMap1.Sample(sampleShadowMap1, uv);
	else if (face == 2)
		D = TexShadowMap2.Sample(sampleShadowMap2, uv);
	else if (face == 3)
		D = TexShadowMap3.Sample(sampleShadowMap3, uv);
	else if (face == 4)
		D = TexShadowMap4.Sample(sampleShadowMap4, uv);
	else if (face == 5)
		D = TexShadowMap5.Sample(sampleShadowMap5, uv);
	else
		D = TexShadowMap6.Sample(sampleShadowMap6, uv);

	float4 shadow = float4(0, 0, 0, 1.0f);
	if (D.x + 0.00005f < depth){
		shadow.r = 1.0f;
		shadow.g = 1.0f;
	}
	shadow.b = length(input.VtxPos.xyz - PointLightPos.xyz);

	for (int i = 0; i <= 15; i++){

		if (LightColor[i].w < 0.001f)
			continue;

		float dist = sqrt( pow(input.VtxPos.x - LightPos[i].x, 2.0f) + pow(input.VtxPos.y - LightPos[i].y, 2.0f) + pow(input.VtxPos.z - LightPos[i].z, 2.0f));
		shadow.r -= clamp(( 1.0f - dist * 0.2f ), 0.0f, 1.0f ) * LightColor[i].w;
	}
	shadow.r = clamp(shadow.r, 0.0f, 1.0f);

	return shadow;
}

//////////////////////////////////////////////////////////////////////////////////

float3 CalcCloudWaveOffset(float3 pos){

	float3 sum = float3(0.0f, 0.0f, 0.0f);

	float t = SkyParam.y;
	for (int i = 0; i <= 7; i++){
		float4 w = CloudParam2[i];
		float wi = 2.0f / max(w.z, 0.001f);
		float rad = (dot(w.xy, float2(pos.x * 0.2f, pos.y * 0.2f)) + t);
		sum.z += sin(rad) / 8000.0f;
		sum.x += w.x * (cos(rad) + 1.0f)* CloudParam1.x / (wi);
		sum.y += w.y * (cos(rad) + 1.0f) * CloudParam1.x / (wi);
	}

	return sum;
}

float4 ps_main6(VertexOut input) : SV_Target0{

	//̕\p

	float4 color = float4(0, 0, 0, 0);
	float len = length(input.VtxPos.xy);
	float3 alpha = clamp(CalcCloudWaveOffset(float3((len - input.VtxPos.x) * 2.0f, ( len - input.VtxPos.y ) * 2.0f, 0.0f)).rgb * 2.0f + 0.3f, 0.0f, 1.0f);

	float t1 = SkyParam.x;
	float t2 = SkyParam.x * 0.15f + 0.26f;
	float cloud_volume = SkyParam.z;
	float cloud_alpha = SkyParam.w;
	float2 cloud_tex1 = float2(input.Tex.x - t1, input.Tex.y * 0.5f);
	float2 cloud_tex2 = float2(input.Tex.x - t2, input.Tex.y * 0.5f);
	float4 cloud = ( TexCloud.Sample(sampleCloud, cloud_tex1).b + TexCloud.Sample(sampleCloud, cloud_tex2).b ) * alpha.x * 0.5f * cloud_alpha;
	cloud = clamp(cloud, 0.0f, 1.0f);
	cloud.rgb *= clamp(input.VtxPos.z, 0.0f, 1.0f);

	float4 star = TexStar.Sample(sampleStar, float2(input.Tex.x * 2.8, input.Tex.y * 2.5f));
	star.rgb = max(0, star.b - cloud_volume);
	star.rgb *= max(min(2.0f - input.Tex.y * 1.8f / 2.0f, 1.0f), 0.0f);

	color.r = SkyColor.r + pow(abs(input.Pos.y / 500), 2.0f)  * cloud.r * 1.8f;
	color.g = SkyColor.g + pow(abs(input.Pos.y / 500), 2.0f) * cloud.g * 1.8f;
	color.b = SkyColor.b + pow(abs(input.Pos.y / 500), 2.0f) * cloud.b * 1.8f;
	color.r += max(0, star.r * (2.0f - SunPos.z) - cloud.r * 3.0f);
	color.g += max(0, star.g * (2.0f - SunPos.z) - cloud.g * 3.0f);
	color.b += max(0, star.b * (2.0f - SunPos.z) - cloud.b * 3.0f);
	color.a = 1.0f;

	color = clamp(color, 0.0f, 1.0f);

	if (color.r >= 0.98 && color.g >= 0.98 && color.b >= 0.98){
		color.rgb = 0.96;
	}

	return color;
}

//̕\
float4 ps_main7(VertexOut input) : SV_Target0{

	float4 color = float4(0, 0, 0, 0);

	float tex_x = input.Tex.x * 0.5f + 0.5f;
	float tex_y = -input.Tex.y * 0.5f + 0.5f;
	float4 moon_color = TexMoon.Sample(sampleMoon, float2(tex_x, tex_y));
	moon_color.rgb *= moon_color.a;

	float r = sqrt( pow( input.Tex.x, 2.0f) + pow( input.Tex.y, 2.0f));
	float power = ( 1.0f - clamp( r, 0.6f, 1.0f ));
	float4 color_around = float4(1.0f, 1.0f, 1.0f, power * 1.8f);

	float rate = cos( MoonPos.w * 3.14159265f );
	float rate_x = sqrt(sin((0.5f - abs((0.5f - tex_y ) * 1.9f ) ) * 3.14159265f)) * rate / 2.0f / 1.9f;
	if (sin(MoonPos.w * 3.14159265f ) >= 0.0f){
		if ( tex_x - 0.5f < -rate_x)
			moon_color = float4( 0, 0, 0, 0 );
	}
	else{
		if ( tex_x - 0.5f > rate_x)
			moon_color = float4( 0, 0 ,0, 0 );
	}

	color = moon_color * 0.4f  + color_around * 0.8f;

	return color;
}

/////////////////////////////////////////////////////////////////////

float4 ps_main8(VertexOut input, uint id : SV_PrimitiveID) : SV_Target0{

	//鉹XN[Z[o[p
	//q̖

	float time = SkyParam.x;

	float4 color = float4(1, 1, 1, 1);
	float Power = 0.000f;
	float4 light_color = float4(0, 0, 0, 1.0f);
	for (int i = 0; i <= 2; i++){
		float Dist = sqrt((abs(pow(input.VtxPos.x - LightPos[i].x, 2)) + abs(pow(input.VtxPos.y - LightPos[i].y, 2)) + abs(pow(input.VtxPos.z - LightPos[i].z, 2))));
		float pw = (0.8f * LightColor[i].w) / Dist;
		Power += pw;
		light_color.rgb += LightColor[i].rgb * pw;
	}
	Power = (Power < 40) ? 40 : Power;
	float dist = (pow((input.Tex.x - 0.8f) / 2.0f, 2) + pow(input.Tex.y + 0.6f, 2)) * 5.0f + 0.5f;
	Power /= dist;
	color.rgb *= Power * light_color.rgb;

	float rad = time * 60.0f;
	id -= id % 2;
	float random = ((float)(((id)* 67) % 100)) / 10.00f;
	color.rgb += sin(rad + random) / 3.0f;

	if (color.r >= 0.98 && color.g >= 0.98 && color.b >= 0.98){
		color.rgb = 0.96;
	}

	return  color;
}

//////////////////////////////////////////////////////////////////////////////////
//{[Cg

float4 ps_main9(VertexOut input) : SV_Target0{

	float4 color = float4(0, 0, 0, 1);

	float screen_w = max(VolumeLightParam1.x, 1.0f);
	float screen_h = max(VolumeLightParam1.y, 1.0f);
	uint pixel_interval = (uint) max(VolumeLightParam1.w + 0.001f, 1.0f);
	float3 texCoord1 = float3(input.Tex.x * screen_w, input.Tex.y * screen_h, 0);

	uint res_x = ((uint) texCoord1.x) % pixel_interval;
	uint res_y = ((uint) texCoord1.y) % pixel_interval;
	
	float disp_resolution = max(VolumeLightParam1.z, 0.001f);
	float4 eye = EyeVL;
	float quality = clamp(VolumeLightParam2.x, 1.0f, 100.0f);
	float4 move = float4(MoveVL.x, MoveVL.y, MoveVL.z, 0.0f);
	float light_power = 0.0f;

	float shadow_tex_size = VolumeLightParam2.y;
	float point_light_power = PointLightColor.w;
	float far = ShadowParam.x;

	if (res_x == 0 && res_y == 0){

		float2 tex_pos = input.Tex.xy * 2.0f - 1.0f;

		float vtx_depth = TexDepth.Load(texCoord1 / disp_resolution).y;
		if (vtx_depth < 0.001f)
			vtx_depth = 10000.0f;

		float4 cPos = float4(eye.xyz + move.xyz, 0.0f);
		float3 cDir = -normalize(eye.xyz);
		float4 cUp = float4(0, 0, -screen_h / screen_w, 0);
		float3 cSide = normalize( cross(cUp.xyz, cDir.xyz));
		float3 ray = normalize(cSide.xyz * tex_pos.x + cUp.xyz * tex_pos.y + cDir.xyz);

		float sight_dist = 30.0f;
		float step_length = 0.1f;
		float3 rPos = cPos.xyz;
		float len = 0.0f;

		//CƉ_̐ڐG
		while (len < sight_dist){

			float L = length(rPos.xyz - PointLightPos.xyz);
			if (L > far * 10.0f ){
				len += step_length;
				rPos = cPos.xyz + ray.xyz * len;
				continue;
			}

			int face = 0;
			matrix mat_light;
			float4 vec = float4(rPos.xyz - PointLightPos.xyz, 0.0f);

			float4 normal1 = float4(-1, 0, 0, 1.0f);
			float4 normal2 = float4(0, -1, 0, 1.0f);
			float4 normal3 = float4(0, 0, -1, 1.0f);
			float4 normal4 = float4(1, 0, 0, 1.0f);
			float4 normal5 = float4(0, 1, 0, 1.0f);
			float4 normal6 = float4(0, 0, 1, 1.0f);

			float d1 = dot(normal1, vec);
			float d2 = dot(normal2, vec);
			float d3 = dot(normal3, vec);
			float d4 = dot(normal4, vec);
			float d5 = dot(normal5, vec);
			float d6 = dot(normal6, vec);

			float d = max(d1, d2);
			d = max(d, d3);
			d = max(d, d4);
			d = max(d, d5);
			d = max(d, d6);

			if (d1 > d - 0.001f){
				face = 1;
				mat_light = MatLight1;
			}
			else if (d2 > d - 0.001f){
				face = 2;
				mat_light = MatLight2;
			}
			else if (d3 > d - 0.001f){
				face = 3;
				mat_light = MatLight3;
			}
			else if (d4 > d - 0.001f){
				face = 4;
				mat_light = MatLight4;
			}
			else if (d5 > d - 0.001f){
				face = 5;
				mat_light = MatLight5;
			}
			else{
				face = 6;
				mat_light = MatLight6;
			}

			float2 uv = float2(0, 0);
			float4 shadow_tex = mul(float4(-rPos.xyz, 1.0f), mat_light);
			shadow_tex = mul(shadow_tex, MatProjLight);

			uv = shadow_tex.xy;
			float depth = shadow_tex.z / shadow_tex.w;

			uv /= shadow_tex.w;
			uv *= shadow_tex_size;

			float4 D = float4(0, 0, 0, 0);
			if (face == 1)
				D = TexShadowMap1.Load(float3(uv.x, uv.y, 0));
			else if (face == 2)
				D = TexShadowMap2.Load(float3(uv.x, uv.y, 0));
			else if (face == 3)
				D = TexShadowMap3.Load(float3(uv.x, uv.y, 0));
			else if (face == 4)
				D = TexShadowMap4.Load(float3(uv.x, uv.y, 0));
			else if (face == 5)
				D = TexShadowMap5.Load(float3(uv.x, uv.y, 0));
			else
				D = TexShadowMap6.Load(float3(uv.x, uv.y, 0));

			float4 depth_pos = mul(float4(rPos.xyz, 0.0f), MatViewVL);
			if (depth_pos.z > vtx_depth){
				//̂ƏՓ˂B
				break;
			}

			if (D.x + 0.01f < depth){

				float LP = point_light_power * (far * 10.0f - L) / (L + far * 3.00f);
				float g = 0.3f;
				float dot_theta = dot(normalize(EyeVL.xyz), normalize(rPos.xyz - PointLightPos.xyz));
				float EP = (1.0f - pow(g, 2.0f)) / pow(4.0f * 3.1415 * (1.0f + pow(g, 2.0f) - 2.0f * g * dot_theta), 3.0f / 2.0f);
				light_power += 0.2f * LP * EP;
			}

			len += step_length;
			rPos = cPos.xyz + ray.xyz * len;
		}
	}

	light_power = clamp(light_power, 0.0f, 1.0f);
	color = float4( light_power * PointLightColor.r, light_power * PointLightColor.g, light_power * PointLightColor.b, 1.0f);

	return color;
}

float4 ps_main10(VertexOut input) : SV_Target0{

	//ԈꂽsNZʂ쐬B

	float4 color = float4(0, 0, 0, 0);

	float screen_w = VolumeLightParam1.x;
	float screen_h = VolumeLightParam1.y;
	float disp_resolution = max(VolumeLightParam1.z, 0.001f);
	uint disp_interval = (uint) (screen_w - disp_resolution * screen_w);
	uint pixel_interval = (uint)max(VolumeLightParam1.w + 0.00001f, 1.0f);

	uint width = (uint) screen_w;
	float3 texCoord = float3(input.Tex.x * screen_w, input.Tex.y * screen_h, 0);

	float tex_x = (texCoord.x - texCoord.x * disp_resolution) / (float)disp_interval;
	float tex_y = (texCoord.y - texCoord.y * disp_resolution) / (float)disp_interval;
	texCoord.x = (((uint)texCoord.x) / pixel_interval) * pixel_interval;
	texCoord.y = (((uint)texCoord.y) / pixel_interval) * pixel_interval;

	float3 texCoord1 = texCoord + float3(0, 0, 0);
	float3 texCoord2 = texCoord + float3(pixel_interval, 0, 0);
	float3 texCoord3 = texCoord + float3(0, pixel_interval, 0);
	float3 texCoord4 = texCoord + float3(pixel_interval, pixel_interval, 0);

	if (texCoord1.x < 0)
		texCoord1.x = texCoord.x;
	if (texCoord1.y < 0)
		texCoord1.y = texCoord.y;
	if (texCoord2.x > screen_w - pixel_interval)
		texCoord2.x = texCoord.x;
	if (texCoord2.y < 0)
		texCoord2.y = texCoord.y;
	if (texCoord3.x < 0)
		texCoord3.x = texCoord.x;
	if (texCoord3.y > screen_h - pixel_interval)
		texCoord3.y = texCoord.y;
	if (texCoord4.x > screen_w - pixel_interval)
		texCoord4.x = texCoord.x;
	if (texCoord4.y > screen_h - pixel_interval)
		texCoord4.y = texCoord.y;

	float4 color1 = TexVolumeLight.Load(texCoord1);
	float4 color2 = TexVolumeLight.Load(texCoord2);
	float4 color3 = TexVolumeLight.Load(texCoord3);
	float4 color4 = TexVolumeLight.Load(texCoord4);

	float4 c1 = color1 * (1.0f - tex_x) + color2 * tex_x;
	float4 c2 = color3 * (1.0f - tex_x) + color4 * tex_x;
	color = c1 * (1.0f - tex_y) + c2 * tex_y;

	return color;
}
