////////////////////////////////////////////////////////
// filename: common.cpp
// author: Chafumi Touji
// version: 1.0.0
// date: 2020/03/05
////////////////////////////////////////////////////////

#include "defcha3dcore.h"

float ToRadian(float angle){

	angle /= 360.000f;
	angle *= 2.00f;
	angle *= 3.14159f;

	return angle;
}

float ToAngle(float radian){

	radian /= 2.00f;
	radian /= 3.14159f;
	radian *= 360.000f;

	return radian;
}

void MatrixSet(matrix *mtx, float m0, float m1, float m2, float m3, float m4, float m5, float m6, float m7, float m8, float m9, float m10, float m11, float m12, float m13, float m14, float m15){

	mtx->m11 = m0;
	mtx->m12 = m1;
	mtx->m13 = m2;
	mtx->m14 = m3;
	mtx->m21 = m4;
	mtx->m22 = m5;
	mtx->m23 = m6;
	mtx->m24 = m7;
	mtx->m31 = m8;
	mtx->m32 = m9;
	mtx->m33 = m10;
	mtx->m34 = m11;
	mtx->m41 = m12;
	mtx->m42 = m13;
	mtx->m43 = m14;
	mtx->m44 = m15;
}

void MatrixInit(matrix *mtx){

	mtx->m11 = 1;
	mtx->m12 = 0;
	mtx->m13 = 0;
	mtx->m14 = 0;
	mtx->m21 = 0;
	mtx->m22 = 1;
	mtx->m23 = 0;
	mtx->m24 = 0;
	mtx->m31 = 0;
	mtx->m32 = 0;
	mtx->m33 = 1;
	mtx->m34 = 0;
	mtx->m41 = 0;
	mtx->m42 = 0;
	mtx->m43 = 0;
	mtx->m44 = 1;
}

bool GetParam(char *line, char *param1, char *param2, char *c1){

	memset(param1, 0, SIZE_CHAR_MAX);
	memset(param2, 0, SIZE_CHAR_MAX);

	char *ctx;
	char *tmp = strtok_s(line, c1, &ctx);
	if (tmp != NULL){
		strcpy_s(param1, SIZE_CHAR_MAX, tmp);
		tmp = strtok_s(NULL, c1, &ctx);
		if (tmp != NULL){
			strcpy_s(param2, SIZE_CHAR_MAX, tmp);
		}
	}

	return true;
}

bool SetVertex(CVertex *vtx, float pos_x, float pos_y, float pos_z, float normal_x, float normal_y, float normal_z, float color_r, float color_g, float color_b, float color_a, float u, float v){

	vtx->Pos.x = pos_x;
	vtx->Pos.y = pos_y;
	vtx->Pos.z = pos_z;
	vtx->Normal.x = normal_x;
	vtx->Normal.y = normal_y;
	vtx->Normal.z = normal_z;
	vtx->Color.x = color_r;
	vtx->Color.y = color_g;
	vtx->Color.z = color_b;
	vtx->Color.w = color_a;
	vtx->UV.x = u;
	vtx->UV.y = v;

	return true;
}
