////////////////////////////////////////////////////////
// filename: CCommonDevice.cpp
// author: Chafumi Touji
// version: 1.0.0
// date: 2020/07/11
////////////////////////////////////////////////////////

#include "defcha3dcore.h"
#include "vs1.h"
#include "vs1_1.h"
#include "vs1_2.h"
#include "vs1_3.h"
#include "vs1_4.h"
#include "vs2.h"
#include "vs3.h"
#include "vs3_1.h"
#include "ps1.h"
#include "ps2.h"
#include "ps3.h"
#include "ps4.h"
#include "ps5.h"
#include "ps6.h"
#include "ps7.h"
#include "ps8.h" //鉹XN[Z[o[p
#include "ps9.h"
#include "ps10.h"

CCommonDevice::CCommonDevice(){

	m_pDevice = NULL;
	m_pDeviceContext = NULL;
	m_pDXGI = NULL;
	m_pAdapter = NULL;
	m_pFactory = NULL;
	m_pSwapChain = NULL;
	m_pBackBuffer = NULL;
	m_pDiffuseTexture = NULL;
	m_pRenderTargetView = NULL;
	m_pDiffuseRenderTargetView = NULL;
	m_pGDIRenderTargetView = NULL;
	m_pDepthStencilView = NULL;
	m_pDepthBuffer = NULL;
	m_pDepthTexture = NULL;
	m_pGDITexture = NULL;
	m_pDiffuseShaderResourceView = NULL;
	m_pDepthShaderResourceView = NULL;
	m_pGDIShaderResourceView = NULL;
	m_pDepthRenderTargetView = NULL;
	m_pLayout1 = NULL;
	m_pLayout2 = NULL;
	m_pVtxShader1 = NULL;
	m_pVtxShader1_1 = NULL;
	m_pVtxShader1_2 = NULL;
	m_pVtxShader1_3 = NULL;
	m_pVtxShader1_4 = NULL;
	m_pVtxShader2 = NULL;
	m_pVtxShader3 = NULL;
	m_pVtxShader3_1 = NULL;
	m_pPxShader1 = NULL;
	m_pPxShader2 = NULL;
	m_pPxShader3 = NULL;
	m_pPxShader4 = NULL;
	m_pPxShader5 = NULL;
	m_pPxShader6 = NULL;
	m_pPxShader7 = NULL;
	m_pPxShader8 = NULL;
	m_pPxShader9 = NULL;
	m_pPxShader10 = NULL;
	m_pConstantBuffer1 = NULL;
	m_pSampleState = NULL;
	m_pRasterizeState = NULL;
	m_pBlendState1 = NULL;
	m_pBlendState2 = NULL;
	m_pSurface = NULL;
	VertexBuffer = NULL;

	for (int i = 0; i <= LIGHT_NUM_MAX - 1; i++){
		ShaderLightPos[i] = XMFLOAT4(0, 0, 0, 0);
		ShaderLight[i] = XMFLOAT4(0, 0, 0, 0);
	}

	Eye.x = 0.0f;
	Eye.y = 0.0f;
	Eye.z = 0.0f;
	At.x = 0.0f;
	At.y = 0.0f;
	At.z = 0.0f;
	Move.x = 0.0f;
	Move.y = 0.0f;
	Move.z = 0.0f;
	RotationX = 0.0f;
	RotationY = 0.0f;
	RotationZ = 0.0f;
	Zoom = DEFAULT_ZOOM;
	MSAA_Count = 1;
	MSAA_Quality = 0;
}

CCommonDevice::~CCommonDevice(){

	SAFE_RELEASE( m_pDevice );
	SAFE_RELEASE(m_pDeviceContext);
	SAFE_RELEASE(m_pDXGI);
	SAFE_RELEASE(m_pAdapter);
	SAFE_RELEASE(m_pFactory);
	SAFE_RELEASE(m_pSwapChain);
	SAFE_RELEASE(m_pBackBuffer);
	SAFE_RELEASE(m_pDiffuseTexture);
	SAFE_RELEASE(m_pRenderTargetView);
	SAFE_RELEASE(m_pDiffuseRenderTargetView);
	SAFE_RELEASE(m_pGDIRenderTargetView);
	SAFE_RELEASE(m_pDepthStencilView);
	SAFE_RELEASE(m_pDepthBuffer);
	SAFE_RELEASE(m_pDepthTexture);
	SAFE_RELEASE(m_pGDITexture);
	SAFE_RELEASE(m_pDiffuseShaderResourceView);
	SAFE_RELEASE(m_pDepthShaderResourceView);
	SAFE_RELEASE(m_pGDIShaderResourceView);
	SAFE_RELEASE(m_pDepthRenderTargetView);
	SAFE_RELEASE(m_pLayout1);
	SAFE_RELEASE(m_pLayout2);
	SAFE_RELEASE(m_pVtxShader1);
	SAFE_RELEASE(m_pVtxShader1_1);
	SAFE_RELEASE(m_pVtxShader1_2);
	SAFE_RELEASE(m_pVtxShader1_3);
	SAFE_RELEASE(m_pVtxShader1_4);
	SAFE_RELEASE(m_pVtxShader2);
	SAFE_RELEASE(m_pVtxShader3);
	SAFE_RELEASE(m_pVtxShader3_1);
	SAFE_RELEASE(m_pPxShader1);
	SAFE_RELEASE(m_pPxShader2);
	SAFE_RELEASE(m_pPxShader3);
	SAFE_RELEASE(m_pPxShader4);
	SAFE_RELEASE(m_pPxShader5);
	SAFE_RELEASE(m_pPxShader6);
	SAFE_RELEASE(m_pPxShader7);
	SAFE_RELEASE(m_pPxShader8);
	SAFE_RELEASE(m_pPxShader9);
	SAFE_RELEASE(m_pPxShader10);
	SAFE_RELEASE(m_pConstantBuffer1);
	SAFE_RELEASE(m_pSampleState);
	SAFE_RELEASE(m_pRasterizeState);
	SAFE_RELEASE(m_pBlendState1);
	SAFE_RELEASE(m_pBlendState2);
	SAFE_RELEASE(m_pSurface);
	SAFE_RELEASE(VertexBuffer);
}

bool CCommonDevice::CreateDevice( HWND m_hWnd, int width, int height ){

	Width = width;
	Height = height;

	D3D11CreateDevice(NULL, D3D_DRIVER_TYPE_HARDWARE, NULL, 0, NULL, 0, D3D11_SDK_VERSION, &m_pDevice, NULL, &m_pDeviceContext);

	UINT quality = 0;
	UINT count = 1;
	for (int i = 1; i <= D3D11_MAX_MULTISAMPLE_SAMPLE_COUNT - 1; i++){
		HRESULT hr = m_pDevice->CheckMultisampleQualityLevels(DXGI_FORMAT_D24_UNORM_S8_UINT, (UINT)i, &quality);
		if (quality > 0 && quality < 32){
			MSAA_Count = i;
			MSAA_Quality = quality - 1;
		}
	}

	//}`TvȂ
	MSAA_Count = 1;
	MSAA_Quality = 0;

	//C^[tF[X擾
	m_pDXGI = NULL;
	m_pDevice->QueryInterface(__uuidof(IDXGIDevice1), (void **)&m_pDXGI);
	
	//A_v^[擾
	m_pAdapter = NULL;
	m_pDXGI->GetAdapter(&m_pAdapter);
	
	//t@Ng[擾
	m_pAdapter->GetParent(__uuidof(IDXGIFactory), (void **)&m_pFactory);
	
	DXGI_SWAP_CHAIN_DESC desc;
	desc.BufferDesc.Width = width;
	desc.BufferDesc.Height = height;
	desc.BufferDesc.RefreshRate.Numerator = 0;
	desc.BufferDesc.RefreshRate.Denominator = 1;
	desc.BufferDesc.Format = DXGI_FORMAT_B8G8R8A8_UNORM;
	desc.BufferDesc.ScanlineOrdering = DXGI_MODE_SCANLINE_ORDER_UNSPECIFIED;
	desc.BufferDesc.Scaling = DXGI_MODE_SCALING_UNSPECIFIED;
	desc.SampleDesc.Count = MSAA_Count;
	desc.SampleDesc.Quality = MSAA_Quality;
	desc.BufferUsage = DXGI_USAGE_RENDER_TARGET_OUTPUT;
	desc.BufferCount = 1;
	desc.OutputWindow = m_hWnd;
	desc.Windowed = true;
	desc.SwapEffect = DXGI_SWAP_EFFECT_DISCARD;
	desc.Flags = DXGI_SWAP_CHAIN_FLAG_ALLOW_MODE_SWITCH;

	m_pFactory->CreateSwapChain(m_pDevice, &desc, &m_pSwapChain);
	m_pSwapChain->SetFullscreenState(true, 0);
	m_pSwapChain->GetBuffer(0, __uuidof(ID3D11Texture2D), (void **)&m_pBackBuffer);	
	m_pDevice->CreateRenderTargetView(m_pBackBuffer, NULL, &m_pRenderTargetView);
	
	////////////////////////////////////////////////////////////////////////

	D3D11_TEXTURE2D_DESC desc_texture_2d;
	ZeroMemory(&desc_texture_2d, sizeof(D3D11_TEXTURE2D_DESC));
	desc_texture_2d.Width = width;
	desc_texture_2d.Height = height;
	desc_texture_2d.MipLevels = 1;
	desc_texture_2d.ArraySize = 1;
	desc_texture_2d.Format = DXGI_FORMAT_B8G8R8A8_UNORM;
	desc_texture_2d.SampleDesc.Count = 1;
	desc_texture_2d.SampleDesc.Quality = 0;
	desc_texture_2d.Usage = D3D11_USAGE_DEFAULT;
	desc_texture_2d.BindFlags = D3D11_BIND_SHADER_RESOURCE | D3D11_BIND_RENDER_TARGET;
	desc_texture_2d.CPUAccessFlags = 0;
	desc_texture_2d.MiscFlags = D3D11_RESOURCE_MISC_GDI_COMPATIBLE;

	D3D11_SHADER_RESOURCE_VIEW_DESC desc_shader_resource;
	ZeroMemory(&desc_shader_resource, sizeof(D3D11_SHADER_RESOURCE_VIEW_DESC));
	desc_shader_resource.Format = desc_texture_2d.Format;
	desc_shader_resource.ViewDimension = D3D11_SRV_DIMENSION_TEXTURE2D;
	desc_shader_resource.Texture2D.MipLevels = desc_texture_2d.MipLevels;
	desc_shader_resource.Texture2D.MostDetailedMip = 0;

	///////////////////////////////////////////////////////////////////////
	// fBt[YeNX`쐬

	m_pDevice->CreateTexture2D(&desc_texture_2d, NULL, &m_pDiffuseTexture);
	m_pDevice->CreateShaderResourceView(m_pDiffuseTexture, &desc_shader_resource, &m_pDiffuseShaderResourceView);
	m_pDevice->CreateRenderTargetView(m_pDiffuseTexture, NULL, &m_pDiffuseRenderTargetView);
	
	/*-----------------------------------------------------*/
	//HDC`p̃eNX`쐬

	desc_texture_2d.Width = ::GetSystemMetrics(SM_CXSCREEN);
	desc_texture_2d.Height = ::GetSystemMetrics(SM_CYSCREEN);;

	m_pDevice->CreateTexture2D(&desc_texture_2d, NULL, &m_pGDITexture);
	m_pDevice->CreateShaderResourceView(m_pGDITexture, &desc_shader_resource, &m_pGDIShaderResourceView);
	m_pDevice->CreateRenderTargetView(m_pGDITexture, NULL, &m_pGDIRenderTargetView);
	m_pGDITexture->QueryInterface(__uuidof(IDXGISurface1), (void **)&m_pSurface);

	///////////////////////////////////////////////////////////////////////
	// [xobt@

	ZeroMemory(&desc_texture_2d, sizeof(D3D11_TEXTURE2D_DESC));
	desc_texture_2d.Width = width;
	desc_texture_2d.Height = height;
	desc_texture_2d.MipLevels = 1;
	desc_texture_2d.ArraySize = 1;
	desc_texture_2d.Format = DXGI_FORMAT_R32_TYPELESS;
	desc_texture_2d.SampleDesc.Count = 1;
	desc_texture_2d.SampleDesc.Quality = 0;
	desc_texture_2d.Usage = D3D11_USAGE_DEFAULT;
	desc_texture_2d.BindFlags = D3D11_BIND_DEPTH_STENCIL | D3D11_BIND_SHADER_RESOURCE;
	desc_texture_2d.CPUAccessFlags = 0;
	desc_texture_2d.MiscFlags = 0;

	m_pDevice->CreateTexture2D(&desc_texture_2d, NULL, &m_pDepthBuffer);

	D3D11_DEPTH_STENCIL_VIEW_DESC desc_stencil_view;
	ZeroMemory(&desc_stencil_view, sizeof(D3D11_DEPTH_STENCILOP_DESC));
	desc_stencil_view.Format = DXGI_FORMAT_D32_FLOAT;
	desc_stencil_view.ViewDimension = D3D11_DSV_DIMENSION_TEXTURE2D;
	desc_stencil_view.Texture2D.MipSlice = 0;

	m_pDevice->CreateDepthStencilView(m_pDepthBuffer, &desc_stencil_view, &m_pDepthStencilView);

	/*-----------------------------------------------------*/
	//VhE}bvp̐[xeNX`

	desc_texture_2d.Format = DXGI_FORMAT_R32G32B32A32_FLOAT;
	desc_texture_2d.SampleDesc.Count = 1;
	desc_texture_2d.SampleDesc.Quality = 0;
	desc_texture_2d.Width = width;
	desc_texture_2d.Height = height;
	desc_texture_2d.BindFlags = D3D11_BIND_RENDER_TARGET | D3D11_BIND_SHADER_RESOURCE;
	m_pDevice->CreateTexture2D(&desc_texture_2d, NULL, &m_pDepthTexture);
	
	ZeroMemory(&desc_shader_resource, sizeof(D3D11_SHADER_RESOURCE_VIEW_DESC));
	desc_shader_resource.Format = desc_texture_2d.Format;
	desc_shader_resource.ViewDimension = D3D11_SRV_DIMENSION_TEXTURE2D;
	desc_shader_resource.Texture2D.MipLevels = desc_texture_2d.MipLevels;
	desc_shader_resource.Texture2D.MostDetailedMip = 0;
	m_pDevice->CreateShaderResourceView(m_pDepthTexture, &desc_shader_resource, &m_pDepthShaderResourceView);
	m_pDevice->CreateRenderTargetView(m_pDepthTexture, NULL, &m_pDepthRenderTargetView);
	
	//////////////////////////////////////////////////////////////////
	// ConstantBuffer

	D3D11_BUFFER_DESC desc_buffer;
	m_pConstantBuffer1 = NULL;
	ZeroMemory(&desc_buffer, sizeof(D3D11_BUFFER_DESC));
	desc_buffer.ByteWidth = sizeof(ConstantBuffer1);
	desc_buffer.Usage = D3D11_USAGE_DYNAMIC;
	desc_buffer.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	desc_buffer.CPUAccessFlags = D3D11_CPU_ACCESS_WRITE;
	desc_buffer.MiscFlags = 0;
	desc_buffer.StructureByteStride = sizeof(float);
	m_pDevice->CreateBuffer(&desc_buffer, NULL, &m_pConstantBuffer1);

	////////////////////////////////////////////////////////////////////////////////////////
	// VF[_CvbgCAEg쐬

	D3D11_INPUT_ELEMENT_DESC desc_input_element1[] = {

		// texcood 0̓eNX`UVłB
		// texcood 1`8̓{[̃EFCg͂܂BWEIGHT_BONE_APPLY_NUM̐texcoordKv܂B(default = 8)

		{ "POSITION", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, 0, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "NORMAL", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, 4 * 3, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "COLOR", 0, DXGI_FORMAT_R32G32B32A32_FLOAT, 0, 4 * 3 + 4 * 3, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 0, DXGI_FORMAT_R32G32_FLOAT, 0, 4 * 3 + 4 * 3 + 4 * 4, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 1, DXGI_FORMAT_R32G32_FLOAT, 0, 4 * 3 + 4 * 3 + 4 * 4 + 4 * 2, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 2, DXGI_FORMAT_R32G32_FLOAT, 0, 4 * 3 + 4 * 3 + 4 * 4 + 4 * 4, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 3, DXGI_FORMAT_R32G32_FLOAT, 0, 4 * 3 + 4 * 3 + 4 * 4 + 4 * 6, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 4, DXGI_FORMAT_R32G32_FLOAT, 0, 4 * 3 + 4 * 3 + 4 * 4 + 4 * 8, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 5, DXGI_FORMAT_R32G32_FLOAT, 0, 4 * 3 + 4 * 3 + 4 * 4 + 4 * 10, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 6, DXGI_FORMAT_R32G32_FLOAT, 0, 4 * 3 + 4 * 3 + 4 * 4 + 4 * 12, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 7, DXGI_FORMAT_R32G32_FLOAT, 0, 4 * 3 + 4 * 3 + 4 * 4 + 4 * 14, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 8, DXGI_FORMAT_R32G32_FLOAT, 0, 4 * 3 + 4 * 3 + 4 * 4 + 4 * 16, D3D11_INPUT_PER_VERTEX_DATA, 0 },
	};

	m_pDevice->CreateInputLayout(desc_input_element1, ARRAYSIZE(desc_input_element1), &g_vs_main1, sizeof(g_vs_main1), &m_pLayout1);

	D3D11_INPUT_ELEMENT_DESC desc_input_element2[] = {

		{ "POSITION", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, 0, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "NORMAL", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, 4 * 3, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "COLOR", 0, DXGI_FORMAT_R32G32B32A32_FLOAT, 0, 4 * 3 + 4 * 3, D3D11_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 0, DXGI_FORMAT_R32G32_FLOAT, 0, 4 * 3 + 4 * 3 + 4 * 4, D3D11_INPUT_PER_VERTEX_DATA, 0 },
	};

	m_pDevice->CreateInputLayout(desc_input_element2, ARRAYSIZE(desc_input_element2), &g_vs_main1_2, sizeof(g_vs_main1_2), &m_pLayout2);

	///////////////////////////////////////////////////////////////////////////////////////////////////////////
	// vertex shader

	m_pDevice->CreateVertexShader(&g_vs_main1, sizeof(g_vs_main1), NULL, &m_pVtxShader1);
	m_pDevice->CreateVertexShader(&g_vs_main1_1, sizeof(g_vs_main1_1), NULL, &m_pVtxShader1_1);
	m_pDevice->CreateVertexShader(&g_vs_main1_2, sizeof(g_vs_main1_2), NULL, &m_pVtxShader1_2);
	m_pDevice->CreateVertexShader(&g_vs_main1_3, sizeof(g_vs_main1_3), NULL, &m_pVtxShader1_3);
	m_pDevice->CreateVertexShader(&g_vs_main1_3, sizeof(g_vs_main1_3), NULL, &m_pVtxShader1_4);
	m_pDevice->CreateVertexShader(&g_vs_main2, sizeof(g_vs_main2), NULL, &m_pVtxShader2);
	m_pDevice->CreateVertexShader(&g_vs_main3, sizeof(g_vs_main3), NULL, &m_pVtxShader3);
	m_pDevice->CreateVertexShader(&g_vs_main3_1, sizeof(g_vs_main3_1), NULL, &m_pVtxShader3_1);

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// pixel shader

	m_pDevice->CreatePixelShader(&g_ps_main1, sizeof(g_ps_main1), NULL, &m_pPxShader1);
	m_pDevice->CreatePixelShader(&g_ps_main2, sizeof(g_ps_main2), NULL, &m_pPxShader2);
	m_pDevice->CreatePixelShader(&g_ps_main3, sizeof(g_ps_main3), NULL, &m_pPxShader3);
	m_pDevice->CreatePixelShader(&g_ps_main4, sizeof(g_ps_main4), NULL, &m_pPxShader4);
	m_pDevice->CreatePixelShader(&g_ps_main5, sizeof(g_ps_main5), NULL, &m_pPxShader5);
	m_pDevice->CreatePixelShader(&g_ps_main6, sizeof(g_ps_main6), NULL, &m_pPxShader6);
	m_pDevice->CreatePixelShader(&g_ps_main7, sizeof(g_ps_main7), NULL, &m_pPxShader7);
	m_pDevice->CreatePixelShader(&g_ps_main8, sizeof(g_ps_main8), NULL, &m_pPxShader8);
	m_pDevice->CreatePixelShader(&g_ps_main9, sizeof(g_ps_main9), NULL, &m_pPxShader9);
	m_pDevice->CreatePixelShader(&g_ps_main10, sizeof(g_ps_main10), NULL, &m_pPxShader10);

	//////////////////////////////////////////////////////////////////////////////////
	// TvXe[g

	D3D11_SAMPLER_DESC sample_desc;
	ZeroMemory(&sample_desc, sizeof(sample_desc));
	sample_desc.Filter = D3D11_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR;
	sample_desc.AddressU = D3D11_TEXTURE_ADDRESS_WRAP;
	sample_desc.AddressV = D3D11_TEXTURE_ADDRESS_WRAP;
	sample_desc.AddressW = D3D11_TEXTURE_ADDRESS_WRAP;
	sample_desc.MaxLOD = D3D11_FLOAT32_MAX;
	sample_desc.MinLOD = 0;
	sample_desc.ComparisonFunc = D3D11_COMPARISON_ALWAYS;

	m_pDevice->CreateSamplerState(&sample_desc, &m_pSampleState);

	///////////////////////////////////////////////////////////////////////////////////////////
	//X^CY

	D3D11_RASTERIZER_DESC raster_desc;
	ZeroMemory(&raster_desc, sizeof(raster_desc));
	raster_desc.MultisampleEnable = false;
	raster_desc.ScissorEnable = false;
	raster_desc.AntialiasedLineEnable = true;
	raster_desc.DepthClipEnable = true;
	raster_desc.CullMode = D3D11_CULL_NONE;
	raster_desc.FillMode = D3D11_FILL_SOLID;
	raster_desc.DepthBiasClamp = 0.05f;
	raster_desc.SlopeScaledDepthBias = 0;

	m_pDevice->CreateRasterizerState(&raster_desc, &m_pRasterizeState);

	////////////////////////////////////////////////////////////////////
	// uhXeCg

	D3D11_BLEND_DESC desc_blend;
	ZeroMemory(&desc_blend, sizeof(D3D11_BLEND_DESC));
	desc_blend.AlphaToCoverageEnable = true;
	desc_blend.IndependentBlendEnable = false;
	desc_blend.RenderTarget[0].BlendEnable = true;
	desc_blend.RenderTarget[0].SrcBlend = D3D11_BLEND_SRC_ALPHA;
	desc_blend.RenderTarget[0].DestBlend = D3D11_BLEND_INV_SRC_ALPHA;
	desc_blend.RenderTarget[0].BlendOp = D3D11_BLEND_OP_ADD;
	desc_blend.RenderTarget[0].SrcBlendAlpha = D3D11_BLEND_ONE;
	desc_blend.RenderTarget[0].DestBlendAlpha = D3D11_BLEND_ZERO;
	desc_blend.RenderTarget[0].BlendOpAlpha = D3D11_BLEND_OP_ADD;
	desc_blend.RenderTarget[0].RenderTargetWriteMask = D3D11_COLOR_WRITE_ENABLE_ALL;
	m_pDevice->CreateBlendState(&desc_blend, &m_pBlendState1); //ʏ̃At@uh

	ZeroMemory(&desc_blend, sizeof(D3D11_BLEND_DESC));
	desc_blend.AlphaToCoverageEnable = false;
	desc_blend.IndependentBlendEnable = false;
	desc_blend.RenderTarget[0].BlendEnable = true;
	desc_blend.RenderTarget[0].SrcBlend = D3D11_BLEND_SRC_ALPHA;
	desc_blend.RenderTarget[0].DestBlend = D3D11_BLEND_INV_SRC_ALPHA;
	desc_blend.RenderTarget[0].BlendOp = D3D11_BLEND_OP_ADD;
	desc_blend.RenderTarget[0].SrcBlendAlpha = D3D11_BLEND_SRC_ALPHA;
	desc_blend.RenderTarget[0].DestBlendAlpha = D3D11_BLEND_INV_SRC_ALPHA;
	desc_blend.RenderTarget[0].BlendOpAlpha = D3D11_BLEND_OP_ADD;
	desc_blend.RenderTarget[0].RenderTargetWriteMask = D3D11_COLOR_WRITE_ENABLE_ALL;
	m_pDevice->CreateBlendState(&desc_blend, &m_pBlendState2); //pAt@uh

	/////////////////////////////////////////////////////////////////////

	CVertex vtx[4];
	SetVertex(&vtx[0], -1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0);
	SetVertex(&vtx[1], 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0);
	SetVertex(&vtx[2], -1, -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1);
	SetVertex(&vtx[3], 1, -1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1);

	ZeroMemory(&desc_buffer, sizeof(D3D11_BUFFER_DESC));
	desc_buffer.ByteWidth = sizeof(CVertex)* 4;
	desc_buffer.Usage = D3D11_USAGE_DYNAMIC;
	desc_buffer.BindFlags = D3D11_BIND_VERTEX_BUFFER;
	desc_buffer.CPUAccessFlags = D3D11_CPU_ACCESS_WRITE;
	desc_buffer.MiscFlags = 0;
	desc_buffer.StructureByteStride = sizeof(float);

	D3D11_SUBRESOURCE_DATA res_data_buffer;
	res_data_buffer.pSysMem = &vtx[0];
	ID3D11Buffer *vertex_buffer = NULL;
	m_pDevice->CreateBuffer(&desc_buffer, &res_data_buffer, &VertexBuffer);

	return true;
}

bool CCommonDevice::SetViewParam( float screen_width, float screen_height, float aspect ){

	matWorld = XMMatrixIdentity();
	matView = XMMatrixIdentity();
	matProj = XMMatrixIdentity();

	Eye.x = cos(RotationZ) * sin(RotationX) * Zoom;
	Eye.y = sin(RotationZ) * sin(RotationX) * Zoom;
	Eye.z = cos(RotationX) * Zoom;

	XMVECTOR at = XMVectorSet(At.x, At.y, At.z, 1.0f);
	XMVECTOR eye = XMVectorSet(Eye.x + At.x, Eye.y + At.y, Eye.z + At.z, 1.0f);
	XMVECTOR up = XMVectorSet(0, 0, 1, 0.0f);
	matView = XMMatrixLookAtLH(eye, at, up) * XMMatrixScaling(-1, 1, 1);
	matProj = XMMatrixPerspectiveFovLH(ToRadian(45.00), aspect, 0.001, 5000.0);

	ConstantBuffer1 constant_buffer1;
	XMStoreFloat4x4(&constant_buffer1.MatWorld, XMMatrixTranspose(matWorld));
	XMStoreFloat4x4(&constant_buffer1.MatView, XMMatrixTranspose(matView));
	XMStoreFloat4x4(&constant_buffer1.MatProj, XMMatrixTranspose(matProj));
	constant_buffer1.EyePos = XMFLOAT4(Eye.x + At.x, Eye.y + At.y, Eye.z + At.z, 1.0f);

	//VF[_[Cg̐ݒ
	for (int i = 0; i <= LIGHT_NUM_MAX - 1; i++){
		constant_buffer1.LightColor[i] = ShaderLight[i];
		constant_buffer1.LightPos[i] = ShaderLightPos[i];
	}

	//RX^gobt@ݒ
	D3D11_MAPPED_SUBRESOURCE resource;
	m_pDeviceContext->Map(m_pConstantBuffer1, 0, D3D11_MAP_WRITE_DISCARD, 0, &resource);
	memcpy(resource.pData, &constant_buffer1, sizeof(ConstantBuffer1));
	m_pDeviceContext->Unmap(m_pConstantBuffer1, 0);

	m_pDeviceContext->VSSetConstantBuffers(0, 1, &m_pConstantBuffer1);
	m_pDeviceContext->PSSetConstantBuffers(0, 1, &m_pConstantBuffer1);

	return true;
}