////////////////////////////////////////////////////////
// filename: ChaResourceObject.h
// author: Chafumi Touji
// version: 1.0.0
// date: 2020/03/08
////////////////////////////////////////////////////////

#ifndef __CHARESOURCEOBJECT_H__
#define __CHARESOURCEOBJECT_H__

struct ConstantBufferMaterial{

	XMFLOAT4		Ambient;
	XMFLOAT4		Diffuse;
	XMFLOAT4		Specular;
};

struct ConstantBufferBoneJoint{

	XMFLOAT4X4		BindShapeMatrix;
	XMFLOAT4X4		BoneMatrix[BONE_JOINT_NUM_MAX];
};

class CMaterialResource{
public:	
	float4 diffuse;
	float4 ambient;
	float4 emmition;
	float4 specular;
	ID3D11Texture2D *Texture;
	ID3D11ShaderResourceView *ShaderResourceView;

public:
	CMaterialResource();
	~CMaterialResource();
};

class CGeometryResource{
public:

	ID3D11Buffer	*VertexBuffer;
	CVector	*IndexBuffer;
	CVector	*Material;
	CVector *IndexCount;
	XMMATRIX BindShapeMatrix;
	int		WeightCount;

public:
	CGeometryResource();
	~CGeometryResource();
};

class CBoneResource{
public:

	wchar_t ID[SIZE_CHAR_MAX];
	wchar_t Name[SIZE_CHAR_MAX];

	XMMATRIX	JointParam;
	XMMATRIX	InvBindMatrix;
	XMMATRIX	JointParamTransformed;
	XMMATRIX	BoneMatrix;

	CVector			*ChildBone;
	CBoneResource	*ParentBone;
	int				Type;

public:

	CBoneResource();
	~CBoneResource();
};

class CAnimationResource{
public:

	wchar_t AnimationID[SIZE_CHAR_MAX];
	CVector *BoneAnimation;

public:

	CAnimationResource();
	~CAnimationResource();
};

class CBoneAnimationResource{
public:

	wchar_t Target[SIZE_CHAR_MAX];
	CBoneResource *TargetBone;

	CVector *KeyTime;
	CVector *PoseMatrix;
	bool Refrain;

public:

	CBoneAnimationResource();
	~CBoneAnimationResource();
};

class CChaResourceObject{
public:

	wchar_t	ModelID[SIZE_CHAR_MAX];
	int		CurrentAnimationNum;

	UINT	FrameCount;
	CVector	*GeometryResource;
	CVector	*TextureOrigin;
	CVector	*ShaderResourceOrigin;
	CVector *ControlBone;
	CVector *BoneArray;
	CVector *AnimationList;

	ID3D11Buffer *m_pConstantBuffer1; //}eÃfBt[Yݒp
	ID3D11Buffer *m_pConstantBuffer2; //{[̃WCg}gNXݒp

public:
	CChaResourceObject();
	~CChaResourceObject();
	bool CreateResource( ID3D11Device *m_pDevice, CChaDataObject *object);
	bool Draw(ID3D11DeviceContext *m_pDeviceContext);
	bool UpdateTransform(ID3D11Device *m_pDevice, CChaDataObject *object );
	bool CopyAnimation(CChaDataObject *object);
	bool CopyAnimation(CChaDataObject *object, int anim_num );
	bool SetCurrentAnimation(int num);

private:
	bool BoneInit(CBoneResource *bone);
	bool CopyControlBone(CChaDataObject *object);
	bool CopyChildBone(CBone *parent, CBoneResource *parent_res);
	bool BoneTransform(CBoneResource *bone);
	XMMATRIX GetAnimationMatrix(CBoneAnimationResource *bone_anim, float sec);
	XMMATRIX CalcInterPauseLinear(XMMATRIX matrix1, XMMATRIX matrix2, float t);
	CBoneResource *FindBoneByID(wchar_t *search_name);
};
#endif