////////////////////////////////////////////////////////
// filename: ChaResourceObject.h
// author: Chafumi Touji
// version: 1.0.0
// date: 2020/03/08
////////////////////////////////////////////////////////

#ifndef __CHARESOURCEOBJECT_H__
#define __CHARESOURCEOBJECT_H__

struct MaterialResource{

	float4 diffuse;
	float4 ambient;
	float4 emmition;
	float4 specular;
	ID3D11Texture2D **Texture;
	ID3D11ShaderResourceView **ShaderResourceView;
};

class CGeometryResource{
public:

	ID3D11Buffer	*VertexBuffer;
	CVector	*IndexBuffer;
	CVector	*Material;
	CVector *IndexCount;

public:
	CGeometryResource();
	~CGeometryResource();
};

class CChaResourceObject{
public:

	bool	ReadyResource;
	CVector	*GeometryResource;
	CVector	*TextureOrigin;
	CVector	*ShaderResourceOrigin;

public:
	CChaResourceObject();
	~CChaResourceObject();
	bool CreateResource( ID3D11Device *m_pDevice, CChaDataObject *object);
	bool Draw(ID3D11DeviceContext *m_pDeviceContext);

};
#endif