
Texture2D txDiffuse : register(t0);
SamplerState samDiffuse : register(s0);

Texture2D txDepth : register(t1);
SamplerState samDepth : register(s1);

cbuffer ConstantBuffer1 : register(b0){

	matrix	MatWorld;
	matrix	MatView;
	matrix	MatProj;
	float4	Light;
}

////////////////////////////////////////////////////////

struct VertexIn{

	float3 Pos : POSITION;
	float3 Normal : NORMAL;
	float4 Color : COLOR;
	float2 Tex : TEXCOORD;
};

struct VertexOut{

	float4 Pos : SV_POSITION;
	float3 VtxPos : POSITION0;
	float3 Normal : POSITION1;
	float4 Color : COLOR0;
	float2 Tex : TEXCOORD0;
};

struct PsOutput{

	float4 Color : SV_Target0;
	float4 Depth : SV_Target1;
};

VertexOut vs_main1(VertexIn IN){

	VertexOut OUT;

	OUT.Pos = mul(float4(IN.Pos, 1.0), MatWorld);
	OUT.Pos = mul(OUT.Pos, MatView);
	OUT.Pos = mul(OUT.Pos, MatProj);
	OUT.Normal = IN.Normal;
	OUT.VtxPos = IN.Pos;
	OUT.Color = float4( 0, 0, 0, 1 );
	OUT.Tex = IN.Tex;

	return OUT;
}

VertexOut vs_main2(VertexIn IN){

	VertexOut OUT;

	OUT.Pos = float4( IN.Pos, 1.0f );
	OUT.Normal = IN.Normal;
	OUT.VtxPos = IN.Pos;
	OUT.Color = float4(0, 0, 0, 1);
	OUT.Tex = IN.Tex;

	return OUT;
}

/////////////////////////////////////////////////////////////////////////

PsOutput ps_main1(VertexOut input){

	PsOutput output;

	input.Tex.y = -input.Tex.y;
	float4 tex_color = txDiffuse.Sample(samDiffuse, input.Tex);
	if (tex_color.r < 0.001 && tex_color.g < 0.001 && tex_color.b < 0.001){
		tex_color = input.Color;
	}
	if (tex_color.r >= 0.99999 && tex_color.g >= 0.99999 && tex_color.b >= 0.99999){
		tex_color.rgb = 0.98;
	}

	//g[VF[_
	float3 vec1 = normalize( Light.xyz - input.VtxPos.xyz);
	float d = dot(vec1, normalize(input.Normal.xyz));
	if (d < -0.1){
		tex_color.gb *= 0.7f;
		tex_color.r *= 0.8f;
	}
	else if (d < 0.5f){
		tex_color.gb *= 0.9f;
		tex_color.r *= 0.95f;
	}

	output.Color = tex_color;
	output.Depth = float4( input.Pos.z / input.Pos.w, 0, 0, 1);

	return output;
}

float4 ps_main2(VertexOut input) : SV_Target0{
	
	float4 tex_color = txDiffuse.Sample(samDiffuse, input.Tex.xy);

	//GbW̋E`

	float tex_x = 1.0f / 1000.0f;
	float tex_y = 1.0f / 1000.0f;

	float4 d_center = txDepth.Sample(samDepth, input.Tex.xy);
	float4 d0 = txDepth.Sample(samDepth, input.Tex.xy + float2(-tex_x * 0.8f, -tex_y * 0.8f));
	float4 d1 = txDepth.Sample(samDepth, input.Tex.xy + float2(0.0f, -tex_y));
	float4 d2 = txDepth.Sample(samDepth, input.Tex.xy + float2(tex_x * 0.8f, -tex_y * 0.8f));
	float4 d3 = txDepth.Sample(samDepth, input.Tex.xy + float2(tex_x, 0.0f));
	float4 d4 = txDepth.Sample(samDepth, input.Tex.xy + float2(tex_x * 0.8f, tex_y * 0.8f));
	float4 d5 = txDepth.Sample(samDepth, input.Tex.xy + float2(0.0f, tex_y));
	float4 d6 = txDepth.Sample(samDepth, input.Tex.xy + float2(-tex_x * 0.8f, tex_y * 0.8f));
	float4 d7 = txDepth.Sample(samDepth, input.Tex.xy + float2(-tex_x, 0.0f));

	float D0 = ( d_center.x - d0.x) / max(abs(d4.x - d_center.x), 0.00005f );
	float D1 = ( d_center.x - d1.x) / max(abs(d5.x - d_center.x), 0.00005f);
	float D2 = ( d_center.x - d2.x) / max(abs(d6.x - d_center.x), 0.00005f);
	float D3 = ( d_center.x - d3.x) / max(abs(d7.x - d_center.x), 0.00005f);

	float d_max = max(D0, D1);
	d_max = max(d_max, D2);
	d_max = max(d_max, D3);

	if ( d_max > 10.0f){
		tex_color.gb *= 0.5;
		tex_color.r *= 0.6;
	}

	return tex_color;
}

