/////////////////////////////////////////////////
//
//  filename: MainWindow.h
//  author:Chafumi Touji 
//  date: 2018/04/03 ver1.00
//		  2020/03/09 ver1.01
//
/////////////////////////////////////////////////

#ifndef __MAINWINDOW_H__
#define __MAINWINDOW_H__

class CButtonClose;
class CButtonMinimize;
class CButtonMaximize;
class CDispWindow;
class CConfig;

class CMainWindow{
public:

	HWND			m_hWnd;

	HICON			hIcon;
	int				DisplayWidth, DisplayHeight;
	int				FrameEdgeX, FrameEdgeY;
	int				TaskBarHeight;
	int				Width, Height;
	int				PosX, PosY;
	int				TitleBarHeight;
	int				BKColorA, BKColorR, BKColorG, BKColorB;
	int				BarColorA, BarColorR, BarColorG, BarColorB;
	bool			LButtonDown;
	bool			GetCaption;
	bool			IsMaximized;
	CPoint			DownPoint;
	float			ScaleX, ScaleY;

	char			*AlphaBMP;
	HDC				MemDC;
	HBITMAP			MemBMP;
	int				BitmapWidth;
	int				BitmapHeight;

	CConfig			*Config;

	CDispWindow			*DispWindow;
	CButtonClose		*ButtonClose;
	CButtonMinimize		*ButtonMinimize;
	CButtonMaximize		*ButtonMaximize;

	CMainWindow();
	~CMainWindow();
	bool SetParam(CConfig *config);
	bool CreateWnd();
	bool OnDraw(HDC hdc);
	bool DrawRoundRect(Gdiplus::Graphics *gfc, Gdiplus::Pen *pen, int x, int y, int w, int h, int r);
	bool FillRoundRect(Gdiplus::Graphics *gfc, Gdiplus::Brush *brush, int x, int y, int w, int h, int r);

public:
	void OnPaint();
	void OnLButtonDown(UINT nFlag, CPoint point);
	void OnLButtonUp(UINT nFlag, CPoint point);
	void OnMouseMove(UINT nFlag, CPoint point);
	void OnSize(UINT nType, int cx, int cy);

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT MainWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	static void CALLBACK  TimeUpdateCallback(UINT timer_id, UINT msg, LPTIMECALLBACK user, DWORD_PTR data1, DWORD_PTR data2);
};

#endif