/////////////////////////////////////////////////
//
//  filename: DispWindow.h
//  author:Chafumi Touji
//  date: 2020/03/09 ver1.00
//
/////////////////////////////////////////////////

#ifndef __DISPWINDOW_H__
#define __DISPWINDOW_H__

struct ConstantBuffer1{

	XMFLOAT4X4	MatWorld;
	XMFLOAT4X4	MatView;
	XMFLOAT4X4	MatProj;
	XMFLOAT4	Light;
};

class CConfig;

class CDispWindow{
public:

	ID3D11Device				*m_pDevice;
	ID3D11DeviceContext			*m_pDeviceContext;
	IDXGIDevice1				*m_pDXGI;
	IDXGIAdapter				*m_pAdapter;
	IDXGIFactory				*m_pFactory;
	IDXGISwapChain				*m_pSwapChain;
	ID3D11Texture2D				*m_pBackBuffer;
	ID3D11Texture2D				*m_pDiffuseTexture;
	ID3D11RenderTargetView		*m_pRenderTargetView;
	ID3D11RenderTargetView		*m_pDiffuseRenderTargetView;
	ID3D11DepthStencilView		*m_pDepthStencilView;
	ID3D11Texture2D				*m_pDepthBuffer;
	ID3D11Texture2D				*m_pDepthTexture;
	ID3D11ShaderResourceView	*m_pDiffuseShaderResourceView;
	ID3D11ShaderResourceView	*m_pDepthShaderResourceView;
	ID3D11RenderTargetView		*m_pDepthRenderTargetView;
	ID3D11InputLayout			*m_pLayout;
	ID3D11VertexShader			*m_pVtxShader1, *m_pVtxShader2;
	ID3D11PixelShader			*m_pPxShader1, *m_pPxShader2;
	ID3D11Buffer				*m_pConstantBuffer1;
	ID3D11SamplerState			*m_pSampleState;
	ID3D11RasterizerState		*m_pRasterizeState;
	ID3D11BlendState			*m_pBlendState;

	ID3D11Buffer				*VertexBuffer;

	CChaDataObject				*ChaDataObject;
	CChaResourceObject			*ChaResourceObject;

	XMMATRIX					matWorld;
	XMMATRIX					matView;
	XMMATRIX					matProj;

	wchar_t						Path[SIZE_CHAR_MAX];
	float4						BKColor;
	float3						Eye;
	float						Zoom;
	float						CameraHeight;

	float						RotationX;
	float						RotationY;
	float						RotationZ;

	HWND			m_hWnd;
	UINT			TimerID;

	int				Width, Height;
	int				DisplayWidth, DisplayHeight;
	bool			LButtonDown;
	bool			RButtonDown;
	CPoint			DownPoint;

	CDispWindow();
	~CDispWindow();
	bool SetParam(CConfig *config);
	bool InitD3D();
	bool ReleaseD3D();
	bool CreateWnd( HWND parent_wnd, int x, int y, int w, int h );
	bool Render();

public:
	void OnPaint();
	void OnLButtonDown(UINT nFlag, CPoint point);
	void OnLButtonUp(UINT nFlag, CPoint point);
	void OnRButtonDown(UINT nFlag, CPoint point);
	void OnRButtonUp(UINT nFlag, CPoint point);
	void OnMouseMove(UINT nFlag, CPoint point);
	void OnMouseWheel(UINT key, int delta, CPoint point);
	void OnSize(UINT nType, int cx, int cy);

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT DispWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	static void CALLBACK  TimeUpdateCallback(UINT timer_id, UINT msg, LPTIMECALLBACK user, DWORD_PTR data1, DWORD_PTR data2);
};

#endif