/////////////////////////////////////////////////
//
//  filename: Config.cpp
//  author:Chafumi Touji 
//  date: 2020/03/13 ver1.00
//
/////////////////////////////////////////////////

#include "StdAfx.h"
#include "Config.h"

CConfig::CConfig(){

	wmemset(Path, 0, SIZE_CHAR_MAX);
	wcscpy_s(Path, SIZE_CHAR_MAX, L"model/coco1.27.dae");
	BKColorA = 255;
	BKColorR = 180;
	BKColorG = 150;
	BKColorB = 150;
	BarColorA = 255;
	BarColorR = 100;
	BarColorG = 70;
	BarColorB = 70;
	ViewerBKColorA = 255;
	ViewerBKColorR = 220;
	ViewerBKColorG = 220;
	ViewerBKColorB = 220;
}

CConfig::~CConfig(){

}

bool CConfig::LoadConfigFile(wchar_t *filename){

	FILE *file = NULL;

	_wfopen_s(&file, filename, L"r");
	if (file == NULL)
		return false;

	char *ctx;
	char line[SIZE_CHAR_MAX];
	char param1[SIZE_CHAR_MAX];
	char param2[SIZE_CHAR_MAX];
	CString str1, str2;
	size_t size;
	while (fgets(line, SIZE_CHAR_MAX, file) != NULL){
		char *tok = strtok_s(line, "=", &ctx);
		char *tok2 = strtok_s(NULL, "\n", &ctx);
		str1 = tok;
		str2 = tok2;
		str1.TrimLeft();
		str1.TrimRight();
		str2.TrimLeft();
		str2.TrimLeft();
		wcstombs_s(&size, param1, str1.GetString(), SIZE_CHAR_MAX);
		wcstombs_s(&size, param2, str2.GetString(), SIZE_CHAR_MAX);
		GetParamS(Path, "ModelPath", param1, param2);
		GetParamI(&BKColorA, "BKColorA", param1, param2);
		GetParamI(&BKColorR, "BKColorR", param1, param2);
		GetParamI(&BKColorG, "BKColorG", param1, param2);
		GetParamI(&BKColorB, "BKColorB", param1, param2);
		GetParamI(&BarColorA, "BarColorA", param1, param2);
		GetParamI(&BarColorR, "BarColorR", param1, param2);
		GetParamI(&BarColorG, "BarColorG", param1, param2);
		GetParamI(&BarColorB, "BarColorB", param1, param2);
		GetParamI(&ViewerBKColorA, "ViewerBKColorA", param1, param2);
		GetParamI(&ViewerBKColorR, "ViewerBKColorR", param1, param2);
		GetParamI(&ViewerBKColorG, "ViewerBKColorG", param1, param2);
		GetParamI(&ViewerBKColorB, "ViewerBKColorB", param1, param2);
	}

	fclose(file);

	return true;
}

bool CConfig::GetParamI( int *value, char *name, char *param1, char *param2){

	if (strcmp(param1, name) == 0){
		*value = atoi(param2);
	}

	return true;
}

bool CConfig::GetParamB(bool *value, char *name, char *param1, char *param2){

	if (strcmp(param1, name) == 0){
		if (strcmp(param2, "true") == 0 || strcmp(param2, "1") == 0 || strcmp(param2, "TRUE") == 0)
			*value = true;
		else
			*value = false;
	}

	return true;
}

bool CConfig::GetParamS(wchar_t *str, char *name, char *param1, char *param2){

	size_t size;
	if (strcmp(name, param1) == 0){
		mbstowcs_s(&size, str, SIZE_CHAR_MAX, param2, SIZE_CHAR_MAX);
	}

	return true;
}

bool CConfig::WriteParamI(FILE *file, char *param1, int value){

	char paramline[SIZE_CHAR_MAX];
	memset(paramline, 0, SIZE_CHAR_MAX);

	char data[SIZE_CHAR_MAX];
	memset(data, 0, SIZE_CHAR_MAX);

	strcpy_s(paramline, SIZE_CHAR_MAX, param1);
	sprintf_s(data, "%d", value);
	strcat_s(paramline, SIZE_CHAR_MAX, data);
	strcat_s(paramline, SIZE_CHAR_MAX, "\n");
	fputs(paramline, file);

	return true;
}

bool CConfig::WriteParamB(FILE *file, char *param1, bool value){

	char paramline[SIZE_CHAR_MAX];
	memset(paramline, 0, SIZE_CHAR_MAX);

	char data[SIZE_CHAR_MAX];
	memset(data, 0, SIZE_CHAR_MAX);

	strcpy_s(paramline, SIZE_CHAR_MAX, param1);
	if ( value == true )
		sprintf_s(data, "true");
	else
		sprintf_s(data, "false");
	strcat_s(paramline, SIZE_CHAR_MAX, data);
	strcat_s(paramline, SIZE_CHAR_MAX, "\n");
	fputs(paramline, file);

	return true;
}

bool CConfig::WriteParamS(FILE *file, char *param1, wchar_t *str){

	char paramline[SIZE_CHAR_MAX];
	memset(paramline, 0, SIZE_CHAR_MAX);

	char data[SIZE_CHAR_MAX];
	memset(data, 0, SIZE_CHAR_MAX);
	size_t size;
	if (str != NULL)
		wcstombs_s(&size, data, SIZE_CHAR_MAX, str, SIZE_CHAR_MAX);

	strcpy_s(paramline, SIZE_CHAR_MAX, param1);
	strcat_s(paramline, SIZE_CHAR_MAX, data);
	strcat_s(paramline, SIZE_CHAR_MAX, "\n");
	fputs(paramline, file);

	return true;
}

bool CConfig::WriteConfigFile(wchar_t *filename){

	FILE *file;
	
	_wfopen_s(&file, filename, L"w");
	if (file == NULL)
		return false;

	WriteParamS(file, "ModelPath = ", Path);
	WriteParamI(file, "BKColorA = ", BKColorA);
	WriteParamI(file, "BKColorR = ", BKColorR);
	WriteParamI(file, "BKColorG = ", BKColorG);
	WriteParamI(file, "BKColorB = ", BKColorB);
	WriteParamI(file, "BarColorA = ", BarColorA);
	WriteParamI(file, "BarColorR = ", BarColorR);
	WriteParamI(file, "BarColorG = ", BarColorG);
	WriteParamI(file, "BarColorB = ", BarColorB);
	WriteParamI(file, "ViewerBKColorA = ", ViewerBKColorA);
	WriteParamI(file, "ViewerBKColorR = ", ViewerBKColorR);
	WriteParamI(file, "ViewerBKColorG = ", ViewerBKColorG);
	WriteParamI(file, "ViewerBKColorB = ", ViewerBKColorB);

	fclose(file);

	return true;
}
